#ifndef KitiBot_h
#define KitiBot_h

#include "KitiBot.h"
#include "Arduino.h"
#include <IRremote.h>

extern uint8_t Ports[7][2];
extern IRrecv irrecv;
extern decode_results results;
extern long lastIRTime;
extern char irRead;

class KitiBot
{
  public:
  /////////////////////////////////////////////////////////////////
  KitiBot();
  void init();
  void setSpeed(char direction, int Speed);
  void move(char direction, int Speed);
  void moveDelay(char direction, int speed,char time);
  float distance(char port);
  void loop();
  boolean getIR(unsigned char r);

  /////////////////////////////////////////////////////////////////
  
  private:
  /////////////////////////////////////////////////////////////////
  int PWMA;            //Right Motor Speed pin (ENA)
  int AIN2;           //Motor-R backward (IN1)
  int AIN1;           //Motor-R forward (IN2).
  int PWMB;             //Left Motor Speed pin (ENB)
  int BIN1;            //Motor-L forward (IN3)
  int BIN2;           //Motor-L backward (IN4)


  /////////////////////////////////////////////////////////////////

};
#endif
