/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import processing.app.Editor;
import processing.app.syntax.SketchTextArea;

public class DiscourseFormat {
    private Editor editor;
    private SketchTextArea textarea;
    private boolean html;

    public DiscourseFormat(Editor editor, boolean html) {
        this.editor = editor;
        this.textarea = editor.getTextArea();
        this.html = html;
    }

    public void show() {
        int stopLine;
        int startLine;
        StringBuilder cf = new StringBuilder(this.html ? "<pre>\n" : "[code]\n");
        int selStart = this.textarea.getSelectionStart();
        int selStop = this.textarea.getSelectionEnd();
        try {
            startLine = this.textarea.getLineOfOffset(selStart);
            stopLine = this.textarea.getLineOfOffset(selStop);
        }
        catch (BadLocationException e) {
            return;
        }
        if (selStart == selStop) {
            startLine = 0;
            stopLine = this.textarea.getLineCount() - 1;
        } else {
            try {
                if (this.textarea.getLineStartOffset(stopLine) == selStop) {
                    --stopLine;
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        for (int i = startLine; i <= stopLine; ++i) {
            this.appendFormattedLine(cf, i);
        }
        cf.append(this.html ? "\n</pre>" : "\n[/code]");
        StringSelection formatted = new StringSelection(cf.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(formatted, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
        Clipboard unixclipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        if (unixclipboard != null) {
            unixclipboard.setContents(formatted, null);
        }
        this.editor.statusNotice("Code formatted for " + (this.html ? "HTML" : "the Arduino forum") + " has been copied to the clipboard.");
    }

    private void appendToHTML(char c, StringBuilder buffer) {
        if (!this.html) {
            buffer.append(c);
        } else if (c == '<') {
            buffer.append("&lt;");
        } else if (c == '>') {
            buffer.append("&gt;");
        } else if (c == '&') {
            buffer.append("&amp;");
        } else if (c > '\u007f') {
            buffer.append("&#" + c + ";");
        } else {
            buffer.append(c);
        }
    }

    public void appendFormattedLine(StringBuilder cf, int line) {
        Segment segment = new Segment();
        this.textarea.getTextLine(line, segment);
        char[] segmentArray = segment.array;
        int segmentOffset = segment.offset;
        int segmentCount = segment.count;
        if (!this.html) {
            for (int j = 0; j < segmentCount; ++j) {
                char c = segmentArray[j + segmentOffset];
                this.appendToHTML(c, cf);
            }
        } else {
            for (Token tokenList = this.textarea.getTokenListForLine(line); tokenList != null; tokenList = tokenList.getNextToken()) {
                if (tokenList.getType() == 0) {
                    cf.append('\n');
                    continue;
                }
                if (!tokenList.isPaintable()) continue;
                tokenList.appendHTMLRepresentation(cf, (RSyntaxTextArea)this.textarea, false);
            }
        }
    }
}

