/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;

public class SketchTextAreaEditorKit
extends RSyntaxTextAreaEditorKit {
    public static final String rtaDeleteNextWordAction = "RTA.DeleteNextWordAction";
    public static final String rtaDeleteLineToCursorAction = "RTA.DeleteLineToCursorAction";
    private static final Action[] defaultActions = new Action[]{new DeleteNextWordAction(), new DeleteLineToCursorAction()};

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public static class DeleteLineToCursorAction
    extends RecordableTextAction {
        public DeleteLineToCursorAction() {
            super(SketchTextAreaEditorKit.rtaDeleteLineToCursorAction);
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            try {
                Document document = textArea.getDocument();
                int caretPosition = textArea.getCaretPosition();
                Element map = document.getDefaultRootElement();
                int currentLineNum = map.getElementIndex(caretPosition);
                Element currentLineElement = map.getElement(currentLineNum);
                int currentLineStart = currentLineElement.getStartOffset();
                if (caretPosition > currentLineStart) {
                    document.remove(currentLineStart, caretPosition - currentLineStart);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        public String getMacroID() {
            return SketchTextAreaEditorKit.rtaDeleteLineToCursorAction;
        }
    }

    public static class DeleteNextWordAction
    extends RecordableTextAction {
        public DeleteNextWordAction() {
            super(SketchTextAreaEditorKit.rtaDeleteNextWordAction);
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            if (!textArea.isEditable() || !textArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                return;
            }
            try {
                int start = textArea.getSelectionStart();
                int end = this.getNextWordStart(textArea, start);
                if (end > start) {
                    textArea.getDocument().remove(start, end - start);
                }
            }
            catch (BadLocationException ex) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            }
        }

        public String getMacroID() {
            return SketchTextAreaEditorKit.rtaDeleteNextWordAction;
        }

        protected int getNextWordStart(RTextArea textArea, int end) throws BadLocationException {
            return Utilities.getNextWord((JTextComponent)textArea, end);
        }
    }
}

