/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import cc.arduino.contributions.libraries.ContributedLibrary;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.IOUtils;
import org.fife.ui.rsyntaxtextarea.TokenMap;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.legacy.PApplet;

public class PdeKeywords {
    private static final Map<String, Integer> KNOWN_TOKEN_TYPES = new HashMap<String, Integer>();
    private static final Pattern ALPHA = Pattern.compile("\\w");
    private final TokenMap keywordTokenType = new TokenMap();
    private final Map<String, String> keywordOldToken = new HashMap<String, String>();
    private final Map<String, String> keywordTokenTypeAsString = new HashMap<String, String>();
    private final Map<String, String> keywordToReference = new HashMap<String, String>();

    public void reload() {
        try {
            this.parseKeywordsTxt(new File(BaseNoGui.getContentFile((String)"lib"), "keywords.txt"));
            for (ContributedLibrary lib : Base.getLibraries()) {
                File keywords = new File(lib.getInstalledFolder(), "keywords.txt");
                if (!keywords.exists()) continue;
                this.parseKeywordsTxt(keywords);
            }
        }
        catch (Exception e) {
            Base.showError("Problem loading keywords", "Could not load keywords.txt,\nplease re-install Arduino.", e);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseKeywordsTxt(File input) throws Exception {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(input)));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                String[] pieces = PApplet.split((String)line, (char)'\t');
                String keyword = pieces[0].trim();
                if (pieces.length >= 2) {
                    this.keywordOldToken.put(keyword, pieces[1]);
                }
                if (pieces.length >= 3) {
                    this.parseHTMLReferenceFileName(pieces[2], keyword);
                }
                if (pieces.length < 4) continue;
                this.parseRSyntaxTextAreaTokenType(pieces[3], keyword);
            }
            this.fillMissingTokenType();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    private void fillMissingTokenType() {
        for (Map.Entry<String, String> oldTokenEntry : this.keywordOldToken.entrySet()) {
            String keyword = oldTokenEntry.getKey();
            if (this.keywordTokenTypeAsString.containsKey(keyword)) continue;
            if ("KEYWORD1".equals(oldTokenEntry.getValue())) {
                this.parseRSyntaxTextAreaTokenType("DATA_TYPE", keyword);
                continue;
            }
            this.parseRSyntaxTextAreaTokenType("FUNCTION", keyword);
        }
    }

    private void parseRSyntaxTextAreaTokenType(String tokenTypeAsString, String keyword) {
        if (!ALPHA.matcher(keyword).find()) {
            return;
        }
        if (KNOWN_TOKEN_TYPES.containsKey(tokenTypeAsString)) {
            this.keywordTokenType.put(keyword, KNOWN_TOKEN_TYPES.get(tokenTypeAsString).intValue());
            this.keywordTokenTypeAsString.put(keyword, tokenTypeAsString);
        } else {
            this.keywordTokenType.put(keyword, 8);
            this.keywordTokenTypeAsString.put(keyword, "FUNCTION");
        }
    }

    private void parseHTMLReferenceFileName(String piece, String keyword) {
        String htmlFilename = piece.trim();
        if (htmlFilename.length() > 0) {
            this.keywordToReference.put(keyword, htmlFilename);
        }
    }

    public String getReference(String keyword) {
        return this.keywordToReference.get(keyword);
    }

    public String getTokenTypeAsString(String keyword) {
        return this.keywordTokenTypeAsString.get(keyword);
    }

    public int getTokenType(char[] array, int start, int end) {
        return this.keywordTokenType.get(array, start, end);
    }

    static {
        KNOWN_TOKEN_TYPES.put("RESERVED_WORD", 6);
        KNOWN_TOKEN_TYPES.put("RESERVED_WORD_2", 7);
        KNOWN_TOKEN_TYPES.put("VARIABLE", 17);
        KNOWN_TOKEN_TYPES.put("OPERATOR", 23);
        KNOWN_TOKEN_TYPES.put("DATA_TYPE", 16);
        KNOWN_TOKEN_TYPES.put("LITERAL_BOOLEAN", 9);
        KNOWN_TOKEN_TYPES.put("LITERAL_CHAR", 14);
    }
}

