/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.font.TextAttribute;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.text.StyleContext;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesHelper;
import processing.app.helpers.PreferencesMap;

public class Theme {
    static PreferencesMap defaults;
    static PreferencesMap table;

    protected static void init() {
        try {
            table.load(new File(BaseNoGui.getContentFile((String)"lib"), "theme/theme.txt"));
        }
        catch (Exception te) {
            Base.showError(null, I18n._((String)"Could not read color theme settings.\nYou'll need to reinstall Arduino."), te);
        }
        Theme.setColor("run.window.bgcolor", SystemColor.control);
        defaults = new PreferencesMap((Map)table);
    }

    public static String get(String attribute) {
        return (String)table.get((Object)attribute);
    }

    public static String getDefault(String attribute) {
        return (String)defaults.get((Object)attribute);
    }

    public static void set(String attribute, String value) {
        table.put((Object)attribute, (Object)value);
    }

    public static boolean getBoolean(String attribute) {
        return table.getBoolean(attribute);
    }

    public static void setBoolean(String attribute, boolean value) {
        table.putBoolean(attribute, value);
    }

    public static int getInteger(String attribute) {
        return Integer.parseInt(Theme.get(attribute));
    }

    public static void setInteger(String key, int value) {
        Theme.set(key, String.valueOf(value));
    }

    public static Color getColor(String name) {
        return PreferencesHelper.parseColor((String)Theme.get(name));
    }

    public static void setColor(String attr, Color color) {
        PreferencesHelper.putColor((PreferencesMap)table, (String)attr, (Color)color);
    }

    public static Font getFont(String attr) {
        Font font = PreferencesHelper.getFont((PreferencesMap)table, (String)attr);
        if (font == null) {
            String value = Theme.getDefault(attr);
            Theme.set(attr, value);
            font = PreferencesHelper.getFont((PreferencesMap)table, (String)attr);
        }
        return font;
    }

    public static final Font getDefaultFont() {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        Font font = null;
        if (OSUtils.isMacOS()) {
            font = sc.getFont("Menlo", 0, 12);
            if (!"Menlo".equals(font.getFamily()) && !"Monaco".equals((font = sc.getFont("Monaco", 0, 12)).getFamily())) {
                font = sc.getFont("Monospaced", 0, 13);
            }
        } else {
            font = sc.getFont("Consolas", 0, 13);
            if (!"Consolas".equals(font.getFamily())) {
                font = sc.getFont("Monospaced", 0, 13);
            }
        }
        return font;
    }

    public static Map<String, Object> getStyledFont(String what, Font font) {
        String[] split = Theme.get("editor." + what + ".style").split(",");
        Color color = PreferencesHelper.parseColor((String)split[0]);
        String style = split[1];
        boolean bold = style.contains("bold");
        boolean italic = style.contains("italic");
        boolean underlined = style.contains("underlined");
        Font styledFont = new Font(font.getFamily(), (bold ? 1 : 0) | (italic ? 2 : 0), font.getSize());
        if (underlined) {
            Hashtable<TextAttribute, Integer> attr = new Hashtable<TextAttribute, Integer>();
            attr.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            styledFont = styledFont.deriveFont(attr);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("color", color);
        result.put("font", styledFont);
        return result;
    }

    static {
        table = new PreferencesMap();
    }
}

