/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.Uploader;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.SketchCode;
import processing.app.SketchCodeDocument;
import processing.app.SketchData;
import processing.app.debug.Compiler;
import processing.app.debug.RunnerException;
import processing.app.forms.PasswordAuthorizationDialog;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMapException;
import processing.app.packages.UserLibrary;

public class Sketch {
    private static File tempBuildFolder;
    private final Editor editor;
    private boolean modified;
    private SketchCodeDocument current;
    private int currentIndex;
    private final SketchData data;
    private boolean renamingCode;
    private static final List<String> hiddenExtensions;

    public Sketch(Editor _editor, File file) throws IOException {
        this.editor = _editor;
        this.data = new SketchData(file);
        tempBuildFolder = BaseNoGui.getBuildFolder();
        this.load();
    }

    protected void load() throws IOException {
        this.load(false);
    }

    protected void load(boolean forceUpdate) throws IOException {
        this.data.load();
        for (SketchCode code : this.data.getCodes()) {
            if (code.getMetadata() != null) continue;
            code.setMetadata((Object)new SketchCodeDocument(this, code));
        }
        if (this.editor != null) {
            this.setCurrentCode(this.currentIndex, forceUpdate);
        }
    }

    public void handleNewCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage(I18n._((String)"Sketch is Read-Only"), I18n._((String)"Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again."));
            return;
        }
        this.renamingCode = false;
        this.editor.status.edit(I18n._((String)"Name for new file:"), "");
    }

    public void handleRenameCode() {
        this.ensureExistence();
        if (this.currentIndex == 0 && this.editor.untitled) {
            Base.showMessage(I18n._((String)"Sketch is Untitled"), I18n._((String)"How about saving the sketch first \nbefore trying to rename it?"));
            return;
        }
        if (this.isReadOnly()) {
            Base.showMessage(I18n._((String)"Sketch is Read-Only"), I18n._((String)"Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again."));
            return;
        }
        this.renamingCode = true;
        String prompt = this.currentIndex == 0 ? "New name for sketch:" : "New name for file:";
        String oldName = this.current.getCode().isExtension(new String[]{"ino"}) ? this.current.getCode().getPrettyName() : this.current.getCode().getFileName();
        this.editor.status.edit(prompt, oldName);
    }

    protected void nameCode(String newName) {
        String sanitaryName;
        this.ensureExistence();
        if (newName.indexOf(46) == -1) {
            newName = newName + "." + this.getDefaultExtension();
        }
        if (this.renamingCode && newName.equalsIgnoreCase(this.current.getCode().getFileName())) {
            return;
        }
        if ((newName = newName.trim()).equals("")) {
            return;
        }
        int dot = newName.indexOf(46);
        if (dot == 0) {
            Base.showWarning(I18n._((String)"Problem with rename"), I18n._((String)"The name cannot start with a period."), null);
            return;
        }
        String newExtension = newName.substring(dot + 1).toLowerCase();
        if (!this.validExtension(newExtension)) {
            Base.showWarning(I18n._((String)"Problem with rename"), I18n.format((String)I18n._((String)"\".{0}\" is not a valid extension."), (Object[])new Object[]{newExtension}), null);
            return;
        }
        if (!this.isDefaultExtension(newExtension) && this.renamingCode && this.current.getCode() == this.data.getCode(0)) {
            Base.showWarning(I18n._((String)"Problem with rename"), I18n._((String)"The main file can't use an extension.\n(It may be time for your to graduate to a\n\"real\" programming environment)"), null);
            return;
        }
        String shortName = newName.substring(0, dot);
        if (!shortName.equals(sanitaryName = BaseNoGui.sanitizeName((String)shortName))) {
            newName = sanitaryName + "." + newExtension;
        }
        for (SketchCode c : this.data.getCodes()) {
            if (!newName.equalsIgnoreCase(c.getFileName())) continue;
            Base.showMessage(I18n._((String)"Nope"), I18n.format((String)I18n._((String)"A file named \"{0}\" already exists in \"{1}\""), (Object[])new Object[]{c.getFileName(), this.data.getFolder().getAbsolutePath()}));
            return;
        }
        if (newName.equals(this.getName() + ".cpp")) {
            Base.showMessage(I18n._((String)"Nope"), I18n._((String)"You can't have a .cpp file with the same name as the sketch."));
            return;
        }
        if (this.renamingCode && this.currentIndex == 0) {
            for (SketchCode code : this.data.getCodes()) {
                if (!sanitaryName.equalsIgnoreCase(code.getPrettyName()) || !code.isExtension(new String[]{"cpp"})) continue;
                Base.showMessage(I18n._((String)"Nope"), I18n.format((String)I18n._((String)"You can't rename the sketch to \"{0}\"\nbecause the sketch already has a .cpp file with that name."), (Object[])new Object[]{sanitaryName}));
                return;
            }
        }
        File newFile = new File(this.data.getFolder(), newName);
        if (this.renamingCode) {
            if (this.currentIndex == 0) {
                String folderName = newName.substring(0, newName.indexOf(46));
                File newFolder = new File(this.data.getFolder().getParentFile(), folderName);
                if (newFolder.exists()) {
                    Base.showWarning(I18n._((String)"Cannot Rename"), I18n.format((String)I18n._((String)"Sorry, a sketch (or folder) named \"{0}\" already exists."), (Object[])new Object[]{newName}), null);
                    return;
                }
                if (this.current.getCode().isModified()) {
                    this.current.getCode().setProgram(this.editor.getText());
                    try {
                        this.current.getCode().save();
                    }
                    catch (Exception e) {
                        Base.showWarning(I18n._((String)"Error"), I18n._((String)"Could not rename the sketch. (0)"), e);
                        return;
                    }
                }
                if (!this.current.getCode().renameTo(newFile)) {
                    Base.showWarning(I18n._((String)"Error"), I18n.format((String)I18n._((String)"Could not rename \"{0}\" to \"{1}\""), (Object[])new Object[]{this.current.getCode().getFileName(), newFile.getName()}), null);
                    return;
                }
                try {
                    for (SketchCode code : this.data.getCodes()) {
                        code.save();
                    }
                }
                catch (Exception e) {
                    Base.showWarning(I18n._((String)"Error"), I18n._((String)"Could not rename the sketch. (1)"), e);
                    return;
                }
                boolean success = this.data.getFolder().renameTo(newFolder);
                if (!success) {
                    Base.showWarning(I18n._((String)"Error"), I18n._((String)"Could not rename the sketch. (2)"), null);
                    return;
                }
                File newMainFile = new File(newFolder, newName + ".ino");
                this.editor.handleOpenUnchecked(newMainFile, this.currentIndex, this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
                this.editor.base.rebuildSketchbookMenus();
            } else if (!this.current.getCode().renameTo(newFile)) {
                Base.showWarning(I18n._((String)"Error"), I18n.format((String)I18n._((String)"Could not rename \"{0}\" to \"{1}\""), (Object[])new Object[]{this.current.getCode().getFileName(), newFile.getName()}), null);
                return;
            }
        } else {
            try {
                if (!newFile.createNewFile()) {
                    throw new IOException(I18n._((String)"createNewFile() returned false"));
                }
            }
            catch (IOException e) {
                Base.showWarning(I18n._((String)"Error"), I18n.format((String)"Could not create the file \"{0}\" in \"{1}\"", (Object[])new Object[]{newFile, this.data.getFolder().getAbsolutePath()}), e);
                return;
            }
            this.ensureExistence();
            this.data.addCode(new SketchCodeDocument(this, newFile).getCode());
        }
        this.data.sortCode();
        this.setCurrentCode(newName);
        this.editor.header.rebuild();
    }

    public void handleDeleteCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage(I18n._((String)"Sketch is Read-Only"), I18n._((String)"Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again."));
            return;
        }
        Object[] options = new Object[]{I18n._((String)"OK"), I18n._((String)"Cancel")};
        String prompt = this.currentIndex == 0 ? I18n._((String)"Are you sure you want to delete this sketch?") : I18n.format((String)I18n._((String)"Are you sure you want to delete \"{0}\"?"), (Object[])new Object[]{this.current.getCode().getFileNameWithExtensionIfNotIno()});
        int result = JOptionPane.showOptionDialog(this.editor, prompt, I18n._((String)"Delete"), 0, 3, null, options, options[0]);
        if (result == 0) {
            if (this.currentIndex == 0) {
                Base.removeDir(this.data.getFolder());
                this.editor.base.handleClose(this.editor);
            } else {
                if (!this.current.getCode().deleteFile(tempBuildFolder)) {
                    Base.showMessage(I18n._((String)"Couldn't do it"), I18n.format((String)I18n._((String)"Could not delete \"{0}\"."), (Object[])new Object[]{this.current.getCode().getFileName()}));
                    return;
                }
                this.data.removeCode(this.current.getCode());
                this.setCurrentCode(0);
                this.editor.header.repaint();
            }
        }
    }

    public void handlePrevCode() {
        int prev = this.currentIndex - 1;
        if (prev < 0) {
            prev = this.data.getCodeCount() - 1;
        }
        this.setCurrentCode(prev);
    }

    public void handleNextCode() {
        this.setCurrentCode((this.currentIndex + 1) % this.data.getCodeCount());
    }

    public void setModified(boolean state) {
        this.current.getCode().setModified(state);
        this.calcModified();
    }

    private void calcModified() {
        this.modified = false;
        for (SketchCode code : this.data.getCodes()) {
            if (!code.isModified()) continue;
            this.modified = true;
            break;
        }
        this.editor.header.repaint();
        if (OSUtils.isMacOS()) {
            Boolean modifiedParam = this.modified ? Boolean.TRUE : Boolean.FALSE;
            this.editor.getRootPane().putClientProperty("windowModified", modifiedParam);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean save() throws IOException {
        this.ensureExistence();
        if (this.current.getCode().isModified()) {
            this.current.getCode().setProgram(this.editor.getText());
        }
        if (this.isReadOnly()) {
            Base.showMessage(I18n._((String)"Sketch is read-only"), I18n._((String)"Some files are marked \"read-only\", so you'll\nneed to re-save this sketch to another location."));
            if (!this.saveAs()) {
                return false;
            }
        } else {
            File mainFile = new File(this.getMainFilePath());
            File mainFolder = mainFile.getParentFile();
            File[] pdeFiles = mainFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".pde");
                }
            });
            if (pdeFiles != null && pdeFiles.length > 0) {
                if (PreferencesData.get((String)"editor.update_extension") == null) {
                    Object[] options = new Object[]{I18n._((String)"OK"), I18n._((String)"Cancel")};
                    int result = JOptionPane.showOptionDialog(this.editor, I18n._((String)"In Arduino 1.0, the default file extension has changed\nfrom .pde to .ino.  New sketches (including those created\nby \"Save-As\") will use the new extension.  The extension\nof existing sketches will be updated on save, but you can\ndisable this in the Preferences dialog.\n\nSave sketch and update its extension?"), I18n._((String)".pde -> .ino"), 2, 3, null, options, options[0]);
                    if (result != 0) {
                        return false;
                    }
                    PreferencesData.setBoolean((String)"editor.update_extension", (boolean)true);
                }
                if (PreferencesData.getBoolean((String)"editor.update_extension")) {
                    for (File pdeFile : pdeFiles) {
                        this.renameCodeToInoExtension(pdeFile);
                    }
                }
            }
        }
        this.data.save();
        this.calcModified();
        return true;
    }

    private boolean renameCodeToInoExtension(File pdeFile) {
        for (SketchCode c : this.data.getCodes()) {
            if (!c.getFile().equals(pdeFile)) continue;
            String pdeName = pdeFile.getPath();
            pdeName = pdeName.substring(0, pdeName.length() - 4) + ".ino";
            return c.renameTo(new File(pdeName));
        }
        return false;
    }

    protected boolean saveAs() throws IOException {
        File customHtml;
        FileDialog fd = new FileDialog((Frame)this.editor, I18n._((String)"Save sketch folder as..."), 1);
        if (this.isReadOnly() || this.isUntitled()) {
            fd.setDirectory(BaseNoGui.getSketchbookFolder().getAbsolutePath());
        } else {
            fd.setDirectory(this.data.getFolder().getParentFile().getAbsolutePath());
        }
        String oldName = this.data.getName();
        fd.setFile(oldName);
        fd.setVisible(true);
        String newParentDir = fd.getDirectory();
        String newName = fd.getFile();
        if (newName == null) {
            return false;
        }
        newName = Sketch.checkName(newName);
        File newFolder = new File(newParentDir, newName);
        SketchCode[] sketchCodeArray = this.data.getCodes();
        int n = sketchCodeArray.length;
        for (int i = 0; i < n; ++i) {
            SketchCode code = sketchCodeArray[i];
            if (!newName.equalsIgnoreCase(code.getPrettyName()) || !code.isExtension(new String[]{"cpp"})) continue;
            Base.showMessage(I18n._((String)"Nope"), I18n.format((String)I18n._((String)"You can't save the sketch as \"{0}\"\nbecause the sketch already has a .cpp file with that name."), (Object[])new Object[]{newName}));
            return false;
        }
        if (newFolder.equals(this.data.getFolder())) {
            return this.save();
        }
        try {
            SketchCode[] newPath = newFolder.getCanonicalPath() + File.separator;
            String oldPath = this.data.getFolder().getCanonicalPath() + File.separator;
            if (newPath.indexOf(oldPath) == 0) {
                Base.showWarning(I18n._((String)"How very Borges of you"), I18n._((String)"You cannot save the sketch into a folder\ninside itself. This would go on forever."), null);
                return false;
            }
        }
        catch (IOException newPath) {
            // empty catch block
        }
        if (newFolder.exists()) {
            Base.removeDir(newFolder);
        }
        newFolder.mkdirs();
        if (this.current.getCode().isModified()) {
            this.current.getCode().setProgram(this.editor.getText());
        }
        for (SketchCode code : this.data.getCodes()) {
            if (this.data.indexOfCode(code) == 0) continue;
            File newFile = new File(newFolder, code.getFileName());
            code.saveAs(newFile);
        }
        if (this.data.getDataFolder().exists()) {
            File newDataFolder = new File(newFolder, "data");
            Base.copyDir(this.data.getDataFolder(), newDataFolder);
        }
        if (this.data.getCodeFolder().exists()) {
            File newCodeFolder = new File(newFolder, "code");
            Base.copyDir(this.data.getCodeFolder(), newCodeFolder);
        }
        if ((customHtml = new File(this.data.getFolder(), "applet.html")).exists()) {
            File newHtml = new File(newFolder, "applet.html");
            Base.copyFile(customHtml, newHtml);
        }
        File newFile = new File(newFolder, newName + ".ino");
        this.data.getCode(0).saveAs(newFile);
        this.editor.handleOpenUnchecked(newFile, this.currentIndex, this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        this.editor.base.rebuildSketchbookMenus();
        this.setUntitled(false);
        return true;
    }

    public void handleAddFile() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Base.showMessage(I18n._((String)"Sketch is Read-Only"), I18n._((String)"Some files are marked \"read-only\", so you'll\nneed to re-save the sketch in another location,\nand try again."));
            return;
        }
        FileDialog fd = new FileDialog((Frame)this.editor, I18n._((String)"Select an image or other data file to copy to your sketch"), 0);
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File sourceFile = new File(directory, filename);
        boolean result = this.addFile(sourceFile);
        if (result) {
            this.editor.statusNotice(I18n._((String)"One file added to the sketch."));
            PreferencesData.set((String)"last.folder", (String)sourceFile.getAbsolutePath());
        }
    }

    public boolean addFile(File sourceFile) {
        boolean muchSuccess;
        String filename = sourceFile.getName();
        File destFile = null;
        String codeExtension = null;
        boolean replacement = false;
        if (filename.toLowerCase().endsWith(".o") || filename.toLowerCase().endsWith(".a") || filename.toLowerCase().endsWith(".so")) {
            this.prepareCodeFolder();
            destFile = new File(this.data.getCodeFolder(), filename);
        } else {
            for (String extension : SketchData.EXTENSIONS) {
                String lower = filename.toLowerCase();
                if (!lower.endsWith("." + extension)) continue;
                destFile = new File(this.data.getFolder(), filename);
                codeExtension = extension;
            }
            if (codeExtension == null) {
                this.prepareDataFolder();
                destFile = new File(this.data.getDataFolder(), filename);
            }
        }
        if (destFile.exists()) {
            Object[] options = new Object[]{I18n._((String)"OK"), I18n._((String)"Cancel")};
            String prompt = I18n.format((String)I18n._((String)"Replace the existing version of {0}?"), (Object[])new Object[]{filename});
            int result = JOptionPane.showOptionDialog(this.editor, prompt, I18n._((String)"Replace"), 0, 3, null, options, options[0]);
            if (result == 0) {
                replacement = true;
            } else {
                return false;
            }
        }
        if (replacement && !(muchSuccess = destFile.delete())) {
            Base.showWarning(I18n._((String)"Error adding file"), I18n.format((String)I18n._((String)"Could not delete the existing ''{0}'' file."), (Object[])new Object[]{filename}), null);
            return false;
        }
        if (codeExtension == null && sourceFile.equals(destFile)) {
            Base.showWarning(I18n._((String)"You can't fool me"), I18n._((String)"This file has already been copied to the\nlocation from which where you're trying to add it.\nI ain't not doin nuthin'."), null);
            return false;
        }
        if (!sourceFile.equals(destFile)) {
            try {
                Base.copyFile(sourceFile, destFile);
            }
            catch (IOException e) {
                Base.showWarning(I18n._((String)"Error adding file"), I18n.format((String)I18n._((String)"Could not add ''{0}'' to the sketch."), (Object[])new Object[]{filename}), e);
                return false;
            }
        }
        if (codeExtension != null) {
            SketchCode newCode = new SketchCodeDocument(this, destFile).getCode();
            if (replacement) {
                this.data.replaceCode(newCode);
            } else {
                this.ensureExistence();
                this.data.addCode(newCode);
                this.data.sortCode();
            }
            this.setCurrentCode(filename);
            this.editor.header.repaint();
            if (this.editor.untitled) {
                this.current.getCode().setModified(true);
            }
        } else if (this.editor.untitled) {
            this.data.getCode(0).setModified(true);
        }
        return true;
    }

    public void importLibrary(UserLibrary lib) throws IOException {
        this.importLibrary(lib.getSrcFolder());
    }

    public void importLibrary(File jarPath) throws IOException {
        this.ensureExistence();
        String[] list = Base.headerListFromIncludePath(jarPath);
        if (this.hasDefaultExtension(this.current.getCode())) {
            this.setCurrentCode(0);
        }
        StringBuilder buffer = new StringBuilder();
        for (String aList : list) {
            buffer.append("#include <");
            buffer.append(aList);
            buffer.append(">\n");
        }
        buffer.append('\n');
        buffer.append(this.editor.getText());
        this.editor.setText(buffer.toString());
        this.editor.setSelection(0, 0);
        this.setModified(true);
    }

    public void setCurrentCode(int which) {
        this.setCurrentCode(which, false);
    }

    public void setCurrentCode(int which, boolean forceUpdate) {
        if (!forceUpdate && this.currentIndex == which && this.current != null) {
            return;
        }
        if (this.current != null) {
            this.current.getCode().setProgram(this.editor.getText());
            this.current.setSelectionStart(this.editor.getSelectionStart());
            this.current.setSelectionStop(this.editor.getSelectionStop());
            this.current.setScrollPosition(this.editor.getScrollPosition());
        }
        this.current = (SketchCodeDocument)this.data.getCode(which).getMetadata();
        this.currentIndex = which;
        this.editor.setCode(this.current);
        this.editor.header.rebuild();
    }

    protected void setCurrentCode(String findName) {
        for (SketchCode code : this.data.getCodes()) {
            if (!findName.equals(code.getFileName()) && !findName.equals(code.getPrettyName())) continue;
            this.setCurrentCode(this.data.indexOfCode(code));
            return;
        }
    }

    public void prepare() throws IOException {
        this.ensureExistence();
        this.current.getCode().setProgram(this.editor.getText());
        if (PreferencesData.getBoolean((String)"editor.external")) {
            this.load(true);
        }
    }

    public String build(boolean verbose, boolean save) throws RunnerException, PreferencesMapException {
        return this.build(tempBuildFolder.getAbsolutePath(), verbose, save);
    }

    public String build(String buildPath, boolean verbose, boolean save) throws RunnerException, PreferencesMapException {
        this.editor.status.progressUpdate(20);
        this.ensureExistence();
        Compiler.ProgressListener pl = new Compiler.ProgressListener(){

            public void progress(int percent) {
                ((Sketch)Sketch.this).editor.status.progressUpdate(percent);
            }
        };
        return Compiler.build((SketchData)this.data, (String)buildPath, (File)tempBuildFolder, (Compiler.ProgressListener)pl, (boolean)verbose, (boolean)save);
    }

    protected boolean exportApplet(boolean usingProgrammer) throws Exception {
        return this.exportApplet(tempBuildFolder.getAbsolutePath(), usingProgrammer);
    }

    public boolean exportApplet(String appletPath, boolean usingProgrammer) throws Exception {
        this.prepare();
        this.editor.status.progressNotice(I18n._((String)"Compiling sketch..."));
        String foundName = this.build(appletPath, false, false);
        if (foundName == null) {
            return false;
        }
        this.editor.status.progressNotice(I18n._((String)"Uploading..."));
        boolean success = this.upload(appletPath, foundName, usingProgrammer);
        this.editor.status.progressUpdate(100);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean upload(String buildPath, String suggestedClassName, boolean usingProgrammer) throws Exception {
        Uploader uploader = Compiler.getUploaderByPreferences((boolean)false);
        boolean success = false;
        do {
            if (uploader.requiresAuthorization() && !PreferencesData.has((String)uploader.getAuthorizationKey())) {
                PasswordAuthorizationDialog dialog = new PasswordAuthorizationDialog((Frame)this.editor, I18n._((String)"Type board password to upload a new sketch"));
                dialog.setLocationRelativeTo(this.editor);
                dialog.setVisible(true);
                if (dialog.isCancelled()) {
                    this.editor.statusNotice(I18n._((String)"Upload cancelled"));
                    return false;
                }
                PreferencesData.set((String)uploader.getAuthorizationKey(), (String)dialog.getPassword());
            }
            LinkedList warningsAccumulator = new LinkedList();
            try {
                success = Compiler.upload((SketchData)this.data, (Uploader)uploader, (String)buildPath, (String)suggestedClassName, (boolean)usingProgrammer, (boolean)false, warningsAccumulator);
            }
            finally {
                if (uploader.requiresAuthorization() && !success) {
                    PreferencesData.remove((String)uploader.getAuthorizationKey());
                }
            }
            for (String warning : warningsAccumulator) {
                System.out.print(I18n._((String)"Warning"));
                System.out.print(": ");
                System.out.println(warning);
            }
        } while (uploader.requiresAuthorization() && !success);
        return success;
    }

    protected void ensureExistence() {
        if (this.data.getFolder().exists()) {
            return;
        }
        Base.showWarning(I18n._((String)"Sketch Disappeared"), I18n._((String)"The sketch folder has disappeared.\n Will attempt to re-save in the same location,\nbut anything besides the code will be lost."), null);
        try {
            this.data.getFolder().mkdirs();
            this.modified = true;
            for (SketchCode code : this.data.getCodes()) {
                code.save();
            }
            this.calcModified();
        }
        catch (Exception e) {
            Base.showWarning(I18n._((String)"Could not re-save sketch"), I18n._((String)"Could not properly re-save the sketch. You may be in trouble at this point,\nand it might be time to copy and paste your code to another text editor."), e);
        }
    }

    public boolean isReadOnly() {
        String apath = this.data.getFolder().getAbsolutePath();
        for (File folder : BaseNoGui.getLibrariesPath()) {
            if (!apath.startsWith(folder.getAbsolutePath())) continue;
            return true;
        }
        if (apath.startsWith(BaseNoGui.getExamplesPath()) || apath.startsWith(Base.getSketchbookLibrariesPath())) {
            return true;
        }
        for (SketchCode code : this.data.getCodes()) {
            if (!code.isModified() || !code.fileReadOnly() || !code.fileExists()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDefaultExtension(SketchCode code) {
        return code.isExtension(new String[]{this.getDefaultExtension()});
    }

    public boolean isDefaultExtension(String what) {
        return what.equals(this.getDefaultExtension());
    }

    public boolean validExtension(String what) {
        return SketchData.EXTENSIONS.contains(what);
    }

    public String getDefaultExtension() {
        return this.data.getDefaultExtension();
    }

    public List<String> getHiddenExtensions() {
        return hiddenExtensions;
    }

    public String getName() {
        return this.data.getName();
    }

    public String getMainFilePath() {
        return this.data.getMainFilePath();
    }

    public File getFolder() {
        return this.data.getFolder();
    }

    public File prepareDataFolder() {
        if (!this.data.getDataFolder().exists()) {
            this.data.getDataFolder().mkdirs();
        }
        return this.data.getDataFolder();
    }

    public File prepareCodeFolder() {
        if (!this.data.getCodeFolder().exists()) {
            this.data.getCodeFolder().mkdirs();
        }
        return this.data.getCodeFolder();
    }

    public SketchCode[] getCodes() {
        return this.data.getCodes();
    }

    public int getCodeCount() {
        return this.data.getCodeCount();
    }

    public SketchCode getCode(int index) {
        return this.data.getCode(index);
    }

    public int getCodeIndex(SketchCode who) {
        return this.data.indexOfCode(who);
    }

    public SketchCode getCurrentCode() {
        return this.current.getCode();
    }

    public void setUntitled(boolean u) {
        this.editor.untitled = u;
    }

    public boolean isUntitled() {
        return this.editor.untitled;
    }

    public static String checkName(String origName) {
        String newName = BaseNoGui.sanitizeName((String)origName);
        if (!newName.equals(origName)) {
            String msg = I18n._((String)"The sketch name had to be modified. Sketch names can only consist\nof ASCII characters and numbers (but cannot start with a number).\nThey should also be less than 64 characters long.");
            System.out.println(msg);
        }
        return newName;
    }

    static {
        hiddenExtensions = Arrays.asList("ino", "pde");
    }
}

