/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import processing.app.AbstractMonitor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Serial;
import processing.app.legacy.PApplet;

public class SerialMonitor
extends AbstractMonitor {
    private Serial serial;
    private int serialRate = PreferencesData.getInteger((String)"serial.debug_rate");

    public SerialMonitor(BoardPort port) {
        super(port);
        this.serialRates.setSelectedItem(this.serialRate + " " + I18n._((String)"baud"));
        this.onSerialRateChange(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String wholeString = (String)SerialMonitor.this.serialRates.getSelectedItem();
                String rateString = wholeString.substring(0, wholeString.indexOf(32));
                SerialMonitor.this.serialRate = Integer.parseInt(rateString);
                PreferencesData.set((String)"serial.debug_rate", (String)rateString);
                try {
                    SerialMonitor.this.close();
                    Thread.sleep(100L);
                    SerialMonitor.this.open();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        });
        this.onSendCommand(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialMonitor.this.send(SerialMonitor.this.textField.getText());
                SerialMonitor.this.textField.setText("");
            }
        });
    }

    private void send(String s) {
        if (this.serial != null) {
            switch (this.lineEndings.getSelectedIndex()) {
                case 1: {
                    s = s + "\n";
                    break;
                }
                case 2: {
                    s = s + "\r";
                    break;
                }
                case 3: {
                    s = s + "\r\n";
                }
            }
            if ("".equals(s) && this.lineEndings.getSelectedIndex() == 0 && !PreferencesData.has((String)"runtime.line.ending.alert.notified")) {
                this.noLineEndingAlert.setForeground(Color.RED);
                PreferencesData.set((String)"runtime.line.ending.alert.notified", (String)"true");
            }
            this.serial.write(s);
        }
    }

    @Override
    public void open() throws Exception {
        super.open();
        if (this.serial != null) {
            return;
        }
        this.serial = new Serial(this.getBoardPort().getAddress(), this.serialRate){

            protected void message(char[] buff, int n) {
                SerialMonitor.this.addToUpdateBuffer(buff, n);
            }
        };
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.serial != null) {
            int[] location = this.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            PreferencesData.set((String)"last.serial.location", (String)locationStr);
            this.textArea.setText("");
            this.serial.dispose();
            this.serial = null;
        }
    }
}

