/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.syntax.SketchTextArea;

public class EditorListener
implements KeyListener {
    private Editor editor;
    private static final int CTRL = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final int CTRL_ALT = 8 | CTRL;
    private static final int CTRL_SHIFT = 1 | CTRL;

    public EditorListener(Editor editor) {
        this.editor = editor;
    }

    @Override
    public void keyTyped(KeyEvent event) {
        char c = event.getKeyChar();
        if ((event.getModifiers() & 2) != 0 && !Character.isISOControl(c)) {
            event.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        SketchTextArea textarea = this.editor.getTextArea();
        if (!textarea.isEditable()) {
            return;
        }
        Sketch sketch = this.editor.getSketch();
        int code = event.getKeyCode();
        if ((event.getModifiers() & CTRL) == CTRL && code == 9) {
            sketch.handleNextCode();
        }
        if ((event.getModifiers() & CTRL_SHIFT) == CTRL_SHIFT && code == 9) {
            sketch.handlePrevCode();
        }
        if ((event.getModifiers() & CTRL_ALT) == CTRL_ALT) {
            if (code == 37) {
                sketch.handlePrevCode();
            } else if (code == 39) {
                sketch.handleNextCode();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

