/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view.preferences;

import cc.arduino.view.preferences.AdditionalBoardsManagerURLTextArea;
import java.awt.Color;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.helpers.FileUtils;
import processing.app.legacy.PApplet;

public class Preferences
extends JDialog {
    private final Language[] languages;
    private final Language[] missingLanguages;
    private final WarningItem[] warningItems;
    private final Base base;
    private JTextField additionalBoardsManagerField;
    private JCheckBox checkUpdatesBox;
    private JComboBox comboLanguage;
    private JComboBox comboWarnings;
    private JCheckBox displayLineNumbersBox;
    private JCheckBox enableCodeFoldingBox;
    private JCheckBox externalEditorBox;
    private JTextField fontSizeField;
    private JLabel preferencesFileLabel;
    private JCheckBox saveVerifyUploadBox;
    private JTextField sketchbookLocationField;
    private JCheckBox updateExtensionBox;
    private JCheckBox verboseCompilationBox;
    private JCheckBox verboseUploadBox;
    private JCheckBox verifyUploadBox;

    public Preferences(Window parent, Base base) {
        super(parent);
        this.base = base;
        this.languages = new Language[]{new Language(I18n._((String)"System Default"), "", ""), new Language(I18n._((String)"Albanian"), "shqip", "sq"), new Language(I18n._((String)"Arabic"), "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "ar"), new Language(I18n._((String)"Aragonese"), "Aragon\u00e9s", "an"), new Language(I18n._((String)"Belarusian"), "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f \u043c\u043e\u0432\u0430", "be"), new Language(I18n._((String)"Bulgarian"), "\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438", "bg"), new Language(I18n._((String)"Catalan"), "Catal\u00e0", "ca"), new Language(I18n._((String)"Chinese Simplified"), "\u7b80\u4f53\u4e2d\u6587", "zh_CN"), new Language(I18n._((String)"Chinese Traditional"), "\u7e41\u9ad4\u4e2d\u6587", "zh_TW"), new Language(I18n._((String)"Croatian"), "Hrvatski", "hr_HR"), new Language(I18n._((String)"Czech (Czech Republic)"), "\u010desk\u00fd (Czech Republic)", "cs_CZ"), new Language(I18n._((String)"Danish (Denmark)"), "Dansk (Denmark)", "da_DK"), new Language(I18n._((String)"Dutch"), "Nederlands", "nl"), new Language(I18n._((String)"English"), "English", "en"), new Language(I18n._((String)"English (United Kingdom)"), "English (United Kingdom)", "en_GB"), new Language(I18n._((String)"Estonian"), "Eesti", "et"), new Language(I18n._((String)"Estonian (Estonia)"), "Eesti keel", "et_EE"), new Language(I18n._((String)"Filipino"), "Pilipino", "fil"), new Language(I18n._((String)"Finnish"), "Suomi", "fi"), new Language(I18n._((String)"French"), "Fran\u00e7ais", "fr"), new Language(I18n._((String)"Canadian French"), "Canadienne-fran\u00e7ais", "fr_CA"), new Language(I18n._((String)"Galician"), "Galego", "gl"), new Language(I18n._((String)"Georgian"), "\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4\u10da\u10dd\u10e1", "ka_GE"), new Language(I18n._((String)"German"), "Deutsch", "de_DE"), new Language(I18n._((String)"Greek"), "\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", "el_GR"), new Language(I18n._((String)"Hebrew"), "\u05e2\u05d1\u05e8\u05d9\u05ea", "he"), new Language(I18n._((String)"Hindi"), "\u0939\u093f\u0902\u0926\u0940", "hi"), new Language(I18n._((String)"Hungarian"), "Magyar", "hu"), new Language(I18n._((String)"Indonesian"), "Bahasa Indonesia", "id"), new Language(I18n._((String)"Italian"), "Italiano", "it_IT"), new Language(I18n._((String)"Japanese"), "\u65e5\u672c\u8a9e", "ja_JP"), new Language(I18n._((String)"Korean"), "\ud55c\uad6d\uc5b4", "ko_KR"), new Language(I18n._((String)"Latvian"), "Latvie\u0161u", "lv_LV"), new Language(I18n._((String)"Lithuaninan"), "Lietuvi\u0173 Kalba", "lt_LT"), new Language(I18n._((String)"Norwegian Bokm\u00e5l"), "Norsk bokm\u00e5l", "nb_NO"), new Language(I18n._((String)"Persian"), "\u0641\u0627\u0631\u0633\u06cc", "fa"), new Language(I18n._((String)"Polish"), "J\u0119zyk Polski", "pl"), new Language(I18n._((String)"Portuguese (Brazil)"), "Portugu\u00eas (Brazil)", "pt_BR"), new Language(I18n._((String)"Portuguese (Portugal)"), "Portugu\u00eas (Portugal)", "pt_PT"), new Language(I18n._((String)"Romanian"), "Rom\u00e2n\u0103", "ro"), new Language(I18n._((String)"Russian"), "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "ru"), new Language(I18n._((String)"Slovenian"), "Sloven\u0161\u010dina", "sl_SI"), new Language(I18n._((String)"Spanish"), "Espa\u00f1ol", "es"), new Language(I18n._((String)"Swedish"), "Svenska", "sv"), new Language(I18n._((String)"Tamil"), "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd", "ta"), new Language(I18n._((String)"Turkish"), "T\u00fcrk", "tr"), new Language(I18n._((String)"Ukrainian"), "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u0439", "uk"), new Language(I18n._((String)"Vietnamese"), "Ti\u1ebfng Vi\u1ec7t", "vi")};
        this.missingLanguages = new Language[]{new Language(I18n._((String)"Afrikaans"), "Afrikaans", "af"), new Language(I18n._((String)"Armenian"), "\u0540\u0561\u0575\u0565\u0580\u0565\u0576", "hy"), new Language(I18n._((String)"Asturian"), "Asturianu", "ast"), new Language(I18n._((String)"Basque"), "Euskara", "eu"), new Language(I18n._((String)"Bengali (India)"), "\u09ac\u09be\u0982\u09b2\u09be (India)", "bn_IN"), new Language(I18n._((String)"Bosnian"), "Bosanski", "bs"), new Language(I18n._((String)"Burmese (Myanmar)"), "\u1017\u1019\u102c\u1005\u1000\u102c\u1038", "my_MM"), new Language(I18n._((String)"Chinese (China)"), "", "zh_CN"), new Language(I18n._((String)"Chinese (Hong Kong)"), "", "zh_HK"), new Language(I18n._((String)"Chinese (Taiwan)"), "", "zh_TW"), new Language(I18n._((String)"Chinese (Taiwan) (Big5)"), "", "zh_TW.Big5"), new Language(I18n._((String)"Czech"), "\u010desk\u00fd", "cs"), new Language(I18n._((String)"Danish"), "Dansk", "da"), new Language(I18n._((String)"Dutch (Netherlands)"), "Nederlands", "nl_NL"), new Language(I18n._((String)"Galician (Spain)"), "Galego (Spain)", "gl_ES"), new Language(I18n._((String)"Nepali"), "\u0928\u0947\u092a\u093e\u0932\u0940", "ne"), new Language(I18n._((String)"N'Ko"), "\u07d2\u07de\u07cf", "nqo"), new Language(I18n._((String)"Marathi"), "\u092e\u0930\u093e\u0920\u0940", "mr"), new Language(I18n._((String)"Malay (Malaysia)"), "\u0628\u0647\u0627\u0633 \u0645\u0644\u0627\u064a\u0648 (Malaysia)", "ms_MY"), new Language(I18n._((String)"Norwegian"), "Norsk", "no"), new Language(I18n._((String)"Norwegian Nynorsk"), "Norsk Nynorsk", "nn"), new Language(I18n._((String)"Portugese"), "Portugu\u00eas", "pt"), new Language(I18n._((String)"Persian (Iran)"), "\u0641\u0627\u0631\u0633\u06cc (Iran)", "fa_IR"), new Language(I18n._((String)"Slovak"), "Sloven\u010dina", "sk"), new Language(I18n._((String)"Swahili"), "\u0643\u0650\u0633\u0648\u064e\u0647\u0650\u0644", "sw"), new Language(I18n._((String)"Talossan"), "Talossan", "tzl"), new Language(I18n._((String)"Urdu (Pakistan)"), "\u0627\u0631\u062f\u0648 (Pakistan)", "ur_PK"), new Language(I18n._((String)"Western Frisian"), "Western Frisian", "fy")};
        this.warningItems = new WarningItem[]{new WarningItem("none", I18n._((String)"None")), new WarningItem("default", I18n._((String)"Default")), new WarningItem("more", I18n._((String)"More")), new WarningItem("all", I18n._((String)"All"))};
        this.initComponents();
        Base.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.cancelButtonActionPerformed(e);
            }
        });
        this.showPrerefencesData();
    }

    private void initComponents() {
        JLabel sketchbookLocationLabel = new JLabel();
        this.sketchbookLocationField = new JTextField();
        JButton browseButton = new JButton();
        JLabel comboLanguageLabel = new JLabel();
        this.comboLanguage = new JComboBox<Language>(this.languages);
        JLabel requiresRestartLabel = new JLabel();
        JLabel fontSizeLabel = new JLabel();
        this.fontSizeField = new JTextField();
        JLabel showVerboseLabel = new JLabel();
        this.verboseCompilationBox = new JCheckBox();
        this.verboseUploadBox = new JCheckBox();
        JLabel comboWarningsLabel = new JLabel();
        this.comboWarnings = new JComboBox<WarningItem>(this.warningItems);
        JLabel additionalBoardsManagerLabel = new JLabel();
        this.additionalBoardsManagerField = new JTextField();
        JButton extendedAdditionalUrlFieldWindow = new JButton();
        JLabel morePreferencesLabel = new JLabel();
        this.preferencesFileLabel = new JLabel();
        JLabel arduinoNotRunningLabel = new JLabel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        JPanel checkboxesContainer = new JPanel();
        this.displayLineNumbersBox = new JCheckBox();
        this.enableCodeFoldingBox = new JCheckBox();
        this.verifyUploadBox = new JCheckBox();
        this.externalEditorBox = new JCheckBox();
        this.checkUpdatesBox = new JCheckBox();
        this.updateExtensionBox = new JCheckBox();
        this.saveVerifyUploadBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(I18n._((String)"Preferences"));
        this.setModal(true);
        this.setResizable(false);
        sketchbookLocationLabel.setText(I18n._((String)"Sketchbook location:"));
        this.sketchbookLocationField.setColumns(40);
        browseButton.setText(I18n.PROMPT_BROWSE);
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.browseButtonActionPerformed(evt);
            }
        });
        comboLanguageLabel.setText(I18n._((String)"Editor language: "));
        requiresRestartLabel.setText(I18n._((String)"  (requires restart of Arduino)"));
        fontSizeLabel.setText(I18n._((String)"Editor font size: "));
        this.fontSizeField.setColumns(4);
        showVerboseLabel.setText(I18n._((String)"Show verbose output during: "));
        this.verboseCompilationBox.setText(I18n._((String)"compilation "));
        this.verboseUploadBox.setText(I18n._((String)"upload"));
        comboWarningsLabel.setText(I18n._((String)"Compiler warnings: "));
        additionalBoardsManagerLabel.setText(I18n._((String)"Additional Boards Manager URLs: "));
        additionalBoardsManagerLabel.setToolTipText(I18n._((String)"Enter a comma separated list of urls"));
        this.additionalBoardsManagerField.setToolTipText(I18n._((String)"Enter a comma separated list of urls"));
        extendedAdditionalUrlFieldWindow.setIcon(new ImageIcon(Base.getThemeImage("newwindow.gif", this)));
        extendedAdditionalUrlFieldWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.extendedAdditionalUrlFieldWindowActionPerformed(evt);
            }
        });
        morePreferencesLabel.setForeground(Color.GRAY);
        morePreferencesLabel.setText(I18n._((String)"More preferences can be edited directly in the file"));
        this.preferencesFileLabel.setText(PreferencesData.getPreferencesFile().getAbsolutePath());
        this.preferencesFileLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Preferences.this.preferencesFileLabelMousePressed(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                Preferences.this.preferencesFileLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                Preferences.this.preferencesFileLabelMouseEntered(evt);
            }
        });
        arduinoNotRunningLabel.setForeground(Color.GRAY);
        arduinoNotRunningLabel.setText(I18n._((String)"(edit only when Arduino is not running)"));
        okButton.setText(I18n.PROMPT_OK);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.okButtonActionPerformed(evt);
            }
        });
        cancelButton.setText(I18n.PROMPT_CANCEL);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.cancelButtonActionPerformed(evt);
            }
        });
        checkboxesContainer.setLayout(new BoxLayout(checkboxesContainer, 1));
        this.displayLineNumbersBox.setText(I18n._((String)"Display line numbers"));
        checkboxesContainer.add(this.displayLineNumbersBox);
        this.enableCodeFoldingBox.setText(I18n._((String)"Enable Code Folding"));
        checkboxesContainer.add(this.enableCodeFoldingBox);
        this.verifyUploadBox.setText(I18n._((String)"Verify code after upload"));
        checkboxesContainer.add(this.verifyUploadBox);
        this.externalEditorBox.setText(I18n._((String)"Use external editor"));
        checkboxesContainer.add(this.externalEditorBox);
        this.checkUpdatesBox.setText(I18n._((String)"Check for updates on startup"));
        checkboxesContainer.add(this.checkUpdatesBox);
        this.updateExtensionBox.setText(I18n._((String)"Update sketch files to new extension on save (.pde -> .ino)"));
        checkboxesContainer.add(this.updateExtensionBox);
        this.saveVerifyUploadBox.setText(I18n._((String)"Save when verifying or uploading"));
        checkboxesContainer.add(this.saveVerifyUploadBox);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sketchbookLocationField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(browseButton)).addComponent(checkboxesContainer, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(cancelButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(additionalBoardsManagerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.additionalBoardsManagerField, -2, 500, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(extendedAdditionalUrlFieldWindow, -2, 36, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(sketchbookLocationLabel).addGroup(layout.createSequentialGroup().addComponent(comboWarningsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboWarnings, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(showVerboseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verboseCompilationBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verboseUploadBox)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(comboLanguageLabel).addComponent(fontSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontSizeField, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.comboLanguage, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(requiresRestartLabel)))).addComponent(arduinoNotRunningLabel).addComponent(morePreferencesLabel).addComponent(this.preferencesFileLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(sketchbookLocationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sketchbookLocationField, -2, -1, -2).addComponent(browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(comboLanguageLabel).addComponent(this.comboLanguage, -2, -1, -2).addComponent(requiresRestartLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(fontSizeLabel).addComponent(this.fontSizeField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(showVerboseLabel).addComponent(this.verboseCompilationBox).addComponent(this.verboseUploadBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(comboWarningsLabel).addComponent(this.comboWarnings, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(checkboxesContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(additionalBoardsManagerLabel).addComponent(this.additionalBoardsManagerField, -2, -1, -2)).addComponent(extendedAdditionalUrlFieldWindow, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(morePreferencesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preferencesFileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(arduinoNotRunningLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(cancelButton).addComponent(okButton)).addContainerGap()));
        this.pack();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File dflt = new File(this.sketchbookLocationField.getText());
        File file = Base.selectFolder(I18n._((String)"Select new sketchbook location"), dflt, this);
        if (file != null) {
            String path = file.getAbsolutePath();
            if (BaseNoGui.getPortableFolder() != null && (path = FileUtils.relativePath((String)BaseNoGui.getPortableFolder().toString(), (String)path)) == null) {
                path = BaseNoGui.getPortableSketchbookFolder();
            }
            this.sketchbookLocationField.setText(path);
        }
    }

    private void extendedAdditionalUrlFieldWindowActionPerformed(ActionEvent evt) {
        final AdditionalBoardsManagerURLTextArea additionalBoardsManagerURLTextArea = new AdditionalBoardsManagerURLTextArea((Window)this);
        additionalBoardsManagerURLTextArea.setText(this.additionalBoardsManagerField.getText());
        additionalBoardsManagerURLTextArea.onOk(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.additionalBoardsManagerField.setText(additionalBoardsManagerURLTextArea.getText());
            }
        });
        additionalBoardsManagerURLTextArea.setVisible(true);
    }

    private void preferencesFileLabelMouseEntered(MouseEvent evt) {
        this.preferencesFileLabel.setForeground(new Color(0, 0, 140));
    }

    private void preferencesFileLabelMousePressed(MouseEvent evt) {
        Base.openFolder(PreferencesData.getPreferencesFile().getParentFile());
    }

    private void preferencesFileLabelMouseExited(MouseEvent evt) {
        this.preferencesFileLabel.setForeground(Color.BLACK);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        List<String> errors = this.validateData();
        if (!errors.isEmpty()) {
            Base.showWarning(I18n._((String)"Error"), errors.get(0), null);
            return;
        }
        this.savePreferencesData();
        for (Editor editor : this.base.getEditors()) {
            editor.applyPreferences();
        }
        this.cancelButtonActionPerformed(evt);
    }

    private List<String> validateData() {
        LinkedList<String> errors = new LinkedList<String>();
        if (FileUtils.isSubDirectory((File)new File(this.sketchbookLocationField.getText()), (File)new File(PreferencesData.get((String)"runtime.ide.path")))) {
            errors.add(I18n._((String)"The specified sketchbook folder contains your copy of the IDE.\nPlease choose a different folder for your sketchbook."));
        }
        return errors;
    }

    private void savePreferencesData() {
        String oldPath = PreferencesData.get((String)"sketchbook.path");
        String newPath = this.sketchbookLocationField.getText();
        if (newPath.isEmpty()) {
            newPath = BaseNoGui.getPortableFolder() == null ? this.base.getDefaultSketchbookFolderOrPromptForIt().toString() : BaseNoGui.getPortableSketchbookFolder();
        }
        if (!newPath.equals(oldPath)) {
            this.base.rebuildSketchbookMenus();
            PreferencesData.set((String)"sketchbook.path", (String)newPath);
        }
        Language newLanguage = (Language)this.comboLanguage.getSelectedItem();
        PreferencesData.set((String)"editor.languages.current", (String)newLanguage.getIsoCode());
        String newSizeText = this.fontSizeField.getText();
        try {
            int newSize = Integer.parseInt(newSizeText.trim());
            String[] pieces = PApplet.split((String)PreferencesData.get((String)"editor.font"), (char)',');
            pieces[2] = String.valueOf(newSize);
            PreferencesData.set((String)"editor.font", (String)PApplet.join((String[])pieces, (char)','));
        }
        catch (Exception e) {
            System.err.println(I18n.format((String)I18n._((String)"ignoring invalid font size {0}"), (Object[])new Object[]{newSizeText}));
        }
        PreferencesData.setBoolean((String)"build.verbose", (boolean)this.verboseCompilationBox.isSelected());
        PreferencesData.setBoolean((String)"upload.verbose", (boolean)this.verboseUploadBox.isSelected());
        WarningItem warningItem = (WarningItem)this.comboWarnings.getSelectedItem();
        PreferencesData.set((String)"compiler.warning_level", (String)warningItem.getValue());
        PreferencesData.setBoolean((String)"editor.linenumbers", (boolean)this.displayLineNumbersBox.isSelected());
        PreferencesData.setBoolean((String)"editor.code_folding", (boolean)this.enableCodeFoldingBox.isSelected());
        PreferencesData.setBoolean((String)"upload.verify", (boolean)this.verifyUploadBox.isSelected());
        PreferencesData.setBoolean((String)"editor.save_on_verify", (boolean)this.saveVerifyUploadBox.isSelected());
        PreferencesData.setBoolean((String)"editor.external", (boolean)this.externalEditorBox.isSelected());
        PreferencesData.setBoolean((String)"update.check", (boolean)this.checkUpdatesBox.isSelected());
        PreferencesData.setBoolean((String)"editor.update_extension", (boolean)this.updateExtensionBox.isSelected());
        PreferencesData.setBoolean((String)"editor.save_on_verify", (boolean)this.saveVerifyUploadBox.isSelected());
        PreferencesData.set((String)"boardsmanager.additional.urls", (String)this.additionalBoardsManagerField.getText().replace("\r\n", "\n").replace("\r", "\n").replace("\n", ","));
    }

    private void showPrerefencesData() {
        this.sketchbookLocationField.setText(PreferencesData.get((String)"sketchbook.path"));
        String currentLanguageISOCode = PreferencesData.get((String)"editor.languages.current");
        for (Language language : this.languages) {
            if (!language.getIsoCode().equals(currentLanguageISOCode)) continue;
            this.comboLanguage.setSelectedItem(language);
        }
        Font editorFont = PreferencesData.getFont((String)"editor.font");
        this.fontSizeField.setText(String.valueOf(editorFont.getSize()));
        this.verboseCompilationBox.setSelected(PreferencesData.getBoolean((String)"build.verbose"));
        this.verboseUploadBox.setSelected(PreferencesData.getBoolean((String)"upload.verbose"));
        String currentWarningLevel = PreferencesData.get((String)"compiler.warning_level", (String)"none");
        for (WarningItem item : this.warningItems) {
            if (!currentWarningLevel.equals(item.getValue())) continue;
            this.comboWarnings.setSelectedItem(item);
        }
        this.displayLineNumbersBox.setSelected(PreferencesData.getBoolean((String)"editor.linenumbers"));
        this.enableCodeFoldingBox.setSelected(PreferencesData.getBoolean((String)"editor.code_folding"));
        this.verifyUploadBox.setSelected(PreferencesData.getBoolean((String)"upload.verify"));
        this.externalEditorBox.setSelected(PreferencesData.getBoolean((String)"editor.external"));
        this.checkUpdatesBox.setSelected(PreferencesData.getBoolean((String)"update.check"));
        this.updateExtensionBox.setSelected(PreferencesData.get((String)"editor.update_extension") == null || PreferencesData.getBoolean((String)"editor.update_extension"));
        this.saveVerifyUploadBox.setSelected(PreferencesData.getBoolean((String)"editor.save_on_verify"));
        this.additionalBoardsManagerField.setText(PreferencesData.get((String)"boardsmanager.additional.urls"));
    }

    private static class WarningItem {
        private final String value;
        private final String translation;

        public WarningItem(String value, String translation) {
            this.value = value;
            this.translation = translation;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.translation;
        }
    }

    public static class Language {
        private final String name;
        private final String originalName;
        private final String isoCode;

        public Language(String name, String originalName, String isoCode) {
            this.name = name;
            this.originalName = originalName;
            this.isoCode = isoCode;
        }

        public String toString() {
            if (this.originalName.length() == 0) {
                return this.name;
            }
            return this.originalName + " (" + this.name + ")";
        }

        public String getIsoCode() {
            return this.isoCode;
        }
    }
}

