/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view.preferences;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import processing.app.Base;
import processing.app.I18n;

public class AdditionalBoardsManagerURLTextArea
extends JDialog {
    private ActionListener onOkListener;
    private final JTextArea additionalBoardsManagerURLs = new JTextArea();

    public AdditionalBoardsManagerURLTextArea(Window parent) {
        super(parent);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        Base.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdditionalBoardsManagerURLTextArea.this.cancelActionPerformed(e);
            }
        });
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        JButton cancel = new JButton();
        JButton ok = new JButton();
        JLabel jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(I18n._((String)"Additional Boards Manager URLs"));
        this.setModal(true);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.additionalBoardsManagerURLs.setColumns(20);
        this.additionalBoardsManagerURLs.setRows(5);
        this.additionalBoardsManagerURLs.setName("");
        jScrollPane1.setViewportView(this.additionalBoardsManagerURLs);
        cancel.setText(I18n._((String)"Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalBoardsManagerURLTextArea.this.cancelActionPerformed(evt);
            }
        });
        ok.setText(I18n._((String)"OK"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalBoardsManagerURLTextArea.this.okActionPerformed(evt);
            }
        });
        jLabel1.setText(I18n._((String)"Enter additional URLs, one for each row"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 332, Short.MAX_VALUE).addComponent(ok).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(cancel)).addComponent(jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(cancel).addComponent(ok)).addContainerGap()));
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void okActionPerformed(ActionEvent evt) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "");
        this.onOkListener.actionPerformed(actionEvent);
        this.cancelActionPerformed(evt);
    }

    public void setText(String text) {
        Collection<String> urls = this.splitAndTrim(text, ",");
        this.additionalBoardsManagerURLs.setText(Joiner.on((String)"\n").skipNulls().join(urls));
    }

    private Collection<String> splitAndTrim(String text, String separator) {
        List<String> urls = Arrays.asList(text.split(separator));
        return FluentIterable.from(urls).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.trim();
            }
        }).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !input.isEmpty();
            }
        }).toList();
    }

    public String getText() {
        Collection<String> urls = this.splitAndTrim(this.additionalBoardsManagerURLs.getText(), "\n");
        return Joiner.on((String)",").skipNulls().join(urls);
    }

    public void onOk(ActionListener listener) {
        this.onOkListener = listener;
    }
}

