/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view.findreplace;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Sketch;
import processing.app.helpers.OSUtils;

public class FindReplace
extends JFrame {
    private static final String FIND_TEXT = "findText";
    private static final String REPLACE_TEXT = "replaceText";
    private static final String IGNORE_CASE = "ignoreCase";
    private static final String SEARCH_ALL_FILES = "searchAllFiles";
    private static final String WRAP_AROUND = "wrapAround";
    private final Editor editor;
    private JPanel buttonsContainer;
    private JButton findButton;
    private JTextField findField;
    private JCheckBox ignoreCaseBox;
    private JButton previousButton;
    private JButton replaceAllButton;
    private JButton replaceButton;
    private JTextField replaceField;
    private JButton replaceFindButton;
    private JCheckBox searchAllFilesBox;
    private JCheckBox wrapAroundBox;

    public FindReplace(Editor editor, Map<String, Object> state) {
        this.editor = editor;
        this.initComponents();
        if (OSUtils.isMacOS()) {
            this.buttonsContainer.removeAll();
            this.buttonsContainer.add(this.replaceAllButton);
            this.buttonsContainer.add(this.replaceButton);
            this.buttonsContainer.add(this.replaceFindButton);
            this.buttonsContainer.add(this.previousButton);
            this.buttonsContainer.add(this.findButton);
        }
        this.getRootPane().setDefaultButton(this.findButton);
        Base.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindReplace.this.setVisible(false);
                Base.FIND_DIALOG_STATE = FindReplace.this.findDialogState();
            }
        });
        Base.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FindReplace.this.findField.requestFocusInWindow();
                FindReplace.this.findField.selectAll();
            }
        });
        this.restoreFindDialogState(state);
    }

    private Map<String, Object> findDialogState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put(FIND_TEXT, this.findField.getText());
        state.put(REPLACE_TEXT, this.replaceField.getText());
        state.put(IGNORE_CASE, this.ignoreCaseBox.isSelected());
        state.put(WRAP_AROUND, this.wrapAroundBox.isSelected());
        state.put(SEARCH_ALL_FILES, this.searchAllFilesBox.isSelected());
        return state;
    }

    private void restoreFindDialogState(Map<String, Object> state) {
        if (state.containsKey(FIND_TEXT)) {
            this.findField.setText((String)state.get(FIND_TEXT));
        }
        if (state.containsKey(REPLACE_TEXT)) {
            this.replaceField.setText((String)state.get(REPLACE_TEXT));
        }
        if (state.containsKey(IGNORE_CASE)) {
            this.ignoreCaseBox.setSelected((Boolean)state.get(IGNORE_CASE));
        }
        if (state.containsKey(SEARCH_ALL_FILES)) {
            this.searchAllFilesBox.setSelected((Boolean)state.get(SEARCH_ALL_FILES));
        }
        if (state.containsKey(WRAP_AROUND)) {
            this.wrapAroundBox.setSelected((Boolean)state.get(WRAP_AROUND));
        }
    }

    private void initComponents() {
        JLabel findLabel = new JLabel();
        this.findField = new JTextField();
        JLabel replaceLabel = new JLabel();
        this.replaceField = new JTextField();
        this.ignoreCaseBox = new JCheckBox();
        this.wrapAroundBox = new JCheckBox();
        this.searchAllFilesBox = new JCheckBox();
        this.buttonsContainer = new JPanel();
        this.findButton = new JButton();
        this.previousButton = new JButton();
        this.replaceFindButton = new JButton();
        this.replaceButton = new JButton();
        this.replaceAllButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(I18n._((String)"Find"));
        findLabel.setText(I18n._((String)"Find:"));
        this.findField.setColumns(20);
        replaceLabel.setText(I18n._((String)"Replace with:"));
        this.replaceField.setColumns(20);
        this.ignoreCaseBox.setSelected(true);
        this.ignoreCaseBox.setText(I18n._((String)"Ignore Case"));
        this.wrapAroundBox.setSelected(true);
        this.wrapAroundBox.setText(I18n._((String)"Wrap Around"));
        this.searchAllFilesBox.setText(I18n._((String)"Search all Sketch Tabs"));
        this.findButton.setText(I18n._((String)"Find"));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.findButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.findButton);
        this.previousButton.setText(I18n._((String)"Previous"));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.previousButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.previousButton);
        this.replaceFindButton.setText(I18n._((String)"Replace & Find"));
        this.replaceFindButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.replaceFindButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.replaceFindButton);
        this.replaceButton.setText(I18n._((String)"Replace"));
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.replaceButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.replaceButton);
        this.replaceAllButton.setText(I18n._((String)"Replace All"));
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindReplace.this.replaceAllButtonActionPerformed(evt);
            }
        });
        this.buttonsContainer.add(this.replaceAllButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(replaceLabel).addComponent(findLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.findField).addComponent(this.replaceField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchAllFilesBox).addComponent(this.wrapAroundBox).addComponent(this.ignoreCaseBox)).addGap(0, 0, Short.MAX_VALUE)))).addComponent(this.buttonsContainer, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(findLabel).addComponent(this.findField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(replaceLabel).addComponent(this.replaceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreCaseBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wrapAroundBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchAllFilesBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonsContainer, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        this.findNext();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        this.findPrevious();
    }

    private void replaceFindButtonActionPerformed(ActionEvent evt) {
        this.replaceAndFindNext();
    }

    private void replaceButtonActionPerformed(ActionEvent evt) {
        this.replace();
    }

    private void replaceAllButtonActionPerformed(ActionEvent evt) {
        this.replaceAll();
    }

    private boolean find(boolean wrap, boolean backwards, boolean searchTabs, int originTab) {
        int nextIndex;
        boolean wrapNeeded = false;
        String search = this.findField.getText();
        if (search.length() == 0) {
            return false;
        }
        String text = this.editor.getText();
        if (this.ignoreCaseBox.isSelected()) {
            search = search.toLowerCase();
            text = text.toLowerCase();
        }
        if (!backwards) {
            int selectionEnd = this.editor.getSelectionStop();
            nextIndex = text.indexOf(search, selectionEnd);
            if (wrap && nextIndex == -1) {
                wrapNeeded = true;
            }
        } else {
            int selectionStart = this.editor.getSelectionStart() - 1;
            nextIndex = selectionStart >= 0 ? text.lastIndexOf(search, selectionStart) : -1;
            if (wrap && nextIndex == -1) {
                wrapNeeded = true;
            }
        }
        if (nextIndex == -1) {
            int realCurrentTab;
            Sketch sketch;
            if (searchTabs && (sketch = this.editor.getSketch()).getCodeCount() > 1 && originTab != (realCurrentTab = sketch.getCodeIndex(sketch.getCurrentCode()))) {
                if (originTab < 0) {
                    originTab = realCurrentTab;
                }
                if (!wrap && (!backwards && realCurrentTab + 1 >= sketch.getCodeCount() || backwards && realCurrentTab - 1 < 0)) {
                    return false;
                }
                if (backwards) {
                    sketch.handlePrevCode();
                    this.setVisible(true);
                    int l = this.editor.getText().length() - 1;
                    this.editor.setSelection(l, l);
                } else {
                    sketch.handleNextCode();
                    this.setVisible(true);
                    this.editor.setSelection(0, 0);
                }
                return this.find(wrap, backwards, true, originTab);
            }
            if (wrapNeeded) {
                int n = nextIndex = backwards ? text.lastIndexOf(search) : text.indexOf(search, 0);
            }
        }
        if (nextIndex != -1) {
            this.editor.setSelection(nextIndex, nextIndex + search.length());
            return true;
        }
        return false;
    }

    private void replace() {
        if (this.findField.getText().length() == 0) {
            return;
        }
        int newpos = this.editor.getSelectionStart() - this.findField.getText().length();
        if (newpos < 0) {
            newpos = 0;
        }
        this.editor.setSelection(newpos, newpos);
        boolean foundAtLeastOne = false;
        if (this.find(false, false, this.searchAllFilesBox.isSelected(), -1)) {
            foundAtLeastOne = true;
            this.editor.setSelectedText(this.replaceField.getText());
            this.editor.getSketch().setModified(true);
        }
        if (!foundAtLeastOne) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void replaceAndFindNext() {
        this.replace();
        this.findNext();
    }

    private void replaceAll() {
        if (this.findField.getText().length() == 0) {
            return;
        }
        if (this.searchAllFilesBox.isSelected()) {
            this.editor.getSketch().setCurrentCode(0);
        }
        this.editor.setSelection(0, 0);
        boolean foundAtLeastOne = false;
        while (this.find(false, false, this.searchAllFilesBox.isSelected(), -1)) {
            foundAtLeastOne = true;
            this.editor.setSelectedText(this.replaceField.getText());
            this.editor.getSketch().setModified(true);
        }
        if (!foundAtLeastOne) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void findNext() {
        if (!this.find(this.wrapAroundBox.isSelected(), false, this.searchAllFilesBox.isSelected(), -1)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void findPrevious() {
        if (!this.find(this.wrapAroundBox.isSelected(), true, this.searchAllFilesBox.isSelected(), -1)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setFindText(String text) {
        if (text == null) {
            return;
        }
        this.findField.setText(text);
    }
}

