/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.formatter;

import cc.arduino.packages.formatter.AStyleInterface;
import java.io.File;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.helpers.FileUtils;
import processing.app.syntax.SketchTextArea;
import processing.app.tools.Tool;

public class AStyle
implements Tool {
    private static final String FORMATTER_CONF = "formatter.conf";
    private final AStyleInterface aStyleInterface = new AStyleInterface();
    private final String formatterConfiguration;
    private Editor editor;

    public AStyle() {
        File customFormatterConf = BaseNoGui.getSettingsFile((String)FORMATTER_CONF);
        File defaultFormatterConf = new File(Base.getContentFile("lib"), FORMATTER_CONF);
        File formatterConf = customFormatterConf.exists() ? customFormatterConf : defaultFormatterConf;
        String formatterConfiguration = "";
        try {
            formatterConfiguration = FileUtils.readFileToString((File)formatterConf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.formatterConfiguration = formatterConfiguration;
    }

    @Override
    public void init(Editor editor) {
        this.editor = editor;
    }

    @Override
    public void run() {
        String originalText = this.editor.getText();
        String formattedText = this.aStyleInterface.AStyleMain(originalText, this.formatterConfiguration);
        if (formattedText.equals(originalText)) {
            this.editor.statusNotice(I18n._((String)"No changes necessary for Auto Format."));
            return;
        }
        SketchTextArea textArea = this.editor.getTextArea();
        int line = this.getLineOfOffset(textArea);
        int lineOffset = this.getLineOffset(textArea, line);
        this.editor.getTextArea().getUndoManager().beginInternalAtomicEdit();
        this.editor.setText(formattedText);
        this.editor.getSketch().setModified(true);
        this.editor.getTextArea().getUndoManager().endInternalAtomicEdit();
        if (line != -1 && lineOffset != -1) {
            this.setCaretPosition(textArea, line, lineOffset);
        }
        this.editor.statusNotice(I18n._((String)"Auto Format finished."));
    }

    private void setCaretPosition(SketchTextArea textArea, int line, int lineOffset) {
        try {
            textArea.setCaretPosition(Math.min(textArea.getLineStartOffset(line) + lineOffset, textArea.getLineEndOffset(line) - 1));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private int getLineOffset(SketchTextArea textArea, int line) {
        try {
            return textArea.getCaretPosition() - textArea.getLineStartOffset(line);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private int getLineOfOffset(SketchTextArea textArea) {
        try {
            return textArea.getLineOfOffset(textArea.getCaretPosition());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public String getMenuTitle() {
        return I18n._((String)"Auto Format");
    }
}

