/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.ui;

import cc.arduino.contributions.ui.DropdownItem;
import cc.arduino.contributions.ui.FilterJTextField;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.contributions.ui.ProgressJProgressBar;
import cc.arduino.contributions.ui.listeners.AbstractKeyListener;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Theme;

public abstract class InstallerJDialog<T>
extends JDialog {
    protected final JComboBox categoryChooser;
    protected final FilterJTextField filterField;
    protected final JPanel filtersContainer;
    protected Predicate<T> categoryFilter;
    protected String[] filters;
    protected final String noConnectionErrorMessage;
    protected JTable contribTable;
    protected final FilteredAbstractTableModel<T> contribModel;
    private final JButton closeButton;
    private final JButton dismissErrorMessageButton;
    protected final ProgressJProgressBar progressBar;
    private final Box progressBox;
    private final Box errorMessageBox;
    private final JLabel errorMessage;
    protected final ActionListener categoryChooserActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            DropdownItem selected = (DropdownItem)InstallerJDialog.this.categoryChooser.getSelectedItem();
            if (InstallerJDialog.this.categoryFilter == null || !InstallerJDialog.this.categoryFilter.equals((Object)selected)) {
                InstallerJDialog.this.categoryFilter = selected.getFilterPredicate();
                if (InstallerJDialog.this.contribTable.getCellEditor() != null) {
                    InstallerJDialog.this.contribTable.getCellEditor().stopCellEditing();
                }
                InstallerJDialog.this.updateIndexFilter(InstallerJDialog.this.filters, InstallerJDialog.this.categoryFilter);
            }
        }
    };

    protected abstract FilteredAbstractTableModel<T> createContribModel();

    protected abstract InstallerTableCell createCellRenderer();

    protected abstract InstallerTableCell createCellEditor();

    public InstallerJDialog(Frame parent, String title, Dialog.ModalityType applicationModal, String noConnectionErrorMessage) {
        super((Window)parent, title, applicationModal);
        this.noConnectionErrorMessage = noConnectionErrorMessage;
        this.setResizable(true);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.categoryChooser = new JComboBox();
        this.categoryChooser.setMaximumRowCount(20);
        this.categoryChooser.setEnabled(false);
        this.filterField = new FilterJTextField(I18n._((String)"Filter your search...")){

            @Override
            protected void onFilter(String[] _filters) {
                InstallerJDialog.this.filters = _filters;
                if (InstallerJDialog.this.contribTable.getCellEditor() != null) {
                    InstallerJDialog.this.contribTable.getCellEditor().stopCellEditing();
                }
                InstallerJDialog.this.updateIndexFilter(InstallerJDialog.this.filters, InstallerJDialog.this.categoryFilter);
            }
        };
        this.filtersContainer = new JPanel();
        this.filtersContainer.setLayout(new BoxLayout(this.filtersContainer, 0));
        this.filtersContainer.add(Box.createHorizontalStrut(5));
        this.filtersContainer.add(new JLabel(I18n._((String)"Type")));
        this.filtersContainer.add(Box.createHorizontalStrut(5));
        this.filtersContainer.add(this.categoryChooser);
        this.filtersContainer.add(Box.createHorizontalStrut(5));
        this.filtersContainer.add(this.filterField);
        this.filtersContainer.setBorder(new EmptyBorder(7, 7, 7, 7));
        pane.add((Component)this.filtersContainer, "North");
        this.contribModel = this.createContribModel();
        this.contribTable = new JTable(this.contribModel);
        this.contribTable.setTableHeader(null);
        this.contribTable.setSelectionMode(0);
        this.contribTable.setColumnSelectionAllowed(false);
        this.contribTable.setDragEnabled(false);
        this.contribTable.setIntercellSpacing(new Dimension(0, 1));
        this.contribTable.setShowVerticalLines(false);
        this.contribTable.setSelectionBackground(Theme.getColor("status.notice.bgcolor"));
        this.contribTable.addKeyListener(new AbstractKeyListener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() != 40 && keyEvent.getKeyCode() != 38) {
                    return;
                }
                if (!InstallerJDialog.this.contribTable.isEnabled()) {
                    return;
                }
                InstallerJDialog.this.contribTable.editCellAt(InstallerJDialog.this.contribTable.getSelectedRow(), InstallerJDialog.this.contribTable.getSelectedColumn());
            }
        });
        TableColumnModel tcm = this.contribTable.getColumnModel();
        TableColumn col = tcm.getColumn(0);
        col.setCellRenderer(this.createCellRenderer());
        col.setCellEditor(this.createCellEditor());
        col.setResizable(true);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.contribTable);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(7);
        pane.add((Component)scrollPane, "Center");
        pane.add(Box.createHorizontalStrut(10), "West");
        pane.add(Box.createHorizontalStrut(10), "East");
        this.progressBar = new ProgressJProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setString(" ");
        this.progressBar.setVisible(true);
        this.errorMessage = new JLabel("");
        this.errorMessage.setForeground(Color.RED);
        JButton cancelButton = new JButton(I18n._((String)"Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InstallerJDialog.this.onCancelPressed();
            }
        });
        this.progressBox = Box.createHorizontalBox();
        this.progressBox.add(this.progressBar);
        this.progressBox.add(Box.createHorizontalStrut(5));
        this.progressBox.add(cancelButton);
        this.dismissErrorMessageButton = new JButton(I18n._((String)"OK"));
        this.dismissErrorMessageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InstallerJDialog.this.clearErrorMessage();
                InstallerJDialog.this.setErrorMessageVisible(false);
            }
        });
        this.closeButton = new JButton(I18n._((String)"Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InstallerJDialog.this.dispatchEvent(new WindowEvent(InstallerJDialog.this, 201));
            }
        });
        this.errorMessageBox = Box.createHorizontalBox();
        this.errorMessageBox.add(Box.createHorizontalGlue());
        this.errorMessageBox.add(this.errorMessage);
        this.errorMessageBox.add(Box.createHorizontalGlue());
        this.errorMessageBox.add(this.dismissErrorMessageButton);
        this.errorMessageBox.add(this.closeButton);
        this.errorMessageBox.setVisible(false);
        JPanel progressPanel = new JPanel();
        progressPanel.setBorder(new EmptyBorder(7, 10, 7, 10));
        progressPanel.setLayout(new BoxLayout(progressPanel, 1));
        progressPanel.add(this.progressBox);
        progressPanel.add(this.errorMessageBox);
        pane.add((Component)progressPanel, "South");
        this.setProgressVisible(false, "");
        this.setMinimumSize(new Dimension(800, 450));
        this.setDefaultCloseOperation(2);
        Base.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerJDialog.this.dispatchEvent(new WindowEvent(InstallerJDialog.this, 201));
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallerJDialog.this.onUpdatePressed();
            }
        });
    }

    public void updateIndexFilter(String[] filters, Predicate<T> ... additionalFilters) {
        Collection notNullAdditionalFilters = Collections2.filter(Arrays.asList(additionalFilters), (Predicate)Predicates.notNull());
        this.contribModel.updateIndexFilter(filters, notNullAdditionalFilters.toArray(new Predicate[notNullAdditionalFilters.size()]));
    }

    public void setErrorMessage(String message) {
        this.errorMessage.setText("<html><body>" + message + "</body></html>");
        this.setErrorMessageVisible(true);
    }

    public void clearErrorMessage() {
        this.errorMessage.setText("");
        this.setErrorMessageVisible(false);
    }

    public void setProgressVisible(boolean visible, String status) {
        if (visible) {
            this.setDefaultCloseOperation(0);
        } else {
            this.setDefaultCloseOperation(2);
        }
        this.errorMessageBox.setVisible(!visible);
        this.progressBox.setVisible(visible);
        this.filterField.setEnabled(!visible);
        this.categoryChooser.setEnabled(!visible);
        this.contribTable.setEnabled(!visible);
        if (this.contribTable.getCellEditor() != null) {
            ((InstallerTableCell)this.contribTable.getCellEditor()).setEnabled(!visible);
            ((InstallerTableCell)this.contribTable.getCellEditor()).setStatus(status);
        }
    }

    private void setErrorMessageVisible(boolean visible) {
        this.errorMessage.setVisible(visible);
        this.dismissErrorMessageButton.setVisible(visible);
        this.closeButton.setVisible(!visible);
        this.errorMessageBox.setVisible(true);
    }

    public void setFilterText(String filterText) {
        for (FocusListener listener : this.filterField.getFocusListeners()) {
            listener.focusGained(new FocusEvent(this.filterField, 1004));
        }
        this.filterField.setText(filterText);
    }

    protected void onCancelPressed() {
        this.clearErrorMessage();
    }

    protected void onUpdatePressed() {
        this.clearErrorMessage();
    }
}

