/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages.ui;

import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributionInstaller;
import cc.arduino.contributions.packages.ContributionsIndexer;
import cc.arduino.contributions.packages.ui.ContributedPlatformTableCell;
import cc.arduino.contributions.packages.ui.ContributionIndexTableModel;
import cc.arduino.contributions.packages.ui.DropdownAllCoresItem;
import cc.arduino.contributions.packages.ui.DropdownCoreOfCategoryItem;
import cc.arduino.contributions.ui.DropdownItem;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import cc.arduino.contributions.ui.InstallerJDialog;
import cc.arduino.contributions.ui.InstallerJDialogUncaughtExceptionHandler;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.utils.Progress;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import processing.app.I18n;
import processing.app.Platform;

public class ContributionManagerUI
extends InstallerJDialog {
    private final Platform platform;
    private ContributionInstaller installer;
    private Thread installerThread = null;

    protected FilteredAbstractTableModel createContribModel() {
        return new ContributionIndexTableModel();
    }

    private ContributionIndexTableModel getContribModel() {
        return (ContributionIndexTableModel)this.contribModel;
    }

    @Override
    protected InstallerTableCell createCellRenderer() {
        return new ContributedPlatformTableCell();
    }

    @Override
    protected InstallerTableCell createCellEditor() {
        return new ContributedPlatformTableCell(){

            @Override
            protected void onInstall(ContributedPlatform selected, ContributedPlatform installed) {
                if (selected.isReadOnly()) {
                    ContributionManagerUI.this.onRemovePressed(installed, false);
                } else {
                    ContributionManagerUI.this.onInstallPressed(selected, installed);
                }
            }

            @Override
            protected void onRemove(ContributedPlatform installedPlatform) {
                ContributionManagerUI.this.onRemovePressed(installedPlatform, true);
            }
        };
    }

    public ContributionManagerUI(Frame parent, Platform platform) {
        super(parent, I18n._((String)"Boards Manager"), Dialog.ModalityType.APPLICATION_MODAL, I18n._((String)"Unable to reach Arduino.cc due to possible network issues."));
        this.platform = platform;
    }

    public void setIndexer(ContributionsIndexer indexer) {
        DropdownItem previouslySelectedCategory = (DropdownItem)this.categoryChooser.getSelectedItem();
        this.categoryChooser.removeActionListener(this.categoryChooserActionListener);
        this.getContribModel().setIndexer(indexer);
        this.categoryFilter = null;
        this.categoryChooser.removeAllItems();
        this.filterField.setEnabled(this.getContribModel().getRowCount() > 0);
        this.categoryChooser.addActionListener(this.categoryChooserActionListener);
        this.categoryChooser.addItem(new DropdownAllCoresItem());
        List categories = indexer.getCategories();
        for (String s : categories) {
            this.categoryChooser.addItem(new DropdownCoreOfCategoryItem(s));
        }
        if (previouslySelectedCategory != null) {
            this.categoryChooser.setSelectedItem(previouslySelectedCategory);
        } else {
            this.categoryChooser.setSelectedIndex(0);
        }
        this.installer = new ContributionInstaller(indexer, this.platform){

            public void onProgress(Progress progress) {
                ContributionManagerUI.this.setProgress(progress);
            }
        };
    }

    public void setProgress(Progress progress) {
        this.progressBar.setValue(progress);
    }

    @Override
    public void onCancelPressed() {
        super.onCancelPressed();
        if (this.installerThread != null) {
            this.installerThread.interrupt();
        }
    }

    @Override
    public void onUpdatePressed() {
        super.onUpdatePressed();
        this.installerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ContributionManagerUI.this.setProgressVisible(true, "");
                    List downloadedPackageIndexFiles = ContributionManagerUI.this.installer.updateIndex();
                    ContributionManagerUI.this.installer.deleteUnknownFiles(downloadedPackageIndexFiles);
                    ContributionManagerUI.this.onIndexesUpdated();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    ContributionManagerUI.this.setProgressVisible(false, "");
                }
            }
        });
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    public void onInstallPressed(final ContributedPlatform platformToInstall, final ContributedPlatform platformToRemove) {
        this.clearErrorMessage();
        this.installerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LinkedList errors = new LinkedList();
                try {
                    ContributionManagerUI.this.setProgressVisible(true, I18n._((String)"Installing..."));
                    errors.addAll(ContributionManagerUI.this.installer.install(platformToInstall));
                    if (platformToRemove != null && !platformToRemove.isReadOnly()) {
                        errors.addAll(ContributionManagerUI.this.installer.remove(platformToRemove));
                    }
                    ContributionManagerUI.this.onIndexesUpdated();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    ContributionManagerUI.this.setProgressVisible(false, "");
                    if (!errors.isEmpty()) {
                        ContributionManagerUI.this.setErrorMessage((String)errors.get(0));
                    }
                }
            }
        });
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    public void onRemovePressed(final ContributedPlatform platform, boolean showWarning) {
        int chosenOption;
        this.clearErrorMessage();
        if (showWarning && (chosenOption = JOptionPane.showConfirmDialog(this, I18n.format((String)I18n._((String)"Do you want to remove {0}?\nIf you do so you won't be able to use {0} any more."), (Object[])new Object[]{platform.getName()}), I18n._((String)"Please confirm boards deletion"), 0, 3)) != 0) {
            return;
        }
        this.installerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ContributionManagerUI.this.setProgressVisible(true, I18n._((String)"Removing..."));
                    ContributionManagerUI.this.installer.remove(platform);
                    ContributionManagerUI.this.onIndexesUpdated();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    ContributionManagerUI.this.setProgressVisible(false, "");
                }
            }
        });
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    protected void onIndexesUpdated() throws Exception {
    }
}

