/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages.ui;

import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributionsIndexer;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ContributionIndexTableModel
extends FilteredAbstractTableModel<ContributedPlatform> {
    public static final int DESCRIPTION_COL = 0;
    private List<ContributedPlatformReleases> contributions = new ArrayList<ContributedPlatformReleases>();
    private String[] columnNames = new String[]{"Description"};
    private Class<?>[] columnTypes = new Class[]{ContributedPlatform.class};
    private ContributionsIndexer indexer;

    public void setIndexer(ContributionsIndexer indexer) {
        this.indexer = indexer;
    }

    @Override
    public void updateIndexFilter(String[] filters, Predicate<ContributedPlatform> ... additionalFilters) {
        this.contributions.clear();
        Predicate filter = Predicates.and(additionalFilters);
        for (ContributedPackage pack : this.indexer.getPackages()) {
            for (ContributedPlatform platform : pack.getPlatforms()) {
                if (!filter.apply((Object)platform) || !this.stringContainsAll(platform.getName(), filters)) continue;
                this.addContribution(platform);
            }
        }
        this.fireTableDataChanged();
    }

    private boolean stringContainsAll(String string, String[] set) {
        if (set == null) {
            return true;
        }
        for (String s : set) {
            if (string.toLowerCase().contains(s.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private void addContribution(ContributedPlatform platform) {
        for (ContributedPlatformReleases contribution : this.contributions) {
            if (!contribution.shouldContain(platform)) continue;
            contribution.add(platform);
            return;
        }
        this.contributions.add(new ContributedPlatformReleases(platform));
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.contributions.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int colum) {
        return this.columnTypes[colum];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.contributions.size()) {
            return null;
        }
        ContributedPlatformReleases contribution = this.contributions.get(row);
        if (col == 0) {
            return contribution;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    public ContributedPlatformReleases getReleases(int row) {
        return this.contributions.get(row);
    }

    public ContributedPlatform getSelectedRelease(int row) {
        return this.contributions.get(row).getSelected();
    }

    public void update() {
        this.fireTableDataChanged();
    }

    public static class ContributedPlatformReleases {
        public final ContributedPackage packager;
        public final String arch;
        public final List<ContributedPlatform> releases;
        public final List<String> versions;
        public ContributedPlatform selected = null;

        public ContributedPlatformReleases(ContributedPlatform platform) {
            this.packager = platform.getParentPackage();
            this.arch = platform.getArchitecture();
            this.releases = new LinkedList<ContributedPlatform>();
            this.versions = new LinkedList<String>();
            this.add(platform);
        }

        public boolean shouldContain(ContributedPlatform platform) {
            if (platform.getParentPackage() != this.packager) {
                return false;
            }
            return platform.getArchitecture().equals(this.arch);
        }

        public void add(ContributedPlatform platform) {
            this.releases.add(platform);
            String version = platform.getParsedVersion();
            if (version != null) {
                this.versions.add(version);
            }
            this.selected = this.getLatest();
        }

        public ContributedPlatform getInstalled() {
            LinkedList installedReleases = new LinkedList(Collections2.filter(this.releases, (Predicate)new InstalledPredicate()));
            Collections.sort(installedReleases, new DownloadableContributionBuiltInAtTheBottomComparator());
            if (installedReleases.isEmpty()) {
                return null;
            }
            return (ContributedPlatform)installedReleases.get(0);
        }

        public ContributedPlatform getLatest() {
            return (ContributedPlatform)ContributionIndexTableModel.getLatestOf(this.releases);
        }

        public ContributedPlatform getSelected() {
            return this.selected;
        }

        public void select(ContributedPlatform value) {
            for (ContributedPlatform plat : this.releases) {
                if (plat != value) continue;
                this.selected = plat;
                return;
            }
        }
    }
}

