/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages.ui;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.filters.BuiltInPredicate;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedBoard;
import cc.arduino.contributions.packages.ContributedHelp;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ui.ContributionIndexTableModel;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.contributions.ui.listeners.DelegatingKeyListener;
import cc.arduino.utils.ReverseComparator;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import processing.app.Base;
import processing.app.I18n;

public class ContributedPlatformTableCell
extends InstallerTableCell {
    private JPanel panel;
    private JButton installButton;
    private JButton removeButton;
    private Component removeButtonPlaceholder;
    private Component installButtonPlaceholder;
    private JComboBox downgradeChooser;
    private JComboBox versionToInstallChooser;
    private JButton downgradeButton;
    private JPanel buttonsPanel;
    private JPanel inactiveButtonsPanel;
    private JLabel statusLabel;
    private ContributionIndexTableModel.ContributedPlatformReleases editorValue;
    private JTable parentTable;
    private Timer enabler = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ContributedPlatformTableCell.this.enable(true);
            ContributedPlatformTableCell.this.enabler.stop();
        }
    });

    public ContributedPlatformTableCell() {
        this.installButton = new JButton(I18n._((String)"Install"));
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributedPlatformTableCell.this.onInstall(ContributedPlatformTableCell.this.editorValue.getSelected(), ContributedPlatformTableCell.this.editorValue.getInstalled());
            }
        });
        int width = this.installButton.getPreferredSize().width;
        this.installButtonPlaceholder = Box.createRigidArea(new Dimension(width, 1));
        this.removeButton = new JButton(I18n._((String)"Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributedPlatformTableCell.this.onRemove(ContributedPlatformTableCell.this.editorValue.getInstalled());
            }
        });
        width = this.removeButton.getPreferredSize().width;
        this.removeButtonPlaceholder = Box.createRigidArea(new Dimension(width, 1));
        this.downgradeButton = new JButton(I18n._((String)"Install"));
        this.downgradeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributedPlatform selected = (ContributedPlatform)ContributedPlatformTableCell.this.downgradeChooser.getSelectedItem();
                ContributedPlatformTableCell.this.onInstall(selected, ContributedPlatformTableCell.this.editorValue.getInstalled());
            }
        });
        this.downgradeChooser = new JComboBox();
        this.downgradeChooser.addItem("-");
        this.downgradeChooser.setMaximumSize(this.downgradeChooser.getPreferredSize());
        this.downgradeChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selectVersionItem = ContributedPlatformTableCell.this.downgradeChooser.getItemAt(0);
                boolean disableDowngrade = e.getItem() == selectVersionItem;
                ContributedPlatformTableCell.this.downgradeButton.setEnabled(!disableDowngrade);
            }
        });
        this.versionToInstallChooser = new JComboBox();
        this.versionToInstallChooser.addItem("-");
        this.versionToInstallChooser.setMaximumSize(this.versionToInstallChooser.getPreferredSize());
        this.versionToInstallChooser.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ContributedPlatformTableCell.this.editorValue.select((ContributedPlatform)ContributedPlatformTableCell.this.versionToInstallChooser.getSelectedItem());
            }
        });
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.makeNewDescription(this.panel);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.add(Box.createHorizontalStrut(7));
        this.buttonsPanel.add(this.downgradeChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.downgradeButton);
        this.buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonsPanel.add(this.versionToInstallChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.installButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.removeButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(Box.createHorizontalStrut(15));
        this.panel.add(this.buttonsPanel);
        this.inactiveButtonsPanel = new JPanel();
        this.inactiveButtonsPanel.setLayout(new BoxLayout(this.inactiveButtonsPanel, 0));
        this.inactiveButtonsPanel.setOpaque(false);
        int height = this.installButton.getMinimumSize().height;
        this.inactiveButtonsPanel.add(Box.createVerticalStrut(height));
        this.inactiveButtonsPanel.add(Box.createGlue());
        this.statusLabel = new JLabel(" ");
        this.inactiveButtonsPanel.add(this.statusLabel);
        this.inactiveButtonsPanel.add(Box.createHorizontalStrut(15));
        this.panel.add(this.inactiveButtonsPanel);
        this.panel.add(Box.createVerticalStrut(15));
    }

    private JTextPane makeNewDescription(JPanel panel) {
        if (panel.getComponentCount() > 0) {
            panel.remove(0);
        }
        JTextPane description = new JTextPane();
        description.setInheritsPopupMenu(true);
        Insets margin = description.getMargin();
        margin.bottom = 0;
        description.setMargin(margin);
        description.setContentType("text/html");
        Document doc = description.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet stylesheet = html.getStyleSheet();
            stylesheet.addRule("body { margin: 0; padding: 0;font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;font-size: 100%;font-size: 0.95em; }");
        }
        description.setOpaque(false);
        description.setBorder(new EmptyBorder(4, 7, 7, 7));
        description.setHighlighter(null);
        description.setEditable(false);
        description.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Base.openURL(e.getDescription());
                }
            }
        });
        description.addKeyListener(new DelegatingKeyListener(this.parentTable));
        panel.add((Component)description, 0);
        return description;
    }

    protected void onRemove(ContributedPlatform contributedPlatform) {
    }

    protected void onInstall(ContributedPlatform contributedPlatform, ContributedPlatform installed) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.parentTable = table;
        this.setEnabled(false);
        Component component = this.getUpdatedCellComponent(value, isSelected, row, false);
        if (row % 2 == 0) {
            component.setBackground(new Color(236, 241, 241));
        } else {
            component.setBackground(new Color(255, 255, 255));
        }
        int height = new Double(component.getPreferredSize().getHeight()).intValue();
        if (table.getRowHeight(row) < height) {
            table.setRowHeight(row, height);
        }
        return component;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.parentTable = table;
        this.editorValue = (ContributionIndexTableModel.ContributedPlatformReleases)value;
        this.setEnabled(true);
        final ContributedPlatform installed = this.editorValue.getInstalled();
        LinkedList<ContributedPlatform> releases = new LinkedList<ContributedPlatform>(this.editorValue.releases);
        LinkedList uninstalledReleases = new LinkedList(Collections2.filter(releases, (Predicate)Predicates.not((Predicate)new InstalledPredicate())));
        LinkedList installedBuiltIn = new LinkedList(Collections2.filter(releases, (Predicate)Predicates.and((Predicate)new InstalledPredicate(), (Predicate)new BuiltInPredicate())));
        if (installed != null && !installedBuiltIn.contains(installed)) {
            uninstalledReleases.addAll(installedBuiltIn);
        }
        Collections.sort(uninstalledReleases, new ReverseComparator((Comparator)new DownloadableContributionVersionComparator()));
        this.downgradeChooser.removeAllItems();
        this.downgradeChooser.addItem(I18n._((String)"Select version"));
        final LinkedList uninstalledPreviousReleases = Lists.newLinkedList();
        final LinkedList uninstalledNewerReleases = Lists.newLinkedList();
        final VersionComparator versionComparator = new VersionComparator();
        Lists.newLinkedList((Iterable)Lists.transform(uninstalledReleases, (Function)new Function<ContributedPlatform, ContributedPlatform>(){

            public ContributedPlatform apply(ContributedPlatform input) {
                if (installed == null || versionComparator.greaterThan(installed.getParsedVersion(), input.getParsedVersion())) {
                    uninstalledPreviousReleases.add(input);
                } else {
                    uninstalledNewerReleases.add(input);
                }
                return input;
            }
        }));
        for (ContributedPlatform release : uninstalledNewerReleases) {
            this.downgradeChooser.addItem(release);
        }
        for (ContributedPlatform release : uninstalledPreviousReleases) {
            this.downgradeChooser.addItem(release);
        }
        this.downgradeChooser.setVisible(installed != null && (!uninstalledPreviousReleases.isEmpty() || uninstalledNewerReleases.size() > 1));
        this.downgradeButton.setVisible(installed != null && (!uninstalledPreviousReleases.isEmpty() || uninstalledNewerReleases.size() > 1));
        this.versionToInstallChooser.removeAllItems();
        for (ContributedPlatform release : uninstalledReleases) {
            this.versionToInstallChooser.addItem(release);
        }
        this.versionToInstallChooser.setVisible(installed == null && uninstalledReleases.size() > 1);
        Component component = this.getUpdatedCellComponent(value, true, row, !installedBuiltIn.isEmpty());
        component.setBackground(new Color(218, 227, 227));
        return component;
    }

    private Component getUpdatedCellComponent(Object value, boolean isSelected, int row, boolean hasBuiltInRelease) {
        String url;
        String author;
        boolean upgradable;
        boolean removable;
        boolean installable;
        ContributionIndexTableModel.ContributedPlatformReleases releases = (ContributionIndexTableModel.ContributedPlatformReleases)value;
        JTextPane description = this.makeNewDescription(this.panel);
        if (releases == null) {
            return this.panel;
        }
        ContributedPlatform selected = releases.getSelected();
        ContributedPlatform installed = releases.getInstalled();
        if (installed == null) {
            installable = true;
            removable = false;
            upgradable = false;
        } else {
            installable = false;
            removable = !installed.isReadOnly() && !hasBuiltInRelease;
            boolean bl = upgradable = new DownloadableContributionVersionComparator().compare((DownloadableContribution)selected, (DownloadableContribution)installed) > 0;
        }
        if (installable) {
            this.installButton.setText(I18n._((String)"Install"));
        }
        if (upgradable) {
            this.installButton.setText(I18n._((String)"Update"));
        }
        this.installButton.setVisible(installable || upgradable);
        this.installButtonPlaceholder.setVisible(!installable && !upgradable);
        this.removeButton.setVisible(removable);
        this.removeButtonPlaceholder.setVisible(!removable);
        String desc = "<html><body>";
        desc = desc + "<b>" + selected.getName() + "</b>";
        if (installed != null && installed.isReadOnly()) {
            desc = desc + " Built-In ";
        }
        if ((author = selected.getParentPackage().getMaintainer()) != null && !author.isEmpty()) {
            desc = desc + " " + I18n.format((String)"by <b>{0}</b>", (Object[])new Object[]{author});
        }
        if (installed != null) {
            desc = desc + " " + I18n.format((String)I18n._((String)"version <b>{0}</b>"), (Object[])new Object[]{installed.getParsedVersion()}) + " <strong><font color=\"#00979D\">INSTALLED</font></strong>";
        }
        desc = desc + "<br />";
        desc = desc + I18n._((String)"Boards included in this package:") + "<br />";
        for (ContributedBoard board : selected.getBoards()) {
            desc = desc + board.getName() + ", ";
        }
        desc = desc.substring(0, desc.lastIndexOf(44)) + ".<br />";
        ContributedHelp help = null;
        if (selected.getHelp() != null) {
            help = selected.getHelp();
        } else if (selected.getParentPackage().getHelp() != null) {
            help = selected.getParentPackage().getHelp();
        }
        if (help != null && (url = help.getOnline()) != null && !url.isEmpty()) {
            desc = desc + " " + I18n.format((String)"<a href=\"{0}\">Online help</a><br/>", (Object[])new Object[]{url});
        }
        if ((url = selected.getParentPackage().getWebsiteURL()) != null && !url.isEmpty()) {
            desc = desc + " " + I18n.format((String)"<a href=\"{0}\">More info</a>", (Object[])new Object[]{url});
        }
        desc = desc + "</body></html>";
        description.setText(desc);
        description.setBackground(Color.WHITE);
        int width = this.parentTable.getBounds().width;
        this.setJTextPaneDimensionToFitContainedText(description, width);
        if (isSelected) {
            this.panel.setBackground(this.parentTable.getSelectionBackground());
            this.panel.setForeground(this.parentTable.getSelectionForeground());
        } else {
            this.panel.setBackground(this.parentTable.getBackground());
            this.panel.setForeground(this.parentTable.getForeground());
        }
        return this.panel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enable(false);
        if (enabled) {
            this.enabler.start();
        } else {
            this.enabler.stop();
        }
        this.buttonsPanel.setVisible(enabled);
        this.inactiveButtonsPanel.setVisible(!enabled);
    }

    public void enable(boolean enabled) {
        this.installButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    @Override
    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }

    public void invalidate() {
        this.panel.invalidate();
    }
}

