/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndexer;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class LibrariesIndexTableModel
extends FilteredAbstractTableModel<ContributedLibrary> {
    public static final int DESCRIPTION_COL = 0;
    private final List<ContributedLibraryReleases> contributions = new ArrayList<ContributedLibraryReleases>();
    private final String[] columnNames = new String[]{"Description"};
    private final Class<?>[] columnTypes = new Class[]{ContributedPlatform.class};
    private LibrariesIndexer indexer;
    Predicate<ContributedLibrary> selectedCategoryFilter = null;
    String[] selectedFilters = null;

    public void setIndexer(LibrariesIndexer _index) {
        this.indexer = _index;
    }

    @Override
    public void updateIndexFilter(String[] filters, Predicate<ContributedLibrary> ... additionalFilters) {
        this.selectedCategoryFilter = Predicates.and(additionalFilters);
        this.selectedFilters = filters;
        this.update();
    }

    private boolean stringContainsAll(String string, String[] filters) {
        if (string == null) {
            return false;
        }
        if (filters == null) {
            return true;
        }
        for (String filter : filters) {
            if (string.toLowerCase().contains(filter.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private void addContribution(ContributedLibrary lib) {
        for (ContributedLibraryReleases contribution : this.contributions) {
            if (!contribution.shouldContain(lib)) continue;
            contribution.add(lib);
            return;
        }
        this.contributions.add(new ContributedLibraryReleases(lib));
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.contributions.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int colum) {
        return this.columnTypes[colum];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            this.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.contributions.size()) {
            return null;
        }
        ContributedLibraryReleases contribution = this.contributions.get(row);
        if (col == 0) {
            return contribution;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    public ContributedLibraryReleases getReleases(int row) {
        return this.contributions.get(row);
    }

    public ContributedLibrary getSelectedRelease(int row) {
        return this.contributions.get(row).getSelected();
    }

    public void update() {
        this.updateContributions();
        this.fireTableDataChanged();
    }

    private void applyFilterToLibrary(ContributedLibrary lib) {
        if (this.selectedCategoryFilter != null && !this.selectedCategoryFilter.apply((Object)lib)) {
            return;
        }
        if (!(this.stringContainsAll(lib.getName(), this.selectedFilters) || this.stringContainsAll(lib.getParagraph(), this.selectedFilters) || this.stringContainsAll(lib.getSentence(), this.selectedFilters))) {
            return;
        }
        this.addContribution(lib);
    }

    public void updateLibrary(ContributedLibrary lib) {
        int row = -1;
        for (ContributedLibraryReleases releases : this.contributions) {
            if (!releases.shouldContain(lib)) continue;
            row = this.contributions.indexOf(releases);
        }
        this.updateContributions();
        for (ContributedLibraryReleases releases : this.contributions) {
            if (!releases.shouldContain(lib)) continue;
            if (row == -1) {
                row = this.contributions.indexOf(releases);
                this.fireTableRowsInserted(row, row);
            } else {
                this.fireTableRowsUpdated(row, row);
            }
            return;
        }
        this.fireTableRowsDeleted(row, row);
    }

    private void updateContributions() {
        this.contributions.clear();
        for (ContributedLibrary l : this.indexer.getIndex().getLibraries()) {
            this.applyFilterToLibrary(l);
        }
        for (ContributedLibrary l : this.indexer.getInstalledLibraries()) {
            this.applyFilterToLibrary(l);
        }
        Collections.sort(this.contributions);
    }

    public static class ContributedLibraryReleases
    implements Comparable<ContributedLibraryReleases> {
        public final String name;
        public final List<ContributedLibrary> releases;
        public final List<String> versions;
        public ContributedLibrary selected;

        public ContributedLibraryReleases(ContributedLibrary library) {
            this.name = library.getName();
            this.versions = new LinkedList<String>();
            this.releases = new LinkedList<ContributedLibrary>();
            this.selected = null;
            this.add(library);
        }

        public boolean shouldContain(ContributedLibrary lib) {
            return lib.getName().equals(this.name);
        }

        public void add(ContributedLibrary library) {
            this.releases.add(library);
            String version = library.getParsedVersion();
            if (version != null) {
                this.versions.add(version);
            }
            this.selected = this.getLatest();
        }

        public ContributedLibrary getInstalled() {
            LinkedList installedReleases = new LinkedList(Collections2.filter(this.releases, (Predicate)new InstalledPredicate()));
            Collections.sort(installedReleases, new DownloadableContributionBuiltInAtTheBottomComparator());
            if (installedReleases.isEmpty()) {
                return null;
            }
            return (ContributedLibrary)installedReleases.get(0);
        }

        public ContributedLibrary getLatest() {
            return (ContributedLibrary)LibrariesIndexTableModel.getLatestOf(this.releases);
        }

        public ContributedLibrary getSelected() {
            return this.selected;
        }

        public void select(ContributedLibrary value) {
            for (ContributedLibrary plat : this.releases) {
                if (plat != value) continue;
                this.selected = plat;
                return;
            }
        }

        @Override
        public int compareTo(ContributedLibraryReleases o) {
            return this.name.compareToIgnoreCase(o.name);
        }
    }
}

