/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.VersionHelper;
import cc.arduino.contributions.filters.BuiltInPredicate;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.view.Event;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;

public class BuiltInCoreIsNewerCheck
implements Runnable {
    private final Base base;

    public BuiltInCoreIsNewerCheck(Base base) {
        this.base = base;
    }

    @Override
    public void run() {
        try {
            this.builtInPackageIsNewerCheck();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void builtInPackageIsNewerCheck() throws InterruptedException {
        if (PreferencesData.getInteger((String)"builtin_platform_is_newer", (int)-1) >= 10605) {
            return;
        }
        LinkedList contributedPlatforms = Lists.newLinkedList((Iterable)Iterables.concat((Iterable)Collections2.transform((Collection)BaseNoGui.indexer.getPackages(), (Function)new Function<ContributedPackage, List<ContributedPlatform>>(){

            public List<ContributedPlatform> apply(ContributedPackage input) {
                return input.getPlatforms();
            }
        })));
        LinkedList installedBuiltInPlatforms = new LinkedList(Collections2.filter((Collection)contributedPlatforms, (Predicate)Predicates.and((Predicate)new InstalledPredicate(), (Predicate)new BuiltInPredicate())));
        if (installedBuiltInPlatforms.size() != 1) {
            return;
        }
        final ContributedPlatform installedBuiltIn = (ContributedPlatform)installedBuiltInPlatforms.get(0);
        ContributedPlatform installedNotBuiltIn = BaseNoGui.indexer.getInstalled(installedBuiltIn.getParentPackage().getName(), installedBuiltIn.getArchitecture());
        if (installedNotBuiltIn == null) {
            return;
        }
        while (!this.base.hasActiveEditor()) {
            Thread.sleep(100L);
        }
        if (VersionHelper.valueOf((String)installedBuiltIn.getParsedVersion()).greaterThan(VersionHelper.valueOf((String)installedNotBuiltIn.getParsedVersion()))) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreferencesData.setInteger((String)"builtin_platform_is_newer", (int)10605);
                    assert (BuiltInCoreIsNewerCheck.this.base.hasActiveEditor());
                    int chosenOption = JOptionPane.showConfirmDialog(BuiltInCoreIsNewerCheck.this.base.getActiveEditor(), I18n.format((String)I18n._((String)"The IDE includes an updated {0} package, but you're using an older one.\nDo you want to upgrade {0}?"), (Object[])new Object[]{installedBuiltIn.getName()}), I18n.format((String)I18n._((String)"A newer {0} package is available"), (Object[])new Object[]{installedBuiltIn.getName()}), 0, 3);
                    if (chosenOption == 0) {
                        Action openBoardsManager = BuiltInCoreIsNewerCheck.this.base.getOpenBoardsManager();
                        Event event = new Event(BuiltInCoreIsNewerCheck.this.base.getActiveEditor(), 1001, installedBuiltIn.getName());
                        event.getPayload().put("filterText", installedBuiltIn.getName());
                        openBoardsManager.actionPerformed(event);
                    }
                }
            });
        }
    }
}

