/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import processing.app.debug.TargetPackage;
import processing.app.legacy.PApplet;
import processing.app.legacy.PConstants;
import processing.app.windows.ListComPortsParser;
import processing.app.windows.RegQueryParser;

public class Platform
extends processing.app.Platform {
    private File settingsFolder;
    private File defaultSketchbookFolder;

    @Override
    public void init() throws IOException {
        super.init();
        this.checkPath();
        this.recoverSettingsFolderPath();
        this.recoverDefaultSketchbookFolder();
    }

    private void recoverSettingsFolderPath() throws IOException {
        String path = this.getFolderPathFromRegistry("AppData");
        this.settingsFolder = new File(path, "Arduino15");
    }

    private void recoverDefaultSketchbookFolder() throws IOException {
        String path = this.getFolderPathFromRegistry("Personal");
        this.defaultSketchbookFolder = new File(path, "Arduino");
    }

    private String getFolderPathFromRegistry(String folderType) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)baos, null));
        CommandLine toDevicePath = CommandLine.parse((String)("reg query \"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\" /v \"" + folderType + "\""));
        executor.execute(toDevicePath);
        return new RegQueryParser(new String(baos.toByteArray())).getValueOfKey();
    }

    protected void checkPath() {
        String path = System.getProperty("java.library.path");
        String[] pieces = PApplet.split(path, File.pathSeparatorChar);
        String[] legit = new String[pieces.length];
        int legitCount = 0;
        for (String item : pieces) {
            File directory;
            if (item.startsWith("\"")) {
                item = item.substring(1);
            }
            if (item.endsWith("\"")) {
                item = item.substring(0, item.length() - 1);
            }
            if (item.endsWith(File.separator)) {
                item = item.substring(0, item.length() - File.separator.length());
            }
            if (!(directory = new File(item)).exists() || item.trim().length() == 0) continue;
            legit[legitCount++] = item;
        }
        String newPath = PApplet.join(legit = PApplet.subset(legit, 0, legitCount), File.pathSeparator);
        if (!newPath.equals(path)) {
            System.setProperty("java.library.path", newPath);
        }
    }

    @Override
    public File getSettingsFolder() {
        return this.settingsFolder;
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return this.defaultSketchbookFolder;
    }

    @Override
    public void openURL(String url) throws Exception {
        if (url.startsWith("http") || url.startsWith("file:")) {
            Runtime.getRuntime().exec("cmd /c start " + url);
        } else {
            Runtime.getRuntime().exec("cmd /c \"" + url + "\"");
        }
    }

    @Override
    public boolean openFolderAvailable() {
        return true;
    }

    @Override
    public void openFolder(File file) throws Exception {
        String folder = file.getAbsolutePath();
        Runtime.getRuntime().exec("explorer \"" + folder + "\"");
    }

    @Override
    public String getName() {
        return PConstants.platformNames[1];
    }

    @Override
    public Map<String, Object> resolveDeviceAttachedTo(String serial, Map<String, TargetPackage> packages, String devicesListOutput) {
        assert (packages != null);
        if (devicesListOutput == null) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
        try {
            String vidPid = new ListComPortsParser().extractVIDAndPID(devicesListOutput, serial);
            if (vidPid == null) {
                return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
            }
            return super.resolveDeviceByVendorIdProductId(packages, vidPid);
        }
        catch (IOException e) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
    }

    @Override
    public String preListAllCandidateDevices() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)baos, null));
        try {
            String listComPorts = new File(System.getProperty("user.dir"), "hardware/tools/listComPorts.exe").getCanonicalPath();
            CommandLine toDevicePath = CommandLine.parse((String)listComPorts);
            executor.execute(toDevicePath);
            return new String(baos.toByteArray());
        }
        catch (Throwable e) {
            return super.preListAllCandidateDevices();
        }
    }

    @Override
    public void fixPrefsFilePermissions(File prefsFile) throws IOException {
    }

    @Override
    public List<File> postInstallScripts(File folder) {
        LinkedList<File> scripts = new LinkedList<File>();
        scripts.add(new File(folder, "post_install.bat"));
        return scripts;
    }

    public void symlink(File something, File somewhere) throws IOException, InterruptedException {
    }

    @Override
    public void link(File something, File somewhere) throws IOException, InterruptedException {
    }

    @Override
    public void chmod(File file, int mode) throws IOException, InterruptedException {
    }
}

