/*
 * Decompiled with CFR 0.152.
 */
package processing.app.macosx;

import cc.arduino.packages.BoardPort;
import com.apple.eio.FileManager;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.StringUtils;
import processing.app.debug.TargetPackage;
import processing.app.legacy.PApplet;
import processing.app.legacy.PConstants;
import processing.app.macosx.SystemProfilerParser;

public class Platform
extends processing.app.Platform {
    private String osArch;
    private static final int kDocumentsFolderType = 1685021555;
    private static final int kDomainLibraryFolderType = 1684826466;
    private static final short kUserDomain = -32763;

    @Override
    public void setLookAndFeel() throws Exception {
    }

    public Platform() {
        Toolkit.getDefaultToolkit();
    }

    @Override
    public void init() throws IOException {
        super.init();
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.discoverRealOsArch();
    }

    private void discoverRealOsArch() throws IOException {
        CommandLine uname = CommandLine.parse((String)"uname -m");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)baos, null));
        executor.execute(uname);
        this.osArch = StringUtils.trim((String)new String(baos.toByteArray()));
    }

    @Override
    public File getSettingsFolder() throws Exception {
        return new File(this.getLibraryFolder(), "Arduino15");
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return new File(this.getDocumentsFolder(), "Arduino");
    }

    @Override
    public void openURL(String url) throws Exception {
        Desktop desktop = Desktop.getDesktop();
        if (url.startsWith("http") || url.startsWith("file:")) {
            desktop.browse(new URI(url));
        } else {
            desktop.open(new File(url));
        }
    }

    @Override
    public boolean openFolderAvailable() {
        return true;
    }

    @Override
    public void openFolder(File file) throws Exception {
        PApplet.open(file.getAbsolutePath());
    }

    private String getLibraryFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1684826466);
    }

    private String getDocumentsFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1685021555);
    }

    @Override
    public String getName() {
        return PConstants.platformNames[2];
    }

    @Override
    public Map<String, Object> resolveDeviceAttachedTo(String serial, Map<String, TargetPackage> packages, String devicesListOutput) {
        assert (packages != null);
        if (devicesListOutput == null) {
            return super.resolveDeviceAttachedTo(serial, packages, null);
        }
        try {
            String vidPid = new SystemProfilerParser().extractVIDAndPID(devicesListOutput, serial);
            if (vidPid == null) {
                return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
            }
            return super.resolveDeviceByVendorIdProductId(packages, vidPid);
        }
        catch (IOException e) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
    }

    @Override
    public String preListAllCandidateDevices() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)baos, null));
        try {
            CommandLine toDevicePath = CommandLine.parse((String)"/usr/sbin/system_profiler SPUSBDataType");
            executor.execute(toDevicePath);
            return new String(baos.toByteArray());
        }
        catch (Throwable e) {
            return super.preListAllCandidateDevices();
        }
    }

    @Override
    public List<BoardPort> filterPorts(List<BoardPort> ports, boolean showAll) {
        if (showAll) {
            return super.filterPorts(ports, true);
        }
        LinkedList<BoardPort> filteredPorts = new LinkedList<BoardPort>();
        for (BoardPort port : ports) {
            if (port.getAddress().startsWith("/dev/tty.")) continue;
            filteredPorts.add(port);
        }
        return filteredPorts;
    }

    @Override
    public String getOsArch() {
        return this.osArch;
    }
}

