/*
 * Decompiled with CFR 0.152.
 */
package processing.app.linux;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import processing.app.PreferencesData;
import processing.app.debug.TargetPackage;
import processing.app.legacy.PConstants;
import processing.app.linux.GTKLookAndFeelFixer;
import processing.app.linux.UDevAdmParser;

public class Platform
extends processing.app.Platform {
    @Override
    public void setLookAndFeel() throws Exception {
        GTKLookAndFeelFixer.installGtkPopupBugWorkaround();
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        File home = new File(System.getProperty("user.home"));
        return new File(home, "Arduino");
    }

    @Override
    public void openURL(String url) throws Exception {
        String launcher;
        if (this.openFolderAvailable() && (launcher = PreferencesData.get("launcher")) != null) {
            Runtime.getRuntime().exec(new String[]{launcher, url});
        }
    }

    @Override
    public boolean openFolderAvailable() {
        if (PreferencesData.get("launcher") != null) {
            return true;
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"xdg-open"});
            p.waitFor();
            PreferencesData.set("launcher", "xdg-open");
            return true;
        }
        catch (Exception p) {
            try {
                Process p2 = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                p2.waitFor();
                PreferencesData.set("launcher", "gnome-open");
                return true;
            }
            catch (Exception p2) {
                try {
                    Process p3 = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    p3.waitFor();
                    PreferencesData.set("launcher", "kde-open");
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
    }

    @Override
    public void openFolder(File file) throws Exception {
        if (this.openFolderAvailable()) {
            String launcher = PreferencesData.get("launcher");
            try {
                String[] params = new String[]{launcher, file.getAbsolutePath()};
                Runtime.getRuntime().exec(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No launcher set, cannot open " + file.getAbsolutePath());
        }
    }

    @Override
    public String getName() {
        return PConstants.platformNames[3];
    }

    @Override
    public Map<String, Object> resolveDeviceAttachedTo(String serial, Map<String, TargetPackage> packages, String devicesListOutput) {
        assert (packages != null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)baos, null));
        try {
            CommandLine toDevicePath = CommandLine.parse((String)("udevadm info -q path -n " + serial));
            executor.execute(toDevicePath);
            String devicePath = new String(baos.toByteArray());
            baos.reset();
            CommandLine commandLine = CommandLine.parse((String)("udevadm info --query=property -p " + devicePath));
            executor.execute(commandLine);
            String vidPid = new UDevAdmParser().extractVIDAndPID(new String(baos.toByteArray()));
            if (vidPid == null) {
                return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
            }
            return super.resolveDeviceByVendorIdProductId(packages, vidPid);
        }
        catch (IOException e) {
            return super.resolveDeviceAttachedTo(serial, packages, devicesListOutput);
        }
    }
}

