/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketException;
import processing.app.debug.MessageConsumer;

public class MessageSiphon
implements Runnable {
    private final Reader streamReader;
    private final MessageConsumer consumer;
    private Thread thread;
    private boolean canRun;
    private int lineTimeout;

    public MessageSiphon(InputStream stream, MessageConsumer consumer) {
        this(stream, consumer, 0);
    }

    public MessageSiphon(InputStream stream, MessageConsumer consumer, int lineTimeout) {
        this.streamReader = new InputStreamReader(stream);
        this.consumer = consumer;
        this.canRun = true;
        this.lineTimeout = lineTimeout;
        this.thread = new Thread(this);
        this.thread.setPriority(9);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            StringBuilder currentLine = new StringBuilder();
            long lineStartTime = 0L;
            while (this.canRun) {
                while (this.lineTimeout == 0 || currentLine.length() == 0 || this.streamReader.ready()) {
                    int c = this.streamReader.read();
                    if (c == -1) {
                        return;
                    }
                    if (!this.canRun) {
                        return;
                    }
                    if (currentLine.length() == 0) {
                        lineStartTime = System.nanoTime();
                    }
                    currentLine.append((char)c);
                    if (c != 10) continue;
                    this.consumer.message(currentLine.toString());
                    currentLine.setLength(0);
                }
                long passed = (System.nanoTime() - lineStartTime) / 1000L;
                if (passed < (long)this.lineTimeout) {
                    Thread.sleep((long)this.lineTimeout - passed);
                    continue;
                }
                this.consumer.message(currentLine.toString());
                currentLine.setLength(0);
            }
        }
        catch (NullPointerException currentLine) {
        }
        catch (SocketException currentLine) {
        }
        catch (Exception e) {
            String mess = e.getMessage();
            if (mess != null && mess.indexOf("Bad file descriptor") != -1) {
            } else {
                e.printStackTrace();
            }
        }
        finally {
            this.thread = null;
        }
    }

    public void join() throws InterruptedException {
        Thread t = this.thread;
        if (t != null) {
            t.join();
        }
    }

    public void stop() {
        this.canRun = false;
    }
}

