/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.helpers.FileUtils;

public class SketchCode {
    private File file;
    private String program;
    private boolean modified;
    private int preprocOffset;
    private Object metadata;

    public SketchCode(File file) {
        this.init(file, null);
    }

    public SketchCode(File file, Object metadata) {
        this.init(file, metadata);
    }

    private void init(File file, Object metadata) {
        this.file = file;
        this.metadata = metadata;
        try {
            this.load();
        }
        catch (IOException e) {
            System.err.println(I18n.format(I18n._("Error while loading code {0}"), file.getName()));
        }
    }

    public File getFile() {
        return this.file;
    }

    protected boolean fileExists() {
        return this.file.exists();
    }

    protected boolean fileReadOnly() {
        return !this.file.canWrite();
    }

    protected boolean deleteFile(File tempBuildFolder) {
        File[] compiledFiles;
        if (!this.file.delete()) {
            return false;
        }
        for (File compiledFile : compiledFiles = tempBuildFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(SketchCode.this.getFileName());
            }
        })) {
            if (compiledFile.delete()) continue;
            return false;
        }
        return true;
    }

    protected boolean renameTo(File what) {
        boolean success = this.file.renameTo(what);
        if (success) {
            this.file = what;
        }
        return success;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getPrettyName() {
        String prettyName = this.getFileName();
        int dot = prettyName.lastIndexOf(46);
        return prettyName.substring(0, dot);
    }

    public String getFileNameWithExtensionIfNotIno() {
        if (this.getFileName().endsWith(".ino")) {
            return this.getPrettyName();
        }
        return this.getFileName();
    }

    public boolean isExtension(String ... extensions) {
        return this.isExtension(Arrays.asList(extensions));
    }

    public boolean isExtension(List<String> extensions) {
        return FileUtils.hasExtension(this.file, extensions);
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String replacement) {
        this.program = replacement;
    }

    public int getLineCount() {
        return BaseNoGui.countLines(this.program);
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setPreprocOffset(int preprocOffset) {
        this.preprocOffset = preprocOffset;
    }

    public void addPreprocOffset(int extra) {
        this.preprocOffset += extra;
    }

    private void load() throws IOException {
        this.program = BaseNoGui.loadFile(this.file);
        if (this.program == null) {
            throw new IOException();
        }
        if (this.program.indexOf(65533) != -1) {
            System.err.println(I18n.format(I18n._("\"{0}\" contains unrecognized characters.If this code was created with an older version of Arduino,you may need to use Tools -> Fix Encoding & Reload to updatethe sketch to use UTF-8 encoding. If not, you may need todelete the bad characters to get rid of this warning."), this.file.getName()));
            System.err.println();
        }
        this.setModified(false);
    }

    public void save() throws IOException {
        BaseNoGui.saveFile(this.program, this.file);
        this.setModified(false);
    }

    public void saveAs(File newFile) throws IOException {
        BaseNoGui.saveFile(this.program, newFile);
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }
}

