/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static ResourceBundle i18n;
    public static String PROMPT_YES;
    public static String PROMPT_NO;
    public static String PROMPT_CANCEL;
    public static String PROMPT_OK;
    public static String PROMPT_BROWSE;

    protected static void init(String language) throws MissingResourceException {
        String[] languageParts = language.split("_");
        Locale locale = Locale.getDefault();
        if (languageParts.length == 2) {
            locale = new Locale(languageParts[0], languageParts[1]);
        } else if (languageParts.length == 1 && !"".equals(languageParts[0])) {
            locale = new Locale(languageParts[0]);
        }
        Locale.setDefault(locale);
        i18n = ResourceBundle.getBundle("processing.app.i18n.Resources", Locale.getDefault());
        PROMPT_YES = I18n._("Yes");
        PROMPT_NO = I18n._("No");
        PROMPT_CANCEL = I18n._("Cancel");
        PROMPT_OK = I18n._("OK");
        PROMPT_BROWSE = I18n._("Browse");
    }

    public static String _(String s) {
        String res;
        try {
            res = i18n == null ? s : i18n.getString(s);
        }
        catch (MissingResourceException e) {
            res = s;
        }
        res = res.replace("%%", "%");
        return res;
    }

    public static String format(String fmt, Object ... args) {
        fmt = fmt.replace("''", "'");
        fmt = fmt.replace("'", "''");
        return MessageFormat.format(fmt, args);
    }

    protected static void unusedStrings() {
        I18n._("Arduino AVR Boards");
        I18n._("Arduino ARM (32-bits) Boards");
        I18n._("Processor");
    }
}

