/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers.serial;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.discoverers.SerialDiscovery;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import processing.app.BaseNoGui;
import processing.app.Platform;
import processing.app.Serial;
import processing.app.debug.TargetBoard;

public class SerialBoardsLister
extends TimerTask {
    private final SerialDiscovery serialDiscovery;

    public SerialBoardsLister(SerialDiscovery serialDiscovery) {
        this.serialDiscovery = serialDiscovery;
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 0L, 3000L);
    }

    @Override
    public void run() {
        while (BaseNoGui.packages == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Platform platform = BaseNoGui.getPlatform();
        if (platform == null) {
            return;
        }
        LinkedList<BoardPort> boardPorts = new LinkedList<BoardPort>();
        List<String> ports = Serial.list();
        String devicesListOutput = null;
        if (!ports.isEmpty()) {
            devicesListOutput = platform.preListAllCandidateDevices();
        }
        for (String port : ports) {
            Map<String, Object> boardData = platform.resolveDeviceAttachedTo(port, BaseNoGui.packages, devicesListOutput);
            BoardPort boardPort = new BoardPort();
            boardPort.setAddress(port);
            boardPort.setProtocol("serial");
            String label = port;
            if (boardData != null) {
                boardPort.getPrefs().put("vid", boardData.get("vid").toString());
                boardPort.getPrefs().put("pid", boardData.get("pid").toString());
                TargetBoard board = (TargetBoard)boardData.get("board");
                if (board != null) {
                    String boardName = board.getName();
                    if (boardName != null) {
                        label = label + " (" + boardName + ")";
                    }
                    boardPort.setBoardName(boardName);
                }
            }
            boardPort.setLabel(label);
            boardPorts.add(boardPort);
        }
        this.serialDiscovery.setSerialBoardPorts(boardPorts);
    }
}

