/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.network.BoardReachabilityFilter;
import cc.arduino.packages.discoverers.network.NetworkChecker;
import cc.arduino.packages.discoverers.network.NetworkTopologyListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.jmdns.JmDNS;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.impl.DNSTaskStarter;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.BaseNoGui;
import processing.app.zeroconf.jmdns.ArduinoDNSTaskStarter;

public class NetworkDiscovery
implements Discovery,
ServiceListener,
NetworkTopologyListener {
    private static final int MAX_TIME_AWAITING_FOR_PACKAGES = 5000;
    private final List<BoardPort> boardPortsDiscoveredWithJmDNS;
    private final Map<InetAddress, JmDNS> mappedJmDNSs;
    private Timer networkCheckerTimer;
    private Timer boardReachabilityFilterTimer;
    private final List<BoardPort> reachableBoardPorts;

    public NetworkDiscovery() {
        DNSTaskStarter.Factory.setClassDelegate((DNSTaskStarter.Factory.ClassDelegate)new ArduinoDNSTaskStarter());
        this.boardPortsDiscoveredWithJmDNS = new LinkedList<BoardPort>();
        this.mappedJmDNSs = new Hashtable<InetAddress, JmDNS>();
        this.reachableBoardPorts = new LinkedList<BoardPort>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BoardPort> listDiscoveredBoards() {
        List<BoardPort> list = this.reachableBoardPorts;
        synchronized (list) {
            return new LinkedList<BoardPort>(this.reachableBoardPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReachableBoardPorts(List<BoardPort> newReachableBoardPorts) {
        List<BoardPort> list = this.reachableBoardPorts;
        synchronized (list) {
            this.reachableBoardPorts.clear();
            this.reachableBoardPorts.addAll(newReachableBoardPorts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BoardPort> getBoardPortsDiscoveredWithJmDNS() {
        List<BoardPort> list = this.boardPortsDiscoveredWithJmDNS;
        synchronized (list) {
            return new LinkedList<BoardPort>(this.boardPortsDiscoveredWithJmDNS);
        }
    }

    @Override
    public void start() throws IOException {
        this.networkCheckerTimer = new Timer(NetworkChecker.class.getName());
        new NetworkChecker(this, NetworkTopologyDiscovery.Factory.getInstance()).start(this.networkCheckerTimer);
        this.boardReachabilityFilterTimer = new Timer(BoardReachabilityFilter.class.getName());
        new BoardReachabilityFilter(this).start(this.boardReachabilityFilterTimer);
    }

    @Override
    public void stop() throws IOException {
        this.networkCheckerTimer.purge();
        this.boardReachabilityFilterTimer.purge();
    }

    public void serviceAdded(ServiceEvent serviceEvent) {
        String type = serviceEvent.getType();
        String name = serviceEvent.getName();
        JmDNS dns = serviceEvent.getDNS();
        dns.requestServiceInfo(type, name);
        ServiceInfo serviceInfo = dns.getServiceInfo(type, name);
        if (serviceInfo != null) {
            dns.requestServiceInfo(type, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRemoved(ServiceEvent serviceEvent) {
        String name = serviceEvent.getName();
        List<BoardPort> list = this.boardPortsDiscoveredWithJmDNS;
        synchronized (list) {
            for (BoardPort port : this.boardPortsDiscoveredWithJmDNS) {
                if (!port.getBoardName().equals(name)) continue;
                this.boardPortsDiscoveredWithJmDNS.remove(port);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResolved(ServiceEvent serviceEvent) {
        int sleptFor = 0;
        while (BaseNoGui.packages == null && sleptFor <= 5000) {
            try {
                Thread.sleep(1000L);
                sleptFor += 1000;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ServiceInfo info = serviceEvent.getInfo();
        for (Inet4Address inetAddress : info.getInet4Addresses()) {
            String boardName;
            String address = ((InetAddress)inetAddress).getHostAddress();
            String name = serviceEvent.getName();
            BoardPort port = new BoardPort();
            String board = null;
            if (info.hasData()) {
                board = info.getPropertyString("board");
                port.getPrefs().put("board", board);
                port.getPrefs().put("distro_version", info.getPropertyString("distro_version"));
                port.getPrefs().put("port", "" + info.getPort());
            }
            String label = name + " at " + address;
            if (board != null && BaseNoGui.packages != null && (boardName = BaseNoGui.getPlatform().resolveDeviceByBoardID(BaseNoGui.packages, board)) != null) {
                label = label + " (" + boardName + ")";
            }
            port.setAddress(address);
            port.setBoardName(name);
            port.setProtocol("network");
            port.setLabel(label);
            List<BoardPort> list = this.boardPortsDiscoveredWithJmDNS;
            synchronized (list) {
                this.removeDuplicateBoards(port);
                this.boardPortsDiscoveredWithJmDNS.add(port);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDuplicateBoards(BoardPort newBoard) {
        List<BoardPort> list = this.boardPortsDiscoveredWithJmDNS;
        synchronized (list) {
            Iterator<BoardPort> iterator = this.boardPortsDiscoveredWithJmDNS.iterator();
            while (iterator.hasNext()) {
                BoardPort board = iterator.next();
                if (!newBoard.getAddress().equals(board.getAddress())) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public void inetAddressAdded(InetAddress address) {
        if (this.mappedJmDNSs.containsKey(address)) {
            return;
        }
        try {
            JmDNS jmDNS = JmDNS.create((InetAddress)address);
            jmDNS.addServiceListener("_arduino._tcp.local.", (ServiceListener)this);
            this.mappedJmDNSs.put(address, jmDNS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void inetAddressRemoved(InetAddress address) {
        JmDNS jmDNS = this.mappedJmDNSs.remove(address);
        IOUtils.closeQuietly((Closeable)jmDNS);
    }
}

