/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages;

import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.filters.DownloadableContributionWithVersionPredicate;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributedTool;
import cc.arduino.contributions.packages.filters.PlatformArchitecturePredicate;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class ContributionsIndex {
    private final List<String> categories = new ArrayList<String>();

    public abstract List<ContributedPackage> getPackages();

    public ContributedPackage findPackage(String packageName) {
        for (ContributedPackage pack : this.getPackages()) {
            if (!pack.getName().equals(packageName)) continue;
            return pack;
        }
        return null;
    }

    public List<ContributedPlatform> findPlatforms(String packageName, String platformArch) {
        if (packageName == null || platformArch == null) {
            return null;
        }
        ContributedPackage aPackage = this.findPackage(packageName);
        if (aPackage == null) {
            return null;
        }
        Collection platforms = Collections2.filter(aPackage.getPlatforms(), (Predicate)new PlatformArchitecturePredicate(platformArch));
        return Lists.newLinkedList((Iterable)platforms);
    }

    public ContributedPlatform findPlatform(String packageName, String platformArch, String platformVersion) {
        if (platformVersion == null) {
            return null;
        }
        List<ContributedPlatform> platformsByName = this.findPlatforms(packageName, platformArch);
        if (platformsByName == null) {
            return null;
        }
        Collection platforms = Collections2.filter(platformsByName, (Predicate)new DownloadableContributionWithVersionPredicate(platformVersion));
        if (platforms.isEmpty()) {
            return null;
        }
        return (ContributedPlatform)platforms.iterator().next();
    }

    public List<ContributedPlatform> getInstalledPlatforms() {
        return Lists.newLinkedList((Iterable)Collections2.filter(this.getPlatforms(), (Predicate)new InstalledPredicate()));
    }

    public ContributedPlatform getInstalledPlatform(String packageName, String platformArch) {
        LinkedList installedPlatforms = new LinkedList(Collections2.filter(this.findPlatforms(packageName, platformArch), (Predicate)new InstalledPredicate()));
        Collections.sort(installedPlatforms, new DownloadableContributionBuiltInAtTheBottomComparator());
        if (installedPlatforms.isEmpty()) {
            return null;
        }
        return (ContributedPlatform)installedPlatforms.get(0);
    }

    public List<ContributedPlatform> getPlatforms() {
        return Lists.newLinkedList((Iterable)Iterables.concat((Iterable)Collections2.transform(this.getPackages(), (Function)new Function<ContributedPackage, List<ContributedPlatform>>(){

            public List<ContributedPlatform> apply(ContributedPackage contributedPackage) {
                return contributedPackage.getPlatforms();
            }
        })));
    }

    public ContributedTool findTool(String packageName, String name, String version) {
        ContributedPackage pack = this.findPackage(packageName);
        if (pack == null) {
            return null;
        }
        return pack.findTool(name, version);
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void fillCategories() {
        this.categories.clear();
        for (ContributedPackage pack : this.getPackages()) {
            for (ContributedPlatform platform : pack.getPlatforms()) {
                if (this.categories.contains(platform.getCategory())) continue;
                this.categories.add(platform.getCategory());
            }
        }
    }

    public ContributedPackage getPackage(String packageName) {
        for (ContributedPackage pack : this.getPackages()) {
            if (!pack.getName().equals(packageName)) continue;
            return pack;
        }
        return null;
    }

    public String toString() {
        String res = "";
        res = res + "Categories: ";
        for (String c : this.getCategories()) {
            res = res + "'" + c + "' ";
        }
        res = res + "\n";
        for (ContributedPackage pack : this.getPackages()) {
            res = res + pack + "\n";
        }
        return res;
    }
}

