/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.contributions.DownloadableContributionsDownloader;
import cc.arduino.contributions.GZippedJsonDownloader;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndexer;
import cc.arduino.utils.ArchiveExtractor;
import cc.arduino.utils.MultiStepProgress;
import cc.arduino.utils.Progress;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.helpers.FileUtils;

public class LibraryInstaller {
    private static final String LIBRARY_INDEX_URL;
    private static final String LIBRARY_INDEX_URL_GZ;
    private final LibrariesIndexer indexer;
    private final DownloadableContributionsDownloader downloader;
    private final Platform platform;

    public LibraryInstaller(LibrariesIndexer indexer, Platform platform) {
        this.indexer = indexer;
        this.platform = platform;
        File stagingFolder = indexer.getStagingFolder();
        this.downloader = new DownloadableContributionsDownloader(stagingFolder){

            @Override
            protected void onProgress(Progress progress) {
                LibraryInstaller.this.onProgress(progress);
            }
        };
    }

    public void updateIndex() throws Exception {
        MultiStepProgress progress = new MultiStepProgress(2);
        URL url = new URL(LIBRARY_INDEX_URL);
        File outputFile = this.indexer.getIndexFile();
        File tmpFile = new File(outputFile.getAbsolutePath() + ".tmp");
        try {
            GZippedJsonDownloader gZippedJsonDownloader = new GZippedJsonDownloader(this.downloader, new URL(LIBRARY_INDEX_URL), new URL(LIBRARY_INDEX_URL_GZ));
            gZippedJsonDownloader.download(tmpFile, progress, I18n._("Downloading libraries index..."));
        }
        catch (InterruptedException e) {
            return;
        }
        progress.stepDone();
        if (outputFile.exists()) {
            outputFile.delete();
        }
        if (!tmpFile.renameTo(outputFile)) {
            throw new Exception(I18n._("An error occurred while updating libraries index!"));
        }
        this.rescanLibraryIndex(progress);
    }

    public void install(ContributedLibrary lib, ContributedLibrary replacedLib) throws Exception {
        File tmpFolder;
        File libsFolder;
        MultiStepProgress progress;
        block5: {
            if (lib.isInstalled()) {
                System.out.println(I18n.format(I18n._("Library is already installed: {0} version {1}"), lib.getName(), lib.getParsedVersion()));
                return;
            }
            progress = new MultiStepProgress(3);
            try {
                this.downloader.download(lib, progress, I18n.format(I18n._("Downloading library: {0}"), lib.getName()));
            }
            catch (InterruptedException e) {
                return;
            }
            progress.setStatus(I18n.format(I18n._("Installing library: {0}"), lib.getName()));
            this.onProgress(progress);
            libsFolder = this.indexer.getSketchbookLibrariesFolder();
            tmpFolder = FileUtils.createTempFolderIn(libsFolder);
            try {
                new ArchiveExtractor(this.platform).extract(lib.getDownloadedFile(), tmpFolder, 1);
            }
            catch (Exception e) {
                if (!tmpFolder.exists()) break block5;
                FileUtils.recursiveDelete(tmpFolder);
            }
        }
        progress.stepDone();
        this.remove(replacedLib);
        File destFolder = new File(libsFolder, lib.getName().replaceAll(" ", "_"));
        tmpFolder.renameTo(destFolder);
        progress.stepDone();
        this.rescanLibraryIndex(progress);
    }

    public void remove(ContributedLibrary lib) throws IOException {
        if (lib == null || lib.isReadOnly()) {
            return;
        }
        MultiStepProgress progress = new MultiStepProgress(2);
        progress.setStatus(I18n.format(I18n._("Removing library: {0}"), lib.getName()));
        this.onProgress(progress);
        FileUtils.recursiveDelete(lib.getInstalledFolder());
        progress.stepDone();
        this.rescanLibraryIndex(progress);
    }

    private void rescanLibraryIndex(MultiStepProgress progress) {
        progress.setStatus(I18n._("Updating list of installed libraries"));
        this.onProgress(progress);
        this.indexer.rescanLibraries();
        progress.stepDone();
    }

    protected void onProgress(Progress progress) {
    }

    static {
        String externalLibraryIndexUrl = System.getProperty("LIBRARY_INDEX_URL");
        LIBRARY_INDEX_URL = externalLibraryIndexUrl != null && !"".equals(externalLibraryIndexUrl) ? externalLibraryIndexUrl : "http://downloads.arduino.cc/libraries/library_index.json";
        LIBRARY_INDEX_URL_GZ = "http://downloads.arduino.cc/libraries/library_index.json.gz";
    }
}

