/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.libraries.ContributedLibraryReference;
import java.util.Comparator;
import java.util.List;
import processing.app.I18n;

public abstract class ContributedLibrary
extends DownloadableContribution {
    public static final Comparator<ContributedLibrary> CASE_INSENSITIVE_ORDER = new Comparator<ContributedLibrary>(){

        @Override
        public int compare(ContributedLibrary o1, ContributedLibrary o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public abstract String getName();

    public abstract String getMaintainer();

    public abstract String getAuthor();

    public abstract String getWebsite();

    public abstract String getCategory();

    public abstract void setCategory(String var1);

    public abstract String getLicense();

    public abstract String getParagraph();

    public abstract String getSentence();

    public abstract List<String> getArchitectures();

    public abstract List<String> getTypes();

    public abstract List<ContributedLibraryReference> getRequires();

    public boolean supportsArchitecture(String reqArch) {
        return this.getArchitectures().contains(reqArch) || this.getArchitectures().contains("*");
    }

    public boolean supportsArchitecture(List<String> reqArchs) {
        if (reqArchs.contains("*")) {
            return true;
        }
        for (String reqArch : reqArchs) {
            if (!this.supportsArchitecture(reqArch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return I18n.format(I18n._("Version {0}"), this.getParsedVersion());
    }

    public String info() {
        String res = "";
        res = res + "  ContributedLibrary : " + this.getName() + "\n";
        res = res + "              author : " + this.getAuthor() + "\n";
        res = res + "          maintainer : " + this.getMaintainer() + "\n";
        res = res + "             version : " + this.getParsedVersion() + "\n";
        res = res + "             website : " + this.getUrl() + "\n";
        res = res + "            category : " + this.getCategory() + "\n";
        res = res + "             license : " + this.getLicense() + "\n";
        res = res + "             descrip : " + this.getSentence() + "\n";
        if (this.getParagraph() != null && !this.getParagraph().isEmpty()) {
            res = res + "                       " + this.getParagraph() + "\n";
        }
        res = res + "       architectures : ";
        if (this.getArchitectures() != null) {
            for (String a : this.getArchitectures()) {
                res = res + a + ",";
            }
        }
        res = res + "\n";
        res = res + "            requires :\n";
        if (this.getRequires() != null) {
            for (ContributedLibraryReference r : this.getRequires()) {
                res = res + "                       " + r;
            }
        }
        res = res + "\n";
        res = res + super.toString();
        return res;
    }

    public boolean equals(Object obj) {
        String otherVersion;
        if (!(obj instanceof ContributedLibrary)) {
            return false;
        }
        String thisVersion = this.getParsedVersion();
        boolean versionEquals = thisVersion == (otherVersion = ((ContributedLibrary)obj).getParsedVersion()) || thisVersion != null && otherVersion != null && thisVersion.equals(otherVersion);
        String thisName = this.getName();
        String otherName = ((ContributedLibrary)obj).getName();
        boolean nameEquals = thisName == null || otherName == null || thisName.equals(otherName);
        return versionEquals && nameEquals;
    }
}

