/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.DownloadableContributionsDownloader;
import cc.arduino.contributions.JsonDownloader;
import cc.arduino.utils.Progress;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.utils.IOUtils;

public class GZippedJsonDownloader {
    private final DownloadableContributionsDownloader downloader;
    private final URL url;
    private final URL gzippedUrl;

    public GZippedJsonDownloader(DownloadableContributionsDownloader downloader, URL url, URL gzippedUrl) {
        this.downloader = downloader;
        this.url = url;
        this.gzippedUrl = gzippedUrl;
    }

    public void download(File tmpFile, Progress progress, String statusText) throws Exception {
        try {
            new JsonDownloader(this.downloader, this.gzippedUrl).download(tmpFile, progress, statusText);
            File gzipTmpFile = new File(tmpFile.getParentFile(), GzipUtils.getCompressedFilename((String)tmpFile.getName()));
            tmpFile.renameTo(gzipTmpFile);
            this.decompress(gzipTmpFile, tmpFile);
        }
        catch (Exception e) {
            new JsonDownloader(this.downloader, this.url).download(tmpFile, progress, statusText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompress(File gzipTmpFile, File tmpFile) throws IOException {
        FileOutputStream os = null;
        GzipCompressorInputStream gzipIs = null;
        try {
            os = new FileOutputStream(tmpFile);
            gzipIs = new GzipCompressorInputStream((InputStream)new FileInputStream(gzipTmpFile));
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = gzipIs.read(buffer))) {
                ((OutputStream)os).write(buffer, 0, n);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly(gzipIs);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)os);
        IOUtils.closeQuietly((Closeable)gzipIs);
    }
}

