/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.utils.FileHash;
import cc.arduino.utils.Progress;
import cc.arduino.utils.network.FileDownloader;
import java.io.File;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import processing.app.I18n;

public class DownloadableContributionsDownloader {
    private final File stagingFolder;

    public DownloadableContributionsDownloader(File _stagingFolder) {
        this.stagingFolder = _stagingFolder;
    }

    public File download(DownloadableContribution contribution, Progress progress, String statusText) throws Exception {
        URL url = new URL(contribution.getUrl());
        File outputFile = new File(this.stagingFolder, contribution.getArchiveFileName());
        this.stagingFolder.mkdirs();
        if (!outputFile.isFile() || outputFile.length() < contribution.getSize()) {
            this.download(url, outputFile, progress, statusText);
        }
        progress.setStatus(I18n._("Verifying archive integrity..."));
        this.onProgress(progress);
        String checksum = contribution.getChecksum();
        String algo = checksum.split(":")[0];
        if (!FileHash.hash(outputFile, algo).equalsIgnoreCase(checksum)) {
            throw new Exception(I18n._("CRC doesn't match. File is corrupted."));
        }
        contribution.setDownloaded(true);
        contribution.setDownloadedFile(outputFile);
        return outputFile;
    }

    public void download(URL url, File tmpFile, final Progress progress, final String statusText) throws Exception {
        FileDownloader downloader = new FileDownloader(url, tmpFile);
        downloader.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                FileDownloader me = (FileDownloader)o;
                String msg = "";
                if (me.getDownloadSize() != null) {
                    long downloaded = (me.getInitialSize() + me.getDownloaded()) / 1000L;
                    long total = (me.getInitialSize() + me.getDownloadSize()) / 1000L;
                    msg = I18n.format(I18n._("Downloaded {0}kb of {1}kb."), downloaded, total);
                }
                progress.setStatus(statusText + " " + msg);
                progress.setProgress(me.getProgress());
                DownloadableContributionsDownloader.this.onProgress(progress);
            }
        });
        downloader.download();
        if (!downloader.isCompleted()) {
            throw new Exception(I18n.format(I18n._("Error downloading {0}"), url), downloader.getError());
        }
    }

    protected void onProgress(Progress progress) {
    }
}

