/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import processing.app.debug.MessageConsumer;

public class MyStreamPumper
implements Runnable {
    private final BufferedReader reader;
    private final MessageConsumer messageConsumer;
    private boolean finished;

    public MyStreamPumper(InputStream is, MessageConsumer messageConsumer) {
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.messageConsumer = messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MyStreamPumper myStreamPumper = this;
        synchronized (myStreamPumper) {
            this.finished = false;
        }
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                this.messageConsumer.message(line + "\n");
            }
        }
        catch (Exception exception) {
            MyStreamPumper myStreamPumper2 = this;
            synchronized (myStreamPumper2) {
                this.finished = true;
                this.notifyAll();
            }
        }
        finally {
            myStreamPumper = this;
            synchronized (myStreamPumper) {
                this.finished = true;
                this.notifyAll();
            }
        }
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }
}

