/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO., LTD
 * SPDX-License-Identifier: LicenseRef-Espressif-Modified-MIT
 *
 * See LICENSE file for details.
 */

#pragma once

#include "esp_gmf_method_helper.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * @brief  Audio general method argument definition
 */
#define ESP_GMF_AUDIO_INDEX_ARG       "index"
#define ESP_GMF_AUDIO_GAIN_ARG        "gain"
#define ESP_GMF_AUDIO_BITS_ARG        "bits"
#define ESP_GMF_AUDIO_CHANNEL_ARG     "channel"
#define ESP_GMF_AUDIO_SAMPLE_RATE_ARG "sample_rate"
#define ESP_GMF_AUDIO_BITRATE_ARG     "bitrate"
#define ESP_GMF_AUDIO_ENABLE_ARG      "enable"
#define ESP_GMF_AUDIO_TYPE_ARG        "type"
#define ESP_GMF_AUDIO_PARA_ARG        "para"
#define ESP_GMF_AUDIO_MODE_ARG        "mode"
#define ESP_GMF_AUDIO_SPEED_ARG       "speed"
#define ESP_GMF_AUDIO_PITCH_ARG       "pitch"
#define ESP_GMF_AUDIO_INSIZE_ARG      "in_size"
#define ESP_GMF_AUDIO_OUTSIZE_ARG     "out_size"
#define ESP_GMF_AUDIO_CFG_ARG         "cfg"
#define ESP_GMF_AUDIO_INFO_ARG        "info"

/**
 * @brief  Audio EQ parameter argument definition
 */
#define ESP_GMF_AUDIO_EQ_PARA_ARG      ESP_GMF_AUDIO_PARA_ARG
#define ESP_GMF_AUDIO_EQ_PARA_FT_ARG   ESP_GMF_AUDIO_TYPE_ARG
#define ESP_GMF_AUDIO_EQ_PARA_FC_ARG   "fc"
#define ESP_GMF_AUDIO_EQ_PARA_Q_ARG    "q"
#define ESP_GMF_AUDIO_EQ_PARA_GAIN_ARG ESP_GMF_AUDIO_GAIN_ARG

/**
 * @brief  Audio general config parameter argument definition
 */
#define ESP_GMF_AUDIO_CFG_TYPE_ARG      ESP_GMF_AUDIO_TYPE_ARG
#define ESP_GMF_AUDIO_CFG_SUBCFGPTR_ARG "sub_cfg"
#define ESP_GMF_AUDIO_CFG_SUBCFGSZ_ARG  "sub_cfg_sz"

/**
 * @brief  Audio sound information parameter argument definition
 */
#define ESP_GMF_AUDIO_SND_INFO_ARG            ESP_GMF_AUDIO_INFO_ARG
#define ESP_GMF_AUDIO_SND_INFO_TYPE_ARG       ESP_GMF_AUDIO_TYPE_ARG
#define ESP_GMF_AUDIO_SND_INFO_SAMPLERATE_ARG ESP_GMF_AUDIO_SAMPLE_RATE_ARG
#define ESP_GMF_AUDIO_SND_INFO_BITRATE_ARG    ESP_GMF_AUDIO_BITRATE_ARG
#define ESP_GMF_AUDIO_SND_INFO_CHANNEL_ARG    ESP_GMF_AUDIO_CHANNEL_ARG
#define ESP_GMF_AUDIO_SND_INFO_BITS_ARG       ESP_GMF_AUDIO_BITS_ARG

/**
 * @brief  GMF audio method definition
 */
#define AMETHOD_DEF(module, method, str) ESP_GMF_METHOD_DEF(AUDIO, module, method, str)

/**
 * @brief  Get GMF audio method string
 */
#define AMETHOD(module, method) ESP_GMF_METHOD_STR(AUDIO, module, method)

/**
 * @brief  GMF audio method argument definition
 */
#define AMETHOD_ARG_DEF(module, method, arg, str) ESP_GMF_METHOD_ARG_DEF(AUDIO, module, method, arg, str)

/**
 * @brief  Get GMF audio method argument string
 */
#define AMETHOD_ARG(module, method, arg) ESP_GMF_METHOD_ARG_STR(AUDIO, module, method, arg)

/**
 * @brief  ALC method
 */
AMETHOD_DEF(ALC, SET_GAIN, "set_gain");
AMETHOD_ARG_DEF(ALC, SET_GAIN, IDX, ESP_GMF_AUDIO_INDEX_ARG);
AMETHOD_ARG_DEF(ALC, SET_GAIN, GAIN, ESP_GMF_AUDIO_GAIN_ARG);

AMETHOD_DEF(ALC, GET_GAIN, "get_gain");
AMETHOD_ARG_DEF(ALC, GET_GAIN, IDX, ESP_GMF_AUDIO_INDEX_ARG);
AMETHOD_ARG_DEF(ALC, GET_GAIN, GAIN, ESP_GMF_AUDIO_GAIN_ARG);

/**
 * @brief  BIT CVT method
 */
AMETHOD_DEF(BIT_CVT, SET_DEST_BITS, "set_dest_bits");
AMETHOD_ARG_DEF(BIT_CVT, SET_DEST_BITS, BITS, ESP_GMF_AUDIO_BITS_ARG);

/**
 * @brief  CH CVT method
 */
AMETHOD_DEF(CH_CVT, SET_DEST_CH, "set_dest_ch");
AMETHOD_ARG_DEF(CH_CVT, SET_DEST_CH, CH, ESP_GMF_AUDIO_CHANNEL_ARG);

/**
 * @brief  RATE CVT method
 */
AMETHOD_DEF(RATE_CVT, SET_DEST_RATE, "set_dest_rate");
AMETHOD_ARG_DEF(RATE_CVT, SET_DEST_RATE, RATE, ESP_GMF_AUDIO_SAMPLE_RATE_ARG);

/**
 * @brief  EQ method
 */
AMETHOD_DEF(EQ, SET_PARA, "set_para");
AMETHOD_ARG_DEF(EQ, SET_PARA, IDX, ESP_GMF_AUDIO_INDEX_ARG);
AMETHOD_ARG_DEF(EQ, SET_PARA, PARA, ESP_GMF_AUDIO_EQ_PARA_ARG);
AMETHOD_ARG_DEF(EQ, SET_PARA, PARA_FT, ESP_GMF_AUDIO_EQ_PARA_FT_ARG);
AMETHOD_ARG_DEF(EQ, SET_PARA, PARA_FC, ESP_GMF_AUDIO_EQ_PARA_FC_ARG);
AMETHOD_ARG_DEF(EQ, SET_PARA, PARA_Q, ESP_GMF_AUDIO_EQ_PARA_Q_ARG);
AMETHOD_ARG_DEF(EQ, SET_PARA, PARA_GAIN, ESP_GMF_AUDIO_EQ_PARA_GAIN_ARG);

AMETHOD_DEF(EQ, GET_PARA, "get_para");
AMETHOD_ARG_DEF(EQ, GET_PARA, IDX, ESP_GMF_AUDIO_INDEX_ARG);
AMETHOD_ARG_DEF(EQ, GET_PARA, PARA, ESP_GMF_AUDIO_EQ_PARA_ARG);
AMETHOD_ARG_DEF(EQ, GET_PARA, PARA_FT, ESP_GMF_AUDIO_EQ_PARA_FT_ARG);
AMETHOD_ARG_DEF(EQ, GET_PARA, PARA_FC, ESP_GMF_AUDIO_EQ_PARA_FC_ARG);
AMETHOD_ARG_DEF(EQ, GET_PARA, PARA_Q, ESP_GMF_AUDIO_EQ_PARA_Q_ARG);
AMETHOD_ARG_DEF(EQ, GET_PARA, PARA_GAIN, ESP_GMF_AUDIO_EQ_PARA_GAIN_ARG);

AMETHOD_DEF(EQ, ENABLE_FILTER, "enable_filter");
AMETHOD_ARG_DEF(EQ, ENABLE_FILTER, IDX, ESP_GMF_AUDIO_INDEX_ARG);
AMETHOD_ARG_DEF(EQ, ENABLE_FILTER, ENABLE, ESP_GMF_AUDIO_ENABLE_ARG);

/**
 * @brief  FADE method
 */
AMETHOD_DEF(FADE, SET_MODE, "set_mode");
AMETHOD_ARG_DEF(FADE, SET_MODE, MODE, ESP_GMF_AUDIO_MODE_ARG);

AMETHOD_DEF(FADE, GET_MODE, "get_mode");
AMETHOD_ARG_DEF(FADE, GET_MODE, MODE, ESP_GMF_AUDIO_MODE_ARG);

AMETHOD_DEF(FADE, RESET_WEIGHT, "reset_weight");

/**
 * @brief  MIXER method
 */
AMETHOD_DEF(MIXER, SET_MODE, "set_mode");
AMETHOD_ARG_DEF(MIXER, SET_MODE, IDX, ESP_GMF_AUDIO_INDEX_ARG);
AMETHOD_ARG_DEF(MIXER, SET_MODE, MODE, ESP_GMF_AUDIO_MODE_ARG);

AMETHOD_DEF(MIXER, SET_INFO, "set_info");
AMETHOD_ARG_DEF(MIXER, SET_INFO, RATE, ESP_GMF_AUDIO_SAMPLE_RATE_ARG);
AMETHOD_ARG_DEF(MIXER, SET_INFO, CH, ESP_GMF_AUDIO_CHANNEL_ARG);
AMETHOD_ARG_DEF(MIXER, SET_INFO, BITS, ESP_GMF_AUDIO_BITS_ARG);

/**
 * @brief  SONIC method
 */
AMETHOD_DEF(SONIC, SET_SPEED, "set_speed");
AMETHOD_ARG_DEF(SONIC, SET_SPEED, SPEED, ESP_GMF_AUDIO_SPEED_ARG);

AMETHOD_DEF(SONIC, GET_SPEED, "get_speed");
AMETHOD_ARG_DEF(SONIC, GET_SPEED, SPEED, ESP_GMF_AUDIO_SPEED_ARG);

AMETHOD_DEF(SONIC, SET_PITCH, "set_pitch");
AMETHOD_ARG_DEF(SONIC, SET_PITCH, PITCH, ESP_GMF_AUDIO_PITCH_ARG);

AMETHOD_DEF(SONIC, GET_PITCH, "get_pitch");
AMETHOD_ARG_DEF(SONIC, GET_PITCH, PITCH, ESP_GMF_AUDIO_PITCH_ARG);

/**
 * @brief  ENCODER method
 */
AMETHOD_DEF(ENCODER, GET_FRAME_SZ, "get_frame_sz");
AMETHOD_ARG_DEF(ENCODER, GET_FRAME_SZ, INSIZE, ESP_GMF_AUDIO_INSIZE_ARG);
AMETHOD_ARG_DEF(ENCODER, GET_FRAME_SZ, OUTSIZE, ESP_GMF_AUDIO_OUTSIZE_ARG);

AMETHOD_DEF(ENCODER, SET_BITRATE, "set_bitrate");
AMETHOD_ARG_DEF(ENCODER, SET_BITRATE, BITRATE, ESP_GMF_AUDIO_BITRATE_ARG);

AMETHOD_DEF(ENCODER, GET_BITRATE, "get_bitrate");
AMETHOD_ARG_DEF(ENCODER, GET_BITRATE, BITRATE, ESP_GMF_AUDIO_BITRATE_ARG);

AMETHOD_DEF(ENCODER, RECONFIG, "recfg");
AMETHOD_ARG_DEF(ENCODER, RECONFIG, CFG, ESP_GMF_AUDIO_CFG_ARG);
AMETHOD_ARG_DEF(ENCODER, RECONFIG, CFG_TYPE, ESP_GMF_AUDIO_CFG_TYPE_ARG);
AMETHOD_ARG_DEF(ENCODER, RECONFIG, CFG_SUBCFGPTR, ESP_GMF_AUDIO_CFG_SUBCFGPTR_ARG);
AMETHOD_ARG_DEF(ENCODER, RECONFIG, CFG_SUBCFGSZ, ESP_GMF_AUDIO_CFG_SUBCFGSZ_ARG);

AMETHOD_DEF(ENCODER, RECONFIG_BY_SND_INFO, "recfg_by_sndinfo");
AMETHOD_ARG_DEF(ENCODER, RECONFIG_BY_SND_INFO, INFO, ESP_GMF_AUDIO_SND_INFO_ARG);
AMETHOD_ARG_DEF(ENCODER, RECONFIG_BY_SND_INFO, INFO_TYPE, ESP_GMF_AUDIO_SND_INFO_TYPE_ARG);
AMETHOD_ARG_DEF(ENCODER, RECONFIG_BY_SND_INFO, INFO_SAMPLERATE, ESP_GMF_AUDIO_SND_INFO_SAMPLERATE_ARG);
AMETHOD_ARG_DEF(ENCODER, RECONFIG_BY_SND_INFO, INFO_BITRATE, ESP_GMF_AUDIO_SND_INFO_BITRATE_ARG);
AMETHOD_ARG_DEF(ENCODER, RECONFIG_BY_SND_INFO, INFO_CHANNEL, ESP_GMF_AUDIO_SND_INFO_CHANNEL_ARG);
AMETHOD_ARG_DEF(ENCODER, RECONFIG_BY_SND_INFO, INFO_BITS, ESP_GMF_AUDIO_SND_INFO_BITS_ARG);

/**
 * @brief  DECODER method
 */
AMETHOD_DEF(DECODER, RECONFIG, "recfg");
AMETHOD_ARG_DEF(DECODER, RECONFIG, CFG, ESP_GMF_AUDIO_CFG_ARG);
AMETHOD_ARG_DEF(DECODER, RECONFIG, CFG_TYPE, ESP_GMF_AUDIO_CFG_TYPE_ARG);
AMETHOD_ARG_DEF(DECODER, RECONFIG, CFG_SUBCFGPTR, ESP_GMF_AUDIO_CFG_SUBCFGPTR_ARG);
AMETHOD_ARG_DEF(DECODER, RECONFIG, CFG_SUBCFGSZ, ESP_GMF_AUDIO_CFG_SUBCFGSZ_ARG);

AMETHOD_DEF(DECODER, RECONFIG_BY_SND_INFO, "recfg_by_sndinfo");
AMETHOD_ARG_DEF(DECODER, RECONFIG_BY_SND_INFO, INFO, ESP_GMF_AUDIO_SND_INFO_ARG);
AMETHOD_ARG_DEF(DECODER, RECONFIG_BY_SND_INFO, INFO_TYPE, ESP_GMF_AUDIO_SND_INFO_TYPE_ARG);
AMETHOD_ARG_DEF(DECODER, RECONFIG_BY_SND_INFO, INFO_SAMPLERATE, ESP_GMF_AUDIO_SND_INFO_SAMPLERATE_ARG);
AMETHOD_ARG_DEF(DECODER, RECONFIG_BY_SND_INFO, INFO_CHANNEL, ESP_GMF_AUDIO_SND_INFO_CHANNEL_ARG);
AMETHOD_ARG_DEF(DECODER, RECONFIG_BY_SND_INFO, INFO_BITS, ESP_GMF_AUDIO_SND_INFO_BITS_ARG);

#ifdef __cplusplus
}
#endif /* __cplusplus */
