```
 _____                                 _      _  _
/  ___|                               | |    (_)| |
\ `--.   ___  _ __   ___   ___   _ __ | |     _ | |__
 `--. \ / _ \| '_ \ / __| / _ \ | '__|| |    | || '_ \
/\__/ /|  __/| | | |\__ \| (_) || |   | |____| || |_) |
\____/  \___||_| |_||___/ \___/ |_|   \_____/|_||_.__/
                 ···   ···
>  Commonly used I2C , SPI device multi-platform libraries

```

[![Build esp-idf](https://github.com/lewisxhe/SensorLib/actions/workflows/esp-idf.yml/badge.svg)](https://github.com/lewisxhe/SensorLib/actions/workflows/esp-idf.yml)
[![Arduino CI](https://github.com/lewisxhe/SensorLib/actions/workflows/arduino_ci.yml/badge.svg)](https://github.com/lewisxhe/SensorLib/actions/workflows/arduino_ci.yml)
[![PlatformIO CI](https://github.com/lewisxhe/SensorLib/actions/workflows/pio.yml/badge.svg)](https://github.com/lewisxhe/SensorLib/actions/workflows/pio.yml)
[![arduino-library-badge](https://www.ardu-badge.com/badge/SensorLib.svg?)](https://www.ardu-badge.com/SensorLib)
[![PlatformIO Registry](https://badges.registry.platformio.org/packages/lewisxhe/library/SensorLib.svg)](https://registry.platformio.org/libraries/lewisxhe/SensorLib)


[![LICENSE](https://img.shields.io/github/license/lewisxhe/SensorLib)](https://github.com/lewisxhe/SensorLib/blob/master/LICENSE)
[![ISSUES](https://img.shields.io/github/issues/lewisxhe/SensorsLib)](https://github.com/lewisxhe/SensorsLib/issues)
[![FORK](https://img.shields.io/github/forks/lewisxhe/SensorsLib)](https://github.com/lewisxhe/SensorsLib/graphs/contributors)
[![STAR](https://img.shields.io/github/stars/lewisxhe/SensorsLib)](https://github.com/lewisxhe/SensorsLib/stargazers)
[![releases](https://img.shields.io/github/release/lewisxhe/SensorsLib)](https://github.com/lewisxhe/SensorLib/releases)

## RTC
![PCF8563](https://img.shields.io/badge/PCF8563-GREEN)
![PCF85063](https://img.shields.io/badge/PCF85063-GREEN)
![HYM8563](https://img.shields.io/badge/HYM8563-GREEN)

## Motion Sensor

![QMI8658](https://img.shields.io/badge/QMI8658-blue)
![BMM150](https://img.shields.io/badge/BMM150-blue)
![QMC6310](https://img.shields.io/badge/QMC6310-blue)
![BMA423](https://img.shields.io/badge/BMA423-blue)
![BHI260AP](https://img.shields.io/badge/BHI260AP-blue)

## GPIO Expansion
![XL9555](https://img.shields.io/badge/XL9555-yellow)
![XL9535](https://img.shields.io/badge/XL9535-yellow)

## Haptic Driver
![DRV2605](https://img.shields.io/badge/DRV2605-teal)

## Light Sensor
![CM32181](https://img.shields.io/badge/CM32181-brown)
![LTR553](https://img.shields.io/badge/LTR553-brown)

## Touchpad
![FT5206](https://img.shields.io/badge/FT5206-red)
![FT6206](https://img.shields.io/badge/FT6206-red)
![FT6236](https://img.shields.io/badge/FT6236-red)
![FT3267](https://img.shields.io/badge/FT3267-red)
![CST816S](https://img.shields.io/badge/CST816S-red)
![CST816D](https://img.shields.io/badge/CST816D-red)
![CST816T](https://img.shields.io/badge/CST816T-red)
![CST820](https://img.shields.io/badge/CST820-red)
![CST226SE](https://img.shields.io/badge/CST226SE-red)
![CHSC5816](https://img.shields.io/badge/CHSC5816-red)
![GT911](https://img.shields.io/badge/GT911-red)
![CST9217](https://img.shields.io/badge/CST9217-red)
![CST9220](https://img.shields.io/badge/CST9220-red)
![GT9895](https://img.shields.io/badge/GT9895-red)

Support list:

| Sensor          | Description              | I2C | SPI |
| --------------- | ------------------------ | --- | --- |
| PCF8563/HYM8563 | Real-time clock          | ✔️   | ❌   |
| PCF85063        | Real-time clock          | ✔️   | ❌   |
| QMI8658         | IMU                      | ✔️   | ✔️   |
| BHI260AP        | IMU                      | ✔️   | ✔️   |
| QMC6310         | Magnetic Sensor          | ✔️   | ❌   |
| BMM150          | Magnetic Sensor          | ✔️   | ❌   |
| XL9555          | I/O expander             | ✔️   | ❌   |
| BMA423          | Accelerometer            | ✔️   | ❌   |
| DRV2605         | Haptic Driver            | ✔️   | ❌   |
| CM32181         | Ambient Light Sensor     | ✔️   | ❌   |
| LTR553          | Light & Proximity Sensor | ✔️   | ❌   |
| FT3267          | Capacitive touch         | ✔️   | ❌   |
| FT5206          | Capacitive touch         | ✔️   | ❌   |
| FT6206          | Capacitive touch         | ✔️   | ❌   |
| FT6236          | Capacitive touch         | ✔️   | ❌   |
| CST820          | Capacitive touch         | ✔️   | ❌   |
| CST816S/T/D     | Capacitive touch         | ✔️   | ❌   |
| CST226SE        | Capacitive touch         | ✔️   | ❌   |
| CHSC5816        | Capacitive touch         | ✔️   | ❌   |
| GT911           | Capacitive touch         | ✔️   | ❌   |
| CST9217         | Capacitive touch         | ✔️   | ❌   |
| CST9220         | Capacitive touch         | ✔️   | ❌   |
| GT9895          | Capacitive touch         | ✔️   | ❌   |

