
#include "Arduino.h"
#include "Audio.h"
#include "SD.h"
#include "FS.h"

// Digital I/O used
#define SD_CS          5
#define SPI_MOSI       2
#define SPI_MISO       4
#define SPI_SCK       17
#define I2S_DOUT      12
#define I2S_BCLK      14
#define I2S_LRC       15

#define ETHERNET_IF
#define ETH_PHY_TYPE  ETH_PHY_LAN8720
#define ETH_PHY_MDC   23
#define ETH_PHY_MDIO  18

#ifdef CONFIG_IDF_TARGET_ESP32
#define ETH_CLK_MODE  ETH_CLOCK_GPIO0_IN
#endif

#ifdef CONFIG_IDF_TARGET_ESP32P4
#define ETH_CLK_MODE  EMAC_CLK_EXT_IN
#endif

#include "ETH.h"

Audio audio;

static bool eth_connected = false;

void onEvent(arduino_event_id_t event) {
  switch (event) {
    case ARDUINO_EVENT_ETH_START:
      Serial.println("ETH Started");
      // The hostname must be set after the interface is started, but needs
      // to be set before DHCP, so set it from the event handler thread.
      ETH.setHostname("esp32-ethernet");
      break;
    case ARDUINO_EVENT_ETH_CONNECTED: Serial.println("ETH Connected"); break;
    case ARDUINO_EVENT_ETH_GOT_IP:
      Serial.println("ETH Got IP");
      Serial.println(ETH);
      eth_connected = true;
      break;
    case ARDUINO_EVENT_ETH_LOST_IP:
      Serial.println("ETH Lost IP");
      eth_connected = false;
      break;
    case ARDUINO_EVENT_ETH_DISCONNECTED:
      Serial.println("ETH Disconnected");
      eth_connected = false;
      break;
    case ARDUINO_EVENT_ETH_STOP:
      Serial.println("ETH Stopped");
      eth_connected = false;
      break;
    default: break;
  }
}

void setup() {
    pinMode(SD_CS, OUTPUT);      digitalWrite(SD_CS, HIGH);
    SPI.begin(SPI_SCK, SPI_MISO, SPI_MOSI);
    Serial.begin(115200);
    SD.begin(SD_CS);

    Network.onEvent(onEvent);
    ETH.begin();
    while (!eth_connected) delay(100);
    // Eth Connected,

    audio.setPinout(I2S_BCLK, I2S_LRC, I2S_DOUT);
    audio.setVolume(21); // default 0...21
    audio.connecttohost("https://wdr-wdr2-ruhrgebiet.icecastssl.wdr.de/wdr/wdr2/ruhrgebiet/mp3/128/stream.mp3"); // mp3
}

void loop(){
    vTaskDelay(1);
    audio.loop();
}

void audio_info(const char *info){
    Serial.print("info        "); Serial.println(info);
}
