/*
MIT License

Copyright (c) 2018 Brian T. Park

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

/**
 * @mainpage AceButton Library
 *
 * This is the Doxygen documentation for the
 * <a href="https://github.com/bxparks/AceButton">AceButton Library</a>.
 *
 * Click on the "Classes" menu above to see the list of classes.
 *
 * Click on the "Files" menu above to see the list of header files.
*/

#ifndef ACE_BUTTON_H
#define ACE_BUTTON_H

#include "ace_button/IEventHandler.h"
#include "ace_button/ButtonConfig.h"
#include "ace_button/Encoded8To3ButtonConfig.h"
#include "ace_button/Encoded4To2ButtonConfig.h"
#include "ace_button/EncodedButtonConfig.h"
#include "ace_button/LadderButtonConfig.h"
#include "ace_button/AceButton.h"

// Version format: xxyyzz == "xx.yy.zz"
#define ACE_BUTTON_VERSION 11001
#define ACE_BUTTON_VERSION_STRING "1.10.1"

#endif
