/*
* Copyright 2016 The Alatsi Project Authors (https://github.com/sorkintype/alatsi).
* This Font Software is licensed under the SIL Open Font License, Version 1.1.
* And is also available with a FAQ at: http://scripts.sil.org/OFL
*/
/*******************************************************************************
 * Size: 21 px
 * Bpp: 4
 * Opts: undefined
 ******************************************************************************/

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
#include "lvgl.h"
#else
#include "lvgl.h"
#endif

#ifndef LV_FONT_ALATSI_REGULAR_21
#define LV_FONT_ALATSI_REGULAR_21 1
#endif

#if LV_FONT_ALATSI_REGULAR_21

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x1f, 0xfc, 0x1f, 0xfb, 0xf, 0xfb, 0xf, 0xfa,
    0xf, 0xfa, 0xf, 0xf9, 0xf, 0xf9, 0xe, 0xf9,
    0xe, 0xf8, 0xe, 0xf8, 0xd, 0xf7, 0x1, 0x21,
    0x3, 0x31, 0xe, 0xf8, 0xe, 0xf8, 0xe, 0xf8,

    /* U+0022 "\"" */
    0x1f, 0xf2, 0xa, 0xf9, 0x1f, 0xf2, 0xa, 0xf9,
    0xf, 0xf1, 0x9, 0xf8, 0xf, 0xf1, 0x9, 0xf8,
    0xf, 0xf0, 0x8, 0xf7, 0xf, 0xf0, 0x8, 0xf7,
    0xe, 0xf0, 0x7, 0xf6, 0x4, 0x40, 0x2, 0x41,

    /* U+0023 "#" */
    0x0, 0x0, 0xbf, 0x20, 0x7f, 0x60, 0x0, 0x0,
    0xd, 0xf0, 0x8, 0xf4, 0x0, 0x0, 0x0, 0xee,
    0x0, 0xaf, 0x20, 0x0, 0x0, 0xf, 0xc0, 0xc,
    0xf1, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x10, 0x5a, 0xbf, 0xda, 0xaf, 0xea, 0xa0, 0x0,
    0x6, 0xf7, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x8f,
    0x50, 0x3f, 0x90, 0x0, 0x0, 0x9, 0xf3, 0x5,
    0xf7, 0x0, 0x0, 0xaa, 0xef, 0xba, 0xcf, 0xca,
    0x50, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0xfe, 0x0, 0xbf, 0x20, 0x0, 0x0, 0x1f,
    0xc0, 0xd, 0xf0, 0x0, 0x0, 0x2, 0xfa, 0x0,
    0xee, 0x0, 0x0, 0x0, 0x4f, 0x90, 0xf, 0xd0,
    0x0, 0x0,

    /* U+0024 "$" */
    0x0, 0x6, 0xff, 0x20, 0x0, 0x0, 0x6, 0xff,
    0x20, 0x0, 0x1, 0x8e, 0xff, 0xc6, 0x0, 0x1d,
    0xff, 0xff, 0xff, 0x70, 0x7f, 0xf6, 0x0, 0x3a,
    0x10, 0x9f, 0xf0, 0x0, 0x0, 0x0, 0x7f, 0xfa,
    0x10, 0x0, 0x0, 0x1e, 0xff, 0xfc, 0x60, 0x0,
    0x1, 0xaf, 0xff, 0xfe, 0x30, 0x0, 0x1, 0x5c,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x9f, 0xf4, 0x15,
    0x0, 0x0, 0x8f, 0xf3, 0x7f, 0xd8, 0x69, 0xff,
    0xd0, 0x2b, 0xff, 0xff, 0xfc, 0x20, 0x0, 0x18,
    0xff, 0x30, 0x0, 0x0, 0x6, 0xff, 0x20, 0x0,

    /* U+0025 "%" */
    0x0, 0x7d, 0xfd, 0x60, 0x0, 0x0, 0xcf, 0x30,
    0x0, 0x0, 0x8f, 0xeb, 0xff, 0x60, 0x0, 0x5f,
    0xb0, 0x0, 0x0, 0xe, 0xf5, 0x9, 0xfc, 0x0,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0xff, 0x30, 0x6f,
    0xe0, 0x6, 0xfa, 0x0, 0x0, 0x0, 0xf, 0xf3,
    0x6, 0xfd, 0x0, 0xef, 0x20, 0x0, 0x0, 0x0,
    0xcf, 0x90, 0xbf, 0xa0, 0x7f, 0x90, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xf2, 0x1f, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x79, 0x71, 0x8, 0xf7,
    0x5, 0xdf, 0xd6, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xfe, 0x5, 0xff, 0xbf, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x60, 0xcf, 0x80, 0x7f, 0xd0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0xe, 0xf5, 0x4, 0xff,
    0x0, 0x0, 0x0, 0xb, 0xf5, 0x0, 0xef, 0x50,
    0x4f, 0xf0, 0x0, 0x0, 0x3, 0xfd, 0x0, 0xb,
    0xf8, 0x7, 0xfd, 0x0, 0x0, 0x0, 0xcf, 0x40,
    0x0, 0x4f, 0xfb, 0xff, 0x70, 0x0, 0x0, 0x4f,
    0xc0, 0x0, 0x0, 0x6d, 0xfe, 0x80, 0x0,

    /* U+0026 "&" */
    0x0, 0x5c, 0xfe, 0xa2, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xfe, 0x10, 0x0, 0x1f, 0xf8, 0x3, 0xff,
    0x70, 0x0, 0x3f, 0xf1, 0x0, 0xdf, 0x90, 0x0,
    0x3f, 0xf3, 0x0, 0xff, 0x60, 0x0, 0xe, 0xfb,
    0x6, 0xff, 0x10, 0x0, 0x5, 0xff, 0xbf, 0xf5,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0x50, 0x0, 0x0,
    0x9, 0xff, 0xff, 0x70, 0x9, 0x70, 0x6f, 0xf3,
    0xbf, 0xf5, 0xe, 0xf6, 0xdf, 0xa0, 0xc, 0xff,
    0xbf, 0xf1, 0xff, 0xa0, 0x1, 0xdf, 0xff, 0x70,
    0xcf, 0xf6, 0x24, 0xcf, 0xff, 0x30, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x2, 0xae, 0xfe, 0xa3,
    0x4e, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0027 "'" */
    0x1f, 0xf2, 0x1f, 0xf2, 0xf, 0xf1, 0xf, 0xf1,
    0xf, 0xf0, 0xf, 0xf0, 0xe, 0xf0, 0x4, 0x40,

    /* U+0028 "(" */
    0x0, 0x0, 0x5, 0x0, 0x0, 0x1d, 0xf5, 0x0,
    0xd, 0xf7, 0x0, 0xa, 0xfb, 0x0, 0x2, 0xff,
    0x30, 0x0, 0xaf, 0xc0, 0x0, 0xf, 0xf7, 0x0,
    0x4, 0xff, 0x40, 0x0, 0x7f, 0xf1, 0x0, 0x8,
    0xff, 0x0, 0x0, 0xaf, 0xf0, 0x0, 0x9, 0xff,
    0x0, 0x0, 0x8f, 0xf0, 0x0, 0x7, 0xff, 0x20,
    0x0, 0x3f, 0xf4, 0x0, 0x0, 0xef, 0x80, 0x0,
    0x8, 0xfd, 0x0, 0x0, 0x1f, 0xf5, 0x0, 0x0,
    0x6f, 0xe1, 0x0, 0x0, 0x9f, 0xc1, 0x0, 0x0,
    0x7f, 0x50, 0x0, 0x0, 0x0,

    /* U+0029 ")" */
    0x1, 0x20, 0x0, 0x0, 0xb, 0xf7, 0x0, 0x0,
    0x1, 0xcf, 0x70, 0x0, 0x0, 0x2f, 0xf3, 0x0,
    0x0, 0x8, 0xfc, 0x0, 0x0, 0x2, 0xff, 0x40,
    0x0, 0x0, 0xdf, 0x90, 0x0, 0x0, 0xaf, 0xe0,
    0x0, 0x0, 0x7f, 0xf2, 0x0, 0x0, 0x6f, 0xf3,
    0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x5f, 0xf4,
    0x0, 0x0, 0x5f, 0xf3, 0x0, 0x0, 0x7f, 0xf1,
    0x0, 0x0, 0x9f, 0xe0, 0x0, 0x0, 0xdf, 0x90,
    0x0, 0x2, 0xff, 0x30, 0x0, 0xa, 0xfb, 0x0,
    0x0, 0x4f, 0xf2, 0x0, 0x2, 0xef, 0x50, 0x0,
    0xb, 0xe5, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,

    /* U+002A "*" */
    0x0, 0x0, 0xdf, 0x30, 0x0, 0x0, 0x0, 0xcf,
    0x20, 0x0, 0xb, 0x81, 0xbf, 0x15, 0xc2, 0x1f,
    0xff, 0xff, 0xef, 0xf7, 0x3, 0x8d, 0xff, 0xfa,
    0x51, 0x0, 0xa, 0xff, 0xe1, 0x0, 0x0, 0x8f,
    0xc6, 0xfd, 0x0, 0x2, 0xff, 0x30, 0xcf, 0x70,
    0x0, 0x37, 0x0, 0x37, 0x0,

    /* U+002B "+" */
    0x0, 0x0, 0x2c, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf1, 0x0, 0x0,
    0x1, 0x11, 0x4f, 0xf2, 0x11, 0x10, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x3f, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xf1,
    0x0, 0x0,

    /* U+002C "," */
    0xa, 0xb5, 0xe, 0xf7, 0xe, 0xf6, 0xf, 0xf5,
    0xf, 0xf3, 0xf, 0xf0, 0x2f, 0xb0,

    /* U+002D "-" */
    0x11, 0x11, 0x11, 0x10, 0x9f, 0xff, 0xff, 0xf2,
    0x9f, 0xff, 0xff, 0xf2,

    /* U+002E "." */
    0x33, 0x1f, 0xf7, 0xff, 0x7f, 0xf7,

    /* U+002F "/" */
    0x0, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0, 0x8,
    0xf8, 0x0, 0x0, 0x0, 0xcf, 0x40, 0x0, 0x0,
    0x1f, 0xf0, 0x0, 0x0, 0x5, 0xfb, 0x0, 0x0,
    0x0, 0x9f, 0x70, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0x2, 0xfe, 0x0, 0x0, 0x0, 0x7f, 0xa0,
    0x0, 0x0, 0xb, 0xf5, 0x0, 0x0, 0x0, 0xff,
    0x10, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0, 0x8,
    0xf8, 0x0, 0x0, 0x0, 0xcf, 0x40, 0x0, 0x0,
    0x1f, 0xf0, 0x0, 0x0, 0x5, 0xfb, 0x0, 0x0,
    0x0, 0x9f, 0x70, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0x2, 0xfe, 0x0, 0x0, 0x0, 0x6f, 0xa0,
    0x0, 0x0, 0xb, 0xf5, 0x0, 0x0, 0x0, 0xff,
    0x10, 0x0, 0x0, 0x3f, 0xd0, 0x0, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x5, 0xcf, 0xfc, 0x60, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xfa, 0x0, 0x3, 0xff, 0xe6, 0x5d,
    0xff, 0x60, 0xa, 0xff, 0x50, 0x2, 0xff, 0xd0,
    0xf, 0xff, 0x0, 0x0, 0xdf, 0xf1, 0x1f, 0xfd,
    0x0, 0x0, 0xaf, 0xf4, 0x3f, 0xfb, 0x0, 0x0,
    0x8f, 0xf5, 0x3f, 0xfb, 0x0, 0x0, 0x8f, 0xf6,
    0x3f, 0xfc, 0x0, 0x0, 0x8f, 0xf5, 0x1f, 0xfd,
    0x0, 0x0, 0xaf, 0xf4, 0xe, 0xff, 0x10, 0x0,
    0xdf, 0xf1, 0xa, 0xff, 0x60, 0x3, 0xff, 0xd0,
    0x3, 0xff, 0xf7, 0x6e, 0xff, 0x60, 0x0, 0x8f,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x5, 0xcf, 0xfd,
    0x70, 0x0,

    /* U+0031 "1" */
    0x0, 0x3, 0x6, 0xdb, 0x2f, 0xfb, 0x2f, 0xfb,
    0x2f, 0xfb, 0x2f, 0xfb, 0x2f, 0xfb, 0x2f, 0xfb,
    0x2f, 0xfb, 0x2f, 0xfb, 0x2f, 0xfb, 0x2f, 0xfb,
    0x2f, 0xfb, 0x2f, 0xfb, 0x2f, 0xfb, 0x2f, 0xfb,

    /* U+0032 "2" */
    0x0, 0x6, 0xcf, 0xfc, 0x60, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xa0, 0x9, 0xff, 0xc7, 0x8f, 0xff,
    0x40, 0xff, 0xb0, 0x0, 0x5f, 0xf9, 0x5, 0xc3,
    0x0, 0x1, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x4f,
    0xf7, 0x0, 0x0, 0x0, 0x1d, 0xff, 0x20, 0x0,
    0x0, 0x3d, 0xff, 0x80, 0x0, 0x0, 0x9f, 0xff,
    0x70, 0x0, 0x2, 0xdf, 0xfd, 0x30, 0x0, 0x0,
    0xdf, 0xf8, 0x0, 0x0, 0x0, 0x7f, 0xf6, 0x0,
    0x0, 0x0, 0xb, 0xff, 0x77, 0x77, 0x77, 0x50,
    0xcf, 0xff, 0xff, 0xff, 0xfc, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xc0,

    /* U+0033 "3" */
    0x1, 0x7c, 0xef, 0xeb, 0x50, 0x0, 0xef, 0xff,
    0xff, 0xff, 0x80, 0xb, 0xfb, 0x88, 0xcf, 0xff,
    0x10, 0x22, 0x0, 0x0, 0xdf, 0xf3, 0x0, 0x0,
    0x0, 0xd, 0xff, 0x10, 0x0, 0x2, 0x3a, 0xff,
    0xa0, 0x0, 0x6, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x6f, 0xff, 0xfe, 0x50, 0x0, 0x0, 0x1, 0x5e,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x7f, 0xf7, 0x0,
    0x0, 0x0, 0x6, 0xff, 0x90, 0x34, 0x0, 0x0,
    0xcf, 0xf7, 0xa, 0xfb, 0x88, 0xdf, 0xff, 0x10,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x2, 0x8d, 0xff,
    0xd9, 0x20, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x2, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x1f,
    0xf9, 0xff, 0x80, 0x0, 0x0, 0x8, 0xff, 0x3f,
    0xf8, 0x0, 0x0, 0x0, 0xef, 0xc0, 0xff, 0x80,
    0x0, 0x0, 0x6f, 0xf6, 0xf, 0xf8, 0x0, 0x0,
    0xd, 0xff, 0x1, 0xff, 0x80, 0x0, 0x5, 0xff,
    0x90, 0x1f, 0xf8, 0x0, 0x0, 0xcf, 0xf2, 0x1,
    0xff, 0x80, 0x0, 0x3f, 0xfa, 0x0, 0x1f, 0xf8,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x42,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x1, 0x11,
    0x11, 0x14, 0xff, 0x81, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0x80, 0x0,

    /* U+0035 "5" */
    0x2, 0xff, 0xff, 0xff, 0xff, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xf0, 0x3, 0xff, 0x74, 0x44, 0x44,
    0x0, 0x4f, 0xf2, 0x0, 0x0, 0x0, 0x4, 0xff,
    0x11, 0x10, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xe8,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x35,
    0x20, 0x17, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x8,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x4f, 0xf9, 0x0,
    0x0, 0x0, 0x5, 0xff, 0x70, 0x10, 0x0, 0x0,
    0xbf, 0xf4, 0x9, 0xd8, 0x67, 0xcf, 0xfc, 0x0,
    0xef, 0xff, 0xff, 0xfd, 0x10, 0x5, 0xbd, 0xfe,
    0xc7, 0x0, 0x0,

    /* U+0036 "6" */
    0x0, 0x2, 0x9d, 0xff, 0xc6, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xfe, 0x0, 0x3, 0xff, 0xf9, 0x66,
    0xa6, 0x0, 0xd, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x3f, 0xf8, 0x0, 0x21, 0x0, 0x0, 0x8f, 0xf3,
    0x9f, 0xff, 0xd4, 0x0, 0xaf, 0xfb, 0xff, 0xff,
    0xff, 0x40, 0xcf, 0xff, 0xa2, 0x18, 0xff, 0xc0,
    0xbf, 0xfb, 0x0, 0x0, 0xdf, 0xf1, 0xaf, 0xf6,
    0x0, 0x0, 0xaf, 0xf2, 0x7f, 0xf7, 0x0, 0x0,
    0xbf, 0xf1, 0x2f, 0xfd, 0x0, 0x1, 0xff, 0xe0,
    0xa, 0xff, 0xb4, 0x5d, 0xff, 0x70, 0x1, 0xcf,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x7, 0xdf, 0xeb,
    0x50, 0x0,

    /* U+0037 "7" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0x61, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x8, 0x88, 0x88, 0x9f, 0xfc,
    0x0, 0x0, 0x0, 0x4, 0xff, 0x70, 0x0, 0x0,
    0x0, 0xaf, 0xf2, 0x0, 0x0, 0x0, 0xf, 0xfc,
    0x0, 0x0, 0x0, 0x4, 0xff, 0x70, 0x0, 0x0,
    0x0, 0xaf, 0xf2, 0x0, 0x0, 0x0, 0xf, 0xfd,
    0x0, 0x0, 0x0, 0x5, 0xff, 0x80, 0x0, 0x0,
    0x0, 0xaf, 0xf3, 0x0, 0x0, 0x0, 0xf, 0xfe,
    0x0, 0x0, 0x0, 0x5, 0xff, 0x90, 0x0, 0x0,
    0x0, 0xaf, 0xf4, 0x0, 0x0, 0x0, 0xf, 0xff,
    0x0, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x5, 0xbe, 0xfe, 0xb5, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0x3, 0xff, 0xd3,
    0x2, 0xdf, 0xf2, 0x0, 0x5f, 0xf7, 0x0, 0x7,
    0xff, 0x50, 0x4, 0xff, 0x90, 0x0, 0x8f, 0xf3,
    0x0, 0xd, 0xff, 0x62, 0x5f, 0xfc, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xfb, 0x10, 0x0, 0x6, 0xef,
    0xff, 0xff, 0xe6, 0x0, 0x5, 0xff, 0xd3, 0x3,
    0xdf, 0xf5, 0x0, 0xdf, 0xf3, 0x0, 0x3, 0xff,
    0xd0, 0xf, 0xff, 0x0, 0x0, 0x1f, 0xff, 0x0,
    0xef, 0xf3, 0x0, 0x3, 0xff, 0xe0, 0x8, 0xff,
    0xd5, 0x35, 0xdf, 0xf8, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x5, 0xbe, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+0039 "9" */
    0x0, 0x39, 0xef, 0xea, 0x20, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x3f, 0xff, 0x73, 0x6e,
    0xfe, 0x10, 0x9f, 0xf5, 0x0, 0x4, 0xff, 0x80,
    0xbf, 0xf1, 0x0, 0x0, 0xff, 0xd0, 0xbf, 0xf3,
    0x0, 0x2, 0xff, 0xf0, 0x7f, 0xfc, 0x20, 0x4e,
    0xff, 0xf2, 0xd, 0xff, 0xff, 0xff, 0xbf, 0xf2,
    0x1, 0xbf, 0xff, 0xc3, 0xaf, 0xf1, 0x0, 0x1,
    0x21, 0x0, 0xdf, 0xf0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xa0, 0x0, 0x10, 0x0, 0x1d, 0xff, 0x40,
    0x2, 0xfa, 0x79, 0xef, 0xfa, 0x0, 0x9, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x2, 0xae, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+003A ":" */
    0x33, 0x1f, 0xf7, 0xff, 0x7f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x33, 0x1f, 0xf7, 0xff,
    0x7f, 0xf7,

    /* U+003B ";" */
    0xf, 0xf7, 0xf, 0xf7, 0xf, 0xf7, 0x3, 0x31,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xb5, 0xe, 0xf7, 0xe, 0xf6, 0xf, 0xf5,
    0xf, 0xf3, 0xf, 0xf0, 0x2f, 0xb0,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xa7, 0x0, 0x0, 0x6, 0xef, 0x70, 0x0, 0x2c,
    0xff, 0xc2, 0x0, 0x7f, 0xfe, 0x60, 0x2, 0xdf,
    0xfa, 0x10, 0x0, 0x5f, 0xf5, 0x0, 0x0, 0x3,
    0xff, 0xe6, 0x0, 0x0, 0x2, 0xcf, 0xfc, 0x20,
    0x0, 0x0, 0x6e, 0xff, 0x80, 0x0, 0x0, 0x1a,
    0xff, 0x70, 0x0, 0x0, 0x4, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x20,

    /* U+003D "=" */
    0xcf, 0xff, 0xff, 0xff, 0xf2, 0xcf, 0xff, 0xff,
    0xff, 0xf2, 0x11, 0x11, 0x11, 0x11, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x12, 0x22, 0x22, 0x22, 0x20, 0xcf, 0xff,
    0xff, 0xff, 0xf2, 0xcf, 0xff, 0xff, 0xff, 0xf2,

    /* U+003E ">" */
    0x0, 0x0, 0x0, 0x0, 0x5, 0xb2, 0x0, 0x0,
    0x0, 0x5f, 0xf7, 0x0, 0x0, 0x1, 0xaf, 0xfd,
    0x30, 0x0, 0x0, 0x4d, 0xff, 0x91, 0x0, 0x0,
    0x8, 0xff, 0xe3, 0x0, 0x0, 0x3, 0xff, 0x70,
    0x0, 0x4, 0xdf, 0xf5, 0x0, 0x1a, 0xff, 0xd3,
    0x0, 0x6e, 0xff, 0x70, 0x0, 0x4f, 0xfc, 0x20,
    0x0, 0x5, 0xe6, 0x0, 0x0, 0x0, 0x21, 0x0,
    0x0, 0x0, 0x0,

    /* U+003F "?" */
    0x0, 0x6c, 0xff, 0xd8, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xc0, 0xc, 0xfc, 0x78, 0xff, 0xf4, 0x1,
    0x80, 0x0, 0x6f, 0xf7, 0x0, 0x0, 0x0, 0x5f,
    0xf5, 0x0, 0x0, 0x0, 0xbf, 0xe0, 0x0, 0x0,
    0x1c, 0xfd, 0x20, 0x0, 0x0, 0xef, 0xd1, 0x0,
    0x0, 0x6, 0xff, 0x20, 0x0, 0x0, 0x8, 0xfd,
    0x0, 0x0, 0x0, 0x6, 0xda, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x33, 0x0,
    0x0, 0x0, 0x7, 0xff, 0x0, 0x0, 0x0, 0x7,
    0xff, 0x0, 0x0, 0x0, 0x7, 0xff, 0x0, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7c, 0xff, 0xfd, 0x81, 0x0, 0x0,
    0x2, 0xef, 0xa6, 0x45, 0x8e, 0xe3, 0x0, 0x3,
    0xfd, 0x20, 0x0, 0x0, 0x1d, 0xe1, 0x0, 0xdd,
    0x10, 0x26, 0x61, 0x77, 0x2f, 0x70, 0x7f, 0x40,
    0x5f, 0xff, 0xef, 0xa0, 0xcc, 0xd, 0xc0, 0x2f,
    0xf3, 0x1b, 0xf7, 0xa, 0xe1, 0xf7, 0x9, 0xf7,
    0x0, 0x8f, 0x30, 0x9e, 0x4f, 0x40, 0xdf, 0x30,
    0xc, 0xf0, 0xb, 0xd5, 0xf3, 0xf, 0xf1, 0x2,
    0xfd, 0x0, 0xda, 0x5f, 0x30, 0xff, 0x10, 0xaf,
    0xa0, 0x2f, 0x53, 0xf4, 0xc, 0xfb, 0x9f, 0xfc,
    0x3c, 0xd0, 0x1f, 0x80, 0x4f, 0xfd, 0x2c, 0xff,
    0xc1, 0x0, 0xbe, 0x10, 0x13, 0x0, 0x4, 0x20,
    0x0, 0x3, 0xfb, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfe, 0x73, 0x12, 0x49, 0xd0, 0x0,
    0x0, 0x2, 0xae, 0xff, 0xff, 0xe9, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x33, 0x10, 0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0x0, 0x54, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xad, 0xfb, 0x0,
    0x0, 0x0, 0x4, 0xff, 0x57, 0xff, 0x20, 0x0,
    0x0, 0xa, 0xff, 0x1, 0xff, 0x90, 0x0, 0x0,
    0x1f, 0xfa, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x8f,
    0xf5, 0x11, 0x6f, 0xf6, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x30, 0xb, 0xff, 0x20, 0x0, 0x3,
    0xff, 0xa0, 0x2f, 0xfc, 0x0, 0x0, 0x0, 0xcf,
    0xf1,

    /* U+0042 "B" */
    0x3f, 0xff, 0xff, 0xd8, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x3f, 0xf7, 0x24, 0xbf, 0xf6,
    0x3, 0xff, 0x60, 0x1, 0xff, 0x90, 0x3f, 0xf6,
    0x0, 0x1f, 0xf8, 0x3, 0xff, 0x60, 0x1a, 0xff,
    0x20, 0x3f, 0xff, 0xff, 0xff, 0x50, 0x3, 0xff,
    0xff, 0xff, 0xfe, 0x30, 0x3f, 0xf6, 0x1, 0x5f,
    0xfe, 0x3, 0xff, 0x60, 0x0, 0x9f, 0xf3, 0x3f,
    0xf6, 0x0, 0x7, 0xff, 0x53, 0xff, 0x60, 0x0,
    0xaf, 0xf3, 0x3f, 0xf8, 0x33, 0x8f, 0xfe, 0x3,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x3f, 0xff, 0xff,
    0xd9, 0x20, 0x0,

    /* U+0043 "C" */
    0x0, 0x0, 0x6c, 0xff, 0xd7, 0x0, 0x1, 0xdf,
    0xff, 0xff, 0xf8, 0x0, 0xdf, 0xfe, 0x98, 0xcf,
    0x10, 0x6f, 0xfc, 0x0, 0x0, 0x30, 0xc, 0xff,
    0x30, 0x0, 0x0, 0x0, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x2f, 0xfc, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x1f, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xf0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x6f, 0xfd, 0x0,
    0x0, 0x20, 0x0, 0xcf, 0xfe, 0x89, 0xcf, 0x10,
    0x1, 0xdf, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x7d,
    0xff, 0xd7, 0x0,

    /* U+0044 "D" */
    0x4f, 0xff, 0xfe, 0xb6, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xd2, 0x0, 0x4f, 0xf7, 0x24, 0xbf,
    0xfd, 0x0, 0x4f, 0xf6, 0x0, 0xb, 0xff, 0x60,
    0x4f, 0xf6, 0x0, 0x3, 0xff, 0xc0, 0x4f, 0xf6,
    0x0, 0x0, 0xdf, 0xf0, 0x4f, 0xf6, 0x0, 0x0,
    0xbf, 0xf0, 0x4f, 0xf6, 0x0, 0x0, 0xaf, 0xf1,
    0x4f, 0xf6, 0x0, 0x0, 0xbf, 0xf0, 0x4f, 0xf6,
    0x0, 0x0, 0xef, 0xe0, 0x4f, 0xf6, 0x0, 0x3,
    0xff, 0x90, 0x4f, 0xf6, 0x0, 0x1d, 0xff, 0x40,
    0x4f, 0xfa, 0x68, 0xef, 0xfa, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x4f, 0xff, 0xfe, 0xb4,
    0x0, 0x0,

    /* U+0045 "E" */
    0x4f, 0xff, 0xff, 0xff, 0x54, 0xff, 0xff, 0xff,
    0xf5, 0x4f, 0xf9, 0x55, 0x55, 0x14, 0xff, 0x50,
    0x0, 0x0, 0x4f, 0xf5, 0x0, 0x0, 0x4, 0xff,
    0x84, 0x44, 0x10, 0x4f, 0xff, 0xff, 0xf5, 0x4,
    0xff, 0xff, 0xff, 0x50, 0x4f, 0xf5, 0x0, 0x0,
    0x4, 0xff, 0x50, 0x0, 0x0, 0x4f, 0xf5, 0x0,
    0x0, 0x4, 0xff, 0x50, 0x0, 0x0, 0x4f, 0xf9,
    0x77, 0x77, 0x54, 0xff, 0xff, 0xff, 0xfc, 0x4f,
    0xff, 0xff, 0xff, 0xc0,

    /* U+0046 "F" */
    0x3f, 0xff, 0xff, 0xff, 0x63, 0xff, 0xff, 0xff,
    0xf6, 0x3f, 0xfa, 0x66, 0x66, 0x23, 0xff, 0x70,
    0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0, 0x3, 0xff,
    0x70, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xfc, 0x3,
    0xff, 0xff, 0xff, 0xc0, 0x3f, 0xfa, 0x66, 0x65,
    0x3, 0xff, 0x70, 0x0, 0x0, 0x3f, 0xf7, 0x0,
    0x0, 0x3, 0xff, 0x70, 0x0, 0x0, 0x3f, 0xf7,
    0x0, 0x0, 0x3, 0xff, 0x70, 0x0, 0x0, 0x3f,
    0xf7, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x0, 0x5b, 0xef, 0xec, 0x60, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0x50, 0x0, 0xbf, 0xff,
    0xa9, 0xae, 0xe0, 0x0, 0x5f, 0xfe, 0x20, 0x0,
    0x3, 0x0, 0xb, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xfa, 0x0, 0x6, 0x66, 0x66, 0x23, 0xff, 0x90,
    0x1, 0xff, 0xff, 0xf7, 0x1f, 0xfa, 0x0, 0x1f,
    0xff, 0xff, 0x80, 0xff, 0xd0, 0x0, 0x0, 0x1f,
    0xf7, 0xb, 0xff, 0x20, 0x0, 0x3, 0xff, 0x50,
    0x5f, 0xfc, 0x0, 0x0, 0x9f, 0xf1, 0x0, 0xcf,
    0xfd, 0x77, 0xbf, 0xfb, 0x0, 0x1, 0xcf, 0xff,
    0xff, 0xfe, 0x20, 0x0, 0x0, 0x6c, 0xff, 0xd9,
    0x10, 0x0,

    /* U+0048 "H" */
    0x3f, 0xf7, 0x0, 0x0, 0xbf, 0xf0, 0x3f, 0xf7,
    0x0, 0x0, 0xbf, 0xf0, 0x3f, 0xf7, 0x0, 0x0,
    0xbf, 0xf0, 0x3f, 0xf7, 0x0, 0x0, 0xbf, 0xf0,
    0x3f, 0xf7, 0x0, 0x0, 0xbf, 0xf0, 0x3f, 0xf7,
    0x0, 0x0, 0xbf, 0xf0, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x3f, 0xfa, 0x66, 0x66, 0xdf, 0xf0, 0x3f, 0xf7,
    0x0, 0x0, 0xbf, 0xf0, 0x3f, 0xf7, 0x0, 0x0,
    0xbf, 0xf0, 0x3f, 0xf7, 0x0, 0x0, 0xbf, 0xf0,
    0x3f, 0xf7, 0x0, 0x0, 0xbf, 0xf0, 0x3f, 0xf7,
    0x0, 0x0, 0xbf, 0xf0, 0x3f, 0xf7, 0x0, 0x0,
    0xbf, 0xf0,

    /* U+0049 "I" */
    0x4f, 0xf6, 0x4f, 0xf6, 0x4f, 0xf6, 0x4f, 0xf6,
    0x4f, 0xf6, 0x4f, 0xf6, 0x4f, 0xf6, 0x4f, 0xf6,
    0x4f, 0xf6, 0x4f, 0xf6, 0x4f, 0xf6, 0x4f, 0xf6,
    0x4f, 0xf6, 0x4f, 0xf6, 0x4f, 0xf6,

    /* U+004A "J" */
    0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0xd, 0xfd,
    0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0xf, 0xfb,
    0x6, 0xb7, 0xbf, 0xf7, 0xd, 0xff, 0xff, 0xe1,
    0x9, 0xdf, 0xea, 0x20,

    /* U+004B "K" */
    0x3f, 0xf7, 0x0, 0x3, 0xff, 0xd0, 0x3f, 0xf7,
    0x0, 0xd, 0xff, 0x30, 0x3f, 0xf7, 0x0, 0x7f,
    0xf8, 0x0, 0x3f, 0xf7, 0x2, 0xff, 0xd0, 0x0,
    0x3f, 0xf7, 0xb, 0xff, 0x30, 0x0, 0x3f, 0xf7,
    0x5f, 0xf7, 0x0, 0x0, 0x3f, 0xf7, 0xef, 0xc0,
    0x0, 0x0, 0x3f, 0xfe, 0xff, 0x50, 0x0, 0x0,
    0x3f, 0xf9, 0xff, 0xd0, 0x0, 0x0, 0x3f, 0xf7,
    0x7f, 0xfa, 0x0, 0x0, 0x3f, 0xf7, 0xc, 0xff,
    0x50, 0x0, 0x3f, 0xf7, 0x2, 0xff, 0xe1, 0x0,
    0x3f, 0xf7, 0x0, 0x7f, 0xfb, 0x0, 0x3f, 0xf7,
    0x0, 0xc, 0xff, 0x70, 0x3f, 0xf7, 0x0, 0x3,
    0xff, 0xf2,

    /* U+004C "L" */
    0x3f, 0xf7, 0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0,
    0x3f, 0xf7, 0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0,
    0x3f, 0xf7, 0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0,
    0x3f, 0xf7, 0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0,
    0x3f, 0xf7, 0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0,
    0x3f, 0xf7, 0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0,
    0x3f, 0xfa, 0x66, 0x64, 0x3f, 0xff, 0xff, 0xfc,
    0x3f, 0xff, 0xff, 0xfc,

    /* U+004D "M" */
    0x36, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa3, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x3f, 0xe2, 0x0,
    0x0, 0x0, 0x5f, 0xf3, 0xff, 0xd1, 0x0, 0x0,
    0x3f, 0xff, 0x3f, 0xff, 0xb0, 0x0, 0x1e, 0xff,
    0xf3, 0xff, 0xff, 0x90, 0xc, 0xff, 0xff, 0x3f,
    0xfc, 0xff, 0x7a, 0xff, 0xcf, 0xf3, 0xff, 0x5c,
    0xff, 0xff, 0x98, 0xff, 0x3f, 0xf5, 0x1e, 0xff,
    0xb0, 0x9f, 0xf3, 0xff, 0x60, 0x3f, 0xd1, 0x9,
    0xff, 0x3f, 0xf6, 0x0, 0x42, 0x0, 0x9f, 0xf3,
    0xff, 0x60, 0x0, 0x0, 0x9, 0xff, 0x3f, 0xf6,
    0x0, 0x0, 0x0, 0x9f, 0xf3, 0xff, 0x60, 0x0,
    0x0, 0x9, 0xff, 0x3f, 0xf6, 0x0, 0x0, 0x0,
    0x9f, 0xf0,

    /* U+004E "N" */
    0x36, 0x0, 0x0, 0x0, 0x7f, 0xf1, 0x3f, 0x40,
    0x0, 0x0, 0x7f, 0xf1, 0x3f, 0xf3, 0x0, 0x0,
    0x7f, 0xf1, 0x3f, 0xfe, 0x10, 0x0, 0x7f, 0xf1,
    0x3f, 0xff, 0xd0, 0x0, 0x7f, 0xf1, 0x3f, 0xff,
    0xfb, 0x0, 0x7f, 0xf1, 0x3f, 0xfc, 0xff, 0x90,
    0x7f, 0xf1, 0x3f, 0xf5, 0xbf, 0xf7, 0x7f, 0xf1,
    0x3f, 0xf5, 0xc, 0xff, 0xaf, 0xf1, 0x3f, 0xf5,
    0x1, 0xdf, 0xff, 0xf1, 0x3f, 0xf5, 0x0, 0x2e,
    0xff, 0xf1, 0x3f, 0xf5, 0x0, 0x3, 0xff, 0xf1,
    0x3f, 0xf5, 0x0, 0x0, 0x5f, 0xf1, 0x3f, 0xf5,
    0x0, 0x0, 0x6, 0xf1, 0x3f, 0xf5, 0x0, 0x0,
    0x0, 0x81,

    /* U+004F "O" */
    0x0, 0x1, 0x8d, 0xfe, 0xc6, 0x0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0xfc, 0x10, 0x0, 0xdf, 0xf9,
    0x45, 0xbf, 0xfb, 0x0, 0x6f, 0xf8, 0x0, 0x0,
    0xbf, 0xf4, 0xc, 0xff, 0x10, 0x0, 0x3, 0xff,
    0x90, 0xff, 0xc0, 0x0, 0x0, 0xf, 0xfd, 0x1f,
    0xfa, 0x0, 0x0, 0x0, 0xdf, 0xe2, 0xff, 0xa0,
    0x0, 0x0, 0xd, 0xff, 0x1f, 0xfb, 0x0, 0x0,
    0x0, 0xdf, 0xe0, 0xff, 0xd0, 0x0, 0x0, 0xf,
    0xfd, 0xc, 0xff, 0x10, 0x0, 0x5, 0xff, 0x90,
    0x6f, 0xfa, 0x0, 0x0, 0xdf, 0xf3, 0x0, 0xdf,
    0xfb, 0x66, 0xdf, 0xfa, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x1, 0x7d, 0xfe, 0xc6,
    0x0, 0x0,

    /* U+0050 "P" */
    0x3f, 0xff, 0xff, 0xc7, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x3f, 0xf9, 0x35, 0xcf, 0xf8,
    0x3, 0xff, 0x70, 0x0, 0xff, 0xd0, 0x3f, 0xf7,
    0x0, 0xb, 0xff, 0x3, 0xff, 0x70, 0x0, 0xaf,
    0xf0, 0x3f, 0xf7, 0x0, 0xc, 0xff, 0x3, 0xff,
    0x70, 0x2, 0xff, 0xb0, 0x3f, 0xf9, 0x46, 0xef,
    0xf4, 0x3, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x3f,
    0xff, 0xfe, 0xb4, 0x0, 0x3, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x3,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x3f, 0xf7, 0x0,
    0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x1, 0x8d, 0xfe, 0xc6, 0x0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0xfc, 0x10, 0x0, 0xdf, 0xf9,
    0x45, 0xbf, 0xfb, 0x0, 0x6f, 0xf8, 0x0, 0x0,
    0xbf, 0xf4, 0xc, 0xff, 0x10, 0x0, 0x3, 0xff,
    0x90, 0xff, 0xc0, 0x0, 0x0, 0xf, 0xfd, 0x1f,
    0xfa, 0x0, 0x0, 0x0, 0xdf, 0xe2, 0xff, 0xa0,
    0x0, 0x0, 0xd, 0xff, 0x1f, 0xfb, 0x0, 0x0,
    0x0, 0xdf, 0xe0, 0xff, 0xd0, 0x0, 0x0, 0xf,
    0xfc, 0xc, 0xff, 0x10, 0x0, 0x5, 0xff, 0x80,
    0x6f, 0xfa, 0x0, 0x0, 0xdf, 0xf3, 0x0, 0xdf,
    0xfb, 0x66, 0xdf, 0xfb, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xfc, 0x10, 0x0, 0x1, 0x7d, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x21, 0x0, 0x0,

    /* U+0052 "R" */
    0x3f, 0xff, 0xff, 0xd8, 0x10, 0x3, 0xff, 0xff,
    0xff, 0xfe, 0x10, 0x3f, 0xf8, 0x24, 0xcf, 0xf9,
    0x3, 0xff, 0x70, 0x0, 0xef, 0xe0, 0x3f, 0xf7,
    0x0, 0xb, 0xff, 0x3, 0xff, 0x70, 0x0, 0xbf,
    0xf0, 0x3f, 0xf7, 0x0, 0xe, 0xfc, 0x3, 0xff,
    0x70, 0x9, 0xff, 0x60, 0x3f, 0xfd, 0xce, 0xff,
    0xb0, 0x3, 0xff, 0xff, 0xfe, 0x70, 0x0, 0x3f,
    0xf7, 0xef, 0xf3, 0x0, 0x3, 0xff, 0x73, 0xff,
    0xd0, 0x0, 0x3f, 0xf7, 0x8, 0xff, 0xa0, 0x3,
    0xff, 0x70, 0xd, 0xff, 0x50, 0x3f, 0xf7, 0x0,
    0x2f, 0xff, 0x20,

    /* U+0053 "S" */
    0x0, 0x19, 0xef, 0xea, 0x30, 0x0, 0xdf, 0xff,
    0xff, 0xf2, 0x7, 0xff, 0xb5, 0x7e, 0xb0, 0xa,
    0xff, 0x10, 0x1, 0x20, 0xa, 0xff, 0x20, 0x0,
    0x0, 0x6, 0xff, 0xd2, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0x70, 0x0, 0x0, 0xa, 0xff, 0xfd, 0x20,
    0x0, 0x0, 0x4d, 0xff, 0xe1, 0x0, 0x0, 0x0,
    0xaf, 0xf9, 0x0, 0x0, 0x0, 0xf, 0xfc, 0x2,
    0x60, 0x0, 0xf, 0xfc, 0xa, 0xfc, 0x76, 0xcf,
    0xf8, 0xc, 0xff, 0xff, 0xff, 0xe1, 0x0, 0x5b,
    0xef, 0xe9, 0x10,

    /* U+0054 "T" */
    0xaf, 0xff, 0xff, 0xff, 0xfd, 0xaf, 0xff, 0xff,
    0xff, 0xfd, 0x47, 0x79, 0xff, 0xb7, 0x75, 0x0,
    0x3, 0xff, 0x70, 0x0, 0x0, 0x3, 0xff, 0x70,
    0x0, 0x0, 0x3, 0xff, 0x70, 0x0, 0x0, 0x3,
    0xff, 0x70, 0x0, 0x0, 0x3, 0xff, 0x70, 0x0,
    0x0, 0x3, 0xff, 0x70, 0x0, 0x0, 0x3, 0xff,
    0x70, 0x0, 0x0, 0x3, 0xff, 0x70, 0x0, 0x0,
    0x3, 0xff, 0x70, 0x0, 0x0, 0x3, 0xff, 0x70,
    0x0, 0x0, 0x3, 0xff, 0x70, 0x0, 0x0, 0x3,
    0xff, 0x70, 0x0,

    /* U+0055 "U" */
    0x9f, 0xf1, 0x0, 0x1, 0xff, 0xa9, 0xff, 0x10,
    0x0, 0x1f, 0xfa, 0x9f, 0xf1, 0x0, 0x1, 0xff,
    0xa9, 0xff, 0x10, 0x0, 0x1f, 0xfa, 0x9f, 0xf1,
    0x0, 0x1, 0xff, 0xa9, 0xff, 0x10, 0x0, 0x1f,
    0xfa, 0x9f, 0xf1, 0x0, 0x1, 0xff, 0xa9, 0xff,
    0x10, 0x0, 0x1f, 0xfa, 0x9f, 0xf1, 0x0, 0x1,
    0xff, 0xa9, 0xff, 0x10, 0x0, 0x1f, 0xfa, 0x8f,
    0xf2, 0x0, 0x2, 0xff, 0x96, 0xff, 0x70, 0x0,
    0x6f, 0xf6, 0x1f, 0xff, 0x96, 0x9f, 0xff, 0x10,
    0x6f, 0xff, 0xff, 0xff, 0x70, 0x0, 0x3a, 0xef,
    0xeb, 0x40, 0x0,

    /* U+0056 "V" */
    0xf, 0xfd, 0x0, 0x0, 0x5, 0xff, 0x80, 0x9f,
    0xf3, 0x0, 0x0, 0xaf, 0xf2, 0x3, 0xff, 0x90,
    0x0, 0xf, 0xfc, 0x0, 0xd, 0xfe, 0x0, 0x5,
    0xff, 0x60, 0x0, 0x7f, 0xf4, 0x0, 0xaf, 0xf0,
    0x0, 0x1, 0xff, 0xa0, 0xf, 0xf9, 0x0, 0x0,
    0xa, 0xff, 0x5, 0xff, 0x30, 0x0, 0x0, 0x4f,
    0xf5, 0xaf, 0xd0, 0x0, 0x0, 0x0, 0xef, 0xaf,
    0xf7, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x92, 0x0,
    0x0, 0x0,

    /* U+0057 "W" */
    0x1f, 0xfd, 0x0, 0x0, 0xb, 0x0, 0x0, 0xf,
    0xfd, 0x0, 0xbf, 0xf2, 0x0, 0x3, 0xf3, 0x0,
    0x4, 0xff, 0x80, 0x6, 0xff, 0x60, 0x0, 0x9f,
    0x80, 0x0, 0x8f, 0xf3, 0x0, 0x1f, 0xfb, 0x0,
    0xe, 0xfe, 0x0, 0xd, 0xfe, 0x0, 0x0, 0xbf,
    0xf0, 0x4, 0xff, 0xf4, 0x1, 0xff, 0x90, 0x0,
    0x6, 0xff, 0x40, 0xaf, 0xff, 0x90, 0x5f, 0xf4,
    0x0, 0x0, 0x1f, 0xf9, 0xf, 0xfd, 0xff, 0xa,
    0xfe, 0x0, 0x0, 0x0, 0xcf, 0xe5, 0xff, 0x3f,
    0xf5, 0xef, 0x90, 0x0, 0x0, 0x6, 0xff, 0xdf,
    0x90, 0xcf, 0xdf, 0xf4, 0x0, 0x0, 0x0, 0x1f,
    0xff, 0xf3, 0x5, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xfc, 0x0, 0xe, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0x60, 0x0, 0x8f, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf0, 0x0, 0x2,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xca, 0x0,
    0x0, 0xc, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x30, 0x0, 0x0, 0x55, 0x0, 0x0, 0x0,

    /* U+0058 "X" */
    0x7f, 0xfa, 0x0, 0x0, 0xbf, 0xf5, 0xe, 0xff,
    0x10, 0x2, 0xff, 0xd0, 0x6, 0xff, 0x80, 0x9,
    0xff, 0x50, 0x0, 0xef, 0xf0, 0x1f, 0xfd, 0x0,
    0x0, 0x6f, 0xf7, 0x7f, 0xf4, 0x0, 0x0, 0xd,
    0xfe, 0xef, 0xc0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x1, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x40, 0x0, 0x0, 0x1f,
    0xfc, 0xff, 0xc0, 0x0, 0x0, 0x8f, 0xf4, 0x9f,
    0xf5, 0x0, 0x1, 0xff, 0xd0, 0x2f, 0xfd, 0x0,
    0x8, 0xff, 0x60, 0xa, 0xff, 0x60, 0x1f, 0xff,
    0x0, 0x3, 0xff, 0xe0, 0x8f, 0xf8, 0x0, 0x0,
    0xcf, 0xf7,

    /* U+0059 "Y" */
    0x1f, 0xfd, 0x0, 0x0, 0x8, 0xff, 0x50, 0x8f,
    0xf5, 0x0, 0x0, 0xff, 0xd0, 0x1, 0xff, 0xd0,
    0x0, 0x7f, 0xf5, 0x0, 0x8, 0xff, 0x40, 0xe,
    0xfd, 0x0, 0x0, 0xe, 0xfc, 0x5, 0xff, 0x50,
    0x0, 0x0, 0x7f, 0xf3, 0xdf, 0xd0, 0x0, 0x0,
    0x0, 0xef, 0xef, 0xf5, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x0,
    0x0, 0x0,

    /* U+005A "Z" */
    0xa, 0xff, 0xff, 0xff, 0xff, 0x30, 0xaf, 0xff,
    0xff, 0xff, 0xb0, 0x3, 0x55, 0x55, 0xcf, 0xf4,
    0x0, 0x0, 0x0, 0x1f, 0xfd, 0x0, 0x0, 0x0,
    0x8, 0xff, 0x50, 0x0, 0x0, 0x0, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x7f, 0xf7, 0x0, 0x0, 0x0,
    0xe, 0xff, 0x0, 0x0, 0x0, 0x6, 0xff, 0x80,
    0x0, 0x0, 0x0, 0xdf, 0xf1, 0x0, 0x0, 0x0,
    0x4f, 0xfa, 0x0, 0x0, 0x0, 0xc, 0xff, 0x30,
    0x0, 0x0, 0x3, 0xff, 0xd5, 0x55, 0x55, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xf2, 0x2f, 0xff, 0xff,
    0xff, 0xff, 0x20,

    /* U+005B "[" */
    0x79, 0x99, 0x91, 0xcf, 0xff, 0xf3, 0xcf, 0x80,
    0x0, 0xcf, 0x80, 0x0, 0xcf, 0x80, 0x0, 0xcf,
    0x80, 0x0, 0xcf, 0x80, 0x0, 0xcf, 0x80, 0x0,
    0xcf, 0x80, 0x0, 0xcf, 0x80, 0x0, 0xcf, 0x80,
    0x0, 0xcf, 0x80, 0x0, 0xcf, 0x80, 0x0, 0xcf,
    0x80, 0x0, 0xcf, 0x80, 0x0, 0xcf, 0x80, 0x0,
    0xcf, 0x80, 0x0, 0xcf, 0x80, 0x0, 0xcf, 0x80,
    0x0, 0xcf, 0xc9, 0x91, 0xcf, 0xff, 0xf3,

    /* U+005C "\\" */
    0x3f, 0xd0, 0x0, 0x0, 0x0, 0xff, 0x10, 0x0,
    0x0, 0xb, 0xf5, 0x0, 0x0, 0x0, 0x6f, 0xa0,
    0x0, 0x0, 0x2, 0xfe, 0x0, 0x0, 0x0, 0xe,
    0xf2, 0x0, 0x0, 0x0, 0x9f, 0x70, 0x0, 0x0,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xf0, 0x0,
    0x0, 0x0, 0xcf, 0x40, 0x0, 0x0, 0x8, 0xf8,
    0x0, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0, 0x0,
    0xff, 0x10, 0x0, 0x0, 0xb, 0xf5, 0x0, 0x0,
    0x0, 0x7f, 0xa0, 0x0, 0x0, 0x2, 0xfe, 0x0,
    0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0, 0x9f,
    0x70, 0x0, 0x0, 0x5, 0xfb, 0x0, 0x0, 0x0,
    0x1f, 0xf0, 0x0, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x0, 0x8, 0xf8, 0x0, 0x0, 0x0, 0x4f, 0xc0,

    /* U+005D "]" */
    0x9, 0x99, 0x98, 0x1f, 0xff, 0xfe, 0x0, 0x6,
    0xfe, 0x0, 0x6, 0xfe, 0x0, 0x6, 0xfe, 0x0,
    0x6, 0xfe, 0x0, 0x6, 0xfe, 0x0, 0x6, 0xfe,
    0x0, 0x6, 0xfe, 0x0, 0x6, 0xfe, 0x0, 0x6,
    0xfe, 0x0, 0x6, 0xfe, 0x0, 0x6, 0xfe, 0x0,
    0x6, 0xfe, 0x0, 0x6, 0xfe, 0x0, 0x6, 0xfe,
    0x0, 0x6, 0xfe, 0x0, 0x6, 0xfe, 0x0, 0x6,
    0xfe, 0x9, 0x9b, 0xfe, 0x1f, 0xff, 0xfe,

    /* U+005E "^" */
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x40, 0x0, 0x0, 0xb, 0xff, 0x90, 0x0, 0x0,
    0xf, 0xff, 0xe0, 0x0, 0x0, 0x5f, 0xce, 0xf3,
    0x0, 0x0, 0xaf, 0x7a, 0xf8, 0x0, 0x0, 0xff,
    0x35, 0xfd, 0x0, 0x5, 0xfe, 0x1, 0xff, 0x20,
    0xa, 0xfa, 0x0, 0xcf, 0x80, 0xe, 0xf5, 0x0,
    0x7f, 0xd0, 0x4f, 0xf0, 0x0, 0x3f, 0xf2, 0x9f,
    0xc0, 0x0, 0xe, 0xf7,

    /* U+005F "_" */
    0x2b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb9, 0x4f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+0060 "`" */
    0x25, 0x52, 0x0, 0x1f, 0xfa, 0x0, 0x7, 0xff,
    0x20, 0x0, 0xdf, 0x90, 0x0, 0x4f, 0xf1,

    /* U+0061 "a" */
    0x1, 0x7c, 0xff, 0xd8, 0x0, 0xa, 0xff, 0xff,
    0xff, 0x90, 0x4, 0xd7, 0x56, 0xef, 0xf0, 0x0,
    0x0, 0x0, 0x6f, 0xf2, 0x0, 0x3, 0x79, 0xcf,
    0xf2, 0x1, 0xcf, 0xff, 0xff, 0xf2, 0xd, 0xfe,
    0x40, 0x5f, 0xf2, 0x2f, 0xf7, 0x0, 0x7f, 0xf2,
    0x1f, 0xfb, 0x15, 0xff, 0xf2, 0xc, 0xff, 0xff,
    0xbf, 0xf2, 0x2, 0xcf, 0xe7, 0x2f, 0xf2,

    /* U+0062 "b" */
    0x5f, 0xf2, 0x0, 0x0, 0x0, 0x5f, 0xf2, 0x0,
    0x0, 0x0, 0x5f, 0xf2, 0x0, 0x0, 0x0, 0x5f,
    0xf2, 0x0, 0x0, 0x0, 0x5f, 0xf2, 0x0, 0x0,
    0x0, 0x5f, 0xf3, 0x9e, 0xfb, 0x20, 0x5f, 0xfc,
    0xff, 0xff, 0xe1, 0x5f, 0xff, 0x64, 0xcf, 0xf7,
    0x5f, 0xf9, 0x0, 0x2f, 0xfc, 0x5f, 0xf5, 0x0,
    0xe, 0xfe, 0x5f, 0xf3, 0x0, 0xd, 0xfe, 0x5f,
    0xf5, 0x0, 0xe, 0xfd, 0x5f, 0xf8, 0x0, 0x2f,
    0xfa, 0x5f, 0xfe, 0x53, 0xcf, 0xf5, 0x5f, 0xfa,
    0xff, 0xff, 0xc0, 0x5f, 0xf0, 0xaf, 0xe9, 0x0,

    /* U+0063 "c" */
    0x0, 0x6, 0xcf, 0xec, 0x40, 0xa, 0xff, 0xff,
    0xfa, 0x5, 0xff, 0xc5, 0x5b, 0x40, 0xcf, 0xf1,
    0x0, 0x0, 0xf, 0xfc, 0x0, 0x0, 0x1, 0xff,
    0xb0, 0x0, 0x0, 0xf, 0xfc, 0x0, 0x0, 0x0,
    0xdf, 0xf0, 0x0, 0x0, 0x7, 0xff, 0xb4, 0x4a,
    0x60, 0xc, 0xff, 0xff, 0xfc, 0x0, 0x8, 0xdf,
    0xea, 0x20,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0x5, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x5f, 0xf2, 0x0, 0x0, 0x0, 0x5, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x5f, 0xf2, 0x0, 0x0,
    0x0, 0x5, 0xff, 0x20, 0x2, 0xbf, 0xfa, 0x5f,
    0xf2, 0x1, 0xef, 0xff, 0xfd, 0xff, 0x20, 0x9f,
    0xfb, 0x37, 0xff, 0xf2, 0xe, 0xfe, 0x0, 0xb,
    0xff, 0x20, 0xff, 0xb0, 0x0, 0x7f, 0xf2, 0x1f,
    0xfa, 0x0, 0x6, 0xff, 0x20, 0xff, 0xb0, 0x0,
    0x7f, 0xf2, 0xd, 0xfe, 0x0, 0xb, 0xff, 0x20,
    0x8f, 0xfa, 0x26, 0xff, 0xf2, 0x0, 0xdf, 0xff,
    0xf9, 0xff, 0x20, 0x1, 0xae, 0xe8, 0x2f, 0xf2,

    /* U+0065 "e" */
    0x0, 0x6, 0xdf, 0xfb, 0x30, 0x0, 0xaf, 0xff,
    0xff, 0xf2, 0x5, 0xff, 0x81, 0x4f, 0xf9, 0xc,
    0xfc, 0x0, 0xc, 0xfd, 0xf, 0xfe, 0xbb, 0xbe,
    0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf, 0xfb,
    0x0, 0x0, 0x0, 0xd, 0xfe, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xb2, 0x15, 0xd0, 0x0, 0xcf, 0xff,
    0xff, 0xf6, 0x0, 0x7, 0xdf, 0xfd, 0x81,

    /* U+0066 "f" */
    0x0, 0x19, 0xef, 0xd4, 0x0, 0xcf, 0xff, 0xf6,
    0x3, 0xff, 0xb4, 0x53, 0x4, 0xff, 0x40, 0x0,
    0x4, 0xff, 0x30, 0x0, 0xbf, 0xff, 0xff, 0xc0,
    0xbf, 0xff, 0xff, 0xc0, 0x27, 0xff, 0x74, 0x30,
    0x4, 0xff, 0x30, 0x0, 0x4, 0xff, 0x30, 0x0,
    0x4, 0xff, 0x30, 0x0, 0x4, 0xff, 0x30, 0x0,
    0x4, 0xff, 0x30, 0x0, 0x4, 0xff, 0x30, 0x0,
    0x4, 0xff, 0x30, 0x0, 0x4, 0xff, 0x30, 0x0,

    /* U+0067 "g" */
    0x0, 0x1a, 0xef, 0xa1, 0xef, 0x30, 0x1e, 0xff,
    0xff, 0xaf, 0xf3, 0x8, 0xff, 0xb3, 0x7f, 0xff,
    0x30, 0xdf, 0xe0, 0x0, 0xbf, 0xf3, 0xf, 0xfb,
    0x0, 0x7, 0xff, 0x31, 0xff, 0xa0, 0x0, 0x6f,
    0xf3, 0xf, 0xfb, 0x0, 0x7, 0xff, 0x30, 0xef,
    0xe0, 0x0, 0xbf, 0xf3, 0x9, 0xff, 0xa2, 0x6f,
    0xff, 0x30, 0x1e, 0xff, 0xff, 0xaf, 0xf3, 0x0,
    0x2a, 0xef, 0x92, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x4f, 0xf2, 0x0, 0x0, 0x0, 0x9, 0xff, 0x0,
    0x4, 0xc7, 0x6a, 0xff, 0x90, 0x0, 0xdf, 0xff,
    0xff, 0xe1, 0x0, 0x6, 0xbe, 0xfe, 0x91, 0x0,

    /* U+0068 "h" */
    0x5f, 0xf1, 0x0, 0x0, 0x0, 0x5f, 0xf1, 0x0,
    0x0, 0x0, 0x5f, 0xf1, 0x0, 0x0, 0x0, 0x5f,
    0xf1, 0x0, 0x0, 0x0, 0x5f, 0xf1, 0x0, 0x0,
    0x0, 0x5f, 0xf2, 0x9e, 0xfb, 0x20, 0x5f, 0xfd,
    0xff, 0xff, 0xc0, 0x5f, 0xfe, 0x54, 0xef, 0xf3,
    0x5f, 0xf5, 0x0, 0x6f, 0xf5, 0x5f, 0xf3, 0x0,
    0x5f, 0xf6, 0x5f, 0xf3, 0x0, 0x5f, 0xf6, 0x5f,
    0xf3, 0x0, 0x5f, 0xf6, 0x5f, 0xf3, 0x0, 0x5f,
    0xf6, 0x5f, 0xf3, 0x0, 0x5f, 0xf6, 0x5f, 0xf3,
    0x0, 0x5f, 0xf6, 0x5f, 0xf3, 0x0, 0x5f, 0xf6,

    /* U+0069 "i" */
    0x8f, 0xf6, 0x8f, 0xf6, 0x7d, 0xd5, 0x0, 0x0,
    0x6f, 0xf5, 0x6f, 0xf5, 0x6f, 0xf5, 0x6f, 0xf5,
    0x6f, 0xf5, 0x6f, 0xf5, 0x6f, 0xf5, 0x6f, 0xf5,
    0x6f, 0xf5, 0x6f, 0xf5, 0x6f, 0xf5,

    /* U+006A "j" */
    0x8, 0xff, 0x60, 0x8f, 0xf6, 0x7, 0xdd, 0x50,
    0x0, 0x0, 0x6, 0xff, 0x30, 0x6f, 0xf3, 0x6,
    0xff, 0x30, 0x6f, 0xf3, 0x6, 0xff, 0x30, 0x6f,
    0xf3, 0x6, 0xff, 0x30, 0x6f, 0xf3, 0x6, 0xff,
    0x30, 0x6f, 0xf3, 0x6, 0xff, 0x30, 0x6f, 0xf3,
    0x7, 0xff, 0x20, 0xbf, 0xf0, 0x8f, 0xfb, 0x5,
    0xfb, 0x10, 0x0, 0x0, 0x0,

    /* U+006B "k" */
    0x5f, 0xf1, 0x0, 0x0, 0x0, 0x5f, 0xf1, 0x0,
    0x0, 0x0, 0x5f, 0xf1, 0x0, 0x0, 0x0, 0x5f,
    0xf1, 0x0, 0x0, 0x0, 0x5f, 0xf1, 0x0, 0x0,
    0x0, 0x5f, 0xf1, 0x1, 0xff, 0xd0, 0x5f, 0xf1,
    0xb, 0xff, 0x20, 0x5f, 0xf1, 0x5f, 0xf6, 0x0,
    0x5f, 0xf2, 0xef, 0xb0, 0x0, 0x5f, 0xfa, 0xfe,
    0x10, 0x0, 0x5f, 0xff, 0xfd, 0x0, 0x0, 0x5f,
    0xf7, 0xff, 0x80, 0x0, 0x5f, 0xf1, 0xcf, 0xf3,
    0x0, 0x5f, 0xf1, 0x3f, 0xfd, 0x0, 0x5f, 0xf1,
    0x8, 0xff, 0x90, 0x5f, 0xf1, 0x0, 0xdf, 0xf3,

    /* U+006C "l" */
    0x6f, 0xf2, 0x6f, 0xf2, 0x6f, 0xf2, 0x6f, 0xf2,
    0x6f, 0xf2, 0x6f, 0xf2, 0x6f, 0xf2, 0x6f, 0xf2,
    0x6f, 0xf2, 0x6f, 0xf2, 0x6f, 0xf2, 0x6f, 0xf2,
    0x6f, 0xf2, 0x6f, 0xf2, 0x6f, 0xf2, 0x6f, 0xf2,

    /* U+006D "m" */
    0x7f, 0xf1, 0xae, 0xfb, 0x11, 0x9e, 0xfb, 0x10,
    0x7f, 0xfd, 0xff, 0xff, 0xcc, 0xff, 0xff, 0xc0,
    0x7f, 0xfe, 0x54, 0xef, 0xff, 0x63, 0xdf, 0xf2,
    0x7f, 0xf6, 0x0, 0x8f, 0xf7, 0x0, 0x6f, 0xf4,
    0x7f, 0xf3, 0x0, 0x6f, 0xf4, 0x0, 0x5f, 0xf5,
    0x7f, 0xf3, 0x0, 0x6f, 0xf4, 0x0, 0x5f, 0xf5,
    0x7f, 0xf3, 0x0, 0x6f, 0xf4, 0x0, 0x5f, 0xf5,
    0x7f, 0xf3, 0x0, 0x6f, 0xf4, 0x0, 0x5f, 0xf5,
    0x7f, 0xf3, 0x0, 0x6f, 0xf4, 0x0, 0x5f, 0xf5,
    0x7f, 0xf3, 0x0, 0x6f, 0xf4, 0x0, 0x5f, 0xf5,
    0x7f, 0xf3, 0x0, 0x6f, 0xf4, 0x0, 0x5f, 0xf5,

    /* U+006E "n" */
    0x7f, 0xf1, 0xae, 0xfb, 0x10, 0x7f, 0xfd, 0xff,
    0xff, 0xb0, 0x7f, 0xfe, 0x43, 0xef, 0xf1, 0x7f,
    0xf6, 0x0, 0x8f, 0xf3, 0x7f, 0xf3, 0x0, 0x6f,
    0xf4, 0x7f, 0xf3, 0x0, 0x6f, 0xf4, 0x7f, 0xf3,
    0x0, 0x6f, 0xf4, 0x7f, 0xf3, 0x0, 0x6f, 0xf4,
    0x7f, 0xf3, 0x0, 0x6f, 0xf4, 0x7f, 0xf3, 0x0,
    0x6f, 0xf4, 0x7f, 0xf3, 0x0, 0x6f, 0xf4,

    /* U+006F "o" */
    0x0, 0x7, 0xdf, 0xeb, 0x30, 0x0, 0xc, 0xff,
    0xff, 0xff, 0x40, 0x7, 0xff, 0xa3, 0x5f, 0xfe,
    0x0, 0xdf, 0xf0, 0x0, 0x9f, 0xf4, 0xf, 0xfc,
    0x0, 0x5, 0xff, 0x71, 0xff, 0xb0, 0x0, 0x4f,
    0xf8, 0xf, 0xfc, 0x0, 0x5, 0xff, 0x70, 0xdf,
    0xf0, 0x0, 0x9f, 0xf4, 0x7, 0xff, 0xa3, 0x6f,
    0xfd, 0x0, 0xc, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x8, 0xdf, 0xea, 0x20, 0x0,

    /* U+0070 "p" */
    0x6f, 0xf2, 0xaf, 0xfa, 0x20, 0x6f, 0xfd, 0xff,
    0xff, 0xd0, 0x6f, 0xff, 0x64, 0xdf, 0xf7, 0x6f,
    0xf8, 0x0, 0x3f, 0xfb, 0x6f, 0xf4, 0x0, 0xf,
    0xfd, 0x6f, 0xf2, 0x0, 0xe, 0xfe, 0x6f, 0xf4,
    0x0, 0xf, 0xfd, 0x6f, 0xf7, 0x0, 0x3f, 0xfa,
    0x6f, 0xfe, 0x43, 0xdf, 0xf4, 0x6f, 0xfb, 0xff,
    0xff, 0xb0, 0x6f, 0xf3, 0xaf, 0xe8, 0x0, 0x6f,
    0xf2, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0,
    0x0, 0x6f, 0xf2, 0x0, 0x0, 0x0, 0x6f, 0xf2,
    0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x2a, 0xef, 0xa3, 0xff, 0x30, 0x1e, 0xff,
    0xff, 0xcf, 0xf3, 0x9, 0xff, 0xb3, 0x7f, 0xff,
    0x30, 0xef, 0xf0, 0x0, 0xbf, 0xf3, 0xf, 0xfb,
    0x0, 0x7, 0xff, 0x31, 0xff, 0xa0, 0x0, 0x6f,
    0xf3, 0xf, 0xfb, 0x0, 0x7, 0xff, 0x30, 0xdf,
    0xf0, 0x0, 0xbf, 0xf3, 0x8, 0xff, 0xa2, 0x6f,
    0xff, 0x30, 0xd, 0xff, 0xff, 0xaf, 0xf3, 0x0,
    0x1a, 0xee, 0x85, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x5f, 0xf3, 0x0, 0x0, 0x0, 0x5, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x5f, 0xf3, 0x0, 0x0, 0x0,
    0x5, 0xff, 0x30, 0x0, 0x0, 0x0, 0x5f, 0xf3,

    /* U+0072 "r" */
    0x8f, 0xd1, 0xae, 0xe0, 0x8f, 0xec, 0xff, 0xb0,
    0x8f, 0xff, 0xb9, 0x60, 0x8f, 0xf7, 0x0, 0x0,
    0x8f, 0xf1, 0x0, 0x0, 0x8f, 0xf1, 0x0, 0x0,
    0x8f, 0xf1, 0x0, 0x0, 0x8f, 0xf1, 0x0, 0x0,
    0x8f, 0xf1, 0x0, 0x0, 0x8f, 0xf1, 0x0, 0x0,
    0x8f, 0xf1, 0x0, 0x0,

    /* U+0073 "s" */
    0x0, 0x6d, 0xfe, 0xc5, 0x0, 0x8f, 0xff, 0xff,
    0xe0, 0xe, 0xfc, 0x22, 0x78, 0x0, 0xff, 0xd1,
    0x0, 0x0, 0xa, 0xff, 0xe8, 0x10, 0x0, 0xa,
    0xff, 0xff, 0x40, 0x0, 0x3, 0xaf, 0xff, 0x20,
    0x0, 0x0, 0x6f, 0xf5, 0xa, 0xa4, 0x28, 0xff,
    0x40, 0xff, 0xff, 0xff, 0xd0, 0x4, 0xce, 0xfe,
    0x91, 0x0,

    /* U+0074 "t" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x5d, 0x80, 0x0,
    0x0, 0xdf, 0x80, 0x0, 0x0, 0xef, 0x80, 0x0,
    0x6f, 0xff, 0xff, 0xf1, 0x6f, 0xff, 0xff, 0xf1,
    0x14, 0xff, 0xa4, 0x40, 0x0, 0xff, 0x80, 0x0,
    0x0, 0xff, 0x80, 0x0, 0x0, 0xff, 0x80, 0x0,
    0x0, 0xff, 0x80, 0x0, 0x0, 0xff, 0x80, 0x0,
    0x0, 0xef, 0xd4, 0x85, 0x0, 0xaf, 0xff, 0xf9,
    0x0, 0x1b, 0xff, 0xb4,

    /* U+0075 "u" */
    0x8f, 0xf1, 0x0, 0xcf, 0xd8, 0xff, 0x10, 0xc,
    0xfd, 0x8f, 0xf1, 0x0, 0xcf, 0xd8, 0xff, 0x10,
    0xc, 0xfd, 0x8f, 0xf1, 0x0, 0xcf, 0xd8, 0xff,
    0x10, 0xc, 0xfd, 0x8f, 0xf1, 0x0, 0xcf, 0xd7,
    0xff, 0x20, 0xe, 0xfd, 0x5f, 0xfa, 0x39, 0xff,
    0xd0, 0xff, 0xff, 0xfd, 0xfd, 0x4, 0xdf, 0xd5,
    0x8f, 0xd0,

    /* U+0076 "v" */
    0xe, 0xff, 0x0, 0x0, 0xef, 0xd0, 0x8, 0xff,
    0x40, 0x3, 0xff, 0x70, 0x2, 0xff, 0xa0, 0x8,
    0xff, 0x10, 0x0, 0xcf, 0xf0, 0xd, 0xfb, 0x0,
    0x0, 0x6f, 0xf4, 0x2f, 0xf5, 0x0, 0x0, 0xf,
    0xf9, 0x7f, 0xf0, 0x0, 0x0, 0xa, 0xfd, 0xbf,
    0xa0, 0x0, 0x0, 0x3, 0xff, 0xff, 0x40, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf2,
    0x0, 0x0,

    /* U+0077 "w" */
    0xbf, 0xe0, 0x0, 0xbf, 0xb0, 0x0, 0xcf, 0xb6,
    0xff, 0x20, 0xf, 0xff, 0x0, 0xf, 0xf7, 0x1f,
    0xf6, 0x3, 0xff, 0xf4, 0x4, 0xff, 0x20, 0xdf,
    0xa0, 0x7f, 0xef, 0x90, 0x8f, 0xd0, 0x8, 0xfd,
    0xc, 0xf8, 0xfd, 0xb, 0xf8, 0x0, 0x3f, 0xf2,
    0xff, 0x1f, 0xf2, 0xff, 0x30, 0x0, 0xef, 0x8f,
    0xb0, 0xcf, 0x8f, 0xe0, 0x0, 0x9, 0xfe, 0xf7,
    0x8, 0xfe, 0xfa, 0x0, 0x0, 0x4f, 0xff, 0x30,
    0x3f, 0xff, 0x50, 0x0, 0x0, 0xff, 0xf0, 0x0,
    0xef, 0xf0, 0x0, 0x0, 0xa, 0xfb, 0x0, 0xa,
    0xfb, 0x0, 0x0,

    /* U+0078 "x" */
    0x7f, 0xf7, 0x0, 0x6f, 0xf5, 0xe, 0xfe, 0x0,
    0xdf, 0xd0, 0x7, 0xff, 0x55, 0xff, 0x50, 0x0,
    0xef, 0xcb, 0xfc, 0x0, 0x0, 0x6f, 0xff, 0xf4,
    0x0, 0x0, 0xf, 0xff, 0xd0, 0x0, 0x0, 0x5f,
    0xff, 0xf5, 0x0, 0x0, 0xdf, 0xbe, 0xfd, 0x0,
    0x6, 0xff, 0x47, 0xff, 0x60, 0xe, 0xfd, 0x0,
    0xef, 0xe0, 0x7f, 0xf6, 0x0, 0x7f, 0xf7,

    /* U+0079 "y" */
    0xe, 0xfe, 0x0, 0x0, 0xef, 0xd0, 0x8, 0xff,
    0x40, 0x3, 0xff, 0x70, 0x2, 0xff, 0x90, 0x8,
    0xff, 0x10, 0x0, 0xcf, 0xe0, 0xe, 0xfc, 0x0,
    0x0, 0x5f, 0xf3, 0x3f, 0xf6, 0x0, 0x0, 0xe,
    0xf8, 0x8f, 0xf1, 0x0, 0x0, 0x9, 0xfc, 0xcf,
    0xa0, 0x0, 0x0, 0x3, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0xcf, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xe0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x80, 0x0, 0x0, 0x0, 0x7,
    0xff, 0x20, 0x0, 0x0, 0x0, 0xa, 0xdb, 0x0,
    0x0, 0x0,

    /* U+007A "z" */
    0xd, 0xff, 0xff, 0xff, 0xc0, 0xd, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x0, 0x4f, 0xfb, 0x0, 0x0,
    0x0, 0xcf, 0xf3, 0x0, 0x0, 0x4, 0xff, 0xb0,
    0x0, 0x0, 0xc, 0xff, 0x20, 0x0, 0x0, 0x5f,
    0xfa, 0x0, 0x0, 0x0, 0xdf, 0xf2, 0x0, 0x0,
    0x6, 0xff, 0x90, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0x90, 0x7f, 0xff, 0xff, 0xff, 0xa0,

    /* U+007B "{" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xaf, 0xf6,
    0x0, 0xd, 0xfb, 0x42, 0x0, 0x6f, 0xf0, 0x0,
    0x0, 0x8f, 0xd0, 0x0, 0x0, 0x9f, 0xc0, 0x0,
    0x0, 0x9f, 0xc0, 0x0, 0x0, 0x9f, 0xc0, 0x0,
    0x0, 0x9f, 0xa0, 0x0, 0x2, 0xef, 0x60, 0x0,
    0x8f, 0xf8, 0x0, 0x0, 0x5c, 0xfc, 0x10, 0x0,
    0x0, 0xcf, 0x80, 0x0, 0x0, 0x9f, 0xb0, 0x0,
    0x0, 0x9f, 0xc0, 0x0, 0x0, 0x9f, 0xc0, 0x0,
    0x0, 0x9f, 0xc0, 0x0, 0x0, 0x8f, 0xd0, 0x0,
    0x0, 0x6f, 0xf0, 0x0, 0x0, 0xe, 0xf9, 0x21,
    0x0, 0x2, 0xcf, 0xf6, 0x0, 0x0, 0x2, 0x31,

    /* U+007C "|" */
    0x57, 0x3b, 0xf6, 0xbf, 0x6b, 0xf6, 0xbf, 0x6b,
    0xf6, 0xbf, 0x6b, 0xf6, 0xbf, 0x6b, 0xf6, 0xbf,
    0x6b, 0xf6, 0xbf, 0x6b, 0xf6, 0xbf, 0x6b, 0xf6,
    0xbf, 0x6b, 0xf6, 0xbf, 0x6b, 0xf6, 0xbf, 0x6b,
    0xf6,

    /* U+007D "}" */
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xfa, 0x20, 0x0,
    0x14, 0xaf, 0xe1, 0x0, 0x0, 0xe, 0xf7, 0x0,
    0x0, 0xb, 0xfa, 0x0, 0x0, 0xb, 0xfb, 0x0,
    0x0, 0xb, 0xfb, 0x0, 0x0, 0xa, 0xfb, 0x0,
    0x0, 0x9, 0xfb, 0x0, 0x0, 0x4, 0xff, 0x30,
    0x0, 0x0, 0x7f, 0xf9, 0x0, 0x0, 0xbf, 0xd6,
    0x0, 0x6, 0xfe, 0x0, 0x0, 0xa, 0xfb, 0x0,
    0x0, 0xb, 0xfb, 0x0, 0x0, 0xb, 0xfb, 0x0,
    0x0, 0xb, 0xfb, 0x0, 0x0, 0xb, 0xfa, 0x0,
    0x0, 0xe, 0xf7, 0x0, 0x2, 0x7f, 0xf1, 0x0,
    0x4f, 0xfd, 0x30, 0x0, 0x3, 0x20, 0x0, 0x0,

    /* U+007E "~" */
    0x0, 0x2, 0x20, 0x0, 0x0, 0x0, 0x2, 0xcf,
    0xfc, 0x20, 0x2, 0xb1, 0xd, 0xff, 0xff, 0xf7,
    0x4d, 0xf6, 0x5f, 0xc1, 0x3c, 0xff, 0xff, 0xc0,
    0x7, 0x20, 0x0, 0x8e, 0xf9, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x38, 0xdf, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x15, 0xae, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x7c, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x49,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xdf, 0xf0, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xb6, 0x10, 0x9f, 0xf0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xd9, 0x40, 0x0,
    0x0, 0x9f, 0xf0, 0x0, 0x0, 0xb, 0xff, 0x72,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xf0, 0x0, 0x0,
    0xb, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xf0, 0x0, 0x0, 0xb, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xf0, 0x0, 0x0, 0xb, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xf0, 0x0,
    0x0, 0xb, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xf0, 0x0, 0x0, 0xb, 0xfe, 0x0, 0x0,
    0x0, 0x5c, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xb,
    0xfe, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x25, 0x5c, 0xfe, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xf0, 0x2c, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xc0, 0xcf, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xfa,
    0x10, 0xef, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x22, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xac, 0xc9, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F008 "" */
    0x83, 0x0, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xc0, 0x3, 0x8f, 0xa7, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x87, 0xaf, 0xff, 0xee, 0xff,
    0x33, 0x33, 0x33, 0x33, 0x3f, 0xfe, 0xef, 0xff,
    0x50, 0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x5f, 0xf5, 0x1, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x5, 0xff, 0xb8, 0x9f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x98, 0xbf, 0xfe,
    0xdd, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xe, 0xfd,
    0xde, 0xff, 0x50, 0x1f, 0xfe, 0xdd, 0xdd, 0xdd,
    0xde, 0xff, 0x10, 0x5f, 0xf5, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x5, 0xff, 0xc9,
    0xaf, 0xf2, 0x11, 0x11, 0x11, 0x12, 0xff, 0xa9,
    0xcf, 0xfe, 0xcd, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xfd, 0xce, 0xff, 0x50, 0x1f, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0x10, 0x5f, 0xf5, 0x1,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x5,
    0xff, 0xca, 0xbf, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xba, 0xcf, 0xfd, 0xbc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xbd, 0xfc, 0x50, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x5c,

    /* U+F00B "" */
    0x1, 0x11, 0x10, 0x0, 0x1, 0x11, 0x11, 0x11,
    0x11, 0x11, 0xd, 0xff, 0xff, 0xe0, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0x19, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x19, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xf0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x13,
    0x33, 0x31, 0x0, 0x23, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x12, 0x44, 0x44, 0x20, 0x4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x42, 0xef, 0xff, 0xff, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff,
    0xff, 0xf1, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x19, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff,
    0xfc, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xfc, 0x5, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff,
    0xf1, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x19, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff,
    0x18, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2,
    0x44, 0x44, 0x20, 0x4, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x42,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xfc, 0x0, 0x6, 0x10, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xfb, 0x0, 0xc,
    0xfd, 0x10, 0x0, 0x0, 0x3, 0xff, 0xff, 0xfb,
    0x0, 0xc, 0xff, 0xfd, 0x10, 0x0, 0x3, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0xdf, 0xff, 0xfd, 0x10,
    0x3, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x2, 0xef,
    0xff, 0xfd, 0x13, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xff, 0xfd, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xda, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xdf, 0x50, 0x0, 0x0, 0x1, 0xcf, 0x60, 0xcf,
    0xff, 0x50, 0x0, 0x1, 0xdf, 0xff, 0x3e, 0xff,
    0xff, 0x50, 0x1, 0xdf, 0xff, 0xf5, 0x3e, 0xff,
    0xff, 0x51, 0xdf, 0xff, 0xf9, 0x0, 0x3f, 0xff,
    0xff, 0xdf, 0xff, 0xf9, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff,
    0xff, 0x50, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x1, 0xdf, 0xff, 0xf9, 0x3f, 0xff,
    0xff, 0x50, 0xcf, 0xff, 0xf9, 0x0, 0x3f, 0xff,
    0xff, 0x3e, 0xff, 0xf9, 0x0, 0x0, 0x3f, 0xff,
    0xf5, 0x3f, 0xf9, 0x0, 0x0, 0x0, 0x3e, 0xfa,
    0x0, 0x24, 0x0, 0x0, 0x0, 0x0, 0x14, 0x0,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x22,
    0x0, 0x3f, 0xff, 0x0, 0x3, 0x10, 0x0, 0x0,
    0x0, 0x5f, 0xf2, 0x3, 0xff, 0xf0, 0x4, 0xfe,
    0x20, 0x0, 0x0, 0x4f, 0xff, 0x90, 0x3f, 0xff,
    0x0, 0xcf, 0xfe, 0x20, 0x0, 0x1f, 0xff, 0xf5,
    0x3, 0xff, 0xf0, 0x8, 0xff, 0xfc, 0x0, 0xa,
    0xff, 0xf5, 0x0, 0x3f, 0xff, 0x0, 0x8, 0xff,
    0xf6, 0x1, 0xff, 0xf9, 0x0, 0x3, 0xff, 0xf0,
    0x0, 0xc, 0xff, 0xe0, 0x6f, 0xff, 0x10, 0x0,
    0x3f, 0xff, 0x0, 0x0, 0x4f, 0xff, 0x39, 0xff,
    0xb0, 0x0, 0x3, 0xff, 0xf0, 0x0, 0x0, 0xef,
    0xf6, 0xbf, 0xf9, 0x0, 0x0, 0x3f, 0xff, 0x0,
    0x0, 0xc, 0xff, 0x8b, 0xff, 0x80, 0x0, 0x3,
    0xff, 0xf0, 0x0, 0x0, 0xbf, 0xf8, 0xaf, 0xfa,
    0x0, 0x0, 0x9, 0xa7, 0x0, 0x0, 0xd, 0xff,
    0x77, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xf4, 0x2f, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0x0, 0xcf, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x90,
    0x3, 0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xf1, 0x0, 0x6, 0xff, 0xff, 0xa4, 0x10,
    0x15, 0xbf, 0xff, 0xf4, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x8d, 0xff, 0xff,
    0xfc, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x34, 0x31, 0x0, 0x0, 0x0, 0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xef,
    0xec, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x3d, 0x51, 0xaf, 0xff, 0xff,
    0xff, 0xa1, 0x6d, 0x30, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0xef, 0xff, 0xff, 0xff, 0xfe, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x1e, 0xff, 0xff, 0xff,
    0x90, 0x0, 0x9f, 0xff, 0xff, 0xfe, 0x10, 0x9,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0xbf, 0xff, 0xf9,
    0x0, 0x0, 0x5f, 0xff, 0xf5, 0x0, 0x0, 0x5,
    0xff, 0xff, 0x50, 0x0, 0x5, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x4f, 0xff, 0xf5, 0x0, 0x0, 0x6f,
    0xff, 0xf9, 0x0, 0x0, 0x9, 0xff, 0xff, 0x60,
    0x0, 0xbf, 0xff, 0xff, 0xf5, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xb1, 0x1f, 0xff, 0xff, 0xff, 0xfc,
    0xac, 0xff, 0xff, 0xff, 0xff, 0x10, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0x5, 0xfa, 0x4d, 0xff, 0xff,
    0xff, 0xfd, 0x49, 0xf5, 0x0, 0x0, 0x1, 0x0,
    0x6, 0xff, 0xff, 0xf6, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x24, 0x31, 0x0, 0x0, 0x0, 0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xe4, 0x0, 0x3f, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1b, 0xff, 0xff, 0x60,
    0x4f, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xdf, 0xff, 0xff, 0xf9, 0x4f, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xc1, 0x5f, 0xff,
    0xef, 0xff, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xfa, 0x3, 0x12, 0xef, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0x70, 0x7f, 0xe3, 0x1c,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xf4,
    0xa, 0xff, 0xff, 0x50, 0x9f, 0xff, 0x70, 0x0,
    0x3, 0xef, 0xfd, 0x21, 0xcf, 0xff, 0xff, 0xf8,
    0x7, 0xff, 0xfa, 0x0, 0x5f, 0xff, 0xc1, 0x3e,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0x4e, 0xff, 0xd2,
    0xdf, 0xf9, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x22, 0xdf, 0xf7, 0x3f, 0x60, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x1b, 0xc0,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xff, 0xfe, 0x11, 0x15, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xfd, 0x0, 0x3, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xff, 0xfd, 0x0, 0x3, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xfd, 0x0, 0x3, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xfd, 0x0, 0x3, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x35, 0x55,
    0x52, 0x0, 0x0, 0x45, 0x55, 0x51, 0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x0, 0x46, 0x66, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x2, 0x88, 0x89,
    0xff, 0xff, 0xf9, 0x88, 0x82, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0x60, 0xbf, 0xb0, 0x6f, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x50, 0x5f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x72,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x3f,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb9, 0xf7, 0xdf, 0xf9, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9,

    /* U+F01C "" */
    0x0, 0x0, 0x6, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0x30, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xd, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0x80, 0x0,
    0x0, 0x8f, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xef, 0xf3, 0x0, 0x3, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xfd, 0x0,
    0xd, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0x80, 0x8f, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0xf3,
    0xff, 0xfe, 0xee, 0xee, 0x50, 0x0, 0x0, 0xb,
    0xee, 0xee, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x44, 0x44, 0xcf,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x4e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x46, 0x50, 0x0, 0x0, 0x3, 0x9d, 0xff,
    0xfc, 0x71, 0x0, 0xe, 0xff, 0x0, 0x0, 0x1b,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x10, 0xdf, 0xf0,
    0x0, 0x3e, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xfe,
    0x3c, 0xff, 0x0, 0x3f, 0xff, 0xfa, 0x30, 0x0,
    0x4b, 0xff, 0xff, 0xef, 0xf0, 0x1e, 0xff, 0xe3,
    0x0, 0x0, 0x0, 0x4, 0xef, 0xff, 0xff, 0x8,
    0xff, 0xe2, 0x0, 0x0, 0x0, 0x10, 0x2, 0xef,
    0xff, 0xf0, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0x4f, 0xfc, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xdd,
    0x50, 0x0, 0x0, 0x0, 0x1c, 0xdd, 0xdd, 0xdd,
    0xdb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbc, 0xcc,
    0xcc, 0xcc, 0xc1, 0x0, 0x0, 0x0, 0x5, 0xcc,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0xcf, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xf, 0xff, 0xfe,
    0x10, 0x11, 0x0, 0x0, 0x0, 0x1e, 0xff, 0x80,
    0xff, 0xff, 0xfd, 0x30, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xe1, 0xf, 0xfe, 0xff, 0xff, 0x93, 0x0,
    0x2, 0x9f, 0xff, 0xf4, 0x0, 0xff, 0xc4, 0xff,
    0xff, 0xff, 0xde, 0xff, 0xff, 0xf4, 0x0, 0xf,
    0xfd, 0x1, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xc2,
    0x0, 0x0, 0xff, 0xe0, 0x0, 0x39, 0xef, 0xff,
    0xea, 0x40, 0x0, 0x0, 0x5, 0x64, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x0, 0x3b, 0x20, 0x0, 0x0,
    0x0, 0x3f, 0xf7, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x80, 0x0, 0x0, 0x3f, 0xff, 0xf8, 0x9d, 0xdd,
    0xdf, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x8d, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x6, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x6, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x80, 0x0, 0x0, 0x0, 0x6, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x0, 0x3b, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x9d, 0xdd, 0xdf, 0xff, 0xff, 0x80, 0x1, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6f, 0x70,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x4f, 0xf4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x7, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x4, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x1d, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x8f, 0xc0,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x6, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6e, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfc, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3b, 0x20, 0x0, 0x0,
    0x3, 0xef, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0x70, 0x0, 0x5, 0x10, 0x1d, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0x80, 0x0, 0x3f,
    0xe4, 0x3, 0xff, 0x30, 0x0, 0x0, 0x3, 0xff,
    0xff, 0x80, 0x0, 0xa, 0xff, 0x20, 0x7f, 0xb0,
    0x9d, 0xdd, 0xdf, 0xff, 0xff, 0x80, 0x1, 0x0,
    0x9f, 0xc0, 0xe, 0xf2, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x7f, 0x80, 0xd, 0xf3, 0x9, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x4f, 0xf4,
    0x7, 0xf8, 0x6, 0xf9, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x6, 0xfa, 0x4, 0xfa, 0x4, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x5, 0xfb,
    0x4, 0xfa, 0x4, 0xfb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x2d, 0xf6, 0x6, 0xf9, 0x5, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x8f, 0xc0,
    0xc, 0xf5, 0x9, 0xf7, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x5, 0x0, 0x6f, 0xe0, 0xd, 0xf3,
    0x0, 0x0, 0x6, 0xff, 0xff, 0x80, 0x0, 0x6,
    0xff, 0x40, 0x5f, 0xd0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0x80, 0x0, 0x3f, 0xf7, 0x0, 0xef, 0x60,
    0x0, 0x0, 0x0, 0x6, 0xff, 0x80, 0x0, 0x9,
    0x40, 0xb, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6e, 0x40, 0x0, 0x0, 0x0, 0xaf, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xc2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F03E "" */
    0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x4e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xfb, 0x69,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x0, 0x2f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xb2, 0xdf, 0xff, 0xff, 0xff,
    0xe3, 0x1, 0xdf, 0xff, 0xff, 0xb0, 0x1, 0xdf,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0xf9, 0xbf,
    0xff, 0xb0, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xff,
    0xf8, 0x0, 0xbf, 0xb0, 0x0, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xfd, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xad, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F043 "" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xfe, 0x10, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x2e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0xff, 0xb2, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x6e, 0xfb, 0xe, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xaf, 0xf1, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x14,
    0xff, 0xc0, 0x5b, 0xff, 0xff, 0xff, 0xb0, 0xb,
    0xff, 0xd5, 0x14, 0xff, 0xff, 0xf2, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x1,
    0x69, 0x98, 0x30, 0x0, 0x0,

    /* U+F048 "" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xfc, 0x0, 0x0, 0x0, 0x7, 0xf9, 0x2f, 0xfc,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0x2f, 0xfc, 0x0,
    0x0, 0x9, 0xff, 0xff, 0x2f, 0xfc, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0x2f, 0xfc, 0x0, 0xb, 0xff,
    0xff, 0xff, 0x2f, 0xfc, 0x1, 0xcf, 0xff, 0xff,
    0xff, 0x2f, 0xfc, 0x1d, 0xff, 0xff, 0xff, 0xff,
    0x2f, 0xfe, 0xef, 0xff, 0xff, 0xff, 0xff, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x2f, 0xfc, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0x2f, 0xfc, 0x3, 0xff, 0xff,
    0xff, 0xff, 0x2f, 0xfc, 0x0, 0x2e, 0xff, 0xff,
    0xff, 0x2f, 0xfc, 0x0, 0x2, 0xdf, 0xff, 0xff,
    0x2f, 0xfc, 0x0, 0x0, 0x1d, 0xff, 0xff, 0x2f,
    0xfc, 0x0, 0x0, 0x1, 0xcf, 0xff, 0x2f, 0xfc,
    0x0, 0x0, 0x0, 0xb, 0xfc, 0x4, 0x53, 0x0,
    0x0, 0x0, 0x0, 0x41,

    /* U+F04B "" */
    0x4, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xc3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf9, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xfe,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xc3, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x10, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd4, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x10, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfa, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe5, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x20, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfa, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xd4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xfe,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x88, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F04C "" */
    0x0, 0x11, 0x11, 0x0, 0x0, 0x0, 0x11, 0x11,
    0x0, 0x6, 0xff, 0xff, 0xff, 0x40, 0x2, 0xef,
    0xff, 0xff, 0x80, 0xef, 0xff, 0xff, 0xfc, 0x0,
    0xaf, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0xe0, 0xb, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0xbf, 0xff, 0xff, 0xff, 0x2f,
    0xff, 0xff, 0xff, 0xe0, 0xb, 0xff, 0xff, 0xff,
    0xf2, 0xff, 0xff, 0xff, 0xfe, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0x2f, 0xff, 0xff, 0xff, 0xe0, 0xb,
    0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0x2f, 0xff, 0xff,
    0xff, 0xe0, 0xb, 0xff, 0xff, 0xff, 0xf2, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0xbf, 0xff, 0xff, 0xff,
    0x2f, 0xff, 0xff, 0xff, 0xe0, 0xb, 0xff, 0xff,
    0xff, 0xf2, 0xff, 0xff, 0xff, 0xfe, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0x2f, 0xff, 0xff, 0xff, 0xe0,
    0xb, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xbf, 0xff, 0xff, 0xff, 0x2f, 0xff,
    0xff, 0xff, 0xe0, 0xb, 0xff, 0xff, 0xff, 0xf2,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0x2f, 0xff, 0xff, 0xff, 0xd0, 0xa, 0xff,
    0xff, 0xff, 0xf1, 0x8f, 0xff, 0xff, 0xf6, 0x0,
    0x4f, 0xff, 0xff, 0xfa, 0x0, 0x24, 0x44, 0x42,
    0x0, 0x0, 0x14, 0x44, 0x43, 0x0,

    /* U+F04D "" */
    0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x35, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x54, 0x0,

    /* U+F051 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0xd,
    0xe4, 0x0, 0x0, 0x0, 0xf, 0xfd, 0x3f, 0xff,
    0x40, 0x0, 0x0, 0x1f, 0xfe, 0x4f, 0xff, 0xf6,
    0x0, 0x0, 0x1f, 0xfe, 0x4f, 0xff, 0xff, 0x70,
    0x0, 0x1f, 0xfe, 0x4f, 0xff, 0xff, 0xf8, 0x0,
    0x1f, 0xfe, 0x4f, 0xff, 0xff, 0xff, 0x90, 0x1f,
    0xfe, 0x4f, 0xff, 0xff, 0xff, 0xfa, 0x1f, 0xfe,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xfe, 0x4f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xef, 0xfe, 0x4f, 0xff, 0xff, 0xff,
    0xfd, 0x2f, 0xfe, 0x4f, 0xff, 0xff, 0xff, 0xc1,
    0x1f, 0xfe, 0x4f, 0xff, 0xff, 0xfb, 0x0, 0x1f,
    0xfe, 0x4f, 0xff, 0xff, 0xa0, 0x0, 0x1f, 0xfe,
    0x4f, 0xff, 0xf9, 0x0, 0x0, 0x1f, 0xfe, 0x4f,
    0xff, 0x80, 0x0, 0x0, 0x1f, 0xfe, 0x1f, 0xf7,
    0x0, 0x0, 0x0, 0x1f, 0xfd, 0x2, 0x30, 0x0,
    0x0, 0x0, 0x4, 0x53,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x10, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x2, 0xac, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcb, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x1, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x20,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x0, 0x8a, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xb0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xd0, 0x0, 0x0, 0xa, 0xff, 0xfe, 0x10,
    0x0, 0x0, 0xaf, 0xff, 0xe1, 0x0, 0x0, 0xa,
    0xff, 0xfe, 0x10, 0x0, 0x0, 0xaf, 0xff, 0xe1,
    0x0, 0x0, 0xa, 0xff, 0xfe, 0x10, 0x0, 0x0,
    0x9f, 0xff, 0xe1, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x1d, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x1,
    0xdf, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x1d, 0xff,
    0xfb, 0x0, 0x0, 0x0, 0x1, 0xdf, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x1d, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0x1, 0xce, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F054 "" */
    0x9, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x1c, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x1, 0xcf, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x1c,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xcf, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x1, 0xcf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xd0, 0x0, 0x0, 0x9, 0xff,
    0xfe, 0x20, 0x0, 0x0, 0x9f, 0xff, 0xe2, 0x0,
    0x0, 0x9, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x9f,
    0xff, 0xe2, 0x0, 0x0, 0x9, 0xff, 0xfe, 0x20,
    0x0, 0x0, 0x9f, 0xff, 0xe2, 0x0, 0x0, 0x0,
    0xbf, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x1d, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x7d, 0xdd, 0xdd, 0xdf,
    0xff, 0xfd, 0xdd, 0xdd, 0xdb, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x5b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe2, 0x1, 0x11, 0x11, 0x1c, 0xff, 0xf3,
    0x11, 0x11, 0x10, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x41, 0x0, 0x0, 0x0, 0x0,

    /* U+F068 "" */
    0x8e, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xec, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x5a, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x1, 0x69, 0xbc, 0xcb, 0x84,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xfa, 0x42, 0x36, 0xcf,
    0xff, 0xe4, 0x0, 0x0, 0x0, 0xb, 0xff, 0xfe,
    0x30, 0x0, 0x0, 0x6, 0xff, 0xff, 0x60, 0x0,
    0x0, 0xcf, 0xff, 0xf2, 0x0, 0xb, 0xb6, 0x0,
    0x7f, 0xff, 0xf7, 0x0, 0x9, 0xff, 0xff, 0x70,
    0x0, 0xe, 0xff, 0xb0, 0xd, 0xff, 0xff, 0x40,
    0x4f, 0xff, 0xff, 0x20, 0x0, 0x2f, 0xff, 0xf6,
    0x7, 0xff, 0xff, 0xe0, 0xdf, 0xff, 0xff, 0x0,
    0xb9, 0xff, 0xff, 0xfa, 0x4, 0xff, 0xff, 0xf8,
    0xef, 0xff, 0xff, 0x1, 0xff, 0xff, 0xff, 0xfb,
    0x4, 0xff, 0xff, 0xf9, 0x5f, 0xff, 0xff, 0x10,
    0xdf, 0xff, 0xff, 0xf7, 0x6, 0xff, 0xff, 0xf1,
    0xb, 0xff, 0xff, 0x60, 0x4f, 0xff, 0xff, 0xd0,
    0xc, 0xff, 0xff, 0x60, 0x1, 0xdf, 0xff, 0xe1,
    0x4, 0xcf, 0xfa, 0x10, 0x5f, 0xff, 0xf9, 0x0,
    0x0, 0x1d, 0xff, 0xfc, 0x10, 0x0, 0x0, 0x4,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xe7, 0x20, 0x3, 0x9f, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x8c, 0xef, 0xfe, 0xb7, 0x10, 0x0, 0x0, 0x0,

    /* U+F070 "" */
    0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xfc, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xbf, 0xff, 0x70, 0x0, 0x37, 0xac, 0xcb,
    0x95, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0xb7, 0xef, 0xff, 0xff, 0xff, 0xff, 0x91,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xff, 0xff,
    0xfd, 0x73, 0x25, 0xaf, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0xff, 0xfb, 0x0, 0x0,
    0x0, 0x3e, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xf9, 0x8, 0xc8, 0x10, 0x3f,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x35, 0x0, 0x6,
    0xff, 0xfc, 0xaf, 0xfe, 0x10, 0x9f, 0xff, 0xf8,
    0x0, 0x0, 0xe, 0xf8, 0x0, 0x3, 0xef, 0xff,
    0xff, 0xfb, 0x3, 0xff, 0xff, 0xf3, 0x0, 0x8,
    0xff, 0xfc, 0x10, 0x1, 0xbf, 0xff, 0xff, 0xf0,
    0xf, 0xff, 0xff, 0xc0, 0x0, 0x9f, 0xff, 0xfe,
    0x20, 0x0, 0x8f, 0xff, 0xff, 0x0, 0xff, 0xff,
    0xfd, 0x0, 0x2, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x4e, 0xff, 0xf2, 0x2f, 0xff, 0xff, 0x50, 0x0,
    0x7, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x1c, 0xff,
    0xfc, 0xff, 0xff, 0xa0, 0x0, 0x0, 0xa, 0xff,
    0xff, 0x50, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0x93, 0x0, 0x0,
    0x2, 0xdf, 0xfe, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xbf, 0xff, 0xff, 0xfc, 0x20, 0x1, 0xbf,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x27,
    0xbe, 0xff, 0xea, 0x0, 0x0, 0x7f, 0xff, 0xb1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4e, 0xff, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1c, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x30,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xff, 0xf1, 0x0, 0x7f, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0x10, 0x7,
    0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xff, 0xf2, 0x0, 0x8f, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0x30,
    0x9, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0xf4, 0x0, 0xaf, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0x50, 0xb, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xfd, 0xbb, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0x91, 0x3e, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x13,
    0xef, 0xff, 0xff, 0xff, 0xff, 0x30, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x18,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0x60,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x90, 0x4,
    0x55, 0x55, 0x10, 0x0, 0x0, 0x0, 0x45, 0x7f,
    0xff, 0x90, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xfd,
    0x10, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfe, 0xef,
    0xff, 0xff, 0xfd, 0x10, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x9, 0xff, 0xb0, 0x6f, 0xff,
    0xd1, 0x4f, 0xff, 0x40, 0x0, 0x0, 0xa, 0xc0,
    0x5f, 0xff, 0xe1, 0x3, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x1, 0x4f, 0xff, 0xe2, 0x0, 0x7, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xf4, 0x16, 0x0, 0x1e, 0x90, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xf5, 0xc, 0xf6, 0x4, 0xff, 0xa0,
    0x5, 0x66, 0x6d, 0xff, 0xf6, 0xa, 0xff, 0xf7,
    0x8f, 0xff, 0xa0, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xfe,
    0xde, 0xee, 0xe9, 0x0, 0x0, 0x0, 0x4e, 0xee,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0x30, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x0, 0x13, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0xff, 0xf9, 0x4f, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xf9, 0x0, 0x4f, 0xff,
    0xf6, 0x0, 0x0, 0x2e, 0xff, 0xf9, 0x0, 0x0,
    0x4f, 0xff, 0xf6, 0x0, 0x2e, 0xff, 0xf9, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xf6, 0xa, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf1, 0x4f,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xfa,
    0x0, 0x36, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x36, 0x0,

    /* U+F078 "" */
    0x1, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x30, 0x2, 0xef, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xef, 0x60, 0xbf, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x1, 0xef, 0xff, 0x14, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x1, 0xef, 0xff, 0x90, 0x4, 0xff,
    0xff, 0x60, 0x0, 0x1, 0xef, 0xff, 0xa0, 0x0,
    0x4, 0xff, 0xff, 0x60, 0x1, 0xef, 0xff, 0xa0,
    0x0, 0x0, 0x4, 0xff, 0xff, 0x61, 0xef, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xef,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x70, 0x0, 0x0,
    0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x8c, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xfe, 0x20, 0x1, 0x89, 0x99, 0x99, 0x99, 0x99,
    0x81, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xfe, 0x20,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xfe, 0x30, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x9f, 0xfd,
    0xff, 0xdf, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x2,
    0xff, 0x80, 0x0, 0xb, 0xfe, 0x2f, 0xf9, 0x7f,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf8, 0x0,
    0x0, 0x17, 0x21, 0xff, 0x90, 0x65, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x1f, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf8, 0x0, 0x0, 0x0, 0x1, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x1f, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x61, 0x1f, 0xf8, 0x4, 0x30, 0x0,
    0x1, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xc2, 0xff, 0x86, 0xff, 0x20, 0x0, 0x1f, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xdf, 0xfd,
    0xff, 0xf2, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd3, 0xb, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0xb, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x8a,
    0xaa, 0xaa, 0xaa, 0xaa, 0xa6, 0x0, 0xa, 0xff,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xe3, 0x0, 0x0,

    /* U+F07B "" */
    0x2a, 0xcc, 0xcc, 0xcc, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb2, 0x22, 0x22, 0x22, 0x20, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x1, 0x77, 0x78,
    0xff, 0xff, 0xf8, 0x77, 0x71, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xf9, 0x1f, 0xff, 0xff, 0x19, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xd0, 0x57, 0x77, 0x50, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa2, 0x11,
    0x12, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x3f,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb9, 0xf7, 0xdf, 0xf9, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x43, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xfb, 0x83, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xdf, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x3, 0x82, 0x0, 0x0, 0xa, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x5, 0xcf, 0xfd, 0x10, 0x1,
    0xbf, 0xff, 0xfc, 0x0, 0x0, 0x6, 0xef, 0xff,
    0xff, 0xb0, 0x6e, 0xff, 0xff, 0xd1, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xfd,
    0x10, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb1, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xd8, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x69, 0x87, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F0C4 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3c, 0xff, 0xb2, 0x0, 0x0, 0x0,
    0x2, 0x54, 0x0, 0x3f, 0xff, 0xff, 0xe1, 0x0,
    0x0, 0x7, 0xff, 0xfe, 0x2b, 0xff, 0xbc, 0xff,
    0x90, 0x0, 0x7, 0xff, 0xff, 0xe1, 0xff, 0xb0,
    0xd, 0xfd, 0x0, 0x7, 0xff, 0xff, 0xd2, 0xf,
    0xfd, 0x0, 0xef, 0xc0, 0x8, 0xff, 0xff, 0xd1,
    0x0, 0xaf, 0xfe, 0xef, 0xfc, 0x8, 0xff, 0xff,
    0xd1, 0x0, 0x1, 0xef, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x1, 0x9d, 0xef, 0xff,
    0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xfc, 0x10, 0x0, 0x0,
    0x0, 0x4, 0x8a, 0xff, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x10, 0x0, 0x8, 0xff, 0xff, 0xff, 0xe2,
    0xbf, 0xff, 0xfd, 0x10, 0x0, 0xef, 0xe3, 0x4f,
    0xfb, 0x0, 0xbf, 0xff, 0xfd, 0x10, 0xf, 0xfb,
    0x0, 0xdf, 0xd0, 0x0, 0xaf, 0xff, 0xfd, 0x10,
    0xcf, 0xf9, 0xaf, 0xfa, 0x0, 0x0, 0xaf, 0xff,
    0xfd, 0x14, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0,
    0x8f, 0xff, 0xe2, 0x4, 0xdf, 0xfd, 0x30, 0x0,
    0x0, 0x0, 0x36, 0x61, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0x0, 0x22, 0x22, 0x22, 0x20, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0x1c, 0x80, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xf1, 0xcf, 0x80, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0x1c, 0xff, 0x80, 0x37, 0x76,
    0xc, 0xff, 0xff, 0xff, 0xf1, 0x9c, 0xcc, 0x1f,
    0xff, 0xf0, 0xcf, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0xff, 0xff, 0xc, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x2f, 0xff, 0xf0, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff, 0xf0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xff,
    0xff, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x2f, 0xff, 0xf0, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0xff, 0xff, 0xc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x2f, 0xff, 0xf0, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff,
    0xf0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0xff, 0xff, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x2f, 0xff, 0xf2, 0x6c, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xa0, 0xff, 0xff, 0xc2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x10, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x6,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa7, 0x0, 0x0,
    0x0,

    /* U+F0C7 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe4, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0xf, 0xfe, 0x99, 0x99,
    0x99, 0x99, 0x9a, 0xff, 0xf5, 0x0, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xf5, 0xf,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xf2, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0x5f, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xf5, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x5f, 0xff, 0xff, 0xff, 0xfb, 0xae, 0xff, 0xff,
    0xff, 0xf5, 0xff, 0xff, 0xff, 0xf3, 0x0, 0xc,
    0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x5, 0xff, 0xff, 0xff, 0x5f, 0xff,
    0xff, 0xff, 0x20, 0x0, 0xcf, 0xff, 0xff, 0xf5,
    0xff, 0xff, 0xff, 0xff, 0xa9, 0xef, 0xff, 0xff,
    0xff, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x1, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x11, 0x10, 0x0,

    /* U+F0C9 "" */
    0xce, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x21, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x6b, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xee, 0xe3, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x6e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F0E0 "" */
    0x7, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x87, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x2c, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x23, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x6, 0xf8,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x1b, 0xff, 0xfc, 0x22, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xc2, 0x4e, 0xff, 0xff, 0xff, 0x60, 0x8f,
    0xff, 0xff, 0xff, 0x80, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xb1, 0x4e, 0xff, 0xfe, 0x42, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe4, 0x19, 0xe9, 0x14,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x20, 0x29, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4,

    /* U+F0E7 "" */
    0x0, 0x2, 0x22, 0x22, 0x21, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xfc, 0x99, 0x99, 0x70, 0x9, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x10, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xa0, 0xd, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x6, 0xaa, 0xaa, 0xbf, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa8, 0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x0, 0x4, 0x74, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x33, 0x37, 0xff, 0xf8, 0x33, 0x31,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xfd, 0x3c, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xa0,
    0x9f, 0xff, 0xff, 0x10, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xcf, 0xff, 0xff, 0xf1, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0xff, 0xff, 0xfe, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0x63, 0xde, 0xee,
    0xee, 0x1a, 0x40, 0x0, 0xff, 0xff, 0xf4, 0x7f,
    0xff, 0xff, 0xf1, 0xcf, 0x40, 0xf, 0xff, 0xff,
    0x47, 0xff, 0xff, 0xff, 0x1c, 0xff, 0x40, 0xff,
    0xff, 0xf4, 0x7f, 0xff, 0xff, 0xf1, 0xcf, 0xff,
    0x1f, 0xff, 0xff, 0x47, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0xff, 0xff, 0xf4, 0x7f, 0xff, 0xff,
    0xf9, 0x55, 0x55, 0xf, 0xff, 0xff, 0x47, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xf4,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xff,
    0xff, 0x47, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0xff, 0xff, 0xf4, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x2a, 0xee, 0xee, 0x37, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x3, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xb0,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18,
    0xef, 0xff, 0xa3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x58, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x17, 0x83, 0x0, 0x0, 0x0,
    0x0,

    /* U+F11C "" */
    0x19, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x60, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0xa0, 0xf, 0x60,
    0xf, 0x60, 0xf, 0x60, 0xf, 0x60, 0xf, 0xfa,
    0xff, 0xa0, 0xe, 0x60, 0xe, 0x60, 0xe, 0x60,
    0xf, 0x60, 0xf, 0xfa, 0xff, 0xd5, 0x6f, 0xa5,
    0x6f, 0xa5, 0x6f, 0xa5, 0x6f, 0xa5, 0x6f, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xa0, 0xf,
    0x70, 0xf, 0x70, 0xf, 0x60, 0xf, 0xff, 0xfa,
    0xff, 0xff, 0x90, 0xf, 0x60, 0xf, 0x60, 0xf,
    0x60, 0xf, 0xff, 0xfa, 0xff, 0xff, 0xc5, 0x6f,
    0xa5, 0x6f, 0xa5, 0x6f, 0xa5, 0x6f, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0xff, 0xa0, 0xf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x60, 0xf, 0xfa,
    0xff, 0xa0, 0xe, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x60, 0xf, 0xfa, 0xff, 0xea, 0xaf, 0xda,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaf, 0xda, 0xaf, 0xfa,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x4e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xef,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x9f, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3a, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x4, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x5d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x6, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x0, 0x0, 0x8e, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x10, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x57, 0x77, 0x77, 0x77, 0xef,
    0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78,
    0x20, 0x0, 0x0, 0x0, 0x0,

    /* U+F15B "" */
    0x24, 0x44, 0x44, 0x44, 0x40, 0x11, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xf3, 0x5e, 0x30, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xe3, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xfe, 0x30,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xff, 0xe3,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x5f, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x47, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x73,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x16, 0x9c, 0xef, 0xfe, 0xda, 0x73, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x81, 0x0, 0x0,
    0x0, 0x0, 0x5e, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x1, 0xbf,
    0xff, 0xff, 0xfb, 0x86, 0x55, 0x57, 0xae, 0xff,
    0xff, 0xfd, 0x30, 0x3, 0xef, 0xff, 0xfb, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x9f, 0xff, 0xff,
    0x60, 0xef, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2a, 0xff, 0xff, 0x25, 0xff,
    0x90, 0x0, 0x0, 0x2, 0x45, 0x64, 0x30, 0x0,
    0x0, 0x6, 0xff, 0x80, 0x4, 0x50, 0x0, 0x1,
    0x8d, 0xff, 0xff, 0xff, 0xea, 0x30, 0x0, 0x3,
    0x60, 0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1c, 0xff, 0xff, 0xff, 0xee, 0xff, 0xff,
    0xff, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0x94, 0x0, 0x0, 0x37, 0xef, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xfc, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xdd, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x40, 0xdf, 0xff, 0x1f, 0xfa, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9, 0xdf,
    0xf1, 0xff, 0xa1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x8, 0xff, 0x1f, 0xfa,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x8f, 0xf1, 0xff, 0xa1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7c,
    0xff, 0x1f, 0xfa, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F241 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40, 0x0,
    0x0, 0xdf, 0xff, 0x1f, 0xfa, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0x9, 0xdf,
    0xf1, 0xff, 0xa1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x8, 0xff, 0x1f, 0xfa,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x8f, 0xf1, 0xff, 0xa1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x7c,
    0xff, 0x1f, 0xfa, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F242 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x44, 0x44, 0x44, 0x44, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0x1f, 0xfa, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x9, 0xdf,
    0xf1, 0xff, 0xa1, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x1f, 0xfa,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf1, 0xff, 0xa1, 0xff, 0xff,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0xff, 0x1f, 0xfa, 0xf, 0xff, 0xff, 0xff, 0xff,
    0x10, 0x0, 0x0, 0x0, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F243 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x44, 0x44, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0x1f, 0xfa, 0x1f, 0xff, 0xff,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xdf,
    0xf1, 0xff, 0xa1, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x1f, 0xfa,
    0x1f, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf1, 0xff, 0xa1, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0xff, 0x1f, 0xfa, 0xf, 0xff, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F244 "" */
    0x7, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x97, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xc0, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0x1f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xdf,
    0xf1, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x1f, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xf1, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0xff, 0x1f, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xf1, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xfe, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1,
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0x81, 0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xbd,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x57, 0xcf, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x50, 0x6f,
    0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x46, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x49, 0x93, 0x0, 0x6,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x0, 0x5f, 0xff, 0xf3, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xfa, 0x10, 0xd, 0xff,
    0xff, 0xd8, 0xcf, 0xa8, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x8f, 0xff, 0x70, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x2a, 0xff, 0xff, 0x70, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf8, 0x0, 0x1b,
    0xff, 0x90, 0x0, 0x0, 0xb, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x60, 0x2, 0x33, 0x31, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x10, 0xef, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xee, 0xbf,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x9b, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x22, 0x22, 0x0, 0x0, 0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x0, 0x0, 0x1, 0x21, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xbf, 0xff, 0xfe, 0xa3, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xdf, 0xff, 0xf7,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xe1, 0xef, 0xff,
    0xf5, 0x0, 0x3, 0xff, 0xff, 0xfe, 0x3, 0xff,
    0xff, 0xe0, 0x0, 0xaf, 0xff, 0xff, 0xe0, 0x4,
    0xff, 0xff, 0x40, 0xe, 0xff, 0xdf, 0xfe, 0x6,
    0x5, 0xff, 0xf9, 0x1, 0xff, 0xf1, 0x3f, 0xe0,
    0xca, 0x7, 0xff, 0xc0, 0x4f, 0xff, 0x90, 0x3d,
    0xb, 0x60, 0xbf, 0xfe, 0x5, 0xff, 0xff, 0x90,
    0x20, 0x30, 0xaf, 0xff, 0xf0, 0x6f, 0xff, 0xff,
    0x90, 0x0, 0x8f, 0xff, 0xff, 0x7, 0xff, 0xff,
    0xff, 0x50, 0x2f, 0xff, 0xff, 0xf1, 0x6f, 0xff,
    0xff, 0x90, 0x0, 0x7f, 0xff, 0xff, 0x5, 0xff,
    0xff, 0x90, 0x30, 0x30, 0x8f, 0xff, 0xf0, 0x4f,
    0xff, 0x90, 0x3e, 0xb, 0x60, 0x9f, 0xfe, 0x1,
    0xff, 0xf2, 0x4f, 0xf0, 0xc9, 0x6, 0xff, 0xc0,
    0xe, 0xff, 0xef, 0xff, 0x6, 0x5, 0xff, 0xf9,
    0x0, 0x8f, 0xff, 0xff, 0xf0, 0x4, 0xff, 0xff,
    0x40, 0x2, 0xff, 0xff, 0xff, 0x4, 0xff, 0xff,
    0xd0, 0x0, 0x6, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x5, 0xef, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x6a, 0xcd, 0xca,
    0x61, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x0, 0x35, 0x55, 0x55, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x79, 0x99,
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x10, 0xb, 0xff, 0xeb, 0xff,
    0xec, 0xff, 0xec, 0xff, 0xf1, 0x0, 0xbf, 0xf9,
    0x1f, 0xf8, 0x2f, 0xf7, 0x3f, 0xff, 0x10, 0xb,
    0xff, 0x91, 0xff, 0x82, 0xff, 0x73, 0xff, 0xf1,
    0x0, 0xbf, 0xf9, 0x1f, 0xf8, 0x2f, 0xf7, 0x3f,
    0xff, 0x10, 0xb, 0xff, 0x91, 0xff, 0x82, 0xff,
    0x73, 0xff, 0xf1, 0x0, 0xbf, 0xf9, 0x1f, 0xf8,
    0x2f, 0xf7, 0x3f, 0xff, 0x10, 0xb, 0xff, 0x91,
    0xff, 0x82, 0xff, 0x73, 0xff, 0xf1, 0x0, 0xbf,
    0xf9, 0x1f, 0xf8, 0x2f, 0xf7, 0x3f, 0xff, 0x10,
    0xb, 0xff, 0x91, 0xff, 0x82, 0xff, 0x73, 0xff,
    0xf1, 0x0, 0xbf, 0xf9, 0x1f, 0xf8, 0x2f, 0xf7,
    0x3f, 0xff, 0x10, 0xb, 0xff, 0xb3, 0xff, 0xa4,
    0xff, 0x95, 0xff, 0xf1, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x6, 0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x81,
    0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x15, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xef, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x31, 0x3f, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xed, 0x13, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0xff, 0xd1, 0x3f, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xef, 0xff, 0xfd, 0x13, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xff,
    0xd1, 0x35, 0x0, 0x0, 0x0, 0x0, 0x3, 0xef,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xef, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xef, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0x97, 0x53, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x0, 0x8, 0xbc, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcb, 0x81, 0x0, 0x0, 0x0,
    0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0x1d, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x20, 0x0, 0x1d, 0xff, 0xff, 0xff, 0xfa, 0xef,
    0xff, 0xfa, 0xef, 0xff, 0xff, 0xf4, 0x0, 0x1d,
    0xff, 0xff, 0xff, 0xf8, 0x2, 0xef, 0xf8, 0x2,
    0xef, 0xff, 0xff, 0x40, 0x1d, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x2, 0xe8, 0x0, 0xd, 0xff, 0xff,
    0xf4, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x1, 0x0, 0xb, 0xff, 0xff, 0xff, 0x4c, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xf4, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x2, 0xef, 0xff, 0xff,
    0xff, 0x43, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x2, 0xef, 0xff, 0xff, 0xf4, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xb, 0x40,
    0x2, 0xef, 0xff, 0xff, 0x40, 0x3, 0xff, 0xff,
    0xff, 0xff, 0x50, 0xb, 0xff, 0x40, 0xd, 0xff,
    0xff, 0xf4, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0x6c, 0xff, 0xff, 0x6b, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x2, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x30,

    /* U+F7C2 "" */
    0x0, 0x0, 0x8, 0x99, 0x99, 0x99, 0x97, 0x20,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0xcf, 0x90, 0x6e, 0x3, 0xf3, 0xe, 0xfb,
    0xb, 0xff, 0x90, 0x6e, 0x2, 0xf2, 0xe, 0xfb,
    0xbf, 0xff, 0x90, 0x6e, 0x2, 0xf2, 0xe, 0xfb,
    0xff, 0xff, 0x90, 0x6e, 0x2, 0xf2, 0xe, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1,
    0x2, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0x10,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xf1, 0x0, 0x0, 0x3c, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xf1, 0x0, 0x3, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xf1, 0x0,
    0x4f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xf1, 0x5, 0xff, 0xff, 0xb4, 0x44, 0x44,
    0x44, 0x44, 0x46, 0xff, 0xf1, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x3, 0xef,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x18, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 64, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 107, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32, .adv_w = 168, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 64, .adv_w = 208, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 162, .adv_w = 178, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 242, .adv_w = 304, .box_w = 19, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 385, .adv_w = 207, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 481, .adv_w = 97, .box_w = 4, .box_h = 8, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 497, .adv_w = 130, .box_w = 7, .box_h = 22, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 574, .adv_w = 130, .box_w = 8, .box_h = 22, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 662, .adv_w = 166, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 707, .adv_w = 192, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 773, .adv_w = 75, .box_w = 4, .box_h = 7, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 787, .adv_w = 153, .box_w = 8, .box_h = 3, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 799, .adv_w = 72, .box_w = 3, .box_h = 4, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 805, .adv_w = 121, .box_w = 9, .box_h = 23, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 909, .adv_w = 195, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 999, .adv_w = 105, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1031, .adv_w = 188, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1114, .adv_w = 183, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1197, .adv_w = 205, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1295, .adv_w = 183, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1378, .adv_w = 209, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1468, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1551, .adv_w = 208, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1649, .adv_w = 209, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1739, .adv_w = 72, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1757, .adv_w = 72, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1787, .adv_w = 179, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1846, .adv_w = 192, .box_w = 10, .box_h = 8, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1886, .adv_w = 179, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1945, .adv_w = 142, .box_w = 10, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2025, .adv_w = 249, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2160, .adv_w = 191, .box_w = 14, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2265, .adv_w = 191, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2348, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2431, .adv_w = 204, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2521, .adv_w = 170, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2589, .adv_w = 156, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2657, .adv_w = 211, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2755, .adv_w = 221, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2845, .adv_w = 97, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2875, .adv_w = 134, .box_w = 8, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2935, .adv_w = 200, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3025, .adv_w = 150, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3085, .adv_w = 252, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3183, .adv_w = 222, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3273, .adv_w = 221, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3371, .adv_w = 184, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3454, .adv_w = 221, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3578, .adv_w = 194, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3661, .adv_w = 169, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3736, .adv_w = 164, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3811, .adv_w = 209, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3894, .adv_w = 184, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3992, .adv_w = 269, .box_w = 19, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4135, .adv_w = 191, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4225, .adv_w = 181, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4323, .adv_w = 176, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4406, .adv_w = 130, .box_w = 6, .box_h = 21, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 4469, .adv_w = 121, .box_w = 9, .box_h = 23, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 4573, .adv_w = 130, .box_w = 6, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4636, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 4696, .adv_w = 202, .box_w = 14, .box_h = 2, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 4710, .adv_w = 92, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 13},
    {.bitmap_index = 4725, .adv_w = 167, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4780, .adv_w = 190, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4860, .adv_w = 152, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4910, .adv_w = 189, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4998, .adv_w = 174, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5053, .adv_w = 117, .box_w = 8, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5117, .adv_w = 187, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 5205, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5285, .adv_w = 94, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5315, .adv_w = 93, .box_w = 5, .box_h = 21, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 5368, .adv_w = 170, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5448, .adv_w = 92, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5480, .adv_w = 285, .box_w = 16, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5568, .adv_w = 188, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5623, .adv_w = 183, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5684, .adv_w = 189, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 5764, .adv_w = 190, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 5852, .adv_w = 128, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5896, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5946, .adv_w = 131, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6006, .adv_w = 182, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6056, .adv_w = 158, .box_w = 12, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6122, .adv_w = 240, .box_w = 15, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6205, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6260, .adv_w = 159, .box_w = 12, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 6350, .adv_w = 149, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6405, .adv_w = 132, .box_w = 8, .box_h = 22, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6493, .adv_w = 139, .box_w = 3, .box_h = 22, .ofs_x = 3, .ofs_y = -4},
    {.bitmap_index = 6526, .adv_w = 130, .box_w = 8, .box_h = 22, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6614, .adv_w = 194, .box_w = 12, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 6644, .adv_w = 336, .box_w = 22, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6886, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7054, .adv_w = 336, .box_w = 21, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7264, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7432, .adv_w = 231, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7552, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7783, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8014, .adv_w = 378, .box_w = 24, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8254, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8485, .adv_w = 378, .box_w = 24, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8677, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8908, .adv_w = 168, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9002, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9138, .adv_w = 378, .box_w = 24, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9390, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9558, .adv_w = 231, .box_w = 15, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9723, .adv_w = 294, .box_w = 14, .box_h = 20, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 9863, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10072, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10262, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10452, .adv_w = 294, .box_w = 14, .box_h = 20, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 10592, .adv_w = 294, .box_w = 20, .box_h = 20, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 10792, .adv_w = 210, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 10906, .adv_w = 210, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 11020, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11210, .adv_w = 294, .box_w = 19, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 11258, .adv_w = 378, .box_w = 24, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11450, .adv_w = 420, .box_w = 27, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11747, .adv_w = 378, .box_w = 25, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 12022, .adv_w = 336, .box_w = 21, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 12232, .adv_w = 294, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 12346, .adv_w = 294, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 12460, .adv_w = 420, .box_w = 27, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12676, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12844, .adv_w = 336, .box_w = 21, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13075, .adv_w = 336, .box_w = 22, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 13317, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13507, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13716, .adv_w = 294, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 13906, .adv_w = 294, .box_w = 19, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 14068, .adv_w = 336, .box_w = 21, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14236, .adv_w = 210, .box_w = 15, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 14401, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14610, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14819, .adv_w = 378, .box_w = 24, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15011, .adv_w = 336, .box_w = 23, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 15264, .adv_w = 252, .box_w = 16, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 15440, .adv_w = 420, .box_w = 27, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 15710, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 15899, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16088, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16277, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16466, .adv_w = 420, .box_w = 27, .box_h = 14, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 16655, .adv_w = 420, .box_w = 27, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 16885, .adv_w = 294, .box_w = 17, .box_h = 22, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 17072, .adv_w = 294, .box_w = 19, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 17281, .adv_w = 336, .box_w = 22, .box_h = 22, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 17523, .adv_w = 420, .box_w = 27, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17739, .adv_w = 252, .box_w = 16, .box_h = 22, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 17915, .adv_w = 338, .box_w = 22, .box_h = 14, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x42,
    0x47, 0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53,
    0x66, 0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77,
    0x78, 0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xc8,
    0xdf, 0xe6, 0xe9, 0xf2, 0x11b, 0x123, 0x15a, 0x1ea,
    0x23f, 0x240, 0x241, 0x242, 0x243, 0x286, 0x292, 0x2ec,
    0x303, 0x559, 0x7c1, 0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 96,
        .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 60, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 0, 0, 1, 0, 0, 0, 2,
    1, 3, 0, 4, 0, 5, 6, 5,
    0, 0, 0, 0, 0, 7, 0, 0,
    0, 0, 0, 5, 5, 0, 0, 0,
    0, 0, 8, 9, 10, 11, 12, 13,
    14, 0, 0, 0, 15, 16, 0, 0,
    11, 17, 11, 18, 19, 20, 0, 21,
    22, 23, 24, 25, 26, 0, 0, 0,
    0, 0, 27, 28, 29, 30, 31, 32,
    33, 27, 34, 35, 36, 30, 27, 27,
    28, 28, 37, 38, 39, 40, 41, 42,
    43, 44, 43, 45, 46, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 1, 2, 0, 0, 0, 3,
    2, 0, 4, 5, 0, 6, 7, 6,
    0, 0, 0, 0, 0, 8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    9, 0, 10, 0, 11, 0, 0, 0,
    11, 0, 0, 12, 0, 0, 0, 0,
    11, 0, 11, 0, 13, 14, 0, 15,
    16, 17, 18, 19, 0, 0, 20, 0,
    0, 0, 21, 22, 23, 23, 23, 24,
    23, 22, 25, 26, 22, 22, 27, 27,
    23, 28, 23, 27, 29, 30, 31, 32,
    33, 34, 35, 36, 0, 0, 20, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, -24,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7, 0, 0,
    0, -7, -3, -3, 0, -3, 0, 0,
    0, 0, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 2, 2, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7, 0, 10,
    0, 18, 0, 0, 0, 0, 0, -10,
    -10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -40, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -13,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, -10,
    0, -10, -7, -7, -7, -10, -3, 0,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 7, 7, 0, 7, 0,
    0, 0, 0, 0, -13, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, 0, 0, 0, -17, 0, -2, 10,
    0, -12, -15, -8, 3, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, -3, 3, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, 0,
    -7, -2, 3, 0, 0, -3, -3, 0,
    0, -5, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -20, 0, 0,
    7, -15, 0, -17, 0, 3, 3, 3,
    3, 5, 0, 0, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -7, 0,
    0, 0, 0, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -10, 0,
    0, 0, 0, 0, -3, -7, 0, -7,
    -7, 0, -10, 0, 0, -30, 0, 0,
    0, 0, -10, 0, -24, 10, 0, 7,
    0, -13, -13, -13, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -30, 0, 0,
    0, -12, 3, -7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 0, 0, 0, 0, 0, 0, 8,
    3, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -30, -10, 0, 7, -12, -3, -10,
    0, 0, 0, 3, 0, 3, 0, 0,
    -17, 0, -17, 0, 0, 0, -15, 0,
    -17, 0, -13, -10, -10, -10, -10, -10,
    0, 0, 0, 0, 0, 0, -7, 0,
    10, -15, -3, -12, -2, 0, 0, -10,
    -10, -10, 0, 0, -13, 0, -13, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -7, 0, 10, -12, 0, -10,
    0, 3, -10, 0, -10, -10, 0, 0,
    -12, 0, -13, 0, 0, 0, 0, 0,
    0, 0, -7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -7, 0,
    7, 3, -3, 7, 0, 0, -10, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, 17, -15, -5, -10,
    0, 3, -10, -10, 0, -10, 0, 0,
    -17, 0, -18, 0, 0, 0, -13, -18,
    -10, 0, -12, 0, 0, -7, 0, -10,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -7, 0, 0, 15, 0, 0,
    0, 0, 0, -10, -10, 0, 0, 0,
    0, 0, 0, -7, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, -17, -8, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -7,
    -7, 0, -7, 0, 0, 0, 0, 0,
    0, 0, 3, 0, -10, 0, 0, 0,
    0, -18, -13, 0, 0, -17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -7, 0,
    0, 0, 0, 0, 0, -13, -10, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -7, 0, 0, 0,
    0, 0, 0, 0, 7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, -7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -17, 0, -13,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 7, 7, 3, 13,
    13, -20, -7, 0, 12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 13,
    -2, 0, -10, 0, 0, 0, 0, 0,
    0, 0, -3, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -10, 0, 0, 0, 0, -17, -10, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    10, 0, 0, 0, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -7, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -17, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -7, 0, 0, 0, 0, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -10, 0, 0, 0, 0, -15, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -7, 0, -7, 0, 0, 0,
    0, -17, 0, 0, 0, -7, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -7, 0, 0, 0, 0, -13, 0, -7,
    0, -18, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, -10,
    0, 0, 7, 0, -7, -5, 0, 0,
    0, -10, 0, 0, 0, 0, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, -10, 0, 0, 7, 0,
    -7, -5, 0, 0, 0, -7, 0, 0,
    0, 0, 0, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, 0,
    0, 0, 0, 0, 0, 3, 0, 0,
    0, -13, 0, 0, 0, -7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -10, 0, 0, 0, 0, -13, 0, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 18, 0, 0,
    0, 0, 0, -10, -10, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 46,
    .right_class_cnt     = 36,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t lv_font_Alatsi_Regular_21 = {
#else
lv_font_t lv_font_Alatsi_Regular_21 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 25,          /*The maximum line height required by the font*/
    .base_line = 6,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = 0,
    .underline_thickness = 2,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if LV_FONT_ALATSI_REGULAR_21*/

