#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

#include <driver/gpio.h>

#define AUDIO_INPUT_SAMPLE_RATE  24000
#define AUDIO_OUTPUT_SAMPLE_RATE 24000

#define AUDIO_I2S_GPIO_MCLK  GPIO_NUM_15
#define AUDIO_I2S_GPIO_WS    GPIO_NUM_5
#define AUDIO_I2S_GPIO_BCLK  GPIO_NUM_3
#define AUDIO_I2S_GPIO_DIN   GPIO_NUM_4
#define AUDIO_I2S_GPIO_DOUT  GPIO_NUM_6

#define AUDIO_CODEC_PA_PIN       GPIO_NUM_23
#define AUDIO_CODEC_I2C_SDA_PIN  GPIO_NUM_8
#define AUDIO_CODEC_I2C_SCL_PIN  GPIO_NUM_7
#define AUDIO_CODEC_ES8311_ADDR  ES8311_CODEC_DEFAULT_ADDR

#define BOOT_BUTTON_GPIO        GPIO_NUM_9


#define LCD_CS       GPIO_NUM_22
#define LCD_PCLK     GPIO_NUM_18
#define LCD_D0       GPIO_NUM_19
#define LCD_D1       GPIO_NUM_20
#define LCD_D2       GPIO_NUM_10
#define LCD_D3       GPIO_NUM_11
#define LCD_RST      GPIO_NUM_21

#define EXAMPLE_LCD_H_RES 466
#define EXAMPLE_LCD_V_RES 466
 
#define DISPLAY_MIRROR_X false
#define DISPLAY_MIRROR_Y false
#define DISPLAY_SWAP_XY  false

#define DISPLAY_OFFSET_X  0
#define DISPLAY_OFFSET_Y  0

#define SYS_POWER_IO_PIN GPIO_NUM_2
#define PWR_KEY_GPIO     GPIO_NUM_1

#endif // _BOARD_CONFIG_H_
