#include "LVGL_Driver.h"

static const char *TAG_LVGL = "LVGL";

    

lv_disp_draw_buf_t disp_buf,disp_buf2;                                                 // contains internal graphic buffer(s) called draw buffer(s)
lv_disp_drv_t disp_drv,disp_drv2;                                                      // contains callback functions
lv_indev_drv_t indev_drv,indev_drv2;

void example_increase_lvgl_tick(void *arg)
{
    /* Tell LVGL how many milliseconds has elapsed */
    lv_tick_inc(EXAMPLE_LVGL_TICK_PERIOD_MS);
}

void LVGL_Loop(void *parameter)
{
    while(1)
    {
        // The task running lv_timer_handler should have lower priority than that running `lv_tick_inc`
        lv_timer_handler();
        vTaskDelay(pdMS_TO_TICKS(10));
    }
    vTaskDelete(NULL);
}

void example_lvgl_flush_cb(lv_disp_drv_t *drv, const lv_area_t *area, lv_color_t *color_map)
{
    esp_lcd_panel_handle_t panel_handle = (esp_lcd_panel_handle_t) drv->user_data;
    int offsetx1 = area->x1;
    int offsetx2 = area->x2;
    int offsety1 = area->y1;
    int offsety2 = area->y2;
    // copy a buffer's content to a specific area of the display
    esp_lcd_panel_draw_bitmap(panel_handle, offsetx1, offsety1, offsetx2 +1, offsety2 + 1, color_map);
    lv_disp_flush_ready(drv);
}

/*Read the touchpad*/
void example_touchpad_read( lv_indev_drv_t * drv, lv_indev_data_t * data )
{
  // printf("CCCCCCCCCCCCC=%d  \r\n",touchpad_cnt);
  if (Simulated_touch_data[1].points != 0x00) {
    data->point.x = Simulated_touch_data[1].x;
    data->point.y = Simulated_touch_data[1].y;
    data->state = LV_INDEV_STATE_PR;
      // printf("X=%u Y=%u num=%d \r\n", data->point.x, data->point.y,touchpad_cnt);
  } else {
      data->state = LV_INDEV_STATE_REL;
  }
  Simulated_touch_data[1].x = 0;
  Simulated_touch_data[1].y = 0;
  Simulated_touch_data[1].points = 0;

}
/*Read the touchpad*/
void example_touchpad1_read( lv_indev_drv_t * drv, lv_indev_data_t * data )
{

  // printf("CCCCCCCCCCCCC=%d  \r\n",touchpad_cnt);
  if (Simulated_touch_data[0].points != 0x00) {
    data->point.x = Simulated_touch_data[0].x;
    data->point.y = Simulated_touch_data[0].y;
    data->state = LV_INDEV_STATE_PR;
      // printf("X=%u Y=%u num=%d \r\n", data->point.x, data->point.y,touchpad_cnt);
  } else {
      data->state = LV_INDEV_STATE_REL;
  }
  Simulated_touch_data[0].x = 0;
  Simulated_touch_data[0].y = 0;
  Simulated_touch_data[0].points = 0;
}
/* Rotate display and touch, when rotated screen in LVGL. Called when driver parameters are updated. */
void example_lvgl_port_update_callback(lv_disp_drv_t *drv)
{
    esp_lcd_panel_handle_t panel_handle = (esp_lcd_panel_handle_t) drv->user_data;

    switch (drv->rotated) {
    case LV_DISP_ROT_NONE:
        // Rotate LCD display
        esp_lcd_panel_swap_xy(panel_handle, false);
        esp_lcd_panel_mirror(panel_handle, true, false);
        break;
    case LV_DISP_ROT_90:
        // Rotate LCD display
        esp_lcd_panel_swap_xy(panel_handle, true);
        esp_lcd_panel_mirror(panel_handle, true, true);
        break;
    case LV_DISP_ROT_180:
        // Rotate LCD display
        esp_lcd_panel_swap_xy(panel_handle, false);
        esp_lcd_panel_mirror(panel_handle, false, true);
        break;
    case LV_DISP_ROT_270:
        // Rotate LCD display
        esp_lcd_panel_swap_xy(panel_handle, true);
        esp_lcd_panel_mirror(panel_handle, false, false);
        break;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
lv_disp_t *disp;
lv_disp_t *disp2;
void LVGL_Init(void)
{
    ESP_LOGI(TAG_LVGL, "Initialize LVGL library");
    lv_init();
    
    lv_color_t *buf1 = heap_caps_malloc(LVGL_BUF_LEN * sizeof(lv_color_t), MALLOC_CAP_SPIRAM); // MALLOC_CAP_DMA  MALLOC_CAP_SPIRAM
    assert(buf1);
    lv_color_t *buf2 = heap_caps_malloc(LVGL_BUF_LEN * sizeof(lv_color_t) , MALLOC_CAP_SPIRAM);    
    assert(buf2);
    lv_disp_draw_buf_init(&disp_buf, buf1, buf2, LVGL_BUF_LEN );    
    
    lv_color_t *buf3 = heap_caps_malloc(LVGL_BUF_LEN * sizeof(lv_color_t), MALLOC_CAP_SPIRAM); // MALLOC_CAP_DMA  MALLOC_CAP_SPIRAM
    assert(buf3);
    lv_color_t *buf4 = heap_caps_malloc(LVGL_BUF_LEN * sizeof(lv_color_t) , MALLOC_CAP_SPIRAM);    
    assert(buf4);
    lv_disp_draw_buf_init(&disp_buf2, buf3, buf4, LVGL_BUF_LEN );                              // initialize LVGL draw buffers

    ESP_LOGI(TAG_LVGL, "Register display driver to LVGL");
    lv_disp_drv_init(&disp_drv);                                                                        // Create a new screen object and initialize the associated device
    disp_drv.hor_res = EXAMPLE_LCD_WIDTH;             
    disp_drv.ver_res = EXAMPLE_LCD_HEIGHT;                                                                       // Vertical axis pixel count
    disp_drv.flush_cb = example_lvgl_flush_cb;                                                          // Function : copy a buffer's content to a specific area of the display
    disp_drv.drv_update_cb = example_lvgl_port_update_callback;                                         // Function : Rotate display and touch, when rotated screen in LVGL. Called when driver parameters are updated. 
    disp_drv.draw_buf = &disp_buf;                                                                      // LVGL will use this buffer(s) to draw the screens contents
    disp_drv.full_refresh = 1;
    disp_drv.user_data = panel_handle;                
    ESP_LOGI(TAG_LVGL,"Register display indev to LVGL");                                                  // Custom display driver user data
    disp = lv_disp_drv_register(&disp_drv);   

    ESP_LOGI(TAG_LVGL, "Register display2 driver to LVGL");
    lv_disp_drv_init(&disp_drv2);                                                                        // Create a new screen object and initialize the associated device
    disp_drv2.hor_res = EXAMPLE_LCD_WIDTH;             
    disp_drv2.ver_res = EXAMPLE_LCD_HEIGHT;                                                                       // Vertical axis pixel count
    disp_drv2.flush_cb = example_lvgl_flush_cb;                                                          // Function : copy a buffer's content to a specific area of the display
    disp_drv2.drv_update_cb = example_lvgl_port_update_callback;                                         // Function : Rotate display and touch, when rotated screen in LVGL. Called when driver parameters are updated. 
    disp_drv2.draw_buf = &disp_buf2;                                                                      // LVGL will use this buffer(s) to draw the screens contents
    disp_drv2.full_refresh = 1;
    disp_drv2.user_data = panel_handle2;                
    ESP_LOGI(TAG_LVGL,"Register display2 indev to LVGL");                                                  // Custom display driver user data
    disp2 = lv_disp_drv_register(&disp_drv2);     
    
    /********************* LVGL TouchPad*********************/
    lv_indev_drv_init ( &indev_drv );
    indev_drv.type = LV_INDEV_TYPE_POINTER;
    indev_drv.disp = disp;
    indev_drv.read_cb = example_touchpad_read;
    lv_indev_drv_register( &indev_drv);

    lv_indev_drv_init ( &indev_drv2 );
    indev_drv2.type = LV_INDEV_TYPE_POINTER;
    indev_drv2.disp = disp2;
    indev_drv2.read_cb = example_touchpad1_read;
    lv_indev_drv_register( &indev_drv2 );

    /********************* LVGL *********************/
    ESP_LOGI(TAG_LVGL, "Install LVGL tick timer");
    // Tick interface for LVGL (using esp_timer to generate 2ms periodic event)
    const esp_timer_create_args_t lvgl_tick_timer_args = {
        .callback = &example_increase_lvgl_tick,
        .name = "lvgl_tick"
    };
    
    esp_timer_handle_t lvgl_tick_timer = NULL;
    ESP_ERROR_CHECK(esp_timer_create(&lvgl_tick_timer_args, &lvgl_tick_timer));
    ESP_ERROR_CHECK(esp_timer_start_periodic(lvgl_tick_timer, EXAMPLE_LVGL_TICK_PERIOD_MS * 1000));
    

}
void LVGL_Start(void){

    xTaskCreatePinnedToCore(
        LVGL_Loop, 
        "LVGL Driver task",
        4096, 
        NULL, 
        2, 
        NULL, 
        1);
}