/*
 * SPDX-FileCopyrightText: 2023-2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include "esp_brookesia_internal.h"

#if !ESP_BROOKESIA_ENABLE_SYSTEMS
#   error "Systems is not enabled, please enable it in the menuconfig"
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////// Core //////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#if !defined(ESP_BROOKESIA_BASE_ENABLE_DEBUG_LOG)
#   if defined(CONFIG_ESP_BROOKESIA_BASE_ENABLE_DEBUG_LOG)
#       define ESP_BROOKESIA_BASE_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_BASE_ENABLE_DEBUG_LOG
#   else
#       define ESP_BROOKESIA_BASE_ENABLE_DEBUG_LOG  (0)
#   endif
#endif

#if ESP_BROOKESIA_BASE_ENABLE_DEBUG_LOG
#   if !defined(ESP_BROOKESIA_BASE_APP_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_BASE_APP_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_BASE_APP_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_BASE_APP_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_BASE_APP_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_BASE_DISPLAY_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_BASE_DISPLAY_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_BASE_DISPLAY_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_BASE_DISPLAY_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_BASE_DISPLAY_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_BASE_EVENT_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_BASE_EVENT_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_BASE_EVENT_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_BASE_EVENT_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_BASE_EVENT_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_BASE_MANAGER_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_BASE_MANAGER_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_BASE_MANAGER_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_BASE_MANAGER_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_BASE_MANAGER_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_BASE_CORE_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_BASE_CORE_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_BASE_CORE_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_BASE_CORE_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_BASE_CORE_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////// Phone //////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#if !defined(ESP_BROOKESIA_SYSTEMS_ENABLE_PHONE)
#   if defined(CONFIG_ESP_BROOKESIA_SYSTEMS_ENABLE_PHONE)
#       define ESP_BROOKESIA_SYSTEMS_ENABLE_PHONE  CONFIG_ESP_BROOKESIA_SYSTEMS_ENABLE_PHONE
#   else
#       define ESP_BROOKESIA_SYSTEMS_ENABLE_PHONE  (0)
#   endif
#endif

#if ESP_BROOKESIA_SYSTEMS_ENABLE_PHONE
#   if !defined(ESP_BROOKESIA_PHONE_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#endif

#if ESP_BROOKESIA_PHONE_ENABLE_DEBUG_LOG
#   if !defined(ESP_BROOKESIA_PHONE_APP_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_APP_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_APP_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_APP_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_APP_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_PHONE_HONE_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_HONE_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_HONE_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_HONE_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_HONE_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_PHONE_MANAGER_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_MANAGER_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_MANAGER_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_MANAGER_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_MANAGER_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_PHONE_PHONE_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_PHONE_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_PHONE_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_PHONE_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_PHONE_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_PHONE_APP_LAUNCHER_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_APP_LAUNCHER_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_APP_LAUNCHER_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_APP_LAUNCHER_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_APP_LAUNCHER_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_PHONE_GESTURE_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_GESTURE_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_GESTURE_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_GESTURE_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_GESTURE_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_PHONE_NAVIGATION_BAR_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_NAVIGATION_BAR_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_NAVIGATION_BAR_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_NAVIGATION_BAR_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_NAVIGATION_BAR_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_PHONE_RECENTS_SCREEN_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_RECENTS_SCREEN_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_RECENTS_SCREEN_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_RECENTS_SCREEN_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_RECENTS_SCREEN_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_PHONE_STATUS_BAR_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_PHONE_STATUS_BAR_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_PHONE_STATUS_BAR_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_PHONE_STATUS_BAR_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_PHONE_STATUS_BAR_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////// Speaker //////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#if !defined(ESP_BROOKESIA_SYSTEMS_ENABLE_SPEAKER)
#   if defined(CONFIG_ESP_BROOKESIA_SYSTEMS_ENABLE_SPEAKER)
#       define ESP_BROOKESIA_SYSTEMS_ENABLE_SPEAKER  CONFIG_ESP_BROOKESIA_SYSTEMS_ENABLE_SPEAKER
#   else
#       define ESP_BROOKESIA_SYSTEMS_ENABLE_SPEAKER  (0)
#   endif
#endif

#if ESP_BROOKESIA_SYSTEMS_ENABLE_SPEAKER
#   if !defined(ESP_BROOKESIA_SPEAKER_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_SPEAKER_FS_MOUNT_POINT)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_FS_MOUNT_POINT)
#           define ESP_BROOKESIA_SPEAKER_FS_MOUNT_POINT  CONFIG_ESP_BROOKESIA_SPEAKER_FS_MOUNT_POINT
#       else
#           error "`ESP_BROOKESIA_SPEAKER_FS_MOUNT_POINT` is not set"
#       endif
#   endif
#endif

#if ESP_BROOKESIA_SPEAKER_ENABLE_DEBUG_LOG
#   if !defined(ESP_BROOKESIA_SPEAKER_AI_BUDDY_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_AI_BUDDY_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_AI_BUDDY_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_AI_BUDDY_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_AI_BUDDY_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_SPEAKER_APP_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_APP_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_APP_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_APP_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_APP_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_SPEAKER_DISPLAY_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_DISPLAY_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_DISPLAY_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_DISPLAY_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_DISPLAY_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_SPEAKER_MANAGER_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_MANAGER_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_MANAGER_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_MANAGER_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_MANAGER_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_SPEAKER_SPEAKER_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_SPEAKER_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_SPEAKER_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_SPEAKER_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_SPEAKER_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_SPEAKER_APP_LAUNCHER_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_APP_LAUNCHER_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_APP_LAUNCHER_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_APP_LAUNCHER_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_APP_LAUNCHER_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_SPEAKER_GESTURE_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_GESTURE_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_GESTURE_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_GESTURE_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_GESTURE_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_SPEAKER_KEYBOARD_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_KEYBOARD_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_KEYBOARD_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_KEYBOARD_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_KEYBOARD_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#   if !defined(ESP_BROOKESIA_SPEAKER_QUICK_SETTINGS_ENABLE_DEBUG_LOG)
#       if defined(CONFIG_ESP_BROOKESIA_SPEAKER_QUICK_SETTINGS_ENABLE_DEBUG_LOG)
#           define ESP_BROOKESIA_SPEAKER_QUICK_SETTINGS_ENABLE_DEBUG_LOG  CONFIG_ESP_BROOKESIA_SPEAKER_QUICK_SETTINGS_ENABLE_DEBUG_LOG
#       else
#           define ESP_BROOKESIA_SPEAKER_QUICK_SETTINGS_ENABLE_DEBUG_LOG  (0)
#       endif
#   endif
#endif
