/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: --bpp 4 --size 16 --no-compress --font MaisonNeue-Book.ttf --range 32-127 --format lvgl -o esp_brookesia_font_maison_neue_book_16.c
 ******************************************************************************/

#ifdef __has_include
    #if __has_include("lvgl.h")
        #ifndef LV_LVGL_H_INCLUDE_SIMPLE
            #define LV_LVGL_H_INCLUDE_SIMPLE
        #endif
    #endif
#endif

#if defined(LV_LVGL_H_INCLUDE_SIMPLE)
    #include "lvgl.h"
#else
    #include "lvgl/lvgl.h"
#endif

#ifndef ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_16
#define ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_16 1
#endif

#if ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_16

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x8c, 0x8, 0xc0, 0x8c, 0x8, 0xc0, 0x8c, 0x8,
    0xc0, 0x8c, 0x8, 0xc0, 0x11, 0x0, 0x0, 0xce,
    0x1d, 0xf1,

    /* U+0022 "\"" */
    0x8a, 0x7b, 0x8a, 0x7b, 0x8a, 0x7b, 0x66, 0x48,

    /* U+0023 "#" */
    0x0, 0x0, 0x3f, 0x0, 0xa9, 0x0, 0x0, 0x0,
    0x6d, 0x0, 0xd6, 0x0, 0x0, 0x0, 0x8a, 0x0,
    0xf3, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x22, 0xe6, 0x27, 0xe2, 0x21, 0x0, 0x0,
    0xf3, 0x7, 0xc0, 0x0, 0x0, 0x2, 0xf1, 0x9,
    0xa0, 0x0, 0x0, 0x4, 0xe0, 0xb, 0x80, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x2, 0x2b,
    0xa2, 0x4f, 0x42, 0x10, 0x0, 0xd, 0x60, 0x4f,
    0x0, 0x0, 0x0, 0xf, 0x30, 0x7c, 0x0, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0x14, 0x0, 0x0, 0x0, 0x0, 0x29,
    0x0, 0x0, 0x0, 0x5c, 0xff, 0xc4, 0x0, 0x6,
    0xf8, 0x6b, 0x9f, 0x70, 0xc, 0x80, 0x29, 0x7,
    0xf1, 0xc, 0x80, 0x29, 0x0, 0x81, 0x6, 0xf9,
    0x59, 0x0, 0x0, 0x0, 0x4c, 0xfe, 0x82, 0x0,
    0x0, 0x0, 0x4d, 0xcf, 0x90, 0x3, 0x0, 0x29,
    0x4, 0xf6, 0x2f, 0x30, 0x29, 0x0, 0x9b, 0xd,
    0xb0, 0x29, 0x0, 0xba, 0x3, 0xfc, 0x8b, 0x5b,
    0xf3, 0x0, 0x2a, 0xef, 0xea, 0x20, 0x0, 0x0,
    0x29, 0x0, 0x0, 0x0, 0x0, 0x14, 0x0, 0x0,

    /* U+0025 "%" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x30, 0x0,
    0x0, 0x9e, 0xd5, 0x0, 0x0, 0x6e, 0x0, 0x0,
    0x8, 0xc2, 0x5f, 0x20, 0x1, 0xe5, 0x0, 0x0,
    0xe, 0x50, 0xb, 0x70, 0x9, 0xc0, 0x0, 0x0,
    0xf, 0x30, 0x9, 0x90, 0x2f, 0x30, 0x0, 0x0,
    0xe, 0x40, 0xb, 0x70, 0xba, 0x0, 0x0, 0x0,
    0x9, 0xb0, 0x3f, 0x34, 0xf1, 0x4c, 0xe9, 0x0,
    0x1, 0xcf, 0xf7, 0xd, 0x71, 0xf5, 0x1b, 0x90,
    0x0, 0x1, 0x0, 0x7d, 0x6, 0xc0, 0x4, 0xf0,
    0x0, 0x0, 0x1, 0xe5, 0x8, 0xa0, 0x2, 0xf0,
    0x0, 0x0, 0x9, 0xc0, 0x6, 0xc0, 0x4, 0xf0,
    0x0, 0x0, 0x2f, 0x30, 0x1, 0xf6, 0x3c, 0x90,
    0x0, 0x0, 0xb9, 0x0, 0x0, 0x4d, 0xfa, 0x10,
    0x0, 0x1, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0026 "&" */
    0x0, 0x1a, 0xfe, 0x80, 0x0, 0x0, 0xc, 0xc3,
    0x5e, 0x70, 0x0, 0x0, 0xf3, 0x0, 0x68, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0x0, 0x0, 0x4, 0xff, 0x50, 0x39,
    0x0, 0x3, 0xf5, 0x6f, 0x65, 0xe0, 0x0, 0xc8,
    0x0, 0x5f, 0xbe, 0x0, 0xf, 0x40, 0x0, 0x4f,
    0xe0, 0x0, 0xe7, 0x0, 0x0, 0x9f, 0xa0, 0x7,
    0xf7, 0x34, 0x8f, 0x6c, 0x10, 0x6, 0xcf, 0xfb,
    0x40, 0x0,

    /* U+0027 "'" */
    0x8a, 0x8a, 0x8a, 0x66,

    /* U+0028 "(" */
    0x0, 0xa, 0x30, 0x7, 0xe1, 0x1, 0xf4, 0x0,
    0x9c, 0x0, 0xe, 0x50, 0x3, 0xf1, 0x0, 0x6e,
    0x0, 0x7, 0xd0, 0x0, 0x8c, 0x0, 0x6, 0xe0,
    0x0, 0x4f, 0x0, 0x0, 0xf4, 0x0, 0xb, 0xa0,
    0x0, 0x3f, 0x20, 0x0, 0xac, 0x0, 0x0, 0xd4,
    0x0, 0x0, 0x0,

    /* U+0029 ")" */
    0x58, 0x0, 0x2, 0xf5, 0x0, 0x7, 0xe0, 0x0,
    0xe, 0x60, 0x0, 0x8c, 0x0, 0x3, 0xf1, 0x0,
    0xf, 0x40, 0x0, 0xf5, 0x0, 0xf, 0x50, 0x0,
    0xf4, 0x0, 0x2f, 0x20, 0x6, 0xe0, 0x0, 0xc8,
    0x0, 0x4f, 0x10, 0xe, 0x70, 0x6, 0xb0, 0x0,
    0x0, 0x0, 0x0,

    /* U+002A "*" */
    0x0, 0x9, 0x70, 0x0, 0x72, 0x97, 0x45, 0x7,
    0xfe, 0xee, 0x50, 0x5, 0xff, 0x20, 0x1, 0xe5,
    0x8c, 0x0, 0x38, 0x0, 0xa2,

    /* U+002B "+" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0xd, 0x40,
    0x0, 0x0, 0x0, 0xd4, 0x0, 0x0, 0x0, 0xd,
    0x40, 0x0, 0xf, 0xff, 0xff, 0xff, 0x70, 0x22,
    0x2d, 0x62, 0x21, 0x0, 0x0, 0xd4, 0x0, 0x0,
    0x0, 0xd, 0x40, 0x0, 0x0, 0x0, 0xd4, 0x0,
    0x0,

    /* U+002C "," */
    0x7d, 0x58, 0xf6, 0x1d, 0x33, 0x40,

    /* U+002D "-" */
    0x0, 0x0, 0x3, 0xff, 0xff, 0x3, 0x33, 0x30,

    /* U+002E "." */
    0x8e, 0x58, 0xf5,

    /* U+002F "/" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x0,
    0x0, 0xd, 0x40, 0x0, 0x4, 0xc0, 0x0, 0x0,
    0xb5, 0x0, 0x0, 0x3d, 0x0, 0x0, 0xa, 0x60,
    0x0, 0x2, 0xe0, 0x0, 0x0, 0x97, 0x0, 0x0,
    0x1e, 0x10, 0x0, 0x7, 0x90, 0x0, 0x0, 0xe2,
    0x0, 0x0, 0x6a, 0x0, 0x0, 0x4, 0x20, 0x0,
    0x0,

    /* U+0030 "0" */
    0x0, 0x1a, 0xff, 0xa1, 0x0, 0x1, 0xeb, 0x44,
    0xbd, 0x0, 0x9, 0xc0, 0x0, 0xd, 0x80, 0xf,
    0x50, 0x0, 0x6, 0xe0, 0x2f, 0x10, 0x0, 0x2,
    0xf1, 0x4f, 0x0, 0x0, 0x1, 0xf3, 0x4f, 0x0,
    0x0, 0x1, 0xf3, 0x2f, 0x10, 0x0, 0x2, 0xf1,
    0xf, 0x50, 0x0, 0x6, 0xe0, 0x9, 0xc0, 0x0,
    0xd, 0x80, 0x1, 0xeb, 0x44, 0xbd, 0x0, 0x0,
    0x1a, 0xff, 0xa1, 0x0,

    /* U+0031 "1" */
    0x0, 0x1, 0x0, 0x1a, 0xf3, 0x3e, 0xaf, 0x35,
    0x40, 0xf3, 0x0, 0xf, 0x30, 0x0, 0xf3, 0x0,
    0xf, 0x30, 0x0, 0xf3, 0x0, 0xf, 0x30, 0x0,
    0xf3, 0x0, 0xf, 0x30, 0x0, 0xf3,

    /* U+0032 "2" */
    0x0, 0x4c, 0xfd, 0x80, 0x0, 0x3f, 0x83, 0x4d,
    0xb0, 0xc, 0x90, 0x0, 0x2f, 0x20, 0xf3, 0x0,
    0x0, 0xf3, 0x1, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x4, 0xde, 0x50, 0x0,
    0x9, 0xf9, 0x10, 0x0, 0x7, 0xf4, 0x0, 0x0,
    0x0, 0xd8, 0x0, 0x0, 0x0, 0xf, 0x73, 0x33,
    0x33, 0x0, 0xff, 0xff, 0xff, 0xf2,

    /* U+0033 "3" */
    0x0, 0x4c, 0xfd, 0x70, 0x0, 0x4f, 0x73, 0x5e,
    0x70, 0xb, 0x80, 0x0, 0x6d, 0x0, 0x41, 0x0,
    0x6, 0xd0, 0x0, 0x0, 0x3, 0xe6, 0x0, 0x0,
    0x4f, 0xfa, 0x0, 0x0, 0x0, 0x25, 0xd9, 0x0,
    0x30, 0x0, 0x3, 0xf1, 0x2f, 0x10, 0x0, 0x1f,
    0x20, 0xe7, 0x0, 0x4, 0xf0, 0x5, 0xf8, 0x45,
    0xe9, 0x0, 0x5, 0xdf, 0xd8, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x6f, 0xc0, 0x0, 0x0, 0x1e, 0xbc,
    0x0, 0x0, 0x9, 0xa7, 0xc0, 0x0, 0x2, 0xf1,
    0x7c, 0x0, 0x0, 0xc7, 0x7, 0xc0, 0x0, 0x5d,
    0x0, 0x7c, 0x0, 0xe, 0x50, 0x7, 0xc0, 0x8,
    0xb0, 0x0, 0x7c, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0x22, 0x22, 0x22, 0x8d, 0x20, 0x0, 0x0, 0x7,
    0xc0, 0x0,

    /* U+0035 "5" */
    0x2, 0xff, 0xff, 0xf9, 0x0, 0x5d, 0x33, 0x33,
    0x10, 0x9, 0x90, 0x0, 0x0, 0x0, 0xc9, 0xbe,
    0xe9, 0x0, 0xf, 0xe6, 0x35, 0xdb, 0x0, 0x41,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0xc, 0x81,
    0x60, 0x0, 0x0, 0xc7, 0x1f, 0x40, 0x0, 0x2f,
    0x40, 0x8e, 0x73, 0x6e, 0xb0, 0x0, 0x6d, 0xfe,
    0x80, 0x0,

    /* U+0036 "6" */
    0x0, 0x9, 0xef, 0xb3, 0x0, 0xc, 0xd5, 0x4a,
    0xe2, 0x7, 0xe1, 0x0, 0xc, 0x80, 0xe7, 0x0,
    0x0, 0x21, 0x2f, 0x38, 0xde, 0xb3, 0x3, 0xfb,
    0xb4, 0x39, 0xf2, 0x4f, 0xd0, 0x0, 0xb, 0xa3,
    0xf8, 0x0, 0x0, 0x6e, 0xf, 0x80, 0x0, 0x6,
    0xe0, 0xad, 0x0, 0x0, 0xba, 0x1, 0xeb, 0x54,
    0xaf, 0x20, 0x2, 0xae, 0xfb, 0x30,

    /* U+0037 "7" */
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xf9,
    0x23, 0x33, 0x34, 0xf6, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0xd8, 0x0, 0x0, 0x5, 0xf1, 0x0,
    0x0, 0xd, 0x80, 0x0, 0x0, 0x5f, 0x10, 0x0,
    0x0, 0xc9, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x7d, 0xfc, 0x40, 0x0, 0x9d, 0x31, 0x6f,
    0x30, 0xf, 0x50, 0x0, 0xa9, 0x0, 0xf4, 0x0,
    0x9, 0xa0, 0xa, 0xc2, 0x4, 0xf4, 0x0, 0x1e,
    0xff, 0xf9, 0x0, 0xc, 0xc4, 0x36, 0xe7, 0x6,
    0xe0, 0x0, 0x4, 0xf1, 0x9b, 0x0, 0x0, 0x1f,
    0x37, 0xe0, 0x0, 0x4, 0xf1, 0x1e, 0xc5, 0x37,
    0xea, 0x0, 0x1a, 0xef, 0xd7, 0x0,

    /* U+0039 "9" */
    0x0, 0x7e, 0xfd, 0x50, 0x0, 0x9e, 0x53, 0x7f,
    0x50, 0x2f, 0x30, 0x0, 0x8e, 0x6, 0xe0, 0x0,
    0x2, 0xf3, 0x5d, 0x0, 0x0, 0x2f, 0x53, 0xf2,
    0x0, 0x6, 0xf6, 0xc, 0xc2, 0x4, 0xef, 0x50,
    0x1b, 0xff, 0xf6, 0xe4, 0x0, 0x1, 0x20, 0x1f,
    0x10, 0xb6, 0x0, 0x6, 0xd0, 0x6, 0xf6, 0x36,
    0xf5, 0x0, 0x6, 0xdf, 0xd6, 0x0,

    /* U+003A ":" */
    0x8e, 0x58, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0x58, 0xf5,

    /* U+003B ";" */
    0x7e, 0x58, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7d, 0x58, 0xf6, 0x1d, 0x33, 0x40,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xc9,
    0x0, 0x0, 0x8f, 0xa1, 0x0, 0x4e, 0xd4, 0x0,
    0xa, 0xf7, 0x0, 0x0, 0xf, 0xc1, 0x0, 0x0,
    0x2, 0xbf, 0x70, 0x0, 0x0, 0x5, 0xed, 0x30,
    0x0, 0x0, 0x9, 0xf8, 0x0, 0x0, 0x0, 0x33,

    /* U+003D "=" */
    0xf, 0xff, 0xff, 0xfe, 0x3, 0x33, 0x33, 0x32,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xfe,
    0x3, 0x33, 0x33, 0x32,

    /* U+003E ">" */
    0x0, 0x0, 0x0, 0x0, 0xc, 0xa1, 0x0, 0x0,
    0x2, 0xcf, 0x60, 0x0, 0x0, 0x5, 0xec, 0x30,
    0x0, 0x0, 0x19, 0xf8, 0x0, 0x0, 0x3, 0xdc,
    0x0, 0x0, 0x9f, 0x91, 0x0, 0x5e, 0xd3, 0x0,
    0xb, 0xf7, 0x0, 0x0, 0x5, 0x10, 0x0, 0x0,

    /* U+003F "?" */
    0x3, 0xbf, 0xe9, 0x0, 0x2f, 0xb5, 0x6e, 0xb0,
    0x9d, 0x0, 0x4, 0xf1, 0x96, 0x0, 0x3, 0xf2,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x3, 0xdd, 0x20,
    0x0, 0x1e, 0xa0, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0x0, 0x5b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9e, 0x30, 0x0, 0x0, 0xaf, 0x40, 0x0,

    /* U+0040 "@" */
    0x0, 0x2, 0x9e, 0xfe, 0xa3, 0x0, 0x0, 0x4e,
    0x71, 0x1, 0x6e, 0x60, 0x1, 0xe3, 0x0, 0x0,
    0x1, 0xe3, 0x9, 0x80, 0x1a, 0xec, 0x20, 0x7a,
    0xd, 0x20, 0xaa, 0x29, 0xb0, 0x2d, 0xf, 0x0,
    0x2, 0x7d, 0xc0, 0x1e, 0xf, 0x0, 0x7d, 0x66,
    0xc0, 0x2d, 0xe, 0x20, 0xc7, 0xa, 0xe0, 0x89,
    0x9, 0x70, 0x5e, 0xe9, 0x8e, 0xb1, 0x2, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0x61, 0x2,
    0x78, 0x0, 0x0, 0x3, 0xae, 0xfd, 0xa4, 0x0,

    /* U+0041 "A" */
    0x0, 0x1, 0xf8, 0x0, 0x0, 0x0, 0x6, 0xfe,
    0x0, 0x0, 0x0, 0xb, 0x8f, 0x30, 0x0, 0x0,
    0x1f, 0x2a, 0x80, 0x0, 0x0, 0x6d, 0x5, 0xe0,
    0x0, 0x0, 0xc7, 0x0, 0xf3, 0x0, 0x1, 0xf2,
    0x0, 0xa9, 0x0, 0x6, 0xc0, 0x0, 0x4e, 0x0,
    0xc, 0xff, 0xff, 0xff, 0x30, 0x1f, 0x43, 0x33,
    0x3b, 0x90, 0x6d, 0x0, 0x0, 0x5, 0xe0, 0xc9,
    0x0, 0x0, 0x1, 0xf3,

    /* U+0042 "B" */
    0xaf, 0xff, 0xfd, 0x70, 0xa, 0xc4, 0x45, 0x7f,
    0x70, 0xab, 0x0, 0x0, 0x8d, 0xa, 0xb0, 0x0,
    0x7, 0xe0, 0xab, 0x0, 0x3, 0xd8, 0xa, 0xff,
    0xff, 0xfd, 0x10, 0xab, 0x33, 0x35, 0xdc, 0xa,
    0xb0, 0x0, 0x2, 0xf3, 0xab, 0x0, 0x0, 0xf,
    0x5a, 0xb0, 0x0, 0x3, 0xf2, 0xac, 0x44, 0x47,
    0xeb, 0xa, 0xff, 0xff, 0xd8, 0x10,

    /* U+0043 "C" */
    0x0, 0x8, 0xef, 0xd7, 0x0, 0x0, 0xce, 0x75,
    0x8f, 0x90, 0x7, 0xe1, 0x0, 0x4, 0xf4, 0xe,
    0x80, 0x0, 0x0, 0xc9, 0x2f, 0x30, 0x0, 0x0,
    0x10, 0x4f, 0x10, 0x0, 0x0, 0x0, 0x4f, 0x10,
    0x0, 0x0, 0x0, 0x2f, 0x30, 0x0, 0x0, 0x44,
    0xe, 0x80, 0x0, 0x0, 0xd9, 0x8, 0xe1, 0x0,
    0x4, 0xf4, 0x0, 0xce, 0x75, 0x8f, 0xa0, 0x0,
    0x8, 0xef, 0xd8, 0x0,

    /* U+0044 "D" */
    0xaf, 0xff, 0xeb, 0x30, 0xa, 0xc4, 0x46, 0xbf,
    0x40, 0xab, 0x0, 0x0, 0xae, 0xa, 0xb0, 0x0,
    0x1, 0xf5, 0xab, 0x0, 0x0, 0xc, 0x9a, 0xb0,
    0x0, 0x0, 0xaa, 0xab, 0x0, 0x0, 0xa, 0xaa,
    0xb0, 0x0, 0x0, 0xc9, 0xab, 0x0, 0x0, 0xf,
    0x6a, 0xb0, 0x0, 0x9, 0xf1, 0xac, 0x44, 0x5b,
    0xf5, 0xa, 0xff, 0xff, 0xb4, 0x0,

    /* U+0045 "E" */
    0xaf, 0xff, 0xff, 0xf1, 0xac, 0x44, 0x44, 0x40,
    0xab, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x0,
    0xab, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xa0,
    0xac, 0x33, 0x33, 0x20, 0xab, 0x0, 0x0, 0x0,
    0xab, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x0,
    0xac, 0x44, 0x44, 0x40, 0xaf, 0xff, 0xff, 0xf1,

    /* U+0046 "F" */
    0xaf, 0xff, 0xff, 0xf1, 0xac, 0x44, 0x44, 0x40,
    0xab, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x0,
    0xab, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xa0, 0xac, 0x33, 0x33, 0x20,
    0xab, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x0,
    0xab, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x8, 0xef, 0xd7, 0x0, 0x0, 0xce, 0x75,
    0x8f, 0xa0, 0x8, 0xe1, 0x0, 0x3, 0xf4, 0xe,
    0x80, 0x0, 0x0, 0xb7, 0x2f, 0x30, 0x0, 0x0,
    0x0, 0x4f, 0x10, 0x0, 0x0, 0x0, 0x4f, 0x10,
    0x6, 0xff, 0xfb, 0x2f, 0x30, 0x1, 0x33, 0xbb,
    0xe, 0x80, 0x0, 0x0, 0xb9, 0x8, 0xe1, 0x0,
    0x3, 0xf4, 0x0, 0xce, 0x75, 0x8f, 0xa0, 0x0,
    0x8, 0xef, 0xd7, 0x0,

    /* U+0048 "H" */
    0xab, 0x0, 0x0, 0x4f, 0x1a, 0xb0, 0x0, 0x4,
    0xf1, 0xab, 0x0, 0x0, 0x4f, 0x1a, 0xb0, 0x0,
    0x4, 0xf1, 0xab, 0x0, 0x0, 0x4f, 0x1a, 0xff,
    0xff, 0xff, 0xf1, 0xab, 0x33, 0x33, 0x6f, 0x1a,
    0xb0, 0x0, 0x4, 0xf1, 0xab, 0x0, 0x0, 0x4f,
    0x1a, 0xb0, 0x0, 0x4, 0xf1, 0xab, 0x0, 0x0,
    0x4f, 0x1a, 0xb0, 0x0, 0x4, 0xf1,

    /* U+0049 "I" */
    0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab,
    0xab, 0xab, 0xab, 0xab,

    /* U+004A "J" */
    0x0, 0x0, 0x4, 0xf1, 0x0, 0x0, 0x4, 0xf1,
    0x0, 0x0, 0x4, 0xf1, 0x0, 0x0, 0x4, 0xf1,
    0x0, 0x0, 0x4, 0xf1, 0x0, 0x0, 0x4, 0xf1,
    0x0, 0x0, 0x4, 0xf1, 0x0, 0x0, 0x4, 0xf1,
    0x37, 0x0, 0x5, 0xf0, 0x5f, 0x0, 0x8, 0xd0,
    0xe, 0xb5, 0x7f, 0x60, 0x3, 0xcf, 0xe7, 0x0,

    /* U+004B "K" */
    0xab, 0x0, 0x0, 0xdb, 0xa, 0xb0, 0x0, 0xad,
    0x10, 0xab, 0x0, 0x6f, 0x30, 0xa, 0xb0, 0x3f,
    0x60, 0x0, 0xab, 0x1e, 0x90, 0x0, 0xa, 0xbb,
    0xf3, 0x0, 0x0, 0xaf, 0xec, 0xc0, 0x0, 0xa,
    0xf4, 0x2f, 0x80, 0x0, 0xab, 0x0, 0x6f, 0x30,
    0xa, 0xb0, 0x0, 0xcd, 0x0, 0xab, 0x0, 0x2,
    0xf8, 0xa, 0xb0, 0x0, 0x7, 0xf3,

    /* U+004C "L" */
    0xab, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0xab,
    0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0xab, 0x0,
    0x0, 0xa, 0xb0, 0x0, 0x0, 0xab, 0x0, 0x0,
    0xa, 0xb0, 0x0, 0x0, 0xab, 0x0, 0x0, 0xa,
    0xb0, 0x0, 0x0, 0xac, 0x44, 0x44, 0x3a, 0xff,
    0xff, 0xfc,

    /* U+004D "M" */
    0xaf, 0x50, 0x0, 0x0, 0xc, 0xf3, 0xaf, 0xb0,
    0x0, 0x0, 0x2f, 0xf3, 0xad, 0xf1, 0x0, 0x0,
    0x8d, 0xf3, 0xab, 0xc7, 0x0, 0x0, 0xe7, 0xf3,
    0xab, 0x6d, 0x0, 0x4, 0xe2, 0xf3, 0xab, 0x1f,
    0x30, 0xa, 0x92, 0xf3, 0xab, 0xa, 0x90, 0x1f,
    0x32, 0xf3, 0xab, 0x4, 0xf0, 0x6c, 0x2, 0xf3,
    0xab, 0x0, 0xd5, 0xc6, 0x2, 0xf3, 0xab, 0x0,
    0x7e, 0xf1, 0x2, 0xf3, 0xab, 0x0, 0x1f, 0xa0,
    0x2, 0xf3, 0xab, 0x0, 0xb, 0x40, 0x2, 0xf3,

    /* U+004E "N" */
    0xaf, 0x20, 0x0, 0xf, 0x6a, 0xfb, 0x0, 0x0,
    0xf6, 0xad, 0xf3, 0x0, 0xf, 0x6a, 0xb9, 0xb0,
    0x0, 0xf6, 0xab, 0x1f, 0x40, 0xf, 0x6a, 0xb0,
    0x9c, 0x0, 0xf6, 0xab, 0x1, 0xf4, 0xf, 0x6a,
    0xb0, 0x8, 0xd0, 0xf6, 0xab, 0x0, 0x1f, 0x5f,
    0x6a, 0xb0, 0x0, 0x7d, 0xf6, 0xab, 0x0, 0x0,
    0xef, 0x6a, 0xb0, 0x0, 0x7, 0xf6,

    /* U+004F "O" */
    0x0, 0x8, 0xef, 0xd7, 0x0, 0x0, 0xc, 0xe7,
    0x57, 0xfa, 0x0, 0x7, 0xe1, 0x0, 0x3, 0xf5,
    0x0, 0xe8, 0x0, 0x0, 0xa, 0xc0, 0x2f, 0x30,
    0x0, 0x0, 0x5f, 0x4, 0xf1, 0x0, 0x0, 0x3,
    0xf1, 0x4f, 0x10, 0x0, 0x0, 0x3f, 0x12, 0xf3,
    0x0, 0x0, 0x5, 0xf0, 0xe, 0x80, 0x0, 0x0,
    0xac, 0x0, 0x8e, 0x10, 0x0, 0x2f, 0x50, 0x0,
    0xce, 0x75, 0x7f, 0xa0, 0x0, 0x0, 0x8e, 0xfd,
    0x70, 0x0,

    /* U+0050 "P" */
    0xaf, 0xff, 0xfd, 0x91, 0xa, 0xc4, 0x44, 0x6d,
    0xc0, 0xab, 0x0, 0x0, 0x2f, 0x3a, 0xb0, 0x0,
    0x0, 0xe6, 0xab, 0x0, 0x0, 0xf, 0x4a, 0xb0,
    0x0, 0x2b, 0xe0, 0xaf, 0xff, 0xff, 0xd3, 0xa,
    0xc3, 0x33, 0x10, 0x0, 0xab, 0x0, 0x0, 0x0,
    0xa, 0xb0, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0,
    0x0, 0xa, 0xb0, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x8, 0xef, 0xd7, 0x0, 0x0, 0xc, 0xe7,
    0x57, 0xfa, 0x0, 0x7, 0xe1, 0x0, 0x3, 0xf5,
    0x0, 0xe8, 0x0, 0x0, 0xa, 0xc0, 0x2f, 0x30,
    0x0, 0x0, 0x5f, 0x4, 0xf1, 0x0, 0x0, 0x3,
    0xf1, 0x4f, 0x10, 0x1, 0x0, 0x3f, 0x12, 0xf3,
    0x0, 0xaa, 0x5, 0xf0, 0xe, 0x80, 0x1, 0xd9,
    0xac, 0x0, 0x8e, 0x10, 0x1, 0xef, 0x60, 0x0,
    0xce, 0x75, 0x8f, 0xf6, 0x0, 0x0, 0x8e, 0xfd,
    0x73, 0xb0,

    /* U+0052 "R" */
    0xaf, 0xff, 0xfd, 0x70, 0xa, 0xc4, 0x45, 0x8f,
    0x80, 0xab, 0x0, 0x0, 0x6f, 0xa, 0xb0, 0x0,
    0x2, 0xf2, 0xab, 0x0, 0x0, 0x4f, 0xa, 0xb0,
    0x1, 0x4d, 0xa0, 0xaf, 0xff, 0xff, 0x90, 0xa,
    0xc3, 0x3e, 0x90, 0x0, 0xab, 0x0, 0x7f, 0x10,
    0xa, 0xb0, 0x0, 0xe9, 0x0, 0xab, 0x0, 0x7,
    0xf1, 0xa, 0xb0, 0x0, 0xe, 0x90,

    /* U+0053 "S" */
    0x0, 0x5c, 0xfd, 0x91, 0x0, 0x6, 0xf8, 0x57,
    0xdd, 0x0, 0xc, 0x90, 0x0, 0x1f, 0x70, 0xc,
    0x90, 0x0, 0x6, 0x40, 0x6, 0xf9, 0x20, 0x0,
    0x0, 0x0, 0x5d, 0xfc, 0x60, 0x0, 0x0, 0x0,
    0x39, 0xfd, 0x10, 0x3, 0x0, 0x0, 0x1c, 0xb0,
    0x5f, 0x10, 0x0, 0x5, 0xf0, 0x1f, 0x80, 0x0,
    0x6, 0xf0, 0x7, 0xfa, 0x65, 0x8f, 0x80, 0x0,
    0x5c, 0xff, 0xc6, 0x0,

    /* U+0054 "T" */
    0x7f, 0xff, 0xff, 0xff, 0xd2, 0x44, 0x4f, 0x84,
    0x44, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x0, 0xf, 0x60, 0x0, 0x0, 0x0, 0xf6, 0x0,
    0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0,

    /* U+0055 "U" */
    0xb9, 0x0, 0x0, 0xf, 0x5b, 0x90, 0x0, 0x0,
    0xf5, 0xb9, 0x0, 0x0, 0xf, 0x5b, 0x90, 0x0,
    0x0, 0xf5, 0xb9, 0x0, 0x0, 0xf, 0x5b, 0x90,
    0x0, 0x0, 0xf5, 0xb9, 0x0, 0x0, 0xf, 0x5b,
    0x90, 0x0, 0x0, 0xf4, 0xab, 0x0, 0x0, 0x1f,
    0x47, 0xe1, 0x0, 0x6, 0xf1, 0x1e, 0xd6, 0x58,
    0xf9, 0x0, 0x2a, 0xef, 0xd7, 0x0,

    /* U+0056 "V" */
    0xca, 0x0, 0x0, 0x0, 0xf6, 0x6e, 0x0, 0x0,
    0x5, 0xf1, 0x1f, 0x40, 0x0, 0xa, 0xb0, 0xc,
    0x90, 0x0, 0xf, 0x50, 0x6, 0xe0, 0x0, 0x5f,
    0x0, 0x1, 0xf4, 0x0, 0xab, 0x0, 0x0, 0xb9,
    0x0, 0xf5, 0x0, 0x0, 0x6e, 0x4, 0xf0, 0x0,
    0x0, 0x1f, 0x4a, 0xb0, 0x0, 0x0, 0xb, 0x9f,
    0x50, 0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x0,
    0x1, 0xfa, 0x0, 0x0,

    /* U+0057 "W" */
    0x9c, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xf1, 0x6f,
    0x0, 0x4, 0xfc, 0x0, 0x6, 0xf0, 0x4f, 0x10,
    0x9, 0xdf, 0x10, 0x9, 0xc0, 0x1f, 0x40, 0xd,
    0x6e, 0x50, 0xc, 0x90, 0xe, 0x70, 0x2f, 0x2a,
    0xa0, 0xe, 0x60, 0xb, 0x90, 0x7d, 0x5, 0xe0,
    0x1f, 0x30, 0x9, 0xc0, 0xb8, 0x1, 0xf3, 0x4f,
    0x10, 0x6, 0xf0, 0xf4, 0x0, 0xc8, 0x6e, 0x0,
    0x3, 0xf6, 0xf0, 0x0, 0x7c, 0x9b, 0x0, 0x0,
    0xfd, 0xb0, 0x0, 0x3f, 0xd8, 0x0, 0x0, 0xdf,
    0x60, 0x0, 0xe, 0xf6, 0x0, 0x0, 0xbf, 0x20,
    0x0, 0xa, 0xf3, 0x0,

    /* U+0058 "X" */
    0x7f, 0x10, 0x0, 0x3f, 0x50, 0xda, 0x0, 0xc,
    0xc0, 0x5, 0xf2, 0x4, 0xf3, 0x0, 0xc, 0xb0,
    0xd9, 0x0, 0x0, 0x3f, 0xaf, 0x10, 0x0, 0x0,
    0xaf, 0x70, 0x0, 0x0, 0xb, 0xf9, 0x0, 0x0,
    0x4, 0xf7, 0xf2, 0x0, 0x0, 0xd9, 0xb, 0xb0,
    0x0, 0x6f, 0x10, 0x3f, 0x40, 0x1e, 0x80, 0x0,
    0xad, 0x8, 0xe1, 0x0, 0x2, 0xf6,

    /* U+0059 "Y" */
    0xbc, 0x0, 0x0, 0xa, 0xd0, 0x2f, 0x50, 0x0,
    0x3f, 0x50, 0x9, 0xd0, 0x0, 0xbc, 0x0, 0x1,
    0xf6, 0x4, 0xf3, 0x0, 0x0, 0x7e, 0xc, 0xa0,
    0x0, 0x0, 0xe, 0xcf, 0x10, 0x0, 0x0, 0x5,
    0xf8, 0x0, 0x0, 0x0, 0x1, 0xf4, 0x0, 0x0,
    0x0, 0x1, 0xf4, 0x0, 0x0, 0x0, 0x1, 0xf4,
    0x0, 0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x0,
    0x1, 0xf4, 0x0, 0x0,

    /* U+005A "Z" */
    0xf, 0xff, 0xff, 0xff, 0xc0, 0x55, 0x55, 0x56,
    0xf8, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x0,
    0x4f, 0x30, 0x0, 0x0, 0x1e, 0x80, 0x0, 0x0,
    0xa, 0xd0, 0x0, 0x0, 0x5, 0xf2, 0x0, 0x0,
    0x1, 0xe7, 0x0, 0x0, 0x0, 0xbc, 0x0, 0x0,
    0x0, 0x5f, 0x20, 0x0, 0x0, 0x1f, 0xb5, 0x55,
    0x55, 0x34, 0xff, 0xff, 0xff, 0xf9,

    /* U+005B "[" */
    0xaf, 0xf9, 0xab, 0x32, 0xaa, 0x0, 0xaa, 0x0,
    0xaa, 0x0, 0xaa, 0x0, 0xaa, 0x0, 0xaa, 0x0,
    0xaa, 0x0, 0xaa, 0x0, 0xaa, 0x0, 0xaa, 0x0,
    0xaa, 0x0, 0xab, 0x32, 0xaf, 0xf9,

    /* U+005C "\\" */
    0x0, 0x0, 0x0, 0x8, 0x70, 0x0, 0x0, 0x2e,
    0x0, 0x0, 0x0, 0xb6, 0x0, 0x0, 0x3, 0xd0,
    0x0, 0x0, 0xc, 0x40, 0x0, 0x0, 0x5c, 0x0,
    0x0, 0x0, 0xd3, 0x0, 0x0, 0x6, 0xa0, 0x0,
    0x0, 0xe, 0x20, 0x0, 0x0, 0x79, 0x0, 0x0,
    0x1, 0xe1, 0x0, 0x0, 0x8, 0x80, 0x0, 0x0,
    0x15,

    /* U+005D "]" */
    0xaf, 0xf9, 0x23, 0xc9, 0x0, 0xb9, 0x0, 0xb9,
    0x0, 0xb9, 0x0, 0xb9, 0x0, 0xb9, 0x0, 0xb9,
    0x0, 0xb9, 0x0, 0xb9, 0x0, 0xb9, 0x0, 0xb9,
    0x0, 0xb9, 0x23, 0xc9, 0xaf, 0xf9,

    /* U+005E "^" */
    0x0, 0x5f, 0x20, 0x0, 0xc, 0xea, 0x0, 0x4,
    0xf3, 0xf2, 0x0, 0xb9, 0xb, 0x90, 0x2f, 0x20,
    0x4f, 0x1a, 0xb0, 0x0, 0xd8,

    /* U+005F "_" */
    0x2f, 0xff, 0xff, 0xff, 0xc0, 0x22, 0x22, 0x22,
    0x22,

    /* U+0060 "`" */
    0x9, 0xd0, 0x0, 0xc6,

    /* U+0061 "a" */
    0x1, 0x9e, 0xfb, 0x20, 0xb, 0xd4, 0x3a, 0xd0,
    0x1e, 0x20, 0x3, 0xf1, 0x0, 0x0, 0x5c, 0xf3,
    0x2, 0xaf, 0xd6, 0xf3, 0xe, 0xa2, 0x1, 0xf3,
    0x3f, 0x0, 0x3, 0xf3, 0x1f, 0x83, 0x5d, 0xf3,
    0x4, 0xdf, 0xd5, 0xf3,

    /* U+0062 "b" */
    0xf4, 0x0, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x0,
    0xf4, 0x0, 0x0, 0x0, 0xf6, 0xbf, 0xe9, 0x0,
    0xff, 0x94, 0x5e, 0xb0, 0xfa, 0x0, 0x2, 0xf4,
    0xf5, 0x0, 0x0, 0xb8, 0xf4, 0x0, 0x0, 0xa9,
    0xf5, 0x0, 0x0, 0xc8, 0xfa, 0x0, 0x2, 0xf4,
    0xff, 0x94, 0x5e, 0xb0, 0xf6, 0xcf, 0xe9, 0x0,

    /* U+0063 "c" */
    0x0, 0x5d, 0xfd, 0x80, 0x0, 0x5f, 0x84, 0x6e,
    0xa0, 0xe, 0x80, 0x0, 0x3f, 0x22, 0xf2, 0x0,
    0x0, 0x40, 0x4f, 0x0, 0x0, 0x0, 0x2, 0xf2,
    0x0, 0x0, 0x40, 0xe, 0x80, 0x0, 0x3f, 0x20,
    0x5f, 0x84, 0x5e, 0xa0, 0x0, 0x5d, 0xfd, 0x80,
    0x0,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0,
    0xe5, 0x0, 0x0, 0x0, 0xe, 0x50, 0x5, 0xdf,
    0xd5, 0xe5, 0x5, 0xf8, 0x46, 0xef, 0x50, 0xe8,
    0x0, 0x4, 0xf5, 0x2f, 0x10, 0x0, 0xf, 0x54,
    0xf0, 0x0, 0x0, 0xe5, 0x2f, 0x10, 0x0, 0xf,
    0x50, 0xe8, 0x0, 0x4, 0xf5, 0x6, 0xf8, 0x46,
    0xef, 0x50, 0x5, 0xdf, 0xd6, 0xe5,

    /* U+0065 "e" */
    0x0, 0x5d, 0xfe, 0x80, 0x0, 0x5f, 0x83, 0x6e,
    0x90, 0xe, 0x80, 0x0, 0x4f, 0x22, 0xf2, 0x0,
    0x0, 0xe5, 0x4f, 0xee, 0xee, 0xef, 0x72, 0xf2,
    0x11, 0x11, 0x10, 0xe, 0x60, 0x0, 0x18, 0x0,
    0x5f, 0x73, 0x4c, 0xc0, 0x0, 0x5d, 0xfe, 0x90,
    0x0,

    /* U+0066 "f" */
    0x0, 0x8f, 0xe0, 0x2, 0xf6, 0x20, 0x3, 0xf0,
    0x0, 0xbf, 0xff, 0xf2, 0x15, 0xf2, 0x20, 0x3,
    0xf0, 0x0, 0x3, 0xf0, 0x0, 0x3, 0xf0, 0x0,
    0x3, 0xf0, 0x0, 0x3, 0xf0, 0x0, 0x3, 0xf0,
    0x0, 0x3, 0xf0, 0x0,

    /* U+0067 "g" */
    0x0, 0x5d, 0xfd, 0x5e, 0x50, 0x5f, 0x84, 0x6e,
    0xf5, 0xe, 0x80, 0x0, 0x4f, 0x52, 0xf1, 0x0,
    0x0, 0xf5, 0x4f, 0x0, 0x0, 0xe, 0x52, 0xf1,
    0x0, 0x0, 0xf5, 0xe, 0x80, 0x0, 0x4f, 0x50,
    0x5f, 0x84, 0x6e, 0xf5, 0x0, 0x5d, 0xfd, 0x5e,
    0x50, 0x0, 0x0, 0x0, 0xf4, 0x4, 0xc0, 0x0,
    0x2f, 0x20, 0x2f, 0x81, 0x2c, 0xb0, 0x0, 0x4d,
    0xff, 0xc1, 0x0, 0x0, 0x2, 0x10, 0x0,

    /* U+0068 "h" */
    0xf4, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0xf4,
    0x0, 0x0, 0xf, 0x7b, 0xfd, 0x70, 0xff, 0x73,
    0x7f, 0x6f, 0x80, 0x0, 0x8c, 0xf5, 0x0, 0x5,
    0xef, 0x40, 0x0, 0x5e, 0xf4, 0x0, 0x5, 0xef,
    0x40, 0x0, 0x5e, 0xf4, 0x0, 0x5, 0xef, 0x40,
    0x0, 0x5e,

    /* U+0069 "i" */
    0x1f, 0x60, 0x62, 0x0, 0x0, 0xf4, 0xf, 0x40,
    0xf4, 0xf, 0x40, 0xf4, 0xf, 0x40, 0xf4, 0xf,
    0x40, 0xf4,

    /* U+006A "j" */
    0x0, 0xe9, 0x0, 0x53, 0x0, 0x0, 0x0, 0xc7,
    0x0, 0xc7, 0x0, 0xc7, 0x0, 0xc7, 0x0, 0xc7,
    0x0, 0xc7, 0x0, 0xc7, 0x0, 0xc7, 0x0, 0xc7,
    0x0, 0xd7, 0x2f, 0xf3, 0x2, 0x0,

    /* U+006B "k" */
    0xf4, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0xf4,
    0x0, 0x0, 0xf, 0x40, 0x6, 0xf3, 0xf4, 0x5,
    0xf4, 0xf, 0x43, 0xf5, 0x0, 0xf7, 0xea, 0x0,
    0xf, 0xfb, 0xf2, 0x0, 0xf9, 0xb, 0xb0, 0xf,
    0x40, 0x2f, 0x50, 0xf4, 0x0, 0x8e, 0xf, 0x40,
    0x0, 0xe8,

    /* U+006C "l" */
    0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4,
    0xf4, 0xf4, 0xf4, 0xf4,

    /* U+006D "m" */
    0xf8, 0xcf, 0xb2, 0x9e, 0xe9, 0xf, 0xe5, 0x4d,
    0xfd, 0x45, 0xe9, 0xf7, 0x0, 0x3f, 0x30, 0x6,
    0xef, 0x40, 0x1, 0xf1, 0x0, 0x4f, 0xf4, 0x0,
    0x1f, 0x10, 0x4, 0xff, 0x40, 0x1, 0xf1, 0x0,
    0x4f, 0xf4, 0x0, 0x1f, 0x10, 0x4, 0xff, 0x40,
    0x1, 0xf1, 0x0, 0x4f, 0xf4, 0x0, 0x1f, 0x10,
    0x4, 0xf0,

    /* U+006E "n" */
    0xf7, 0xcf, 0xd7, 0xf, 0xf7, 0x37, 0xf6, 0xf8,
    0x0, 0x8, 0xcf, 0x50, 0x0, 0x5e, 0xf4, 0x0,
    0x5, 0xef, 0x40, 0x0, 0x5e, 0xf4, 0x0, 0x5,
    0xef, 0x40, 0x0, 0x5e, 0xf4, 0x0, 0x5, 0xe0,

    /* U+006F "o" */
    0x0, 0x5c, 0xfe, 0x90, 0x0, 0x5f, 0x84, 0x5d,
    0xc0, 0xe, 0x80, 0x0, 0x1f, 0x52, 0xf1, 0x0,
    0x0, 0xa9, 0x4f, 0x0, 0x0, 0x9, 0xb2, 0xf1,
    0x0, 0x0, 0xa9, 0xe, 0x80, 0x0, 0x1f, 0x50,
    0x5f, 0x84, 0x5d, 0xc0, 0x0, 0x5c, 0xfe, 0x90,
    0x0,

    /* U+0070 "p" */
    0xf6, 0xbf, 0xe9, 0x0, 0xff, 0x94, 0x5e, 0xb0,
    0xfa, 0x0, 0x2, 0xf4, 0xf5, 0x0, 0x0, 0xc8,
    0xf4, 0x0, 0x0, 0xa9, 0xf5, 0x0, 0x0, 0xc8,
    0xfa, 0x0, 0x2, 0xf4, 0xff, 0x94, 0x5e, 0xb0,
    0xf6, 0xbf, 0xe9, 0x0, 0xf4, 0x0, 0x0, 0x0,
    0xf4, 0x0, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x0,
    0x72, 0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x5d, 0xfd, 0x5e, 0x50, 0x5f, 0x84, 0x6e,
    0xf5, 0xe, 0x80, 0x0, 0x4f, 0x52, 0xf1, 0x0,
    0x0, 0xf5, 0x4f, 0x0, 0x0, 0xe, 0x52, 0xf1,
    0x0, 0x0, 0xf5, 0xe, 0x80, 0x0, 0x4f, 0x50,
    0x6f, 0x84, 0x6e, 0xf5, 0x0, 0x5d, 0xfd, 0x5e,
    0x50, 0x0, 0x0, 0x0, 0xe5, 0x0, 0x0, 0x0,
    0xe, 0x50, 0x0, 0x0, 0x0, 0xe5, 0x0, 0x0,
    0x0, 0x6, 0x20,

    /* U+0072 "r" */
    0x0, 0x0, 0xfa, 0xec, 0xfd, 0x32, 0xf6, 0x0,
    0xf4, 0x0, 0xf4, 0x0, 0xf4, 0x0, 0xf4, 0x0,
    0xf4, 0x0, 0xf4, 0x0,

    /* U+0073 "s" */
    0x1, 0xaf, 0xe9, 0x10, 0xc, 0xc4, 0x5d, 0xb0,
    0xf, 0x40, 0x2, 0xb1, 0xa, 0xe7, 0x20, 0x0,
    0x0, 0x5b, 0xfc, 0x30, 0x14, 0x0, 0x18, 0xf2,
    0x4f, 0x10, 0x0, 0xd6, 0xc, 0xc5, 0x38, 0xf3,
    0x1, 0x9e, 0xfc, 0x50,

    /* U+0074 "t" */
    0x3, 0x60, 0x0, 0x6d, 0x0, 0xbf, 0xff, 0xe1,
    0x7d, 0x22, 0x6, 0xd0, 0x0, 0x6d, 0x0, 0x6,
    0xd0, 0x0, 0x6d, 0x0, 0x6, 0xd0, 0x0, 0x5f,
    0x41, 0x0, 0xcf, 0x70,

    /* U+0075 "u" */
    0xf, 0x30, 0x0, 0x8b, 0xf, 0x30, 0x0, 0x8b,
    0xf, 0x30, 0x0, 0x8b, 0xf, 0x30, 0x0, 0x8b,
    0xf, 0x30, 0x0, 0x8b, 0xf, 0x30, 0x0, 0x8b,
    0xe, 0x60, 0x0, 0xcb, 0x9, 0xe5, 0x49, 0xfb,
    0x0, 0xae, 0xfa, 0x9b,

    /* U+0076 "v" */
    0xab, 0x0, 0x0, 0x1f, 0x33, 0xf1, 0x0, 0x8,
    0xd0, 0xd, 0x70, 0x0, 0xe6, 0x0, 0x7d, 0x0,
    0x4f, 0x10, 0x1, 0xf3, 0xa, 0x90, 0x0, 0xa,
    0x91, 0xf3, 0x0, 0x0, 0x4f, 0x7d, 0x0, 0x0,
    0x0, 0xdf, 0x60, 0x0, 0x0, 0x7, 0xf1, 0x0,
    0x0,

    /* U+0077 "w" */
    0x7b, 0x0, 0xb, 0xc0, 0x0, 0xa9, 0x4f, 0x0,
    0xf, 0xf1, 0x0, 0xe5, 0xf, 0x20, 0x5b, 0xa6,
    0x1, 0xf1, 0xc, 0x60, 0xa6, 0x5b, 0x5, 0xe0,
    0x9, 0x90, 0xf1, 0xf, 0x18, 0xa0, 0x5, 0xd5,
    0xc0, 0xa, 0x6c, 0x60, 0x2, 0xfb, 0x60, 0x5,
    0xbf, 0x30, 0x0, 0xef, 0x10, 0x0, 0xff, 0x0,
    0x0, 0xac, 0x0, 0x0, 0xbc, 0x0,

    /* U+0078 "x" */
    0x8e, 0x0, 0x7, 0xe1, 0xd, 0x90, 0x1f, 0x50,
    0x3, 0xf3, 0xbb, 0x0, 0x0, 0x9e, 0xf2, 0x0,
    0x0, 0x2f, 0xa0, 0x0, 0x0, 0xbc, 0xf3, 0x0,
    0x5, 0xf2, 0x9c, 0x0, 0x1e, 0x70, 0x1e, 0x70,
    0x9d, 0x0, 0x5, 0xf2,

    /* U+0079 "y" */
    0xab, 0x0, 0x0, 0x8c, 0x3, 0xf1, 0x0, 0xe,
    0x60, 0xd, 0x70, 0x4, 0xf0, 0x0, 0x6d, 0x0,
    0xb9, 0x0, 0x0, 0xf4, 0x1f, 0x20, 0x0, 0x9,
    0xa7, 0xc0, 0x0, 0x0, 0x2f, 0xe5, 0x0, 0x0,
    0x0, 0xce, 0x0, 0x0, 0x0, 0xb, 0x80, 0x0,
    0x0, 0x2, 0xf2, 0x0, 0x0, 0x0, 0x8b, 0x0,
    0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x2, 0x70,
    0x0, 0x0, 0x0,

    /* U+007A "z" */
    0x5f, 0xff, 0xff, 0xf6, 0x2, 0x22, 0x28, 0xf2,
    0x0, 0x0, 0x3f, 0x40, 0x0, 0x1, 0xe7, 0x0,
    0x0, 0xc, 0xa0, 0x0, 0x0, 0x9d, 0x0, 0x0,
    0x6, 0xe2, 0x0, 0x0, 0x3f, 0x72, 0x22, 0x21,
    0x8f, 0xff, 0xff, 0xf8,

    /* U+007B "{" */
    0x0, 0x2d, 0xf8, 0x0, 0x9d, 0x52, 0x0, 0xb9,
    0x0, 0x0, 0xb8, 0x0, 0x0, 0xb8, 0x0, 0x0,
    0xb8, 0x0, 0x8, 0xf5, 0x0, 0xf, 0xe1, 0x0,
    0x0, 0xd8, 0x0, 0x0, 0xb8, 0x0, 0x0, 0xb8,
    0x0, 0x0, 0xb8, 0x0, 0x0, 0xb9, 0x0, 0x0,
    0x9d, 0x52, 0x0, 0x2d, 0xf8,

    /* U+007C "|" */
    0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68,
    0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68,
    0x68, 0x68,

    /* U+007D "}" */
    0xaf, 0xc1, 0x3, 0x6f, 0x70, 0x0, 0xb9, 0x0,
    0xb, 0x90, 0x0, 0xb9, 0x0, 0xb, 0x90, 0x0,
    0x8e, 0x70, 0x3, 0xfe, 0x0, 0xab, 0x0, 0xb,
    0x90, 0x0, 0xb9, 0x0, 0xb, 0x90, 0x0, 0xb9,
    0x2, 0x5f, 0x70, 0xaf, 0xc1, 0x0,

    /* U+007E "~" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xdf, 0xc6,
    0x15, 0xe0, 0xd, 0x70, 0x6d, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x21, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 69, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 100, .box_w = 3, .box_h = 12, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 18, .adv_w = 99, .box_w = 4, .box_h = 4, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 26, .adv_w = 201, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 98, .adv_w = 168, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 178, .adv_w = 257, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 306, .adv_w = 172, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 372, .adv_w = 65, .box_w = 2, .box_h = 4, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 376, .adv_w = 94, .box_w = 5, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 419, .adv_w = 94, .box_w = 5, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 462, .adv_w = 125, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 483, .adv_w = 151, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 524, .adv_w = 78, .box_w = 3, .box_h = 4, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 530, .adv_w = 93, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 538, .adv_w = 77, .box_w = 3, .box_h = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 541, .adv_w = 114, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 590, .adv_w = 159, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 650, .adv_w = 93, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 680, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 734, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 788, .adv_w = 138, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 838, .adv_w = 146, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 888, .adv_w = 152, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 942, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 990, .adv_w = 138, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1044, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1098, .adv_w = 77, .box_w = 3, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1110, .adv_w = 78, .box_w = 3, .box_h = 10, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 1125, .adv_w = 141, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1165, .adv_w = 142, .box_w = 8, .box_h = 5, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 1185, .adv_w = 141, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1225, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1273, .adv_w = 207, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1345, .adv_w = 152, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1405, .adv_w = 162, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1459, .adv_w = 166, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1519, .adv_w = 167, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1573, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1621, .adv_w = 141, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1669, .adv_w = 167, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1729, .adv_w = 167, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1783, .adv_w = 65, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1795, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1843, .adv_w = 154, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1897, .adv_w = 133, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1939, .adv_w = 217, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2011, .adv_w = 172, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2065, .adv_w = 174, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2131, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2185, .adv_w = 174, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2251, .adv_w = 156, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2305, .adv_w = 154, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2365, .adv_w = 151, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2419, .adv_w = 169, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2473, .adv_w = 154, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2533, .adv_w = 216, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2617, .adv_w = 142, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2671, .adv_w = 147, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2731, .adv_w = 152, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2785, .adv_w = 79, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2815, .adv_w = 114, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2864, .adv_w = 79, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2894, .adv_w = 142, .box_w = 7, .box_h = 6, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 2915, .adv_w = 154, .box_w = 9, .box_h = 2, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2924, .adv_w = 75, .box_w = 4, .box_h = 2, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 2928, .adv_w = 131, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2964, .adv_w = 150, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3012, .adv_w = 144, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3053, .adv_w = 150, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3107, .adv_w = 147, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3148, .adv_w = 87, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3184, .adv_w = 149, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 3247, .adv_w = 142, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3289, .adv_w = 54, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3307, .adv_w = 56, .box_w = 4, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 3337, .adv_w = 131, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3379, .adv_w = 54, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3391, .adv_w = 207, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3441, .adv_w = 142, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3473, .adv_w = 151, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3514, .adv_w = 150, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 3566, .adv_w = 150, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3625, .adv_w = 83, .box_w = 4, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3645, .adv_w = 129, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3681, .adv_w = 87, .box_w = 5, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3709, .adv_w = 140, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3745, .adv_w = 137, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3786, .adv_w = 193, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3840, .adv_w = 120, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3876, .adv_w = 131, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3935, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3971, .adv_w = 93, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4016, .adv_w = 67, .box_w = 2, .box_h = 18, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 4034, .adv_w = 93, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4072, .adv_w = 162, .box_w = 10, .box_h = 4, .ofs_x = 0, .ofs_y = 4}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 2, 3, 0, 0, 0, 0,
    3, 4, 4, 5, 0, 6, 7, 6,
    8, 9, 10, 11, 12, 13, 14, 15,
    16, 17, 9, 0, 0, 0, 0, 0,
    2, 0, 18, 19, 20, 21, 22, 23,
    21, 24, 24, 25, 26, 27, 24, 24,
    21, 28, 29, 30, 31, 32, 25, 33,
    34, 26, 35, 36, 37, 38, 37, 0,
    6, 0, 39, 40, 40, 41, 40, 42,
    43, 39, 44, 44, 45, 41, 39, 39,
    40, 40, 0, 46, 47, 48, 49, 50,
    51, 45, 52, 53, 37, 0, 37, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 0, 1, 0, 0, 0, 0,
    1, 2, 2, 3, 0, 4, 5, 4,
    6, 7, 8, 9, 10, 11, 12, 7,
    13, 14, 15, 16, 16, 0, 0, 0,
    17, 0, 18, 19, 20, 19, 19, 19,
    20, 19, 19, 21, 19, 19, 19, 19,
    20, 19, 20, 19, 22, 23, 24, 25,
    26, 27, 28, 29, 30, 31, 30, 0,
    4, 0, 32, 33, 34, 34, 34, 35,
    34, 33, 36, 37, 33, 33, 38, 38,
    34, 38, 34, 38, 39, 40, 41, 42,
    43, 44, 45, 46, 30, 0, 30, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, -10, 0, -20, 0,
    -8, -5, -3, -10, 0, 0, 0, -8,
    0, -8, -5, 0, 0, 0, -5, -5,
    0, -10, -5, -8, -10, 0, -13, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -31,
    0, 0, -5, 0, 0, 0, -18, -5,
    3, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, -3, -10, 0,
    3, 0, 3, 3, 3, 3, 0, 0,
    0, -8, 5, -8, 0, 8, 8, 0,
    0, 0, 0, -5, -3, -5, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 3, 0, 0, 0, -15, 3,
    0, 0, 0, 0, 0, 0, -36, -13,
    0, 0, 0, 0, -10, -25, 0, 0,
    3, -5, -18, 0, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -13, 0, 0,
    0, 0, 5, 0, 0, 0, 10, 8,
    -18, 7, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -38,
    0, 0, 0, -5, 0, 0, 0, 0,
    0, 0, 0, -18, 3, -8, -31, -8,
    8, 8, 8, 5, 8, 8, 3, 0,
    0, -20, 5, -28, 3, 8, 8, -10,
    -20, 0, 0, 0, 0, -13, 0, -8,
    -5, 0, 0, -10, 5, 0, 0, -3,
    -8, -5, -3, -3, -10, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, -8, 0, 0, -5, -5, -5,
    0, 0, -3, 0, 0, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -8, -5, -5, -5, -8, -5,
    -10, -3, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, -5, -5, 0, 0, 0, -8, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -8, 0, 0, 0, 0, 0, -3, -5,
    0, 0, 0, 0, -8, 0, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -8, 0,
    0, 0, 0, 0, 0, -10, -5, -3,
    0, 0, -8, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -8, 0, 0, 0,
    0, 0, -3, -5, -3, 0, 0, 0,
    -8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, -46, -23, 0,
    -15, -5, -13, -8, -18, -8, 0, -10,
    -3, 0, 0, -18, 0, -5, -26, -3,
    0, 0, 0, 3, 0, 0, -8, 0,
    0, 0, 0, -15, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 5, 0, -3, -5,
    -3, 0, 0, 0, -10, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -26, 0,
    0, 5, -5, 8, 0, 0, 0, -8,
    0, 0, -5, 0, 0, 0, -18, 5,
    0, -5, 0, -8, -26, -10, -18, -10,
    3, -23, 0, -8, 0, 0, 0, -5,
    -10, 0, 0, 0, -5, -8, 0, -13,
    -10, 3, -18, 0, -8, 0, 0, -5,
    0, -5, 0, 0, 0, -5, 0, 0,
    -3, 0, 0, 0, 0, -5, 0, 0,
    0, 0, -8, 0, -10, -3, -8, -10,
    -3, -5, 0, -8, 0, -3, 0, 0,
    0, -3, 0, 0, 0, -3, 0, 0,
    0, 0, -5, -3, 0, -10, 5, -8,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, 0, 2, -5, 0, 0, 0, 0,
    -10, 0, -5, 0, -5, -5, -8, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 5, 5, 2, 5, 0,
    -10, -3, 0, -10, 5, -8, 0, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    -5, -5, 0, 0, 0, 0, -10, 0,
    -10, 0, -5, -13, -8, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    0, 0, 0, -5, -3, 0, -3, 0,
    0, 0, 0, 8, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, -5,
    0, 0, 0, 0, -8, -3, 0, -5,
    0, 0, 0, 0, 0, 0, 0, -28,
    0, -23, 0, 0, 0, 0, 0, 0,
    5, 0, 0, 0, 0, -13, 0, -5,
    -26, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, 0, -8, -8, 0,
    -3, 0, -10, -10, -5, -10, -10, -10,
    -10, -13, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -10, 0, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    0, 0, -20, 8, 0, 0, 0, -8,
    0, 0, 0, 0, 0, 0, -8, 3,
    0, -8, -8, 0, 0, 0, 0, 0,
    3, 0, 0, 3, 5, -5, 0, -13,
    -10, 0, 0, 0, -8, -8, -5, -15,
    -8, 0, -15, 0, -33, 0, 0, 8,
    -31, 8, 0, 0, 0, 0, 0, 0,
    -8, 0, 0, 0, -13, 5, 0, -8,
    0, 0, -23, -8, -33, -13, 3, -36,
    0, -5, 0, 0, 0, -3, -8, 0,
    0, 0, 0, -8, 0, -23, -13, 3,
    -20, 0, 0, 0, 0, -33, 0, -23,
    0, 0, 0, 0, -8, 0, 0, 0,
    0, 0, 3, -15, 0, 0, -36, 0,
    0, 0, 0, 0, -8, -8, -8, -5,
    0, 0, 0, -8, 0, 0, 0, 0,
    -3, 5, 0, 0, 0, 0, 0, 0,
    -10, -3, 0, -10, 5, -8, 0, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    -5, -3, 0, 0, 0, 0, -10, 0,
    -10, 0, -5, -13, -5, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    0, 0, 0, -5, -3, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, -5, 0, -3, 0,
    0, -8, -3, 0, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 3, 0,
    -8, 0, 0, 0, 0, -5, 0, 0,
    0, 0, -10, 0, -8, 0, 0, -8,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, 0, 0, 0,
    0, 0, 0, 3, 0, -38, -33, -31,
    0, 0, 0, -13, -18, 0, 5, 0,
    0, -26, -3, -26, 0, -10, -38, 0,
    -5, 0, 0, 0, 0, 0, 0, 3,
    5, -41, -5, -33, -13, -5, -5, -36,
    -38, -13, -31, -28, -36, -33, -33, -36,
    0, 3, 0, -33, -13, -20, 0, 0,
    0, 0, -13, 0, 3, 0, 0, 0,
    0, -18, 0, -8, -33, -5, 0, 0,
    5, 0, 0, 5, 0, 3, 0, -15,
    0, -13, 0, 0, 0, -5, -15, -3,
    -10, -3, -5, 0, -3, -8, 0, 3,
    0, -26, -3, -13, 0, 0, 0, 0,
    -8, 0, 3, 0, 0, 0, 0, -10,
    0, 0, -18, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, -3, 0, -8,
    0, 0, 0, -3, -8, 0, 0, 0,
    0, 0, -3, 0, 0, 3, 0, -44,
    -26, -33, 0, 0, 0, 0, -23, 0,
    3, 0, 0, 0, 0, -23, 0, -10,
    -36, -5, 0, 0, 5, 0, 0, 0,
    0, 3, 0, -23, 0, -23, -8, 0,
    0, -15, -23, -7, -18, -10, -10, -10,
    -10, -18, 0, 0, 0, 0, -16, 3,
    0, 0, 0, 0, -13, 0, 0, 0,
    0, 0, -5, 0, 0, -15, -3, 0,
    0, 0, 0, 3, 0, 3, 0, 0,
    0, 0, 0, -10, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, -5, -15, -5, 3, 0,
    3, 3, 3, 3, 0, 0, 0, -3,
    0, -8, 0, 0, 8, 0, -8, 0,
    0, -8, -3, -5, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 5,
    0, 0, 0, 0, -26, 0, 0, 0,
    3, 0, 0, 0, -38, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, 0, 0, -20, -5, -8, 0,
    0, 5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, -5, 0,
    0, 0, 0, -3, 0, -8, -5, -5,
    -3, 0, -13, -8, -8, -8, 3, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -13, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8,
    -26, -3, 0, -3, -5, 0, 0, 0,
    -3, -3, 0, -8, -5, -8, -5, -5,
    0, 3, 0, 0, 0, 8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 5,
    3, -28, 0, -8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, -5,
    3, 0, 0, 0, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 8, 0, 0, 0, 8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, -18, 8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, -13, -5,
    0, -8, 0, 0, 0, 0, -10, 3,
    0, 0, 0, 3, 0, 0, 0, 0,
    0, -26, -15, -20, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, -10, 0, -8,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, 0, 0, 0, -15, 0, -15, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, -5, 0,
    0, 0, -3, -5, 0, -8, -5, -10,
    -8, 0, -3, 0, 0, 0, -18, 8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8,
    0, -8, 0, -8, -3, 0, 0, 0,
    -5, -3, 0, 0, 0, 0, 0, 0,
    -8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, -31, -5, -13, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, 0, -5, 0, -10,
    0, 0, 0, 0, -8, 3, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -15,
    -3, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, -5, 0, -5, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, -30, -8, -13,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, -8, 0, -8, 3, 0, 0, 0,
    -8, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, -5, 0, 0, 0, 0, -5, 0,
    0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 53,
    .right_class_cnt     = 46,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 1,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t esp_brookesia_font_maison_neue_book_16 = {
#else
lv_font_t esp_brookesia_font_maison_neue_book_16 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 19,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_16*/
