/*******************************************************************************
 * Size: 10 px
 * Bpp: 4
 * Opts: --bpp 4 --size 10 --no-compress --font MaisonNeue-Book.ttf --range 32-127 --format lvgl -o esp_brookesia_font_maison_neue_book_10.c
 ******************************************************************************/

#ifdef __has_include
    #if __has_include("lvgl.h")
        #ifndef LV_LVGL_H_INCLUDE_SIMPLE
            #define LV_LVGL_H_INCLUDE_SIMPLE
        #endif
    #endif
#endif

#if defined(LV_LVGL_H_INCLUDE_SIMPLE)
    #include "lvgl.h"
#else
    #include "lvgl/lvgl.h"
#endif

#ifndef ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_10
#define ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_10 1
#endif

#if ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_10

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x76, 0x76, 0x76, 0x76, 0x76, 0x32, 0x22, 0xa8,

    /* U+0022 "\"" */
    0x1a, 0xb1, 0xab, 0x4, 0x50,

    /* U+0023 "#" */
    0x0, 0xb, 0xc, 0x0, 0x0, 0x39, 0xc, 0x0,
    0xa, 0xdd, 0xde, 0xc2, 0x0, 0x84, 0x47, 0x0,
    0x0, 0xa2, 0x65, 0x0, 0x4c, 0xfc, 0xed, 0x90,
    0x0, 0xc0, 0xb0, 0x0, 0x1, 0xa0, 0xc0, 0x0,

    /* U+0024 "$" */
    0x0, 0x8, 0x0, 0x0, 0x7d, 0xea, 0x0, 0x2b,
    0x8, 0x79, 0x2, 0xb0, 0x80, 0x40, 0x7, 0xdb,
    0x30, 0x0, 0x0, 0xbb, 0x80, 0x55, 0x8, 0xc,
    0x3, 0xc1, 0x81, 0xd0, 0x5, 0xde, 0xc4, 0x0,
    0x0, 0x80, 0x0,

    /* U+0025 "%" */
    0x0, 0x0, 0x0, 0x6, 0x0, 0xa, 0xc7, 0x0,
    0x75, 0x0, 0x48, 0xc, 0x1, 0xc0, 0x0, 0x56,
    0xa, 0x18, 0x40, 0x0, 0x39, 0xc, 0x2b, 0x5c,
    0x90, 0x8, 0xc5, 0xa3, 0xc0, 0x84, 0x0, 0x2,
    0xa1, 0xa0, 0x56, 0x0, 0xb, 0x20, 0xc0, 0x74,
    0x0, 0x49, 0x0, 0x6c, 0xa0, 0x0, 0x51, 0x0,
    0x0, 0x0,

    /* U+0026 "&" */
    0x4, 0xcc, 0x40, 0x0, 0xb1, 0xa, 0x0, 0x9,
    0x40, 0x0, 0x0, 0x4e, 0x31, 0x40, 0x1c, 0x3c,
    0x69, 0x5, 0x70, 0x1c, 0x90, 0x3a, 0x0, 0x7e,
    0x30, 0x8d, 0xd9, 0x10,

    /* U+0027 "'" */
    0x1a, 0x1a, 0x4,

    /* U+0028 "(" */
    0x0, 0x32, 0x0, 0xc1, 0x6, 0x70, 0xc, 0x10,
    0xd, 0x0, 0x1c, 0x0, 0xc, 0x0, 0xd, 0x0,
    0x9, 0x30, 0x2, 0xb0, 0x0, 0x93, 0x0, 0x0,

    /* U+0029 ")" */
    0x50, 0x5, 0x80, 0xc, 0x10, 0x66, 0x2, 0xa0,
    0x1b, 0x2, 0xb0, 0x48, 0x9, 0x41, 0xc0, 0x93,
    0x0, 0x0,

    /* U+002A "*" */
    0x0, 0xa0, 0x2, 0xbd, 0xb1, 0x6, 0xd5, 0x0,
    0x90, 0x90,

    /* U+002B "+" */
    0x0, 0x22, 0x0, 0x0, 0x65, 0x0, 0x0, 0x65,
    0x0, 0x4b, 0xdc, 0xb3, 0x0, 0x65, 0x0, 0x0,
    0x65, 0x0,

    /* U+002C "," */
    0x4, 0x1, 0xf1, 0xb, 0x0, 0x0,

    /* U+002D "-" */
    0x6d, 0xd1,

    /* U+002E "." */
    0x4, 0x1, 0xf1,

    /* U+002F "/" */
    0x0, 0x0, 0x0, 0x0, 0x81, 0x0, 0xa, 0x0,
    0x6, 0x40, 0x0, 0xa0, 0x0, 0x46, 0x0, 0xa,
    0x0, 0x2, 0x80, 0x0, 0x81, 0x0, 0x3, 0x0,
    0x0,

    /* U+0030 "0" */
    0x4, 0xdd, 0x70, 0xc, 0x10, 0xb3, 0x56, 0x0,
    0x39, 0x74, 0x0, 0x1b, 0x74, 0x0, 0x1b, 0x56,
    0x0, 0x39, 0xc, 0x10, 0xb3, 0x4, 0xdd, 0x70,

    /* U+0031 "1" */
    0x2, 0x45, 0xca, 0x42, 0xa0, 0x2a, 0x2, 0xa0,
    0x2a, 0x2, 0xa0, 0x2a,

    /* U+0032 "2" */
    0x6, 0xcc, 0x50, 0x2b, 0x0, 0xc0, 0x44, 0x0,
    0xa2, 0x0, 0x6, 0xb0, 0x1, 0xba, 0x0, 0xd,
    0x40, 0x0, 0x48, 0x0, 0x0, 0x5e, 0xcc, 0xc1,

    /* U+0033 "3" */
    0x7, 0xcc, 0x40, 0x2a, 0x0, 0xc0, 0x0, 0x1,
    0xb0, 0x0, 0x8f, 0x40, 0x0, 0x1, 0xc0, 0x65,
    0x0, 0xa1, 0x3b, 0x0, 0xd0, 0x7, 0xdd, 0x40,

    /* U+0034 "4" */
    0x0, 0x7, 0x20, 0x0, 0x7d, 0x40, 0x0, 0xb8,
    0x40, 0x8, 0x48, 0x40, 0x1b, 0x8, 0x40, 0x93,
    0x8, 0x40, 0xcc, 0xce, 0xd1, 0x0, 0x8, 0x40,

    /* U+0035 "5" */
    0xb, 0xcc, 0x90, 0xb, 0x0, 0x0, 0x29, 0x0,
    0x0, 0x4b, 0xbb, 0x40, 0x36, 0x0, 0xc1, 0x0,
    0x0, 0x74, 0x68, 0x0, 0xb2, 0x9, 0xdd, 0x60,

    /* U+0036 "6" */
    0x3, 0xdd, 0x70, 0xd, 0x20, 0xa3, 0x59, 0x0,
    0x22, 0x77, 0xac, 0x70, 0x8d, 0x10, 0x95, 0x68,
    0x0, 0x38, 0x1c, 0x0, 0x85, 0x5, 0xdd, 0x90,

    /* U+0037 "7" */
    0xbd, 0xdd, 0xa0, 0x0, 0x66, 0x0, 0xc, 0x0,
    0x6, 0x70, 0x0, 0xc0, 0x0, 0x58, 0x0, 0xc,
    0x10, 0x0,

    /* U+0038 "8" */
    0x9, 0xbb, 0x30, 0x58, 0x1, 0xb0, 0x39, 0x2,
    0xa0, 0xc, 0xdf, 0x30, 0x77, 0x2, 0xc0, 0xb1,
    0x0, 0xa1, 0x85, 0x1, 0xd0, 0x1a, 0xcc, 0x40,

    /* U+0039 "9" */
    0x9, 0xcc, 0x30, 0x76, 0x1, 0xb0, 0x92, 0x0,
    0xb2, 0x68, 0x2, 0xe3, 0x9, 0xca, 0xa3, 0x12,
    0x0, 0xb1, 0x2b, 0x2, 0xc0, 0x6, 0xcd, 0x30,

    /* U+003A ":" */
    0x0, 0x1, 0xf1, 0x3, 0x0, 0x0, 0x4, 0x1,
    0xf1,

    /* U+003B ";" */
    0x0, 0x1, 0xf2, 0x3, 0x0, 0x0, 0x4, 0x1,
    0xf1, 0xb, 0x0, 0x0,

    /* U+003C "<" */
    0x0, 0x2, 0x80, 0x7, 0xc2, 0x2c, 0x70, 0x4,
    0xc3, 0x0, 0x2, 0xb8, 0x0, 0x0, 0x7a, 0x0,
    0x0, 0x0,

    /* U+003D "=" */
    0x4c, 0xcc, 0xb0, 0x0, 0x0, 0x4c, 0xcc, 0xb0,

    /* U+003E ">" */
    0x27, 0x0, 0x0, 0x7c, 0x20, 0x0, 0x2c, 0x70,
    0x0, 0x8b, 0x3, 0xc7, 0x2, 0xc2, 0x0, 0x0,
    0x0, 0x0,

    /* U+003F "?" */
    0x5, 0xdd, 0x60, 0x1c, 0x0, 0xd0, 0x24, 0x0,
    0xd0, 0x0, 0xa, 0x80, 0x0, 0x86, 0x0, 0x0,
    0xa1, 0x0, 0x0, 0x41, 0x0, 0x0, 0xe4, 0x0,

    /* U+0040 "@" */
    0x0, 0x6a, 0x97, 0x0, 0x8, 0x6a, 0xb5, 0xa0,
    0x18, 0x35, 0x67, 0x64, 0x44, 0x1b, 0xb8, 0x36,
    0x54, 0x56, 0x58, 0x45, 0x28, 0x1a, 0x99, 0xa0,
    0x9, 0x40, 0x3, 0x0, 0x0, 0x7b, 0xa8, 0x0,

    /* U+0041 "A" */
    0x0, 0x98, 0x0, 0x0, 0xed, 0x0, 0x3, 0xcd,
    0x20, 0x8, 0x78, 0x70, 0xd, 0x23, 0xc0, 0x2d,
    0x0, 0xe1, 0x7e, 0xcc, 0xe6, 0xc2, 0x0, 0x3b,

    /* U+0042 "B" */
    0x2f, 0xdd, 0xc1, 0x2b, 0x0, 0x68, 0x2b, 0x0,
    0x66, 0x2f, 0xdd, 0xe1, 0x2b, 0x0, 0x5a, 0x2b,
    0x0, 0xc, 0x2b, 0x0, 0x4a, 0x2f, 0xdd, 0xc1,

    /* U+0043 "C" */
    0x3, 0xdd, 0xb1, 0x0, 0xd2, 0x4, 0xb0, 0x58,
    0x0, 0x9, 0x7, 0x50, 0x0, 0x0, 0x75, 0x0,
    0x0, 0x5, 0x80, 0x0, 0xc0, 0xd, 0x20, 0x5b,
    0x0, 0x3d, 0xdb, 0x10,

    /* U+0044 "D" */
    0x2f, 0xde, 0x80, 0x2, 0xb0, 0x9, 0x60, 0x2b,
    0x0, 0xc, 0x2, 0xb0, 0x0, 0xc0, 0x2b, 0x0,
    0xd, 0x2, 0xb0, 0x0, 0xd0, 0x2b, 0x0, 0x88,
    0x2, 0xfd, 0xd8, 0x0,

    /* U+0045 "E" */
    0x2f, 0xdd, 0xd0, 0x2b, 0x0, 0x0, 0x2b, 0x0,
    0x0, 0x2b, 0x0, 0x0, 0x2f, 0xdd, 0xa0, 0x2b,
    0x0, 0x0, 0x2b, 0x0, 0x0, 0x2f, 0xdd, 0xd0,

    /* U+0046 "F" */
    0x2f, 0xdd, 0xd0, 0x2b, 0x0, 0x0, 0x2b, 0x0,
    0x0, 0x2b, 0x0, 0x0, 0x2f, 0xdd, 0xa0, 0x2b,
    0x0, 0x0, 0x2b, 0x0, 0x0, 0x2b, 0x0, 0x0,

    /* U+0047 "G" */
    0x3, 0xdd, 0xb1, 0x0, 0xd2, 0x4, 0xb0, 0x58,
    0x0, 0x8, 0x7, 0x50, 0x0, 0x0, 0x75, 0x6,
    0xde, 0x15, 0x80, 0x0, 0xc0, 0xd, 0x20, 0x4b,
    0x0, 0x3d, 0xdb, 0x10,

    /* U+0048 "H" */
    0x2b, 0x0, 0x2a, 0x2b, 0x0, 0x2a, 0x2b, 0x0,
    0x2a, 0x2b, 0x0, 0x2a, 0x2e, 0xcc, 0xda, 0x2b,
    0x0, 0x2a, 0x2b, 0x0, 0x2a, 0x2b, 0x0, 0x2a,

    /* U+0049 "I" */
    0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b, 0x2b,

    /* U+004A "J" */
    0x0, 0x6, 0x60, 0x0, 0x66, 0x0, 0x6, 0x60,
    0x0, 0x66, 0x0, 0x6, 0x63, 0x0, 0x76, 0x85,
    0xb, 0x31, 0xcd, 0x80,

    /* U+004B "K" */
    0x2b, 0x0, 0xa5, 0x2b, 0x6, 0x90, 0x2b, 0x2c,
    0x0, 0x2b, 0xc4, 0x0, 0x2f, 0x9b, 0x0, 0x2c,
    0x9, 0x60, 0x2b, 0x1, 0xd1, 0x2b, 0x0, 0x6a,

    /* U+004C "L" */
    0x2b, 0x0, 0x2, 0xb0, 0x0, 0x2b, 0x0, 0x2,
    0xb0, 0x0, 0x2b, 0x0, 0x2, 0xb0, 0x0, 0x2b,
    0x0, 0x2, 0xfd, 0xdb,

    /* U+004D "M" */
    0x2f, 0x20, 0x0, 0xaa, 0x2f, 0x70, 0x0, 0xea,
    0x2b, 0xc0, 0x6, 0x9a, 0x2b, 0x93, 0xb, 0x4a,
    0x2b, 0x39, 0x1a, 0x3a, 0x2b, 0xc, 0x75, 0x3a,
    0x2b, 0x7, 0xe0, 0x3a, 0x2b, 0x2, 0x90, 0x3a,

    /* U+004E "N" */
    0x2f, 0x10, 0xd, 0x2e, 0x80, 0xd, 0x2b, 0xc1,
    0xd, 0x2b, 0x58, 0xd, 0x2b, 0xc, 0x1d, 0x2b,
    0x5, 0x8d, 0x2b, 0x0, 0xcd, 0x2b, 0x0, 0x5d,

    /* U+004F "O" */
    0x3, 0xde, 0xb1, 0x0, 0xd2, 0x4, 0xb0, 0x58,
    0x0, 0xb, 0x27, 0x50, 0x0, 0x84, 0x75, 0x0,
    0x8, 0x45, 0x80, 0x0, 0xb2, 0xd, 0x20, 0x5b,
    0x0, 0x3d, 0xeb, 0x10,

    /* U+0050 "P" */
    0x2f, 0xdd, 0xc2, 0x2b, 0x0, 0x3b, 0x2b, 0x0,
    0xd, 0x2b, 0x0, 0x4b, 0x2f, 0xdd, 0xb2, 0x2b,
    0x0, 0x0, 0x2b, 0x0, 0x0, 0x2b, 0x0, 0x0,

    /* U+0051 "Q" */
    0x3, 0xde, 0xb1, 0x0, 0xd2, 0x4, 0xb0, 0x58,
    0x0, 0xb, 0x27, 0x50, 0x0, 0x84, 0x75, 0x4,
    0x8, 0x45, 0x80, 0x59, 0xb2, 0xd, 0x20, 0x9c,
    0x0, 0x3d, 0xdb, 0xa1,

    /* U+0052 "R" */
    0x2f, 0xdd, 0xb1, 0x2b, 0x0, 0x68, 0x2b, 0x0,
    0x2b, 0x2b, 0x0, 0x77, 0x2f, 0xdf, 0x70, 0x2b,
    0xa, 0x50, 0x2b, 0x2, 0xd0, 0x2b, 0x0, 0xa4,

    /* U+0053 "S" */
    0x8, 0xdd, 0x60, 0x3b, 0x0, 0xc3, 0x3b, 0x0,
    0x21, 0x7, 0xd8, 0x10, 0x0, 0x6, 0xd2, 0x73,
    0x0, 0x49, 0x4b, 0x0, 0x68, 0x7, 0xdd, 0xa0,

    /* U+0054 "T" */
    0x9d, 0xee, 0xd7, 0x0, 0x75, 0x0, 0x0, 0x75,
    0x0, 0x0, 0x75, 0x0, 0x0, 0x75, 0x0, 0x0,
    0x75, 0x0, 0x0, 0x75, 0x0, 0x0, 0x75, 0x0,

    /* U+0055 "U" */
    0x3a, 0x0, 0xd, 0x3a, 0x0, 0xd, 0x3a, 0x0,
    0xd, 0x3a, 0x0, 0xd, 0x3a, 0x0, 0xd, 0x2a,
    0x0, 0xc, 0xd, 0x10, 0x69, 0x4, 0xdd, 0xb1,

    /* U+0056 "V" */
    0xc1, 0x0, 0x1c, 0x76, 0x0, 0x57, 0x2b, 0x0,
    0xa2, 0xd, 0x0, 0xd0, 0x8, 0x44, 0x80, 0x3,
    0x99, 0x30, 0x0, 0xdd, 0x0, 0x0, 0x99, 0x0,

    /* U+0057 "W" */
    0xb1, 0x4, 0xb0, 0xa, 0x28, 0x40, 0x9e, 0x0,
    0xd0, 0x67, 0xc, 0x84, 0xd, 0x3, 0x91, 0xb4,
    0x82, 0xa0, 0x1c, 0x66, 0xc, 0x48, 0x0, 0xda,
    0x20, 0xb8, 0x50, 0xc, 0xd0, 0x7, 0xe3, 0x0,
    0x9a, 0x0, 0x2f, 0x0,

    /* U+0058 "X" */
    0x96, 0x0, 0xd2, 0x1d, 0x5, 0x90, 0x8, 0x6c,
    0x10, 0x0, 0xe8, 0x0, 0x1, 0xe9, 0x0, 0x9,
    0x5c, 0x20, 0x2c, 0x4, 0xa0, 0xa5, 0x0, 0xc2,

    /* U+0059 "Y" */
    0xb3, 0x0, 0x77, 0x3b, 0x0, 0xd0, 0xa, 0x38,
    0x60, 0x2, 0xcc, 0x0, 0x0, 0xa6, 0x0, 0x0,
    0x84, 0x0, 0x0, 0x84, 0x0, 0x0, 0x84, 0x0,

    /* U+005A "Z" */
    0x5e, 0xee, 0xf7, 0x0, 0x0, 0xc1, 0x0, 0x8,
    0x60, 0x0, 0x3b, 0x0, 0x0, 0xc2, 0x0, 0x7,
    0x70, 0x0, 0x2c, 0x0, 0x0, 0x8e, 0xee, 0xe5,

    /* U+005B "[" */
    0x2e, 0xb2, 0xa0, 0x2a, 0x2, 0xa0, 0x2a, 0x2,
    0xa0, 0x2a, 0x2, 0xa0, 0x2a, 0x2, 0xeb,

    /* U+005C "\\" */
    0x0, 0x0, 0x9, 0x0, 0x0, 0x46, 0x0, 0x0,
    0xa0, 0x0, 0x6, 0x40, 0x0, 0xa, 0x0, 0x0,
    0x82, 0x0, 0x1, 0x80, 0x0, 0x9, 0x0, 0x0,
    0x21,

    /* U+005D "]" */
    0xae, 0x30, 0x93, 0x9, 0x30, 0x93, 0x9, 0x30,
    0x93, 0x9, 0x30, 0x93, 0x9, 0x3a, 0xe3,

    /* U+005E "^" */
    0x0, 0xc4, 0x0, 0x3a, 0xb0, 0xa, 0x29, 0x21,
    0xb0, 0x39,

    /* U+005F "_" */
    0x5c, 0xcc, 0xc6,

    /* U+0060 "`" */
    0x15, 0x0, 0xa1,

    /* U+0061 "a" */
    0xa, 0xcb, 0x5, 0x70, 0x66, 0x1, 0x7c, 0x74,
    0xb4, 0x57, 0x84, 0x8, 0x72, 0xcc, 0xa7,

    /* U+0062 "b" */
    0x57, 0x0, 0x0, 0x57, 0x0, 0x0, 0x5a, 0xcd,
    0x50, 0x5c, 0x0, 0xc1, 0x57, 0x0, 0x75, 0x57,
    0x0, 0x75, 0x5c, 0x0, 0xc1, 0x5b, 0xcd, 0x50,

    /* U+0063 "c" */
    0x7, 0xdd, 0x50, 0x3a, 0x0, 0xc0, 0x74, 0x0,
    0x10, 0x74, 0x0, 0x10, 0x3a, 0x0, 0xc0, 0x7,
    0xdd, 0x50,

    /* U+0064 "d" */
    0x0, 0x0, 0x93, 0x0, 0x0, 0x93, 0x7, 0xdc,
    0xb3, 0x3a, 0x1, 0xd3, 0x74, 0x0, 0x93, 0x74,
    0x0, 0x93, 0x3a, 0x1, 0xd3, 0x7, 0xdc, 0xb3,

    /* U+0065 "e" */
    0x7, 0xcc, 0x50, 0x39, 0x0, 0xb1, 0x7c, 0xbb,
    0xc3, 0x75, 0x0, 0x0, 0x3b, 0x0, 0xc0, 0x7,
    0xcc, 0x50,

    /* U+0066 "f" */
    0x9, 0xd0, 0xc, 0x0, 0x9f, 0xc2, 0xc, 0x0,
    0xc, 0x0, 0xc, 0x0, 0xc, 0x0, 0xc, 0x0,

    /* U+0067 "g" */
    0x7, 0xdc, 0xb3, 0x3a, 0x1, 0xd3, 0x74, 0x0,
    0x93, 0x74, 0x0, 0x93, 0x3a, 0x1, 0xd3, 0x7,
    0xdc, 0xb3, 0x1, 0x0, 0xa2, 0xd, 0x11, 0xd0,
    0x3, 0xbc, 0x40,

    /* U+0068 "h" */
    0x57, 0x0, 0x5, 0x70, 0x0, 0x5b, 0xcd, 0x45,
    0xb0, 0x1c, 0x57, 0x0, 0xc5, 0x70, 0xc, 0x57,
    0x0, 0xc5, 0x70, 0xc,

    /* U+0069 "i" */
    0x67, 0x0, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,

    /* U+006A "j" */
    0x4, 0x90, 0x0, 0x3, 0x80, 0x38, 0x3, 0x80,
    0x38, 0x3, 0x80, 0x38, 0x4, 0x81, 0xd4,

    /* U+006B "k" */
    0x57, 0x0, 0x5, 0x70, 0x0, 0x57, 0xa, 0x55,
    0x78, 0x70, 0x5c, 0xe0, 0x5, 0xb7, 0x70, 0x57,
    0xc, 0x15, 0x70, 0x49,

    /* U+006C "l" */
    0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57,

    /* U+006D "m" */
    0x5c, 0xcb, 0x8c, 0xb0, 0x59, 0x7, 0x90, 0x76,
    0x57, 0x5, 0x70, 0x47, 0x57, 0x5, 0x70, 0x47,
    0x57, 0x5, 0x70, 0x47, 0x57, 0x5, 0x70, 0x47,

    /* U+006E "n" */
    0x5b, 0xcd, 0x45, 0xb0, 0x1c, 0x57, 0x0, 0xc5,
    0x70, 0xc, 0x57, 0x0, 0xc5, 0x70, 0xc,

    /* U+006F "o" */
    0x7, 0xdd, 0x50, 0x3a, 0x0, 0xc2, 0x74, 0x0,
    0x66, 0x74, 0x0, 0x66, 0x3a, 0x0, 0xc2, 0x7,
    0xdd, 0x50,

    /* U+0070 "p" */
    0x5b, 0xcd, 0x50, 0x5c, 0x0, 0xc1, 0x57, 0x0,
    0x75, 0x57, 0x0, 0x75, 0x5c, 0x0, 0xc1, 0x5b,
    0xcd, 0x50, 0x57, 0x0, 0x0, 0x57, 0x0, 0x0,
    0x12, 0x0, 0x0,

    /* U+0071 "q" */
    0x7, 0xdc, 0xb3, 0x3a, 0x1, 0xd3, 0x74, 0x0,
    0x93, 0x74, 0x0, 0x93, 0x3a, 0x1, 0xd3, 0x7,
    0xdc, 0xc3, 0x0, 0x0, 0x93, 0x0, 0x0, 0x93,
    0x0, 0x0, 0x20,

    /* U+0072 "r" */
    0x0, 0x0, 0x5d, 0xc0, 0x59, 0x0, 0x57, 0x0,
    0x57, 0x0, 0x57, 0x0, 0x57, 0x0,

    /* U+0073 "s" */
    0xb, 0xda, 0x5, 0x70, 0x64, 0x1c, 0x82, 0x1,
    0x4, 0xb5, 0x76, 0x3, 0x90, 0xad, 0xd2,

    /* U+0074 "t" */
    0xc, 0x0, 0x9f, 0xc0, 0xc, 0x0, 0xc, 0x0,
    0xc, 0x0, 0xc, 0x0, 0xb, 0xa0,

    /* U+0075 "u" */
    0x66, 0x0, 0xc6, 0x60, 0xc, 0x66, 0x0, 0xc6,
    0x60, 0xc, 0x49, 0x3, 0xd0, 0xad, 0xac,

    /* U+0076 "v" */
    0xb1, 0x0, 0xb1, 0x57, 0x2, 0xb0, 0xc, 0x7,
    0x50, 0x9, 0x3c, 0x0, 0x3, 0xc9, 0x0, 0x0,
    0xd3, 0x0,

    /* U+0077 "w" */
    0xa1, 0xb, 0x40, 0x93, 0x75, 0xb, 0x90, 0xb0,
    0x38, 0x55, 0xa0, 0xb0, 0xb, 0x90, 0x76, 0x80,
    0xb, 0xa0, 0x2d, 0x50, 0x9, 0x60, 0xd, 0x20,

    /* U+0078 "x" */
    0x95, 0xa, 0x41, 0xc4, 0xa0, 0x6, 0xe1, 0x0,
    0x7e, 0x20, 0x1c, 0x2b, 0xa, 0x40, 0x95,

    /* U+0079 "y" */
    0xb1, 0x0, 0xc0, 0x57, 0x5, 0x70, 0xc, 0xb,
    0x10, 0x9, 0x4b, 0x0, 0x3, 0xe5, 0x0, 0x0,
    0xd0, 0x0, 0x3, 0x90, 0x0, 0x9, 0x30, 0x0,
    0x6, 0x0, 0x0,

    /* U+007A "z" */
    0x7c, 0xcd, 0x90, 0x0, 0xc2, 0x0, 0xa5, 0x0,
    0x68, 0x0, 0x2b, 0x0, 0xa, 0xdc, 0xc8,

    /* U+007B "{" */
    0x4, 0xe6, 0x9, 0x40, 0x9, 0x30, 0x9, 0x30,
    0x5e, 0x0, 0xa, 0x20, 0x9, 0x30, 0x9, 0x30,
    0x8, 0x40, 0x4, 0xe6,

    /* U+007C "|" */
    0x99, 0x99, 0x99, 0x99, 0x99, 0x99,

    /* U+007D "}" */
    0xbd, 0x0, 0x9, 0x30, 0x9, 0x30, 0x8, 0x40,
    0x4, 0xf0, 0x8, 0x50, 0x9, 0x30, 0x9, 0x30,
    0x9, 0x30, 0xad, 0x0,

    /* U+007E "~" */
    0xb, 0xc4, 0x28, 0x36, 0x1a, 0xd2
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 43, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 62, .box_w = 2, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8, .adv_w = 62, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 13, .adv_w = 126, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 45, .adv_w = 105, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 80, .adv_w = 160, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 130, .adv_w = 108, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 158, .adv_w = 41, .box_w = 2, .box_h = 3, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 161, .adv_w = 59, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 185, .adv_w = 59, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 203, .adv_w = 78, .box_w = 5, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 213, .adv_w = 94, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 231, .adv_w = 48, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 237, .adv_w = 58, .box_w = 4, .box_h = 1, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 239, .adv_w = 48, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 242, .adv_w = 71, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 267, .adv_w = 100, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 291, .adv_w = 58, .box_w = 3, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 303, .adv_w = 92, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 327, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 351, .adv_w = 87, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 375, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 399, .adv_w = 95, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 423, .adv_w = 81, .box_w = 5, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 441, .adv_w = 86, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 465, .adv_w = 91, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 489, .adv_w = 48, .box_w = 3, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 498, .adv_w = 48, .box_w = 3, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 510, .adv_w = 88, .box_w = 5, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 528, .adv_w = 88, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 536, .adv_w = 88, .box_w = 5, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 554, .adv_w = 95, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 578, .adv_w = 129, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 610, .adv_w = 95, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 634, .adv_w = 101, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 658, .adv_w = 104, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 686, .adv_w = 104, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 714, .adv_w = 90, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 738, .adv_w = 88, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 762, .adv_w = 104, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 790, .adv_w = 104, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 814, .adv_w = 41, .box_w = 2, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 822, .adv_w = 84, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 842, .adv_w = 96, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 866, .adv_w = 83, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 886, .adv_w = 136, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 918, .adv_w = 108, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 942, .adv_w = 109, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 970, .adv_w = 98, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 994, .adv_w = 109, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1022, .adv_w = 97, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1046, .adv_w = 96, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1070, .adv_w = 94, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1094, .adv_w = 106, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1118, .adv_w = 96, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1142, .adv_w = 135, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1178, .adv_w = 88, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1202, .adv_w = 92, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1226, .adv_w = 95, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1250, .adv_w = 49, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1265, .adv_w = 71, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1290, .adv_w = 49, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1305, .adv_w = 89, .box_w = 5, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 1315, .adv_w = 96, .box_w = 6, .box_h = 1, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1318, .adv_w = 47, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 1321, .adv_w = 82, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1336, .adv_w = 94, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1360, .adv_w = 90, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1378, .adv_w = 94, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1402, .adv_w = 92, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1420, .adv_w = 54, .box_w = 4, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1436, .adv_w = 93, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1463, .adv_w = 89, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1483, .adv_w = 33, .box_w = 2, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1491, .adv_w = 35, .box_w = 3, .box_h = 10, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 1506, .adv_w = 82, .box_w = 5, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1526, .adv_w = 33, .box_w = 2, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1534, .adv_w = 129, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1558, .adv_w = 89, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1573, .adv_w = 94, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1591, .adv_w = 94, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1618, .adv_w = 94, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1645, .adv_w = 52, .box_w = 4, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1659, .adv_w = 80, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1674, .adv_w = 54, .box_w = 4, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1688, .adv_w = 88, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1703, .adv_w = 86, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1721, .adv_w = 121, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1745, .adv_w = 75, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1760, .adv_w = 82, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1787, .adv_w = 80, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1802, .adv_w = 58, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1822, .adv_w = 42, .box_w = 1, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 1828, .adv_w = 58, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1848, .adv_w = 101, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 3}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 1, 2, 3, 0, 0, 0, 0,
    3, 4, 4, 5, 0, 6, 7, 6,
    8, 9, 10, 11, 12, 13, 14, 15,
    16, 17, 9, 0, 0, 0, 0, 0,
    2, 0, 18, 19, 20, 21, 22, 23,
    21, 24, 24, 25, 26, 27, 24, 24,
    21, 28, 29, 30, 31, 32, 25, 33,
    34, 26, 35, 36, 37, 38, 37, 0,
    6, 0, 39, 40, 40, 41, 40, 42,
    43, 39, 44, 44, 45, 41, 39, 39,
    40, 40, 0, 46, 47, 48, 49, 50,
    51, 45, 52, 53, 37, 0, 37, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 0, 1, 0, 0, 0, 0,
    1, 2, 2, 3, 0, 4, 5, 4,
    6, 7, 8, 9, 10, 11, 12, 7,
    13, 14, 15, 16, 16, 0, 0, 0,
    17, 0, 18, 19, 20, 19, 19, 19,
    20, 19, 19, 21, 19, 19, 19, 19,
    20, 19, 20, 19, 22, 23, 24, 25,
    26, 27, 28, 29, 30, 31, 30, 0,
    4, 0, 32, 33, 34, 34, 34, 35,
    34, 33, 36, 37, 33, 33, 38, 38,
    34, 38, 34, 38, 39, 40, 41, 42,
    43, 44, 45, 46, 30, 0, 30, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, -6, 0, -13, 0,
    -5, -3, -2, -6, 0, 0, 0, -5,
    0, -5, -3, 0, 0, 0, -3, -3,
    0, -6, -3, -5, -6, 0, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -19,
    0, 0, -3, 0, 0, 0, -11, -3,
    2, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, -2, -6, 0,
    2, 0, 2, 2, 2, 2, 0, 0,
    0, -5, 3, -5, 0, 5, 5, 0,
    0, 0, 0, -3, -2, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 2, 0, 0, 0, -10, 2,
    0, 0, 0, 0, 0, 0, -22, -8,
    0, 0, 0, 0, -6, -16, 0, 0,
    2, -3, -11, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, 0, 3, 0, 0, 0, 6, 5,
    -11, 5, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -24,
    0, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, -11, 2, -5, -19, -5,
    5, 5, 5, 3, 5, 5, 2, 0,
    0, -13, 3, -18, 2, 5, 5, -6,
    -13, 0, 0, 0, 0, -8, 0, -5,
    -3, 0, 0, -6, 3, 0, 0, -2,
    -5, -3, -2, -2, -6, -2, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, -5, 0, 0, -3, -3, -3,
    0, 0, -2, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, -3, -3, -3, -5, -3,
    -6, -2, -2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, -3, -3, 0, 0, 0, -5, 0,
    -2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, -2, -3,
    0, 0, 0, 0, -5, 0, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, 0, 0, 0, 0, -6, -3, -2,
    0, 0, -5, 0, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, -2, -3, -2, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, -29, -15, 0,
    -10, -3, -8, -5, -11, -5, 0, -7,
    -2, 0, 0, -11, 0, -3, -16, -2,
    0, 0, 0, 2, 0, 0, -5, 0,
    0, 0, 0, -9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 3, 0, -2, -3,
    -2, 0, 0, 0, -6, 2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -16, 0,
    0, 3, -3, 5, 0, 0, 0, -5,
    0, 0, -3, 0, 0, 0, -11, 3,
    0, -3, 0, -5, -16, -6, -11, -6,
    2, -14, 0, -5, 0, 0, 0, -3,
    -6, 0, 0, 0, -3, -5, 0, -8,
    -6, 2, -11, 0, -5, 0, 0, -3,
    0, -3, 0, 0, 0, -3, 0, 0,
    -2, 0, 0, 0, 0, -3, 0, 0,
    0, 0, -5, 0, -6, -2, -5, -6,
    -2, -3, 0, -5, 0, -2, 0, 0,
    0, -2, 0, 0, 0, -2, 0, 0,
    0, 0, -3, -2, 0, -6, 3, -5,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 1, -3, 0, 0, 0, 0,
    -6, 0, -3, 0, -3, -3, -5, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 3, 3, 1, 3, 0,
    -6, -2, 0, -6, 3, -5, 0, 0,
    0, 0, 0, 0, -7, 0, 0, 0,
    -3, -3, 0, 0, 0, 0, -6, 0,
    -6, 0, -3, -8, -5, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, -3, -2, 0, -2, 0,
    0, 0, 0, 5, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -3,
    0, 0, 0, 0, -5, -2, 0, -3,
    0, 0, 0, 0, 0, 0, 0, -18,
    0, -14, 0, 0, 0, 0, 0, 0,
    3, 0, 0, 0, 0, -8, 0, -3,
    -16, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, -5, -5, 0,
    -2, 0, -6, -6, -3, -6, -6, -6,
    -6, -8, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -6, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, 0, 0, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, -13, 5, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, -5, 2,
    0, -5, -5, 0, 0, 0, 0, 0,
    2, 0, 0, 2, 3, -3, 0, -8,
    -6, 0, 0, 0, -5, -5, -3, -9,
    -5, 0, -9, 0, -21, 0, 0, 5,
    -19, 5, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, -8, 3, 0, -5,
    0, 0, -14, -5, -21, -8, 2, -22,
    0, -3, 0, 0, 0, -2, -5, 0,
    0, 0, 0, -5, 0, -14, -8, 2,
    -13, 0, 0, 0, 0, -21, 0, -14,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 2, -10, 0, 0, -23, 0,
    0, 0, 0, 0, -5, -5, -5, -3,
    0, 0, 0, -5, 0, 0, 0, 0,
    -2, 3, 0, 0, 0, 0, 0, 0,
    -6, -2, 0, -6, 3, -5, 0, 0,
    0, 0, 0, 0, -7, 0, 0, 0,
    -3, -2, 0, 0, 0, 0, -6, 0,
    -6, 0, -3, -8, -3, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 2,
    0, 0, 0, -3, -2, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -6, 0, -3, 0, -2, 0,
    0, -5, -2, 0, 0, 0, 0, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -6, 0, 0, -3,
    0, 0, 0, 0, 0, 0, 2, 0,
    -5, 0, 0, 0, 0, -3, 0, 0,
    0, 0, -6, 0, -5, 0, 0, -5,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 2, 0, -24, -21, -19,
    0, 0, 0, -8, -11, 0, 3, 0,
    0, -16, -2, -16, 0, -6, -24, 0,
    -3, 0, 0, 0, 0, 0, 0, 2,
    3, -26, -3, -21, -8, -3, -3, -22,
    -24, -8, -19, -18, -22, -21, -21, -22,
    0, 2, 0, -21, -8, -13, 0, 0,
    0, 0, -8, 0, 2, 0, 0, 0,
    0, -11, 0, -5, -21, -3, 0, 0,
    3, 0, 0, 3, 0, 2, 0, -10,
    0, -8, 0, 0, 0, -3, -10, -2,
    -6, -2, -3, 0, -2, -5, 0, 2,
    0, -16, -2, -8, 0, 0, 0, 0,
    -5, 0, 2, 0, 0, 0, 0, -6,
    0, 0, -11, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 0, -2, 0, -5,
    0, 0, 0, -2, -5, 0, 0, 0,
    0, 0, -2, 0, 0, 2, 0, -27,
    -16, -21, 0, 0, 0, 0, -14, 0,
    2, 0, 0, 0, 0, -14, 0, -6,
    -22, -3, 0, 0, 3, 0, 0, 0,
    0, 2, 0, -14, 0, -14, -5, 0,
    0, -9, -14, -5, -11, -6, -6, -6,
    -6, -11, 0, 0, 0, 0, -10, 2,
    0, 0, 0, 0, -8, 0, 0, 0,
    0, 0, -3, 0, 0, -10, -2, 0,
    0, 0, 0, 2, 0, 2, 0, 0,
    0, 0, 0, -6, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, -3, -9, -3, 2, 0,
    2, 2, 2, 2, 0, 0, 0, -2,
    0, -5, 0, 0, 5, 0, -5, 0,
    0, -5, -2, -3, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    0, 0, 0, 0, -16, 0, 0, 0,
    2, 0, 0, 0, -24, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 0, -13, -3, -5, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, -3, 0,
    0, 0, 0, -2, 0, -5, -3, -3,
    -2, 0, -8, -5, -5, -5, 2, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    -16, -2, 0, -2, -3, 0, 0, 0,
    -2, -2, 0, -5, -3, -5, -3, -3,
    0, 2, 0, 0, 0, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 3,
    2, -17, 0, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, -3,
    2, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 5, 0, 0, 0, 5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, -11, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -8, -3,
    0, -5, 0, 0, 0, 0, -6, 2,
    0, 0, 0, 2, 0, 0, 0, 0,
    0, -16, -10, -13, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, -6, 0, -5,
    0, 0, 0, 0, -6, 0, 0, 0,
    0, 0, 0, 0, -10, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, -3, 0,
    0, 0, -2, -3, 0, -5, -3, -6,
    -5, 0, -2, 0, 0, 0, -11, 5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, -5, 0, -5, -2, 0, 0, 0,
    -3, -2, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, -19, -3, -8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, -3, 0, -6,
    0, 0, 0, 0, -5, 2, 0, 0,
    0, 0, 0, 0, 0, -2, 0, -10,
    -2, -6, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, -3, 0, -3, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, -3, 0, -19, -5, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 2, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, -5, 0, -5, 2, 0, 0, 0,
    -5, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -6, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -2,
    0, -3, 0, 0, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 53,
    .right_class_cnt     = 46,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 1,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t esp_brookesia_font_maison_neue_book_10 = {
#else
lv_font_t esp_brookesia_font_maison_neue_book_10 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 12,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_10*/
