/*
* Copyright 2016 The Alatsi Project Authors (https://github.com/sorkintype/alatsi)
* This Font Software is licensed under the SIL Open Font License, Version 1.1.
* And is also available with a FAQ at: http://scripts.sil.org/OFL
*/
/*******************************************************************************
 * Size: 17 px
 * Bpp: 4
 * Opts: undefined
 ******************************************************************************/

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
#include "lvgl.h"
#else
#include "lvgl.h"
#endif

#ifndef LV_FONT_MONTSERRATMEDIUM_17
#define LV_FONT_MONTSERRATMEDIUM_17 1
#endif

#if LV_FONT_MONTSERRATMEDIUM_17

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0xaf, 0x39, 0xf3, 0x9f, 0x28, 0xf1, 0x8f, 0x17,
    0xf0, 0x6f, 0x6, 0xf0, 0x0, 0x0, 0x10, 0xaf,
    0x39, 0xe2,

    /* U+0022 "\"" */
    0xe7, 0xd, 0x8e, 0x70, 0xd8, 0xd6, 0xc, 0x8d,
    0x60, 0xc7, 0x73, 0x6, 0x40,

    /* U+0023 "#" */
    0x0, 0x2, 0xf0, 0x0, 0xc7, 0x0, 0x0, 0x4,
    0xe0, 0x0, 0xe5, 0x0, 0x0, 0x6, 0xc0, 0x0,
    0xf3, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x3, 0x3b, 0xa3, 0x36, 0xf3, 0x31, 0x0, 0xc,
    0x70, 0x5, 0xd0, 0x0, 0x0, 0xe, 0x50, 0x7,
    0xb0, 0x0, 0x0, 0xf, 0x30, 0x9, 0xa0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x13, 0x6f,
    0x33, 0x3d, 0x83, 0x30, 0x0, 0x5d, 0x0, 0xf,
    0x40, 0x0, 0x0, 0x7b, 0x0, 0x1f, 0x20, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0x2e, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0x0, 0x0, 0x0, 0x4b, 0xef, 0xfc, 0x60, 0x5,
    0xfd, 0x9f, 0x8c, 0xf2, 0xd, 0xd0, 0x2e, 0x0,
    0x20, 0xf, 0xb0, 0x2e, 0x0, 0x0, 0xc, 0xf7,
    0x3e, 0x0, 0x0, 0x2, 0xdf, 0xff, 0x72, 0x0,
    0x0, 0x4, 0xaf, 0xff, 0xb0, 0x0, 0x0, 0x2e,
    0x2a, 0xf9, 0x0, 0x0, 0x2e, 0x0, 0xed, 0x7,
    0x0, 0x2e, 0x1, 0xfb, 0x2f, 0xe9, 0x8f, 0x8e,
    0xf3, 0x2, 0x9d, 0xff, 0xea, 0x20, 0x0, 0x0,
    0x2e, 0x0, 0x0, 0x0, 0x0, 0x2e, 0x0, 0x0,

    /* U+0025 "%" */
    0x2, 0xce, 0xb1, 0x0, 0x0, 0xc8, 0x0, 0xd,
    0x60, 0x8a, 0x0, 0x7, 0xd0, 0x0, 0x3d, 0x0,
    0x1f, 0x0, 0x2f, 0x30, 0x0, 0x5c, 0x0, 0xf,
    0x10, 0xc8, 0x0, 0x0, 0x3e, 0x0, 0x1f, 0x7,
    0xd0, 0x0, 0x0, 0xd, 0x60, 0x9a, 0x2f, 0x20,
    0x0, 0x0, 0x2, 0xce, 0xa1, 0xc7, 0x8, 0xed,
    0x70, 0x0, 0x0, 0x8, 0xc0, 0x7c, 0x12, 0xd5,
    0x0, 0x0, 0x3f, 0x20, 0xc5, 0x0, 0x79, 0x0,
    0x0, 0xd7, 0x0, 0xc5, 0x0, 0x79, 0x0, 0x8,
    0xc0, 0x0, 0x7b, 0x0, 0xd5, 0x0, 0x3f, 0x20,
    0x0, 0x9, 0xdd, 0x70,

    /* U+0026 "&" */
    0x0, 0x7, 0xdf, 0xd5, 0x0, 0x0, 0x0, 0x7f,
    0x63, 0x8f, 0x20, 0x0, 0x0, 0xbc, 0x0, 0xf,
    0x50, 0x0, 0x0, 0x9f, 0x10, 0x8f, 0x20, 0x0,
    0x0, 0x1e, 0xcb, 0xf5, 0x0, 0x0, 0x0, 0xb,
    0xff, 0x30, 0x0, 0x0, 0x2, 0xdd, 0x6e, 0xc1,
    0x5, 0x50, 0xd, 0xd0, 0x3, 0xec, 0x1d, 0x90,
    0x2f, 0x60, 0x0, 0x3e, 0xef, 0x40, 0x2f, 0x90,
    0x0, 0x5, 0xff, 0x10, 0xa, 0xfb, 0x66, 0x9f,
    0xce, 0xd1, 0x0, 0x7d, 0xff, 0xc6, 0x2, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0027 "'" */
    0xe7, 0xe7, 0xd6, 0xd6, 0x73,

    /* U+0028 "(" */
    0x0, 0xae, 0x0, 0x2f, 0x60, 0x8, 0xf1, 0x0,
    0xeb, 0x0, 0x1f, 0x80, 0x4, 0xf5, 0x0, 0x5f,
    0x40, 0x6, 0xf3, 0x0, 0x5f, 0x40, 0x4, 0xf5,
    0x0, 0x1f, 0x80, 0x0, 0xdb, 0x0, 0x8, 0xf1,
    0x0, 0x2f, 0x60, 0x0, 0xae, 0x0,

    /* U+0029 ")" */
    0x3f, 0x50, 0x0, 0xbe, 0x0, 0x4, 0xf4, 0x0,
    0xf, 0x90, 0x0, 0xcd, 0x0, 0x9, 0xf0, 0x0,
    0x8f, 0x10, 0x7, 0xf1, 0x0, 0x8f, 0x0, 0x9,
    0xf0, 0x0, 0xcd, 0x0, 0xf, 0x90, 0x4, 0xf4,
    0x0, 0xbe, 0x0, 0x3f, 0x50, 0x0,

    /* U+002A "*" */
    0x0, 0x1e, 0x0, 0x5, 0x82, 0xe1, 0xa3, 0x2a,
    0xef, 0xe8, 0x10, 0x6e, 0xfd, 0x40, 0x7c, 0x5e,
    0x5e, 0x40, 0x1, 0xe0, 0x0, 0x0, 0x4, 0x0,
    0x0,

    /* U+002B "+" */
    0x0, 0x4, 0x30, 0x0, 0x0, 0xc, 0xa0, 0x0,
    0x0, 0xc, 0xa0, 0x0, 0x1, 0x1c, 0xa1, 0x10,
    0xdf, 0xff, 0xff, 0xfc, 0x34, 0x4d, 0xb4, 0x43,
    0x0, 0xc, 0xa0, 0x0, 0x0, 0xc, 0xa0, 0x0,

    /* U+002C "," */
    0x8, 0x70, 0x2f, 0xf0, 0xa, 0xd0, 0xb, 0x70,
    0xf, 0x20,

    /* U+002D "-" */
    0x1, 0x11, 0x10, 0xf, 0xff, 0xf8, 0x4, 0x44,
    0x42,

    /* U+002E "." */
    0x2, 0x20, 0x1f, 0xf0, 0xd, 0xc0,

    /* U+002F "/" */
    0x0, 0x0, 0x1, 0xf6, 0x0, 0x0, 0x6, 0xf1,
    0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x1f, 0x60,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0xca, 0x0,
    0x0, 0x2, 0xf5, 0x0, 0x0, 0x7, 0xf0, 0x0,
    0x0, 0xd, 0xa0, 0x0, 0x0, 0x3f, 0x40, 0x0,
    0x0, 0x8e, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x0,
    0x3, 0xf3, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x0,
    0xe, 0x80, 0x0, 0x0, 0x4f, 0x20, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x6, 0xdf, 0xe9, 0x10, 0x0, 0xa, 0xfc,
    0x8a, 0xfe, 0x10, 0x6, 0xf8, 0x0, 0x3, 0xfb,
    0x0, 0xce, 0x0, 0x0, 0x9, 0xf1, 0xf, 0xa0,
    0x0, 0x0, 0x4f, 0x52, 0xf8, 0x0, 0x0, 0x3,
    0xf7, 0x2f, 0x80, 0x0, 0x0, 0x3f, 0x70, 0xfa,
    0x0, 0x0, 0x4, 0xf5, 0xc, 0xe0, 0x0, 0x0,
    0x9f, 0x10, 0x6f, 0x80, 0x0, 0x3f, 0xb0, 0x0,
    0xaf, 0xc8, 0xaf, 0xe1, 0x0, 0x0, 0x6d, 0xfe,
    0x91, 0x0,

    /* U+0031 "1" */
    0xdf, 0xff, 0x86, 0x78, 0xf8, 0x0, 0x2f, 0x80,
    0x2, 0xf8, 0x0, 0x2f, 0x80, 0x2, 0xf8, 0x0,
    0x2f, 0x80, 0x2, 0xf8, 0x0, 0x2f, 0x80, 0x2,
    0xf8, 0x0, 0x2f, 0x80, 0x2, 0xf8,

    /* U+0032 "2" */
    0x3, 0xae, 0xfe, 0xa2, 0x0, 0x6f, 0xe9, 0x8a,
    0xff, 0x20, 0x18, 0x0, 0x0, 0x5f, 0x80, 0x0,
    0x0, 0x0, 0x1f, 0xa0, 0x0, 0x0, 0x0, 0x4f,
    0x70, 0x0, 0x0, 0x1, 0xde, 0x10, 0x0, 0x0,
    0x1c, 0xf4, 0x0, 0x0, 0x1, 0xcf, 0x40, 0x0,
    0x0, 0x1d, 0xf4, 0x0, 0x0, 0x1, 0xde, 0x30,
    0x0, 0x0, 0x1d, 0xfa, 0x77, 0x77, 0x71, 0x6f,
    0xff, 0xff, 0xff, 0xf3,

    /* U+0033 "3" */
    0x6f, 0xff, 0xff, 0xff, 0x72, 0x77, 0x77, 0x7e,
    0xf3, 0x0, 0x0, 0x7, 0xf6, 0x0, 0x0, 0x4,
    0xf9, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x0,
    0xaf, 0xfc, 0x40, 0x0, 0x3, 0x57, 0xdf, 0x50,
    0x0, 0x0, 0x1, 0xec, 0x0, 0x0, 0x0, 0xc,
    0xe4, 0x50, 0x0, 0x2, 0xfb, 0xbf, 0xd9, 0x8a,
    0xff, 0x30, 0x6b, 0xef, 0xea, 0x20,

    /* U+0034 "4" */
    0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0, 0x0,
    0x6, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0xde, 0x10, 0x0, 0x0,
    0x0, 0xa, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x70, 0x9, 0xc0, 0x0, 0x2, 0xfb, 0x0, 0xb,
    0xe0, 0x0, 0xd, 0xf3, 0x22, 0x2b, 0xe2, 0x20,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x15, 0x55,
    0x55, 0x5d, 0xe5, 0x50, 0x0, 0x0, 0x0, 0xb,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0, 0x0,

    /* U+0035 "5" */
    0x4, 0xff, 0xff, 0xff, 0x80, 0x5, 0xf9, 0x77,
    0x77, 0x30, 0x7, 0xf1, 0x0, 0x0, 0x0, 0x9,
    0xf0, 0x0, 0x0, 0x0, 0xa, 0xf2, 0x10, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xd7, 0x0, 0x4, 0x55,
    0x57, 0xcf, 0x90, 0x0, 0x0, 0x0, 0xc, 0xf0,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x16, 0x0, 0x0,
    0xd, 0xe0, 0x7f, 0xe9, 0x89, 0xef, 0x60, 0x5,
    0xae, 0xfe, 0xb4, 0x0,

    /* U+0036 "6" */
    0x0, 0x3, 0xae, 0xfe, 0xa2, 0x0, 0x7, 0xfe,
    0x87, 0x8d, 0x10, 0x4, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x10, 0x0, 0x0, 0x0, 0xf, 0xa0,
    0x0, 0x0, 0x0, 0x2, 0xf8, 0x6d, 0xff, 0xd6,
    0x0, 0x2f, 0xef, 0x74, 0x6c, 0xf6, 0x1, 0xff,
    0x30, 0x0, 0xd, 0xe0, 0xe, 0xf0, 0x0, 0x0,
    0xaf, 0x0, 0x8f, 0x40, 0x0, 0x1e, 0xd0, 0x0,
    0xcf, 0x96, 0x7d, 0xf4, 0x0, 0x0, 0x8d, 0xfe,
    0xb3, 0x0,

    /* U+0037 "7" */
    0x7f, 0xff, 0xff, 0xff, 0xf7, 0x7f, 0x87, 0x77,
    0x7c, 0xf5, 0x7f, 0x20, 0x0, 0xd, 0xd0, 0x4a,
    0x10, 0x0, 0x5f, 0x70, 0x0, 0x0, 0x0, 0xcf,
    0x0, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0,
    0xa, 0xf1, 0x0, 0x0, 0x0, 0x2f, 0xa0, 0x0,
    0x0, 0x0, 0x9f, 0x30, 0x0, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x0, 0x7, 0xf5, 0x0, 0x0, 0x0,
    0xe, 0xe0, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x3b, 0xef, 0xea, 0x30, 0x0, 0x4f, 0xe7,
    0x68, 0xef, 0x30, 0xb, 0xf1, 0x0, 0x2, 0xfa,
    0x0, 0xce, 0x0, 0x0, 0xf, 0xb0, 0x6, 0xfa,
    0x21, 0x2a, 0xf5, 0x0, 0x9, 0xff, 0xff, 0xf8,
    0x0, 0x8, 0xfb, 0x54, 0x5b, 0xf7, 0x1, 0xfb,
    0x0, 0x0, 0xc, 0xf0, 0x3f, 0x80, 0x0, 0x0,
    0x8f, 0x21, 0xfc, 0x0, 0x0, 0xd, 0xf0, 0x7,
    0xfd, 0x76, 0x8d, 0xf7, 0x0, 0x5, 0xbe, 0xfe,
    0xb4, 0x0,

    /* U+0039 "9" */
    0x0, 0x7d, 0xfe, 0xb3, 0x0, 0xb, 0xfa, 0x67,
    0xcf, 0x50, 0x4f, 0x70, 0x0, 0xc, 0xe0, 0x7f,
    0x20, 0x0, 0x7, 0xf5, 0x6f, 0x50, 0x0, 0xa,
    0xf9, 0x1e, 0xe5, 0x22, 0x8f, 0xfa, 0x3, 0xdf,
    0xff, 0xd5, 0xf9, 0x0, 0x2, 0x32, 0x2, 0xf7,
    0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0,
    0x3f, 0xb0, 0x7, 0xb8, 0x7b, 0xfd, 0x10, 0x6,
    0xdf, 0xfd, 0x70, 0x0,

    /* U+003A ":" */
    0xd, 0xc0, 0x1f, 0xe0, 0x2, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x20, 0x1f, 0xf0,
    0xd, 0xc0,

    /* U+003B ";" */
    0xd, 0xc0, 0x1f, 0xe0, 0x2, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xc0,
    0x1f, 0xf0, 0x9, 0xb0, 0xc, 0x50, 0xa, 0x0,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x15, 0x0, 0x0, 0x5b, 0xfb,
    0x2, 0x8e, 0xfa, 0x40, 0xaf, 0xd6, 0x10, 0x0,
    0xdf, 0x93, 0x0, 0x0, 0x5, 0xcf, 0xd7, 0x10,
    0x0, 0x2, 0x8e, 0xf8, 0x0, 0x0, 0x0, 0x57,

    /* U+003D "=" */
    0xdf, 0xff, 0xff, 0xfc, 0x45, 0x55, 0x55, 0x53,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x11, 0x11, 0x10,
    0xdf, 0xff, 0xff, 0xfc, 0x34, 0x44, 0x44, 0x43,

    /* U+003E ">" */
    0x51, 0x0, 0x0, 0x0, 0xdf, 0xa4, 0x0, 0x0,
    0x5, 0xbf, 0xe7, 0x10, 0x0, 0x1, 0x7d, 0xf9,
    0x0, 0x0, 0x3a, 0xfb, 0x1, 0x7d, 0xfb, 0x50,
    0xaf, 0xe7, 0x10, 0x0, 0x84, 0x0, 0x0, 0x0,

    /* U+003F "?" */
    0x3, 0xae, 0xfe, 0xa2, 0x7, 0xfd, 0x87, 0x9f,
    0xf2, 0x28, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x0,
    0x2, 0xf7, 0x0, 0x0, 0x0, 0xaf, 0x20, 0x0,
    0x0, 0xaf, 0x60, 0x0, 0x0, 0x9f, 0x60, 0x0,
    0x0, 0xf, 0xb0, 0x0, 0x0, 0x0, 0x31, 0x0,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0xfa,
    0x0, 0x0, 0x0, 0x2e, 0x90, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x5, 0xbd, 0xfe, 0xd9, 0x30, 0x0,
    0x0, 0x0, 0x3d, 0xd7, 0x42, 0x24, 0x9e, 0xa1,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x1b,
    0xd0, 0x0, 0x1e, 0x60, 0x7, 0xdf, 0xd7, 0x6f,
    0x1b, 0xa0, 0x9, 0xc0, 0xa, 0xf9, 0x56, 0xde,
    0xf1, 0x1f, 0x30, 0xe5, 0x4, 0xf7, 0x0, 0x1,
    0xef, 0x10, 0xa8, 0x1f, 0x20, 0x9f, 0x0, 0x0,
    0x8, 0xf1, 0x8, 0xb2, 0xf1, 0xa, 0xd0, 0x0,
    0x0, 0x6f, 0x10, 0x6b, 0x1f, 0x20, 0x9f, 0x0,
    0x0, 0x8, 0xf1, 0x7, 0xa0, 0xe6, 0x4, 0xf6,
    0x0, 0x1, 0xef, 0x10, 0xb7, 0x8, 0xc0, 0xa,
    0xf9, 0x56, 0xdc, 0xf8, 0x7f, 0x10, 0x1e, 0x70,
    0x7, 0xdf, 0xd7, 0x9, 0xfd, 0x40, 0x0, 0x4f,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0xd7, 0x42, 0x35, 0x92, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xbd, 0xfe, 0xc8, 0x10, 0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0x0, 0xdf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xe8, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x71, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x10,
    0xaf, 0x10, 0x0, 0x0, 0x1, 0xfa, 0x0, 0x4f,
    0x80, 0x0, 0x0, 0x8, 0xf3, 0x0, 0xd, 0xf0,
    0x0, 0x0, 0xf, 0xd1, 0x11, 0x17, 0xf7, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0xee, 0x44, 0x44, 0x44, 0x9f, 0x50, 0x5, 0xf7,
    0x0, 0x0, 0x0, 0x1f, 0xc0, 0xc, 0xe0, 0x0,
    0x0, 0x0, 0x9, 0xf3,

    /* U+0042 "B" */
    0x3f, 0xff, 0xff, 0xfd, 0x81, 0x0, 0x3f, 0xa5,
    0x55, 0x69, 0xfe, 0x0, 0x3f, 0x70, 0x0, 0x0,
    0x8f, 0x50, 0x3f, 0x70, 0x0, 0x0, 0x6f, 0x40,
    0x3f, 0x81, 0x11, 0x25, 0xed, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x3f, 0x94, 0x44, 0x46,
    0xcf, 0x50, 0x3f, 0x70, 0x0, 0x0, 0xe, 0xd0,
    0x3f, 0x70, 0x0, 0x0, 0xc, 0xf0, 0x3f, 0x70,
    0x0, 0x0, 0x1e, 0xe0, 0x3f, 0xa5, 0x55, 0x67,
    0xdf, 0x60, 0x3f, 0xff, 0xff, 0xfe, 0xb4, 0x0,

    /* U+0043 "C" */
    0x0, 0x0, 0x7c, 0xef, 0xd9, 0x20, 0x0, 0x3e,
    0xfc, 0x98, 0xaf, 0xf4, 0x1, 0xee, 0x40, 0x0,
    0x1, 0xa1, 0x9, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x1, 0xee,
    0x40, 0x0, 0x2, 0xa1, 0x0, 0x3d, 0xfd, 0x98,
    0xbf, 0xf4, 0x0, 0x0, 0x7c, 0xef, 0xd9, 0x10,

    /* U+0044 "D" */
    0x3f, 0xff, 0xff, 0xec, 0x71, 0x0, 0x3, 0xfb,
    0x77, 0x78, 0xcf, 0xe4, 0x0, 0x3f, 0x70, 0x0,
    0x0, 0x3e, 0xf2, 0x3, 0xf7, 0x0, 0x0, 0x0,
    0x3f, 0xa0, 0x3f, 0x70, 0x0, 0x0, 0x0, 0xbf,
    0x3, 0xf7, 0x0, 0x0, 0x0, 0x8, 0xf2, 0x3f,
    0x70, 0x0, 0x0, 0x0, 0x8f, 0x23, 0xf7, 0x0,
    0x0, 0x0, 0xb, 0xf0, 0x3f, 0x70, 0x0, 0x0,
    0x3, 0xfa, 0x3, 0xf7, 0x0, 0x0, 0x3, 0xef,
    0x20, 0x3f, 0xb7, 0x77, 0x8c, 0xfe, 0x40, 0x3,
    0xff, 0xff, 0xfe, 0xc7, 0x10, 0x0,

    /* U+0045 "E" */
    0x3f, 0xff, 0xff, 0xff, 0xf3, 0x3f, 0xb7, 0x77,
    0x77, 0x71, 0x3f, 0x70, 0x0, 0x0, 0x0, 0x3f,
    0x70, 0x0, 0x0, 0x0, 0x3f, 0x82, 0x22, 0x22,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0x70, 0x3f, 0xa5,
    0x55, 0x55, 0x20, 0x3f, 0x70, 0x0, 0x0, 0x0,
    0x3f, 0x70, 0x0, 0x0, 0x0, 0x3f, 0x70, 0x0,
    0x0, 0x0, 0x3f, 0xb7, 0x77, 0x77, 0x73, 0x3f,
    0xff, 0xff, 0xff, 0xf6,

    /* U+0046 "F" */
    0x3f, 0xff, 0xff, 0xff, 0xf3, 0x3f, 0xb7, 0x77,
    0x77, 0x71, 0x3f, 0x70, 0x0, 0x0, 0x0, 0x3f,
    0x70, 0x0, 0x0, 0x0, 0x3f, 0x70, 0x0, 0x0,
    0x0, 0x3f, 0x82, 0x22, 0x22, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0x70, 0x3f, 0xa5, 0x55, 0x55, 0x20,
    0x3f, 0x70, 0x0, 0x0, 0x0, 0x3f, 0x70, 0x0,
    0x0, 0x0, 0x3f, 0x70, 0x0, 0x0, 0x0, 0x3f,
    0x70, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x0, 0x6c, 0xef, 0xd9, 0x20, 0x0, 0x3d,
    0xfd, 0x98, 0xaf, 0xf6, 0x1, 0xee, 0x40, 0x0,
    0x1, 0x92, 0x9, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x90, 0x0, 0x0,
    0x0, 0xfa, 0xf, 0xc0, 0x0, 0x0, 0x0, 0xfa,
    0x9, 0xf4, 0x0, 0x0, 0x0, 0xfa, 0x1, 0xef,
    0x50, 0x0, 0x1, 0xfa, 0x0, 0x3d, 0xfd, 0x98,
    0xaf, 0xf7, 0x0, 0x0, 0x7c, 0xef, 0xd9, 0x30,

    /* U+0048 "H" */
    0x3f, 0x70, 0x0, 0x0, 0xb, 0xf0, 0x3f, 0x70,
    0x0, 0x0, 0xb, 0xf0, 0x3f, 0x70, 0x0, 0x0,
    0xb, 0xf0, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xf0,
    0x3f, 0x82, 0x22, 0x22, 0x2b, 0xf0, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x3f, 0xa5, 0x55, 0x55,
    0x5c, 0xf0, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xf0,
    0x3f, 0x70, 0x0, 0x0, 0xb, 0xf0, 0x3f, 0x70,
    0x0, 0x0, 0xb, 0xf0, 0x3f, 0x70, 0x0, 0x0,
    0xb, 0xf0, 0x3f, 0x70, 0x0, 0x0, 0xb, 0xf0,

    /* U+0049 "I" */
    0x3f, 0x73, 0xf7, 0x3f, 0x73, 0xf7, 0x3f, 0x73,
    0xf7, 0x3f, 0x73, 0xf7, 0x3f, 0x73, 0xf7, 0x3f,
    0x73, 0xf7,

    /* U+004A "J" */
    0x0, 0xff, 0xff, 0xff, 0x0, 0x7, 0x77, 0x7c,
    0xf0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0xbf,
    0x0, 0x73, 0x0, 0xe, 0xd0, 0xd, 0xf9, 0x7d,
    0xf6, 0x0, 0x19, 0xef, 0xd6, 0x0,

    /* U+004B "K" */
    0x3f, 0x70, 0x0, 0x0, 0x8f, 0x60, 0x3f, 0x70,
    0x0, 0x8, 0xf7, 0x0, 0x3f, 0x70, 0x0, 0x7f,
    0x80, 0x0, 0x3f, 0x70, 0x6, 0xf9, 0x0, 0x0,
    0x3f, 0x70, 0x6f, 0xa0, 0x0, 0x0, 0x3f, 0x75,
    0xff, 0x10, 0x0, 0x0, 0x3f, 0xcf, 0xef, 0xa0,
    0x0, 0x0, 0x3f, 0xfc, 0x1a, 0xf8, 0x0, 0x0,
    0x3f, 0xc1, 0x0, 0xcf, 0x50, 0x0, 0x3f, 0x70,
    0x0, 0x1d, 0xf3, 0x0, 0x3f, 0x70, 0x0, 0x2,
    0xee, 0x10, 0x3f, 0x70, 0x0, 0x0, 0x3f, 0xc0,

    /* U+004C "L" */
    0x3f, 0x70, 0x0, 0x0, 0x3, 0xf7, 0x0, 0x0,
    0x0, 0x3f, 0x70, 0x0, 0x0, 0x3, 0xf7, 0x0,
    0x0, 0x0, 0x3f, 0x70, 0x0, 0x0, 0x3, 0xf7,
    0x0, 0x0, 0x0, 0x3f, 0x70, 0x0, 0x0, 0x3,
    0xf7, 0x0, 0x0, 0x0, 0x3f, 0x70, 0x0, 0x0,
    0x3, 0xf7, 0x0, 0x0, 0x0, 0x3f, 0xb7, 0x77,
    0x77, 0x63, 0xff, 0xff, 0xff, 0xfe,

    /* U+004D "M" */
    0x3f, 0x70, 0x0, 0x0, 0x0, 0x4, 0xf6, 0x3f,
    0xf1, 0x0, 0x0, 0x0, 0xd, 0xf7, 0x3f, 0xfa,
    0x0, 0x0, 0x0, 0x6f, 0xf7, 0x3f, 0xdf, 0x30,
    0x0, 0x1, 0xed, 0xf7, 0x3f, 0x7d, 0xd0, 0x0,
    0x9, 0xf4, 0xf7, 0x3f, 0x64, 0xf6, 0x0, 0x2f,
    0x73, 0xf7, 0x3f, 0x60, 0xae, 0x10, 0xbd, 0x3,
    0xf7, 0x3f, 0x60, 0x1f, 0x95, 0xf4, 0x3, 0xf7,
    0x3f, 0x60, 0x7, 0xfe, 0xb0, 0x3, 0xf7, 0x3f,
    0x60, 0x0, 0xdf, 0x20, 0x3, 0xf7, 0x3f, 0x60,
    0x0, 0x35, 0x0, 0x3, 0xf7, 0x3f, 0x60, 0x0,
    0x0, 0x0, 0x3, 0xf7,

    /* U+004E "N" */
    0x3f, 0x90, 0x0, 0x0, 0xb, 0xf0, 0x3f, 0xf5,
    0x0, 0x0, 0xb, 0xf0, 0x3f, 0xff, 0x30, 0x0,
    0xb, 0xf0, 0x3f, 0xaf, 0xe1, 0x0, 0xb, 0xf0,
    0x3f, 0x75, 0xfb, 0x0, 0xb, 0xf0, 0x3f, 0x70,
    0x9f, 0x80, 0xb, 0xf0, 0x3f, 0x70, 0xb, 0xf5,
    0xb, 0xf0, 0x3f, 0x70, 0x1, 0xef, 0x3b, 0xf0,
    0x3f, 0x70, 0x0, 0x3f, 0xdc, 0xf0, 0x3f, 0x70,
    0x0, 0x5, 0xff, 0xf0, 0x3f, 0x70, 0x0, 0x0,
    0x9f, 0xf0, 0x3f, 0x70, 0x0, 0x0, 0xc, 0xf0,

    /* U+004F "O" */
    0x0, 0x0, 0x7c, 0xef, 0xd8, 0x20, 0x0, 0x0,
    0x3d, 0xfc, 0x98, 0xbf, 0xf6, 0x0, 0x1, 0xee,
    0x40, 0x0, 0x2, 0xcf, 0x40, 0x9, 0xf4, 0x0,
    0x0, 0x0, 0x1e, 0xe0, 0xf, 0xc0, 0x0, 0x0,
    0x0, 0x8, 0xf4, 0x2f, 0x90, 0x0, 0x0, 0x0,
    0x4, 0xf6, 0x2f, 0x90, 0x0, 0x0, 0x0, 0x4,
    0xf6, 0xf, 0xc0, 0x0, 0x0, 0x0, 0x8, 0xf4,
    0x9, 0xf4, 0x0, 0x0, 0x0, 0x1e, 0xd0, 0x1,
    0xee, 0x40, 0x0, 0x2, 0xdf, 0x40, 0x0, 0x3d,
    0xfc, 0x98, 0xbf, 0xf6, 0x0, 0x0, 0x0, 0x7c,
    0xef, 0xd8, 0x20, 0x0,

    /* U+0050 "P" */
    0x3f, 0xff, 0xff, 0xeb, 0x40, 0x3, 0xfb, 0x77,
    0x79, 0xff, 0x60, 0x3f, 0x70, 0x0, 0x1, 0xdf,
    0x13, 0xf7, 0x0, 0x0, 0x7, 0xf5, 0x3f, 0x70,
    0x0, 0x0, 0x6f, 0x53, 0xf7, 0x0, 0x0, 0xb,
    0xf2, 0x3f, 0x82, 0x22, 0x4a, 0xfa, 0x3, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x3f, 0xa5, 0x55, 0x30,
    0x0, 0x3, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x70, 0x0, 0x0, 0x0, 0x3, 0xf7, 0x0, 0x0,
    0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x0, 0x6c, 0xef, 0xd8, 0x20, 0x0, 0x0,
    0x2, 0xdf, 0xc9, 0x8b, 0xff, 0x60, 0x0, 0x1,
    0xee, 0x40, 0x0, 0x2, 0xcf, 0x40, 0x0, 0x9f,
    0x40, 0x0, 0x0, 0x1, 0xed, 0x0, 0xf, 0xc0,
    0x0, 0x0, 0x0, 0x8, 0xf4, 0x1, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x60, 0x2f, 0x90, 0x0,
    0x0, 0x0, 0x4, 0xf6, 0x0, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x40, 0xa, 0xf4, 0x0, 0x0,
    0x0, 0x1e, 0xe0, 0x0, 0x2f, 0xe4, 0x0, 0x0,
    0x1c, 0xf5, 0x0, 0x0, 0x4e, 0xfb, 0x87, 0xaf,
    0xf7, 0x0, 0x0, 0x0, 0x18, 0xdf, 0xff, 0x92,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf9, 0x22,
    0x7a, 0x0, 0x0, 0x0, 0x0, 0x7, 0xef, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x33, 0x0,
    0x0,

    /* U+0052 "R" */
    0x3f, 0xff, 0xff, 0xeb, 0x40, 0x3, 0xfb, 0x77,
    0x79, 0xff, 0x60, 0x3f, 0x70, 0x0, 0x1, 0xdf,
    0x13, 0xf7, 0x0, 0x0, 0x6, 0xf5, 0x3f, 0x70,
    0x0, 0x0, 0x6f, 0x53, 0xf7, 0x0, 0x0, 0xb,
    0xf2, 0x3f, 0x82, 0x22, 0x4a, 0xfa, 0x3, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x3f, 0xa5, 0x54, 0xbf,
    0x20, 0x3, 0xf7, 0x0, 0x1, 0xed, 0x0, 0x3f,
    0x70, 0x0, 0x4, 0xf8, 0x3, 0xf7, 0x0, 0x0,
    0x9, 0xf4,

    /* U+0053 "S" */
    0x0, 0x3b, 0xef, 0xeb, 0x60, 0x5, 0xfe, 0x87,
    0x8c, 0xf2, 0xd, 0xe0, 0x0, 0x0, 0x20, 0xf,
    0xb0, 0x0, 0x0, 0x0, 0xc, 0xf7, 0x0, 0x0,
    0x0, 0x2, 0xdf, 0xfc, 0x73, 0x0, 0x0, 0x4,
    0x9d, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x1a, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xed, 0x8, 0x10, 0x0,
    0x1, 0xfb, 0x1f, 0xfb, 0x87, 0x9e, 0xf3, 0x1,
    0x8c, 0xff, 0xea, 0x20,

    /* U+0054 "T" */
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x77, 0x77, 0xee,
    0x77, 0x76, 0x0, 0x0, 0xdd, 0x0, 0x0, 0x0,
    0x0, 0xdd, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x0,
    0x0, 0x0, 0x0, 0xdd, 0x0, 0x0, 0x0, 0x0,
    0xdd, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x0, 0x0,
    0x0, 0x0, 0xdd, 0x0, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x0, 0x0, 0xdd, 0x0, 0x0, 0x0,
    0x0, 0xdd, 0x0, 0x0,

    /* U+0055 "U" */
    0x5f, 0x60, 0x0, 0x0, 0xe, 0xc5, 0xf6, 0x0,
    0x0, 0x0, 0xec, 0x5f, 0x60, 0x0, 0x0, 0xe,
    0xc5, 0xf6, 0x0, 0x0, 0x0, 0xec, 0x5f, 0x60,
    0x0, 0x0, 0xe, 0xc5, 0xf6, 0x0, 0x0, 0x0,
    0xec, 0x4f, 0x60, 0x0, 0x0, 0xe, 0xb4, 0xf7,
    0x0, 0x0, 0x0, 0xfb, 0x1f, 0xb0, 0x0, 0x0,
    0x3f, 0x80, 0xcf, 0x40, 0x0, 0x1c, 0xf2, 0x2,
    0xef, 0xb8, 0x9e, 0xf8, 0x0, 0x1, 0x9e, 0xff,
    0xb5, 0x0,

    /* U+0056 "V" */
    0xc, 0xf1, 0x0, 0x0, 0x0, 0xc, 0xe0, 0x5,
    0xf7, 0x0, 0x0, 0x0, 0x3f, 0x70, 0x0, 0xee,
    0x0, 0x0, 0x0, 0xaf, 0x10, 0x0, 0x7f, 0x50,
    0x0, 0x1, 0xf9, 0x0, 0x0, 0x1f, 0xc0, 0x0,
    0x8, 0xf2, 0x0, 0x0, 0x9, 0xf3, 0x0, 0xe,
    0xb0, 0x0, 0x0, 0x2, 0xfa, 0x0, 0x6f, 0x40,
    0x0, 0x0, 0x0, 0xbf, 0x10, 0xdd, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x84, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xec, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x20, 0x0, 0x0,

    /* U+0057 "W" */
    0x4f, 0x70, 0x0, 0x0, 0x5f, 0x90, 0x0, 0x0,
    0x2f, 0x60, 0xec, 0x0, 0x0, 0xa, 0xfe, 0x0,
    0x0, 0x8, 0xf1, 0xa, 0xf1, 0x0, 0x0, 0xfe,
    0xf4, 0x0, 0x0, 0xdc, 0x0, 0x4f, 0x70, 0x0,
    0x5f, 0x4f, 0x90, 0x0, 0x3f, 0x60, 0x0, 0xfc,
    0x0, 0xa, 0xe0, 0xbe, 0x0, 0x8, 0xf1, 0x0,
    0xa, 0xf1, 0x0, 0xf8, 0x5, 0xf4, 0x0, 0xdc,
    0x0, 0x0, 0x4f, 0x70, 0x5f, 0x30, 0xf, 0x90,
    0x3f, 0x70, 0x0, 0x0, 0xfc, 0xb, 0xd0, 0x0,
    0xbe, 0x8, 0xf1, 0x0, 0x0, 0xa, 0xf2, 0xf8,
    0x0, 0x5, 0xf4, 0xdc, 0x0, 0x0, 0x0, 0x5f,
    0xcf, 0x30, 0x0, 0xf, 0xcf, 0x70, 0x0, 0x0,
    0x0, 0xff, 0xd0, 0x0, 0x0, 0xaf, 0xf1, 0x0,
    0x0, 0x0, 0xa, 0xf8, 0x0, 0x0, 0x5, 0xfc,
    0x0, 0x0,

    /* U+0058 "X" */
    0x2f, 0xc0, 0x0, 0x0, 0x4f, 0x80, 0x6, 0xf8,
    0x0, 0x1, 0xec, 0x0, 0x0, 0xbf, 0x40, 0xb,
    0xf2, 0x0, 0x0, 0x1e, 0xe1, 0x7f, 0x60, 0x0,
    0x0, 0x4, 0xfc, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xf3,
    0x0, 0x0, 0x0, 0x8, 0xf7, 0xee, 0x10, 0x0,
    0x0, 0x4f, 0xa0, 0x4f, 0xa0, 0x0, 0x1, 0xee,
    0x10, 0x8, 0xf6, 0x0, 0xb, 0xf3, 0x0, 0x0,
    0xcf, 0x20, 0x6f, 0x80, 0x0, 0x0, 0x2f, 0xd0,

    /* U+0059 "Y" */
    0xc, 0xf1, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x2f,
    0xa0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x8f, 0x40,
    0x0, 0x2f, 0x80, 0x0, 0x0, 0xed, 0x0, 0xb,
    0xe0, 0x0, 0x0, 0x5, 0xf7, 0x5, 0xf5, 0x0,
    0x0, 0x0, 0xb, 0xf2, 0xec, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xef, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x50, 0x0, 0x0,

    /* U+005A "Z" */
    0x2f, 0xff, 0xff, 0xff, 0xff, 0x71, 0x77, 0x77,
    0x77, 0x7f, 0xf3, 0x0, 0x0, 0x0, 0x9, 0xf6,
    0x0, 0x0, 0x0, 0x6, 0xf9, 0x0, 0x0, 0x0,
    0x3, 0xfc, 0x0, 0x0, 0x0, 0x1, 0xee, 0x10,
    0x0, 0x0, 0x0, 0xcf, 0x30, 0x0, 0x0, 0x0,
    0x9f, 0x60, 0x0, 0x0, 0x0, 0x6f, 0x90, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0x0, 0x0, 0x1e,
    0xf9, 0x77, 0x77, 0x77, 0x54, 0xff, 0xff, 0xff,
    0xff, 0xfa,

    /* U+005B "[" */
    0x3f, 0xff, 0x53, 0xf9, 0x51, 0x3f, 0x60, 0x3,
    0xf6, 0x0, 0x3f, 0x60, 0x3, 0xf6, 0x0, 0x3f,
    0x60, 0x3, 0xf6, 0x0, 0x3f, 0x60, 0x3, 0xf6,
    0x0, 0x3f, 0x60, 0x3, 0xf6, 0x0, 0x3f, 0x60,
    0x3, 0xf9, 0x51, 0x3f, 0xff, 0x50,

    /* U+005C "\\" */
    0x7f, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0xc, 0xb0, 0x0, 0x0, 0x6, 0xf1, 0x0, 0x0,
    0x1, 0xf6, 0x0, 0x0, 0x0, 0xbc, 0x0, 0x0,
    0x0, 0x5f, 0x10, 0x0, 0x0, 0xf, 0x70, 0x0,
    0x0, 0xa, 0xc0, 0x0, 0x0, 0x5, 0xf2, 0x0,
    0x0, 0x0, 0xe8, 0x0, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0x0, 0x4f, 0x30, 0x0, 0x0, 0xe, 0x80,
    0x0, 0x0, 0x8, 0xe0, 0x0, 0x0, 0x3, 0xf4,

    /* U+005D "]" */
    0xaf, 0xfe, 0x35, 0xde, 0x0, 0xce, 0x0, 0xce,
    0x0, 0xce, 0x0, 0xce, 0x0, 0xce, 0x0, 0xce,
    0x0, 0xce, 0x0, 0xce, 0x0, 0xce, 0x0, 0xce,
    0x0, 0xce, 0x35, 0xde, 0xaf, 0xfe,

    /* U+005E "^" */
    0x0, 0xe, 0xd0, 0x0, 0x0, 0x5e, 0xe4, 0x0,
    0x0, 0xc7, 0x8b, 0x0, 0x3, 0xf1, 0x2f, 0x20,
    0xa, 0xa0, 0xb, 0x90, 0x1f, 0x30, 0x4, 0xf0,
    0x8c, 0x0, 0x0, 0xd6,

    /* U+005F "_" */
    0xff, 0xff, 0xff, 0xff, 0x71, 0x11, 0x11, 0x11,
    0x10,

    /* U+0060 "`" */
    0x5, 0xf9, 0x0, 0x0, 0x1c, 0xb0,

    /* U+0061 "a" */
    0x2, 0x9d, 0xfe, 0xb3, 0x0, 0xae, 0x86, 0x8e,
    0xf2, 0x1, 0x10, 0x0, 0x3f, 0x80, 0x0, 0x0,
    0x0, 0xfa, 0x2, 0xbe, 0xff, 0xff, 0xb0, 0xde,
    0x52, 0x22, 0xfb, 0x1f, 0x80, 0x0, 0x1f, 0xb0,
    0xde, 0x42, 0x5d, 0xfb, 0x2, 0xae, 0xfd, 0x6d,
    0xb0,

    /* U+0062 "b" */
    0x7f, 0x20, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x0,
    0x0, 0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0x39, 0xef, 0xd7, 0x0, 0x7f, 0xed, 0x87, 0xbf,
    0xb0, 0x7f, 0xc0, 0x0, 0x7, 0xf6, 0x7f, 0x50,
    0x0, 0x0, 0xeb, 0x7f, 0x20, 0x0, 0x0, 0xcd,
    0x7f, 0x50, 0x0, 0x0, 0xeb, 0x7f, 0xc0, 0x0,
    0x7, 0xf6, 0x7f, 0xed, 0x87, 0xbf, 0xc0, 0x7f,
    0x29, 0xef, 0xd7, 0x0,

    /* U+0063 "c" */
    0x0, 0x19, 0xef, 0xd8, 0x0, 0x2, 0xef, 0x96,
    0x9f, 0xc0, 0xc, 0xe2, 0x0, 0x4, 0x40, 0x2f,
    0x80, 0x0, 0x0, 0x0, 0x4f, 0x60, 0x0, 0x0,
    0x0, 0x2f, 0x80, 0x0, 0x0, 0x0, 0xc, 0xe2,
    0x0, 0x4, 0x40, 0x2, 0xee, 0x86, 0x9f, 0xc0,
    0x0, 0x19, 0xef, 0xe8, 0x0,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x0, 0x2, 0xae, 0xfc, 0x59, 0xf0, 0x3, 0xfe,
    0x87, 0x9f, 0xef, 0x0, 0xde, 0x20, 0x0, 0x4f,
    0xf0, 0x2f, 0x80, 0x0, 0x0, 0xbf, 0x4, 0xf6,
    0x0, 0x0, 0x9, 0xf0, 0x2f, 0x80, 0x0, 0x0,
    0xbf, 0x0, 0xde, 0x10, 0x0, 0x3f, 0xf0, 0x3,
    0xfe, 0x75, 0x8f, 0xef, 0x0, 0x2, 0xae, 0xfd,
    0x68, 0xf0,

    /* U+0065 "e" */
    0x0, 0x2a, 0xef, 0xc6, 0x0, 0x3, 0xfe, 0x76,
    0xbf, 0x80, 0xd, 0xe1, 0x0, 0x8, 0xf3, 0x2f,
    0x70, 0x0, 0x0, 0xf8, 0x4f, 0xff, 0xff, 0xff,
    0xfa, 0x2f, 0x92, 0x22, 0x22, 0x21, 0xd, 0xe1,
    0x0, 0x0, 0x20, 0x3, 0xff, 0x97, 0x8e, 0xd0,
    0x0, 0x29, 0xef, 0xea, 0x20,

    /* U+0066 "f" */
    0x0, 0x4c, 0xfe, 0x50, 0xf, 0xd6, 0x62, 0x3,
    0xf6, 0x0, 0xc, 0xff, 0xff, 0xf0, 0x37, 0xf9,
    0x55, 0x0, 0x3f, 0x60, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x3f, 0x60, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x3f,
    0x60, 0x0,

    /* U+0067 "g" */
    0x0, 0x2a, 0xef, 0xd7, 0x6f, 0x20, 0x3f, 0xf9,
    0x79, 0xfe, 0xf2, 0xd, 0xf2, 0x0, 0x3, 0xff,
    0x22, 0xf8, 0x0, 0x0, 0xa, 0xf2, 0x4f, 0x60,
    0x0, 0x0, 0x7f, 0x22, 0xf8, 0x0, 0x0, 0x9,
    0xf2, 0xd, 0xe2, 0x0, 0x3, 0xff, 0x20, 0x3f,
    0xf9, 0x69, 0xfe, 0xf2, 0x0, 0x2a, 0xef, 0xd6,
    0x8f, 0x10, 0x0, 0x0, 0x0, 0xd, 0xd0, 0x8,
    0xea, 0x86, 0x8d, 0xf5, 0x0, 0x6, 0xce, 0xfe,
    0xb4, 0x0,

    /* U+0068 "h" */
    0x7f, 0x20, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x0,
    0x0, 0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0x49, 0xef, 0xd6, 0x0, 0x7f, 0xed, 0x88, 0xdf,
    0x70, 0x7f, 0xc0, 0x0, 0xe, 0xe0, 0x7f, 0x50,
    0x0, 0x9, 0xf1, 0x7f, 0x20, 0x0, 0x8, 0xf1,
    0x7f, 0x20, 0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0,
    0x8, 0xf1, 0x7f, 0x20, 0x0, 0x8, 0xf1, 0x7f,
    0x20, 0x0, 0x8, 0xf1,

    /* U+0069 "i" */
    0x7f, 0x48, 0xf4, 0x0, 0x7, 0xf2, 0x7f, 0x27,
    0xf2, 0x7f, 0x27, 0xf2, 0x7f, 0x27, 0xf2, 0x7f,
    0x27, 0xf2,

    /* U+006A "j" */
    0x0, 0x6, 0xf5, 0x0, 0x7, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf4, 0x0, 0x6, 0xf4, 0x0,
    0x6, 0xf4, 0x0, 0x6, 0xf4, 0x0, 0x6, 0xf4,
    0x0, 0x6, 0xf4, 0x0, 0x6, 0xf4, 0x0, 0x6,
    0xf4, 0x0, 0x6, 0xf4, 0x0, 0x6, 0xf3, 0x28,
    0x6e, 0xe0, 0x4e, 0xfc, 0x30,

    /* U+006B "k" */
    0x7f, 0x20, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x0,
    0x0, 0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0x20, 0x0, 0x7f, 0x80, 0x7f, 0x20, 0x8, 0xf8,
    0x0, 0x7f, 0x20, 0xaf, 0x80, 0x0, 0x7f, 0x3b,
    0xf8, 0x0, 0x0, 0x7f, 0xdf, 0xfd, 0x0, 0x0,
    0x7f, 0xf5, 0x6f, 0xa0, 0x0, 0x7f, 0x50, 0x9,
    0xf7, 0x0, 0x7f, 0x20, 0x0, 0xcf, 0x40, 0x7f,
    0x20, 0x0, 0x1e, 0xe1,

    /* U+006C "l" */
    0x7f, 0x27, 0xf2, 0x7f, 0x27, 0xf2, 0x7f, 0x27,
    0xf2, 0x7f, 0x27, 0xf2, 0x7f, 0x27, 0xf2, 0x7f,
    0x27, 0xf2,

    /* U+006D "m" */
    0x7f, 0x3a, 0xef, 0xc4, 0x6, 0xcf, 0xe9, 0x10,
    0x7f, 0xfc, 0x77, 0xef, 0xbf, 0x96, 0x9f, 0xc0,
    0x7f, 0xb0, 0x0, 0x2f, 0xf6, 0x0, 0x7, 0xf4,
    0x7f, 0x40, 0x0, 0xd, 0xf0, 0x0, 0x3, 0xf7,
    0x7f, 0x20, 0x0, 0xc, 0xd0, 0x0, 0x2, 0xf8,
    0x7f, 0x20, 0x0, 0xc, 0xd0, 0x0, 0x2, 0xf8,
    0x7f, 0x20, 0x0, 0xc, 0xd0, 0x0, 0x2, 0xf8,
    0x7f, 0x20, 0x0, 0xc, 0xd0, 0x0, 0x2, 0xf8,
    0x7f, 0x20, 0x0, 0xc, 0xd0, 0x0, 0x2, 0xf8,

    /* U+006E "n" */
    0x7f, 0x3a, 0xef, 0xd6, 0x0, 0x7f, 0xec, 0x77,
    0xcf, 0x70, 0x7f, 0xb0, 0x0, 0xe, 0xe0, 0x7f,
    0x40, 0x0, 0x9, 0xf1, 0x7f, 0x20, 0x0, 0x8,
    0xf1, 0x7f, 0x20, 0x0, 0x8, 0xf1, 0x7f, 0x20,
    0x0, 0x8, 0xf1, 0x7f, 0x20, 0x0, 0x8, 0xf1,
    0x7f, 0x20, 0x0, 0x8, 0xf1,

    /* U+006F "o" */
    0x0, 0x29, 0xef, 0xd8, 0x0, 0x0, 0x3f, 0xe8,
    0x79, 0xfd, 0x10, 0xd, 0xe2, 0x0, 0x4, 0xf9,
    0x2, 0xf8, 0x0, 0x0, 0xb, 0xf0, 0x4f, 0x60,
    0x0, 0x0, 0x9f, 0x2, 0xf8, 0x0, 0x0, 0xb,
    0xf0, 0xd, 0xe2, 0x0, 0x4, 0xf9, 0x0, 0x3f,
    0xe8, 0x69, 0xfd, 0x10, 0x0, 0x29, 0xef, 0xd8,
    0x0, 0x0,

    /* U+0070 "p" */
    0x7f, 0x39, 0xef, 0xd7, 0x0, 0x7f, 0xed, 0x75,
    0xaf, 0xb0, 0x7f, 0xc0, 0x0, 0x6, 0xf6, 0x7f,
    0x50, 0x0, 0x0, 0xeb, 0x7f, 0x20, 0x0, 0x0,
    0xcd, 0x7f, 0x50, 0x0, 0x0, 0xeb, 0x7f, 0xd0,
    0x0, 0x7, 0xf6, 0x7f, 0xed, 0x87, 0xbf, 0xc0,
    0x7f, 0x39, 0xef, 0xd7, 0x0, 0x7f, 0x20, 0x0,
    0x0, 0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x7f,
    0x20, 0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x2a, 0xef, 0xc5, 0x8f, 0x0, 0x3f, 0xe8,
    0x7a, 0xfe, 0xf0, 0xd, 0xe2, 0x0, 0x4, 0xff,
    0x2, 0xf8, 0x0, 0x0, 0xb, 0xf0, 0x4f, 0x60,
    0x0, 0x0, 0x9f, 0x2, 0xf8, 0x0, 0x0, 0xb,
    0xf0, 0xd, 0xe2, 0x0, 0x4, 0xff, 0x0, 0x3f,
    0xe8, 0x69, 0xfe, 0xf0, 0x0, 0x2a, 0xef, 0xc5,
    0x9f, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf0,

    /* U+0072 "r" */
    0x7f, 0x39, 0xe6, 0x7f, 0xde, 0xa3, 0x7f, 0xc0,
    0x0, 0x7f, 0x50, 0x0, 0x7f, 0x30, 0x0, 0x7f,
    0x20, 0x0, 0x7f, 0x20, 0x0, 0x7f, 0x20, 0x0,
    0x7f, 0x20, 0x0,

    /* U+0073 "s" */
    0x2, 0x9e, 0xfd, 0xb4, 0x0, 0xee, 0x76, 0x8d,
    0x50, 0x4f, 0x60, 0x0, 0x0, 0x1, 0xfd, 0x51,
    0x0, 0x0, 0x5, 0xdf, 0xfe, 0xa1, 0x0, 0x0,
    0x14, 0x8f, 0xc0, 0x1, 0x0, 0x0, 0xaf, 0x5,
    0xfa, 0x76, 0x9f, 0xb0, 0x18, 0xdf, 0xfd, 0x80,
    0x0,

    /* U+0074 "t" */
    0x3, 0xf6, 0x0, 0x0, 0x3f, 0x60, 0x0, 0xcf,
    0xff, 0xff, 0x3, 0x7f, 0x95, 0x50, 0x3, 0xf6,
    0x0, 0x0, 0x3f, 0x60, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x2, 0xf7, 0x0, 0x0,
    0xe, 0xe6, 0x83, 0x0, 0x3c, 0xfd, 0x40,

    /* U+0075 "u" */
    0x8f, 0x10, 0x0, 0xb, 0xf8, 0xf1, 0x0, 0x0,
    0xbf, 0x8f, 0x10, 0x0, 0xb, 0xf8, 0xf1, 0x0,
    0x0, 0xbf, 0x8f, 0x10, 0x0, 0xb, 0xf8, 0xf2,
    0x0, 0x0, 0xdf, 0x5f, 0x70, 0x0, 0x3f, 0xf0,
    0xdf, 0x96, 0x8f, 0xff, 0x1, 0x9d, 0xfd, 0x69,
    0xf0,

    /* U+0076 "v" */
    0xd, 0xd0, 0x0, 0x0, 0x4f, 0x40, 0x6f, 0x50,
    0x0, 0xb, 0xd0, 0x0, 0xeb, 0x0, 0x2, 0xf6,
    0x0, 0x8, 0xf2, 0x0, 0x9e, 0x0, 0x0, 0x1f,
    0x90, 0x1f, 0x80, 0x0, 0x0, 0xaf, 0x17, 0xf1,
    0x0, 0x0, 0x3, 0xf7, 0xea, 0x0, 0x0, 0x0,
    0xc, 0xff, 0x30, 0x0, 0x0, 0x0, 0x5f, 0xc0,
    0x0, 0x0,

    /* U+0077 "w" */
    0xbd, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x7, 0xf0,
    0x5f, 0x30, 0x0, 0x9f, 0xe0, 0x0, 0xd, 0x90,
    0xe, 0x90, 0x0, 0xeb, 0xf4, 0x0, 0x3f, 0x30,
    0x9, 0xe0, 0x5, 0xf2, 0xda, 0x0, 0x9d, 0x0,
    0x3, 0xf4, 0xb, 0xc0, 0x7f, 0x0, 0xe7, 0x0,
    0x0, 0xda, 0x1f, 0x50, 0x1f, 0x65, 0xf2, 0x0,
    0x0, 0x7f, 0x8f, 0x0, 0xb, 0xcb, 0xb0, 0x0,
    0x0, 0x1f, 0xf9, 0x0, 0x5, 0xff, 0x50, 0x0,
    0x0, 0xb, 0xf3, 0x0, 0x0, 0xef, 0x0, 0x0,

    /* U+0078 "x" */
    0x3f, 0x90, 0x0, 0x3f, 0x90, 0x7, 0xf5, 0x1,
    0xec, 0x0, 0x0, 0xaf, 0x2b, 0xe1, 0x0, 0x0,
    0xd, 0xff, 0x40, 0x0, 0x0, 0x6, 0xfc, 0x0,
    0x0, 0x0, 0x2e, 0xdf, 0x60, 0x0, 0x0, 0xce,
    0x19, 0xf3, 0x0, 0x9, 0xf3, 0x0, 0xce, 0x10,
    0x6f, 0x70, 0x0, 0x2f, 0xb0,

    /* U+0079 "y" */
    0xc, 0xe0, 0x0, 0x0, 0x4f, 0x40, 0x5f, 0x50,
    0x0, 0xc, 0xd0, 0x0, 0xdc, 0x0, 0x3, 0xf6,
    0x0, 0x6, 0xf4, 0x0, 0xae, 0x0, 0x0, 0xe,
    0xb0, 0x1f, 0x70, 0x0, 0x0, 0x8f, 0x28, 0xf1,
    0x0, 0x0, 0x1, 0xfa, 0xe8, 0x0, 0x0, 0x0,
    0x9, 0xff, 0x10, 0x0, 0x0, 0x0, 0x3f, 0xa0,
    0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x1c,
    0x78, 0xfa, 0x0, 0x0, 0x1, 0xae, 0xe9, 0x0,
    0x0, 0x0,

    /* U+007A "z" */
    0x3f, 0xff, 0xff, 0xff, 0x11, 0x55, 0x55, 0x8f,
    0xb0, 0x0, 0x0, 0x1d, 0xd1, 0x0, 0x0, 0xb,
    0xf2, 0x0, 0x0, 0x8, 0xf5, 0x0, 0x0, 0x5,
    0xf8, 0x0, 0x0, 0x3, 0xfb, 0x0, 0x0, 0x1,
    0xdf, 0x65, 0x55, 0x51, 0x5f, 0xff, 0xff, 0xff,
    0x30,

    /* U+007B "{" */
    0x0, 0xa, 0xfa, 0x0, 0x8f, 0x93, 0x0, 0xaf,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xaf, 0x0, 0x1, 0xde, 0x0, 0xf, 0xf7, 0x0,
    0x4, 0xee, 0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0x8f, 0x93, 0x0, 0x1b, 0xfa,

    /* U+007C "|" */
    0x3f, 0x43, 0xf4, 0x3f, 0x43, 0xf4, 0x3f, 0x43,
    0xf4, 0x3f, 0x43, 0xf4, 0x3f, 0x43, 0xf4, 0x3f,
    0x43, 0xf4, 0x3f, 0x43, 0xf4, 0x3f, 0x40,

    /* U+007D "}" */
    0xaf, 0xa0, 0x3, 0x9f, 0x70, 0x0, 0xfa, 0x0,
    0xf, 0xa0, 0x0, 0xfa, 0x0, 0xf, 0xa0, 0x0,
    0xec, 0x10, 0x7, 0xff, 0x0, 0xed, 0x40, 0xf,
    0xa0, 0x0, 0xfa, 0x0, 0xf, 0xa0, 0x0, 0xfa,
    0x3, 0x9f, 0x70, 0xaf, 0xa0, 0x0,

    /* U+007E "~" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xf8, 0x0,
    0x3d, 0xb, 0xa4, 0xd9, 0x9, 0xa0, 0xe2, 0x1,
    0xbf, 0xe2, 0x2, 0x0, 0x0, 0x10, 0x0,

    /* U+F001 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38,
    0xc8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x15, 0xae,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x2, 0x7c, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x6, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xfe, 0x0, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xb6, 0x13, 0xfe, 0x0, 0x0,
    0xe, 0xff, 0xd9, 0x40, 0x0, 0x3, 0xfe, 0x0,
    0x0, 0xe, 0xf4, 0x0, 0x0, 0x0, 0x3, 0xfe,
    0x0, 0x0, 0xe, 0xf3, 0x0, 0x0, 0x0, 0x3,
    0xfe, 0x0, 0x0, 0xe, 0xf3, 0x0, 0x0, 0x0,
    0x3, 0xfe, 0x0, 0x0, 0xe, 0xf3, 0x0, 0x0,
    0x1, 0x35, 0xfe, 0x0, 0x0, 0xe, 0xf3, 0x0,
    0x0, 0x9f, 0xff, 0xfe, 0x0, 0x0, 0x1e, 0xf3,
    0x0, 0x5, 0xff, 0xff, 0xfe, 0x4, 0xdf, 0xff,
    0xf3, 0x0, 0x4, 0xff, 0xff, 0xfb, 0xf, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x5c, 0xfe, 0x91, 0xf,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xdf, 0xfd, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F008 "" */
    0x90, 0x9, 0xcc, 0xcc, 0xcc, 0xcc, 0xc9, 0x0,
    0x9f, 0xbb, 0xff, 0xdd, 0xdd, 0xdd, 0xdf, 0xfb,
    0xbf, 0xf7, 0x6e, 0xc0, 0x0, 0x0, 0x0, 0xce,
    0x67, 0xff, 0x10, 0xdc, 0x0, 0x0, 0x0, 0xc,
    0xd0, 0x1f, 0xf9, 0x8f, 0xc0, 0x0, 0x0, 0x0,
    0xcf, 0x89, 0xff, 0xa9, 0xfd, 0x22, 0x22, 0x22,
    0x2d, 0xf9, 0xaf, 0xf1, 0xd, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x1, 0xff, 0x65, 0xee, 0x66, 0x66,
    0x66, 0x6e, 0xe5, 0x6f, 0xfc, 0xcf, 0xc0, 0x0,
    0x0, 0x0, 0xcf, 0xcc, 0xff, 0x10, 0xdc, 0x0,
    0x0, 0x0, 0xc, 0xd0, 0x1f, 0xf3, 0x2d, 0xc0,
    0x0, 0x0, 0x0, 0xcd, 0x23, 0xff, 0xff, 0xff,
    0x99, 0x99, 0x99, 0x9f, 0xff, 0xff, 0xd1, 0xd,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x1, 0xd0,

    /* U+F00B "" */
    0xcf, 0xff, 0xb0, 0xcf, 0xff, 0xff, 0xff, 0xff,
    0xcf, 0xff, 0xff, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x24, 0x44, 0x20, 0x24, 0x44, 0x44,
    0x44, 0x44, 0x22, 0x44, 0x42, 0x2, 0x44, 0x44,
    0x44, 0x44, 0x42, 0xff, 0xff, 0xe0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xfb, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x13, 0x33, 0x10,
    0x13, 0x33, 0x33, 0x33, 0x33, 0x1e, 0xff, 0xfd,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
    0xff, 0xc0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x11, 0x10, 0x0, 0x11, 0x11, 0x11, 0x11, 0x10,

    /* U+F00C "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x87,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xf3, 0x3, 0x40, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xf3, 0x4, 0xff, 0x50, 0x0, 0x0, 0x9f,
    0xff, 0xf3, 0x0, 0xef, 0xff, 0x50, 0x0, 0x9f,
    0xff, 0xf3, 0x0, 0x7, 0xff, 0xff, 0x50, 0x9f,
    0xff, 0xf3, 0x0, 0x0, 0x7, 0xff, 0xff, 0xbf,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F00D "" */
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xc1,
    0x0, 0x0, 0x3f, 0xd1, 0xef, 0xfc, 0x10, 0x3,
    0xff, 0xf9, 0x8f, 0xff, 0xc1, 0x3f, 0xff, 0xf4,
    0x9, 0xff, 0xfd, 0xff, 0xff, 0x40, 0x0, 0x9f,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0xa, 0xff, 0xff,
    0x50, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xc1, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x3f, 0xff,
    0xf4, 0x9f, 0xff, 0xc1, 0xef, 0xff, 0x40, 0x9,
    0xff, 0xf9, 0xaf, 0xf4, 0x0, 0x0, 0x9f, 0xf5,
    0x7, 0x30, 0x0, 0x0, 0x6, 0x40,

    /* U+F011 "" */
    0x0, 0x0, 0x0, 0x9, 0xd7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x0, 0xef, 0xb0, 0x2, 0x0,
    0x0, 0x0, 0x1d, 0xf1, 0xe, 0xfb, 0x3, 0xfb,
    0x0, 0x0, 0x1d, 0xff, 0x60, 0xef, 0xb0, 0x9f,
    0xfb, 0x0, 0x9, 0xff, 0xb0, 0xe, 0xfb, 0x1,
    0xdf, 0xf6, 0x1, 0xff, 0xd0, 0x0, 0xef, 0xb0,
    0x2, 0xff, 0xd0, 0x7f, 0xf5, 0x0, 0xe, 0xfb,
    0x0, 0x9, 0xff, 0x3a, 0xff, 0x10, 0x0, 0xef,
    0xb0, 0x0, 0x4f, 0xf6, 0xbf, 0xf0, 0x0, 0xe,
    0xfb, 0x0, 0x2, 0xff, 0x8a, 0xff, 0x0, 0x0,
    0x7a, 0x50, 0x0, 0x3f, 0xf7, 0x8f, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0x53, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xf0, 0xc, 0xff,
    0x70, 0x0, 0x0, 0x0, 0xaf, 0xf9, 0x0, 0x2f,
    0xff, 0xa2, 0x0, 0x3, 0xcf, 0xfd, 0x10, 0x0,
    0x4f, 0xff, 0xfe, 0xde, 0xff, 0xfe, 0x20, 0x0,
    0x0, 0x2d, 0xff, 0xff, 0xff, 0xfb, 0x10, 0x0,
    0x0, 0x0, 0x4, 0x9c, 0xdc, 0x93, 0x0, 0x0,
    0x0,

    /* U+F013 "" */
    0x0, 0x0, 0x0, 0x37, 0x97, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0xd, 0xb6, 0xef, 0xff, 0xff, 0xe6,
    0xbd, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x3f, 0xff, 0xff, 0xd3, 0x3,
    0xdf, 0xff, 0xff, 0x30, 0x1e, 0xff, 0xf2, 0x0,
    0x2, 0xff, 0xfe, 0x10, 0x0, 0xdf, 0xfe, 0x0,
    0x0, 0xe, 0xff, 0xd0, 0x0, 0xd, 0xff, 0xf0,
    0x0, 0x0, 0xff, 0xfd, 0x0, 0x2c, 0xff, 0xff,
    0xa0, 0x0, 0xaf, 0xff, 0xfc, 0x22, 0xff, 0xff,
    0xff, 0xec, 0xef, 0xff, 0xff, 0xf3, 0xb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x2f,
    0xea, 0xff, 0xff, 0xff, 0xfa, 0xef, 0x20, 0x0,
    0x20, 0x3, 0xdf, 0xff, 0xd3, 0x0, 0x20, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6b, 0xdc, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+F015 "" */
    0x0, 0x0, 0x0, 0x0, 0x6c, 0x70, 0x5, 0xdd,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xfb,
    0x7, 0xff, 0x30, 0x0, 0x0, 0x0, 0x1, 0xcf,
    0xfb, 0xff, 0xd9, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0x50, 0x3e, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x5, 0xff, 0xe3, 0x5f, 0x62, 0xdf, 0xff,
    0x30, 0x0, 0x0, 0x8f, 0xfc, 0x17, 0xff, 0xf9,
    0x1b, 0xff, 0x90, 0x0, 0xa, 0xff, 0xa1, 0xaf,
    0xff, 0xff, 0xc1, 0x8f, 0xfb, 0x10, 0xcf, 0xf7,
    0x1c, 0xff, 0xff, 0xff, 0xfd, 0x25, 0xff, 0xe0,
    0x8f, 0x43, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x3e, 0xa0, 0x1, 0xc, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x1, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xdc, 0xdf, 0xff, 0xff, 0x0, 0x0, 0x0, 0xd,
    0xff, 0xff, 0x0, 0xd, 0xff, 0xff, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0x0, 0xd, 0xff, 0xff,
    0x0, 0x0, 0x0, 0xd, 0xff, 0xff, 0x0, 0xd,
    0xff, 0xff, 0x0, 0x0, 0x0, 0xc, 0xff, 0xfe,
    0x0, 0xc, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F019 "" */
    0x0, 0x0, 0x0, 0x4c, 0xcc, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x66, 0xcf, 0xff,
    0xc6, 0x65, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x11, 0x11,
    0x13, 0xef, 0xe3, 0x11, 0x11, 0x10, 0xef, 0xff,
    0xff, 0x53, 0xc3, 0x5f, 0xff, 0xff, 0xef, 0xff,
    0xff, 0xff, 0x83, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0xd2, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd0,

    /* U+F01C "" */
    0x0, 0x1, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xc2,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0x5f, 0xf4, 0x22,
    0x22, 0x22, 0x23, 0xff, 0x70, 0x0, 0x1, 0xef,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0,
    0xa, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xfc, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x70, 0xef, 0xd6, 0x66, 0x40,
    0x0, 0x0, 0x36, 0x66, 0xcf, 0xf0, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0xef, 0xff, 0xff, 0xf1,
    0xff, 0xff, 0xff, 0xfa, 0x44, 0x48, 0xff, 0xff,
    0xff, 0xf2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x90,

    /* U+F021 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x10, 0x0, 0x0, 0x4, 0x78, 0x63, 0x0, 0x5,
    0xff, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xfd, 0x60,
    0x4f, 0xf0, 0x1, 0xdf, 0xff, 0xfe, 0xff, 0xff,
    0xc5, 0xff, 0x1, 0xef, 0xfb, 0x30, 0x0, 0x4b,
    0xff, 0xff, 0xf0, 0xaf, 0xf7, 0x0, 0x0, 0x0,
    0x5, 0xff, 0xff, 0x2f, 0xf8, 0x0, 0x0, 0x6,
    0xfe, 0xef, 0xff, 0xf7, 0xff, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0x25, 0x40, 0x0, 0x0,
    0x1, 0x55, 0x55, 0x55, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x45, 0x55, 0x55,
    0x51, 0x0, 0x0, 0x0, 0x35, 0x2f, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0xf, 0xf7, 0xff, 0xff,
    0xef, 0xf6, 0x0, 0x0, 0x7, 0xff, 0x2f, 0xff,
    0xf3, 0x0, 0x0, 0x0, 0x4, 0xff, 0xb0, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x7, 0xff, 0xf2, 0xf,
    0xf7, 0xff, 0xff, 0xa8, 0xae, 0xff, 0xf4, 0x0,
    0xff, 0x42, 0xaf, 0xff, 0xff, 0xff, 0xc2, 0x0,
    0xf, 0xf5, 0x0, 0x28, 0xbd, 0xc9, 0x40, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F026 "" */
    0x0, 0x0, 0x0, 0x8, 0x20, 0x0, 0x0, 0xb,
    0xf7, 0x0, 0x0, 0xb, 0xff, 0x84, 0x66, 0x6b,
    0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x8f,
    0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0x8c, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x4f,
    0xff, 0x80, 0x0, 0x0, 0x4f, 0xf8, 0x0, 0x0,
    0x0, 0x4f, 0x60, 0x0, 0x0, 0x0, 0x10,

    /* U+F027 "" */
    0x0, 0x0, 0x0, 0x7, 0x20, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0x80, 0x0, 0x4, 0x66, 0x6b, 0xff, 0xf8,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0x80, 0xca,
    0xf, 0xff, 0xff, 0xff, 0xf8, 0x8, 0xf7, 0xff,
    0xff, 0xff, 0xff, 0x80, 0xe, 0xbf, 0xff, 0xff,
    0xff, 0xf8, 0x4, 0xf9, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xde, 0x1c, 0xff, 0xff, 0xff, 0xf8, 0x2,
    0x10, 0x0, 0x0, 0x4f, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0,

    /* U+F028 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0x20, 0x0, 0x0, 0x8f, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x70, 0x0, 0x93, 0x7, 0xf8, 0x0,
    0x0, 0x0, 0xb, 0xff, 0x80, 0x0, 0xef, 0x50,
    0xbf, 0x20, 0x46, 0x66, 0xbf, 0xff, 0x80, 0x0,
    0x2d, 0xf1, 0x3f, 0x90, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xcb, 0x4, 0xf8, 0xc, 0xd0, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x7f, 0x70, 0xdc, 0x9, 0xf0,
    0xff, 0xff, 0xff, 0xff, 0x80, 0xe, 0xb0, 0xbe,
    0x8, 0xf1, 0xff, 0xff, 0xff, 0xff, 0x80, 0x4f,
    0x90, 0xcd, 0x8, 0xf1, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xde, 0x12, 0xf9, 0xb, 0xe0, 0xcf, 0xff,
    0xff, 0xff, 0x80, 0x21, 0xb, 0xf3, 0x1f, 0xa0,
    0x0, 0x0, 0x4f, 0xff, 0x80, 0x0, 0xbf, 0x80,
    0x8f, 0x40, 0x0, 0x0, 0x4, 0xff, 0x80, 0x0,
    0xd7, 0x3, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x60, 0x0, 0x0, 0x4f, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x3, 0xfd, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x81,
    0x0, 0x0,

    /* U+F03E "" */
    0x5c, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdc,
    0x5e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0xff, 0x91, 0x4e, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x8, 0xff, 0xff, 0xf4,
    0xbf, 0xff, 0xff, 0xfa, 0x36, 0xff, 0xff, 0xf3,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xef, 0xff, 0xf3,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xd1, 0x5f, 0xf3,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xd1, 0x0, 0x53,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xff, 0xff, 0x32, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,

    /* U+F043 "" */
    0x0, 0x0, 0xb, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xf6,
    0x0, 0x0, 0x0, 0x3, 0xff, 0xfe, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0x70, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xf1, 0x0, 0x1, 0xef, 0xff, 0xff,
    0xfb, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0xef, 0xdf, 0xff, 0xff,
    0xff, 0xf9, 0xff, 0x2c, 0xff, 0xff, 0xff, 0xfa,
    0xdf, 0x57, 0xff, 0xff, 0xff, 0xf8, 0x8f, 0xd1,
    0x8e, 0xff, 0xff, 0xf3, 0x1e, 0xfd, 0x40, 0xcf,
    0xff, 0xa0, 0x3, 0xef, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x19, 0xff, 0xfd, 0x70, 0x0, 0x0, 0x0,
    0x1, 0x10, 0x0, 0x0,

    /* U+F048 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xd5, 0x0,
    0x0, 0x3, 0xc5, 0xef, 0x70, 0x0, 0x4, 0xff,
    0xbe, 0xf7, 0x0, 0x5, 0xff, 0xfb, 0xef, 0x70,
    0x6, 0xff, 0xff, 0xbe, 0xf7, 0x7, 0xff, 0xff,
    0xfb, 0xef, 0x78, 0xff, 0xff, 0xff, 0xbe, 0xfe,
    0xff, 0xff, 0xff, 0xfb, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xef,
    0x8c, 0xff, 0xff, 0xff, 0xbe, 0xf7, 0xb, 0xff,
    0xff, 0xfb, 0xef, 0x70, 0x9, 0xff, 0xff, 0xbe,
    0xf7, 0x0, 0x8, 0xff, 0xfb, 0xef, 0x70, 0x0,
    0x7, 0xff, 0xbe, 0xf7, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04B "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xd8, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xfe, 0x60, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xc3, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xf9, 0x10, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd4, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfa, 0x10, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x5f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xb2, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xa1, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xfc, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04C "" */
    0x5c, 0xdd, 0xd9, 0x0, 0xa, 0xdd, 0xdc, 0x4f,
    0xff, 0xff, 0xf5, 0x6, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0x60, 0x7f, 0xff, 0xff, 0xef, 0xff,
    0xff, 0xf6, 0x7, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0x60, 0x7f, 0xff, 0xff, 0xef, 0xff, 0xff,
    0xf6, 0x7, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff,
    0x60, 0x7f, 0xff, 0xff, 0xef, 0xff, 0xff, 0xf6,
    0x7, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0x60,
    0x7f, 0xff, 0xff, 0xef, 0xff, 0xff, 0xf6, 0x7,
    0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0x60, 0x7f,
    0xff, 0xff, 0xef, 0xff, 0xff, 0xf6, 0x7, 0xff,
    0xff, 0xfe, 0xff, 0xff, 0xff, 0x60, 0x7f, 0xff,
    0xff, 0xef, 0xff, 0xff, 0xf5, 0x6, 0xff, 0xff,
    0xfe, 0x8f, 0xff, 0xfc, 0x0, 0x1d, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F04D "" */
    0x5c, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdc, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F051 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xc3, 0x0,
    0x0, 0x5, 0xdb, 0xbf, 0xf4, 0x0, 0x0, 0x7f,
    0xeb, 0xff, 0xf5, 0x0, 0x7, 0xfe, 0xbf, 0xff,
    0xf6, 0x0, 0x7f, 0xeb, 0xff, 0xff, 0xf7, 0x7,
    0xfe, 0xbf, 0xff, 0xff, 0xf9, 0x7f, 0xeb, 0xff,
    0xff, 0xff, 0xfe, 0xfe, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xeb, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xbf,
    0xff, 0xff, 0xfb, 0x8f, 0xeb, 0xff, 0xff, 0xfa,
    0x7, 0xfe, 0xbf, 0xff, 0xf9, 0x0, 0x7f, 0xeb,
    0xff, 0xf8, 0x0, 0x7, 0xfe, 0xbf, 0xf7, 0x0,
    0x0, 0x7f, 0xe7, 0xf6, 0x0, 0x0, 0x7, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F052 "" */
    0x0, 0x0, 0x0, 0x9, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe2, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe2, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x29, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x98, 0x10, 0x0, 0x23, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x20, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x0,

    /* U+F053 "" */
    0x0, 0x0, 0x0, 0x3, 0x70, 0x0, 0x0, 0x0,
    0x4f, 0xf7, 0x0, 0x0, 0x4, 0xff, 0xf6, 0x0,
    0x0, 0x4f, 0xff, 0x70, 0x0, 0x4, 0xff, 0xf7,
    0x0, 0x0, 0x4f, 0xff, 0x70, 0x0, 0x4, 0xff,
    0xf7, 0x0, 0x0, 0xf, 0xff, 0x90, 0x0, 0x0,
    0x8, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0x40, 0x0, 0x0, 0x8, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0x40, 0x0, 0x0, 0x8, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x8f, 0xf9, 0x0, 0x0,
    0x0, 0x7, 0xb1,

    /* U+F054 "" */
    0x1, 0x81, 0x0, 0x0, 0x0, 0xd, 0xfd, 0x10,
    0x0, 0x0, 0xc, 0xff, 0xd1, 0x0, 0x0, 0x1,
    0xcf, 0xfd, 0x10, 0x0, 0x0, 0x1c, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0xcf, 0xfd, 0x10, 0x0, 0x0,
    0xc, 0xff, 0xd1, 0x0, 0x0, 0x1, 0xef, 0xfa,
    0x0, 0x0, 0x9, 0xff, 0xf3, 0x0, 0x0, 0x9f,
    0xff, 0x30, 0x0, 0x9, 0xff, 0xf3, 0x0, 0x0,
    0x9f, 0xff, 0x30, 0x0, 0x9, 0xff, 0xf3, 0x0,
    0x0, 0xf, 0xfe, 0x30, 0x0, 0x0, 0x4, 0xc3,
    0x0, 0x0, 0x0,

    /* U+F067 "" */
    0x0, 0x0, 0x0, 0xac, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc1, 0x33, 0x33, 0x5f, 0xff,
    0x33, 0x33, 0x30, 0x0, 0x0, 0x2, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F068 "" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x30,

    /* U+F06E "" */
    0x0, 0x0, 0x0, 0x48, 0xab, 0xa8, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6e, 0xff, 0xfe, 0xff,
    0xfe, 0x70, 0x0, 0x0, 0x0, 0x1b, 0xff, 0xe5,
    0x0, 0x4, 0xdf, 0xfc, 0x20, 0x0, 0x1, 0xdf,
    0xfe, 0x10, 0x17, 0x50, 0xc, 0xff, 0xe2, 0x0,
    0xc, 0xff, 0xf4, 0x0, 0xf, 0xfc, 0x2, 0xff,
    0xfd, 0x10, 0x8f, 0xff, 0xe0, 0x0, 0x6f, 0xff,
    0x70, 0xcf, 0xff, 0xa0, 0xff, 0xff, 0xc0, 0x8f,
    0xff, 0xff, 0xb0, 0xaf, 0xff, 0xf1, 0xaf, 0xff,
    0xe0, 0x7f, 0xff, 0xff, 0x90, 0xcf, 0xff, 0xc0,
    0x1e, 0xff, 0xf2, 0xe, 0xff, 0xff, 0x21, 0xff,
    0xff, 0x30, 0x3, 0xff, 0xfb, 0x1, 0x9c, 0xa2,
    0xa, 0xff, 0xf5, 0x0, 0x0, 0x3e, 0xff, 0xb1,
    0x0, 0x0, 0x9f, 0xff, 0x50, 0x0, 0x0, 0x1,
    0x9f, 0xff, 0xb9, 0xbf, 0xff, 0xb2, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x7c, 0xef, 0xfc, 0x93, 0x0,
    0x0, 0x0,

    /* U+F070 "" */
    0x5b, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xe3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3d, 0xff,
    0x60, 0x3, 0x69, 0xba, 0x85, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xbf, 0xfb, 0xdf, 0xff, 0xef, 0xff,
    0xe7, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xfe,
    0x60, 0x0, 0x4c, 0xff, 0xd2, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0xff, 0x50, 0x86, 0x0, 0xcf, 0xfe,
    0x30, 0x0, 0x0, 0x70, 0x1, 0xcf, 0xf9, 0xff,
    0xd1, 0x2f, 0xff, 0xe1, 0x0, 0x7, 0xfc, 0x20,
    0x9, 0xff, 0xff, 0xf8, 0xb, 0xff, 0xfb, 0x0,
    0xe, 0xff, 0xe4, 0x0, 0x5f, 0xff, 0xfc, 0x9,
    0xff, 0xff, 0x20, 0x9, 0xff, 0xff, 0x0, 0x2,
    0xdf, 0xfc, 0xb, 0xff, 0xfd, 0x0, 0x1, 0xef,
    0xff, 0x40, 0x0, 0xa, 0xff, 0xbf, 0xff, 0xf3,
    0x0, 0x0, 0x3f, 0xff, 0xd0, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x3, 0xef, 0xfc,
    0x20, 0x0, 0x3, 0xef, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x19, 0xff, 0xfc, 0x99, 0x0, 0x1b, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x28, 0xce, 0xff,
    0xa0, 0x0, 0x8f, 0xfd, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xef, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2c, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F071 "" */
    0x0, 0x0, 0x0, 0x0, 0x6, 0xc7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xf2, 0x0, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xff, 0x20, 0xf,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xf3, 0x1, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xff, 0x40, 0x2f, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xf5, 0x3, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff,
    0xda, 0xdf, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xf6, 0x4, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0x10, 0xf, 0xff,
    0xff, 0xff, 0x30, 0xa, 0xff, 0xff, 0xff, 0xf9,
    0x17, 0xff, 0xff, 0xff, 0xfc, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x1, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x21, 0x0,

    /* U+F074 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0x30, 0xab, 0xbb, 0x60, 0x0, 0x0, 0x7b, 0xcf,
    0xff, 0x3f, 0xff, 0xff, 0x60, 0x0, 0x7f, 0xff,
    0xff, 0xfe, 0xef, 0xff, 0xff, 0x40, 0x6f, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x5f, 0xf3, 0x5f, 0xff,
    0x34, 0xff, 0x70, 0x0, 0x0, 0x64, 0x4f, 0xff,
    0x40, 0x2f, 0x70, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x63, 0x10, 0x1b, 0x30, 0x0, 0x0, 0x2e, 0xff,
    0x72, 0xed, 0x14, 0xff, 0x30, 0xab, 0xbe, 0xff,
    0x80, 0x9f, 0xfd, 0xcf, 0xff, 0x3f, 0xff, 0xff,
    0x90, 0x0, 0xbf, 0xff, 0xff, 0xfe, 0xef, 0xff,
    0xa0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F077 "" */
    0x0, 0x0, 0x0, 0x3b, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xef, 0xfe, 0x20, 0x0, 0x0, 0x3f,
    0xff, 0x90, 0xbf, 0xfe, 0x20, 0x0, 0x3e, 0xff,
    0x90, 0x0, 0xbf, 0xfe, 0x20, 0x3e, 0xff, 0x90,
    0x0, 0x0, 0xbf, 0xfe, 0x2b, 0xff, 0x90, 0x0,
    0x0, 0x0, 0xbf, 0xf9, 0x3e, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xad, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F078 "" */
    0x1a, 0x50, 0x0, 0x0, 0x0, 0x0, 0x69, 0xa,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x7f, 0xf8, 0x5f,
    0xff, 0x50, 0x0, 0x0, 0x7f, 0xff, 0x40, 0x6f,
    0xff, 0x50, 0x0, 0x7f, 0xff, 0x40, 0x0, 0x6f,
    0xff, 0x50, 0x7f, 0xff, 0x40, 0x0, 0x0, 0x6f,
    0xff, 0xaf, 0xff, 0x40, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F079 "" */
    0x0, 0x0, 0x7a, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xfc, 0x10,
    0x8e, 0xee, 0xee, 0xee, 0xea, 0x0, 0x0, 0x0,
    0x9f, 0xff, 0xfd, 0x16, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x9f, 0xff, 0xfe, 0xfd, 0x2,
    0x33, 0x33, 0x35, 0xff, 0x0, 0x0, 0xd, 0xf4,
    0xef, 0x4d, 0xf2, 0x0, 0x0, 0x0, 0x2f, 0xf0,
    0x0, 0x0, 0x2, 0xe, 0xf3, 0x12, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf0, 0x0,
    0x0, 0x0, 0xe, 0xf3, 0x0, 0x0, 0x0, 0x1,
    0x2, 0xff, 0x1, 0x0, 0x0, 0x0, 0xef, 0x30,
    0x0, 0x0, 0x1, 0xfd, 0x4f, 0xf3, 0xfd, 0x0,
    0x0, 0xe, 0xf5, 0x22, 0x22, 0x21, 0xd, 0xfe,
    0xff, 0xef, 0xb0, 0x0, 0x0, 0xef, 0xff, 0xff,
    0xff, 0xf6, 0x1d, 0xff, 0xff, 0xa0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0x90, 0x1c, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0x80, 0x0, 0x0,

    /* U+F07B "" */
    0x4b, 0xcc, 0xcc, 0xb3, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xaa, 0xaa,
    0xa9, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,

    /* U+F093 "" */
    0x0, 0x0, 0x0, 0x4, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x29, 0x99, 0xef, 0xff,
    0xc9, 0x97, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0x60, 0x0, 0x0, 0x0, 0x11, 0x11,
    0xd, 0xff, 0xf6, 0x1, 0x11, 0x10, 0xef, 0xff,
    0xf6, 0x8d, 0xdd, 0x36, 0xff, 0xff, 0xef, 0xff,
    0xff, 0xe5, 0x33, 0x35, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb4, 0xd2, 0xff,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd0,

    /* U+F095 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xb7, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xdf, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xef, 0xfd, 0x0, 0x0, 0x0, 0x27, 0x0, 0x0,
    0x1d, 0xff, 0xf4, 0x0, 0x0, 0x4b, 0xff, 0xb0,
    0x3, 0xef, 0xff, 0x70, 0x0, 0xc, 0xff, 0xff,
    0xf9, 0xaf, 0xff, 0xf9, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xe4, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xfd, 0xa5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F0C4 "" */
    0x4, 0xbc, 0x70, 0x0, 0x0, 0x0, 0x42, 0x0,
    0x5f, 0xff, 0xfa, 0x0, 0x0, 0x3e, 0xff, 0x90,
    0xdf, 0xa6, 0xff, 0x20, 0x2, 0xef, 0xff, 0x50,
    0xff, 0x20, 0xcf, 0x50, 0x2e, 0xff, 0xf5, 0x0,
    0xcf, 0xa7, 0xff, 0x32, 0xef, 0xff, 0x50, 0x0,
    0x4f, 0xff, 0xff, 0xcd, 0xff, 0xf5, 0x0, 0x0,
    0x3, 0xad, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x25, 0xef, 0xff, 0xfe, 0x20, 0x0, 0x0,
    0x1b, 0xff, 0xff, 0xff, 0xff, 0xe2, 0x0, 0x0,
    0x9f, 0xfe, 0xff, 0x67, 0xff, 0xfe, 0x20, 0x0,
    0xef, 0x40, 0xef, 0x40, 0x7f, 0xff, 0xe2, 0x0,
    0xef, 0x62, 0xef, 0x30, 0x6, 0xff, 0xfe, 0x20,
    0x8f, 0xff, 0xfd, 0x0, 0x0, 0x6f, 0xff, 0xb0,
    0x8, 0xef, 0xb2, 0x0, 0x0, 0x2, 0x76, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F0C5 "" */
    0x0, 0x0, 0xbf, 0xff, 0xff, 0x64, 0xa0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xf7, 0x4f, 0xb0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0x74, 0xff, 0xa8, 0xbb,
    0x2e, 0xff, 0xff, 0xf7, 0x3, 0x33, 0xff, 0xf3,
    0xef, 0xff, 0xff, 0xea, 0x99, 0x8f, 0xff, 0x3e,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xf3, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0x3e, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xf3, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xef, 0xff, 0x3e, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0xff, 0xf3, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xef, 0xff, 0x3e, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0xff, 0xf3, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xef, 0xff, 0x4b, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0xff, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x22, 0x22, 0x22, 0x22, 0x10, 0x0, 0x0,

    /* U+F0C7 "" */
    0x6e, 0xff, 0xff, 0xff, 0xff, 0xe9, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xff,
    0x52, 0x22, 0x22, 0x22, 0x8f, 0xf9, 0xf, 0xf2,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xf8, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0xef, 0xf2, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xfe, 0xff, 0x53, 0x33,
    0x33, 0x33, 0x8f, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xe2, 0x3,
    0xef, 0xff, 0xfe, 0xff, 0xff, 0xf6, 0x0, 0x7,
    0xff, 0xff, 0xef, 0xff, 0xff, 0x70, 0x0, 0x8f,
    0xff, 0xfe, 0xff, 0xff, 0xfe, 0x51, 0x5f, 0xff,
    0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x70, 0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0,

    /* U+F0C9 "" */
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x57,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x74, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xde, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x34, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd1, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x21,

    /* U+F0E0 "" */
    0x28, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x2d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x23, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe3, 0x5f, 0x71, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xb2, 0xaf, 0xff, 0xc2, 0x7f, 0xff, 0xff,
    0xff, 0x73, 0xdf, 0xff, 0xff, 0xf6, 0x3d, 0xff,
    0xfd, 0x37, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x19,
    0xe9, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x63, 0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,

    /* U+F0E7 "" */
    0x0, 0xbf, 0xff, 0xff, 0x40, 0x0, 0x0, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x2, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x9, 0xff,
    0xff, 0xfa, 0xaa, 0xa4, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0xd, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0x60, 0x7, 0x99,
    0x9b, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xf3, 0x0, 0x0, 0x0, 0xb, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x2f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xbb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+F0EA "" */
    0x0, 0x1, 0xbd, 0x50, 0x0, 0x0, 0x0, 0xa,
    0xdd, 0xee, 0xaf, 0xdd, 0xc2, 0x0, 0x0, 0xff,
    0xff, 0xa4, 0xff, 0xff, 0x60, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0xff, 0xff,
    0xf8, 0x66, 0x66, 0x20, 0x0, 0xf, 0xff, 0xf7,
    0x25, 0x55, 0x52, 0x11, 0x0, 0xff, 0xff, 0x4d,
    0xff, 0xff, 0x64, 0xe2, 0xf, 0xff, 0xf4, 0xef,
    0xff, 0xf6, 0x4f, 0xe2, 0xff, 0xff, 0x4e, 0xff,
    0xff, 0x63, 0xdd, 0xbf, 0xff, 0xf4, 0xef, 0xff,
    0xfc, 0x55, 0x54, 0xff, 0xff, 0x4e, 0xff, 0xff,
    0xff, 0xff, 0xef, 0xff, 0xf4, 0xef, 0xff, 0xff,
    0xff, 0xfe, 0xff, 0xff, 0x4e, 0xff, 0xff, 0xff,
    0xff, 0xec, 0xff, 0xf3, 0xef, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x2, 0x22, 0x22, 0x22, 0x20,

    /* U+F0F3 "" */
    0x0, 0x0, 0x0, 0x4c, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5d, 0xff, 0xfc, 0x30, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xd0, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x10, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x2, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe1, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xba, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,

    /* U+F11C "" */
    0x6e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0xff, 0x53, 0xf5, 0x2d,
    0x72, 0x5f, 0x35, 0xf3, 0x3f, 0xf2, 0xff, 0x20,
    0xe2, 0xc, 0x40, 0x2e, 0x2, 0xe0, 0xf, 0xf2,
    0xff, 0x64, 0xf6, 0x4e, 0x84, 0x7f, 0x46, 0xf4,
    0x5f, 0xf2, 0xff, 0xff, 0xce, 0xfc, 0xdf, 0xdc,
    0xfe, 0xcf, 0xff, 0xf2, 0xff, 0xfb, 0x5, 0xb0,
    0x1f, 0x30, 0x96, 0x9, 0xff, 0xf2, 0xff, 0xfc,
    0x17, 0xc1, 0x3f, 0x51, 0xb7, 0x1a, 0xff, 0xf2,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0xff, 0x20, 0xe2, 0x0, 0x0, 0x0,
    0x2, 0xf0, 0xf, 0xf2, 0xff, 0x42, 0xf4, 0x22,
    0x22, 0x22, 0x24, 0xf2, 0x2f, 0xf2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x90,

    /* U+F124 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x9d, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3b, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xcf, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x17, 0xef, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x1, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x1a, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x0, 0xd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0x3,
    0xab, 0xbb, 0xbb, 0xdf, 0xff, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F15B "" */
    0xcf, 0xff, 0xff, 0xf6, 0x49, 0x0, 0xf, 0xff,
    0xff, 0xff, 0x75, 0xfa, 0x0, 0xff, 0xff, 0xff,
    0xf7, 0x5f, 0xfa, 0xf, 0xff, 0xff, 0xff, 0x75,
    0xff, 0xf9, 0xff, 0xff, 0xff, 0xf7, 0x14, 0x44,
    0x4f, 0xff, 0xff, 0xff, 0xea, 0xaa, 0xa9, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F1EB "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x47, 0xac,
    0xdc, 0xb8, 0x50, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x8e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa3, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xfe, 0xde, 0xff,
    0xff, 0xff, 0xa1, 0x0, 0x1c, 0xff, 0xfe, 0x83,
    0x0, 0x0, 0x2, 0x7c, 0xff, 0xfe, 0x30, 0xdf,
    0xfe, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4d,
    0xff, 0xf2, 0x5f, 0xc1, 0x0, 0x0, 0x46, 0x77,
    0x51, 0x0, 0x0, 0x9f, 0x90, 0x2, 0x0, 0x2,
    0xaf, 0xff, 0xff, 0xff, 0xc4, 0x0, 0x3, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x2, 0xff, 0xfd, 0x73,
    0x23, 0x6b, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x60, 0x0, 0x0, 0x0, 0x3d, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xfd, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+F240 "" */
    0x6d, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xe8, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0xff, 0x53,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xff,
    0xb0, 0xff, 0x23, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x40, 0xff, 0xf3, 0xff, 0x2d, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x5f, 0xf3, 0xff,
    0x2d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0xe, 0xf3, 0xff, 0x2d, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x4f, 0xf3, 0xff, 0x2c, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xf3,
    0xff, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x6e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0,

    /* U+F241 "" */
    0x6d, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xe8, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0xff, 0x53,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xff,
    0xb0, 0xff, 0x24, 0x44, 0x44, 0x44, 0x44, 0x43,
    0x0, 0x0, 0xff, 0xf3, 0xff, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x0, 0x5f, 0xf3, 0xff,
    0x2e, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0,
    0xe, 0xf3, 0xff, 0x2e, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x0, 0x4f, 0xf3, 0xff, 0x2e, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xff, 0xf3,
    0xff, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x6e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0,

    /* U+F242 "" */
    0x6d, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xe8, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0xff, 0x53,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xff,
    0xb0, 0xff, 0x24, 0x44, 0x44, 0x44, 0x20, 0x0,
    0x0, 0x0, 0xff, 0xf3, 0xff, 0x2e, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x5f, 0xf3, 0xff,
    0x2e, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0,
    0xe, 0xf3, 0xff, 0x2e, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x4f, 0xf3, 0xff, 0x2e, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0xff, 0xf3,
    0xff, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x6e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0,

    /* U+F243 "" */
    0x6d, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xe8, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0xff, 0x53,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xff,
    0xb0, 0xff, 0x24, 0x44, 0x41, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xf3, 0xff, 0x2e, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf3, 0xff,
    0x2e, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xf3, 0xff, 0x2e, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xf3, 0xff, 0x2e, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf3,
    0xff, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x6e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0,

    /* U+F244 "" */
    0x6d, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xe8, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0xff, 0x53,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xff,
    0xb0, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xf3, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xf3, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xf3, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xf3, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xf3,
    0xff, 0x42, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x6e, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0,

    /* U+F287 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xd6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3a,
    0xbf, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xfa, 0x8f, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xb0, 0x5, 0x93,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xb6, 0x0, 0x1f,
    0x30, 0x0, 0x0, 0x0, 0x1, 0x30, 0x0, 0xaf,
    0xff, 0x60, 0xab, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xfa, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe2, 0xcf, 0xff, 0x93,
    0x33, 0x8f, 0x43, 0x33, 0x33, 0x36, 0xfd, 0x40,
    0x2c, 0xea, 0x0, 0x0, 0xd, 0x70, 0x0, 0x0,
    0x2, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xe0, 0x7, 0x88, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xca, 0x5f, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1a, 0xdf,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F293 "" */
    0x0, 0x3, 0x9c, 0xdc, 0xa5, 0x0, 0x0, 0x9,
    0xff, 0xfc, 0xff, 0xfb, 0x0, 0x7, 0xff, 0xff,
    0x1c, 0xff, 0xf9, 0x1, 0xff, 0xff, 0xf0, 0x1d,
    0xff, 0xf2, 0x6f, 0xff, 0xff, 0x3, 0x1d, 0xff,
    0x7a, 0xfe, 0x1a, 0xf0, 0x97, 0x1e, 0xfa, 0xcf,
    0xf8, 0xa, 0x8, 0x35, 0xff, 0xcd, 0xff, 0xf8,
    0x0, 0x4, 0xff, 0xfd, 0xef, 0xff, 0xf7, 0x1,
    0xff, 0xff, 0xee, 0xff, 0xfe, 0x20, 0x9, 0xff,
    0xfe, 0xdf, 0xfe, 0x23, 0x4, 0xa, 0xff, 0xdb,
    0xfe, 0x23, 0xf0, 0x98, 0xc, 0xfc, 0x8f, 0xf8,
    0xff, 0x17, 0x16, 0xff, 0x93, 0xff, 0xff, 0xf1,
    0x6, 0xff, 0xf4, 0xb, 0xff, 0xff, 0x17, 0xff,
    0xfd, 0x0, 0x1d, 0xff, 0xf8, 0xff, 0xff, 0x30,
    0x0, 0x8, 0xdf, 0xff, 0xfa, 0x30, 0x0, 0x0,
    0x0, 0x1, 0x10, 0x0, 0x0,

    /* U+F2ED "" */
    0x0, 0x0, 0x2d, 0xee, 0xec, 0x10, 0x0, 0xc,
    0xee, 0xee, 0xff, 0xff, 0xfe, 0xee, 0xeb, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0xc, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xda, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0xf, 0xfd, 0x8f,
    0xf6, 0xff, 0x7f, 0xfd, 0x0, 0xff, 0xb3, 0xfe,
    0xf, 0xf1, 0xdf, 0xd0, 0xf, 0xfb, 0x3f, 0xe0,
    0xff, 0x1d, 0xfd, 0x0, 0xff, 0xb3, 0xfe, 0xf,
    0xf1, 0xdf, 0xd0, 0xf, 0xfb, 0x3f, 0xe0, 0xff,
    0x1d, 0xfd, 0x0, 0xff, 0xb3, 0xfe, 0xf, 0xf1,
    0xdf, 0xd0, 0xf, 0xfb, 0x3f, 0xe0, 0xff, 0x1d,
    0xfd, 0x0, 0xff, 0xb3, 0xfe, 0xf, 0xf1, 0xdf,
    0xd0, 0xf, 0xfc, 0x4f, 0xf2, 0xff, 0x3e, 0xfd,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x1, 0x22, 0x22, 0x22, 0x22, 0x21, 0x0,

    /* U+F304 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xd6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x81, 0x9f, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xfd, 0x19, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xd1, 0x9f, 0xc1, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xff, 0xfd, 0x17, 0x10, 0x0,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xfc, 0x10,
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xc1,
    0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xfc,
    0x10, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xc1, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xff, 0xc1, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xff, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xda, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+F55A "" */
    0x0, 0x0, 0x4, 0xac, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcc, 0xca, 0x30, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf3, 0x0, 0x5f, 0xff, 0xff, 0xf8, 0x1d, 0xff,
    0x62, 0xef, 0xff, 0xf4, 0x5, 0xff, 0xff, 0xff,
    0xf3, 0x1, 0xc6, 0x0, 0xbf, 0xff, 0xf4, 0x5f,
    0xff, 0xff, 0xff, 0xfe, 0x30, 0x0, 0xa, 0xff,
    0xff, 0xf4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1,
    0x0, 0x7f, 0xff, 0xff, 0xf4, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x1c, 0xff, 0xff, 0xf4,
    0x9, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x93, 0x1,
    0xdf, 0xff, 0xf4, 0x0, 0x9f, 0xff, 0xff, 0xf4,
    0xa, 0xfe, 0x30, 0xcf, 0xff, 0xf4, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xcf, 0xff, 0xfd, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x7, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x60,

    /* U+F7C2 "" */
    0x0, 0x4, 0xff, 0xff, 0xff, 0xfc, 0x20, 0x4,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x4, 0xfc, 0x2e,
    0x43, 0xf3, 0x5f, 0xe4, 0xff, 0xb0, 0xe2, 0xf,
    0x3, 0xfe, 0xff, 0xfb, 0xe, 0x20, 0xf0, 0x3f,
    0xef, 0xff, 0xea, 0xfb, 0xaf, 0xab, 0xfe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xed, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x4e, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+F8A2 "" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf1, 0x0, 0x0, 0x71, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xf1, 0x0, 0x1c, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xf1, 0x1, 0xdf, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xf1, 0x2e, 0xff, 0xfc,
    0xaa, 0xaa, 0xaa, 0xaa, 0xdf, 0xf1, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x6, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xd3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 73, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 73, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18, .adv_w = 106, .box_w = 5, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 31, .adv_w = 191, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 103, .adv_w = 169, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 183, .adv_w = 229, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 267, .adv_w = 187, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 345, .adv_w = 57, .box_w = 2, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 350, .adv_w = 92, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 388, .adv_w = 92, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 426, .adv_w = 109, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 451, .adv_w = 158, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 483, .adv_w = 62, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 493, .adv_w = 104, .box_w = 6, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 502, .adv_w = 62, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 508, .adv_w = 96, .box_w = 8, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 572, .adv_w = 181, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 638, .adv_w = 101, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 668, .adv_w = 156, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 728, .adv_w = 156, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 782, .adv_w = 182, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 854, .adv_w = 156, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 914, .adv_w = 168, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 980, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1040, .adv_w = 175, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1106, .adv_w = 168, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1166, .adv_w = 62, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1184, .adv_w = 62, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1208, .adv_w = 158, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1240, .adv_w = 158, .box_w = 8, .box_h = 6, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1264, .adv_w = 158, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1296, .adv_w = 156, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1350, .adv_w = 281, .box_w = 17, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1478, .adv_w = 199, .box_w = 14, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1562, .adv_w = 206, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1634, .adv_w = 197, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1706, .adv_w = 225, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1784, .adv_w = 182, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1844, .adv_w = 173, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1904, .adv_w = 210, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1976, .adv_w = 221, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2048, .adv_w = 84, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2066, .adv_w = 140, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2120, .adv_w = 196, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2192, .adv_w = 162, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2246, .adv_w = 260, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2330, .adv_w = 221, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2402, .adv_w = 228, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2486, .adv_w = 196, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2552, .adv_w = 228, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2665, .adv_w = 198, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2731, .adv_w = 169, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2791, .adv_w = 160, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2851, .adv_w = 215, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2917, .adv_w = 194, .box_w = 14, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3001, .adv_w = 306, .box_w = 19, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3115, .adv_w = 183, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3187, .adv_w = 176, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3265, .adv_w = 179, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3331, .adv_w = 91, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3369, .adv_w = 96, .box_w = 8, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 3433, .adv_w = 91, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3463, .adv_w = 159, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 3491, .adv_w = 136, .box_w = 9, .box_h = 2, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3500, .adv_w = 163, .box_w = 6, .box_h = 2, .ofs_x = 1, .ofs_y = 10},
    {.bitmap_index = 3506, .adv_w = 163, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3547, .adv_w = 186, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3607, .adv_w = 155, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3652, .adv_w = 186, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3718, .adv_w = 166, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3763, .adv_w = 96, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3805, .adv_w = 188, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3871, .adv_w = 185, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3931, .adv_w = 76, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3949, .adv_w = 77, .box_w = 6, .box_h = 15, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 3994, .adv_w = 168, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4054, .adv_w = 76, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4072, .adv_w = 288, .box_w = 16, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4144, .adv_w = 185, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4189, .adv_w = 173, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4239, .adv_w = 186, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4299, .adv_w = 186, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4365, .adv_w = 112, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4392, .adv_w = 136, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4433, .adv_w = 113, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4472, .adv_w = 184, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4513, .adv_w = 152, .box_w = 11, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4563, .adv_w = 245, .box_w = 16, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4635, .adv_w = 150, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4680, .adv_w = 152, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 4746, .adv_w = 142, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4787, .adv_w = 95, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4832, .adv_w = 81, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4855, .adv_w = 95, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4893, .adv_w = 158, .box_w = 9, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 4916, .adv_w = 272, .box_w = 18, .box_h = 18, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 5078, .adv_w = 272, .box_w = 17, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5189, .adv_w = 272, .box_w = 17, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5325, .adv_w = 272, .box_w = 17, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5436, .adv_w = 187, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5514, .adv_w = 272, .box_w = 17, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5659, .adv_w = 272, .box_w = 17, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5812, .adv_w = 306, .box_w = 20, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 5972, .adv_w = 272, .box_w = 17, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6117, .adv_w = 306, .box_w = 20, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6247, .adv_w = 272, .box_w = 17, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6409, .adv_w = 136, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6472, .adv_w = 204, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6563, .adv_w = 306, .box_w = 20, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6733, .adv_w = 272, .box_w = 17, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6844, .adv_w = 187, .box_w = 12, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6952, .adv_w = 238, .box_w = 11, .box_h = 17, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 7046, .adv_w = 238, .box_w = 15, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7189, .adv_w = 238, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7309, .adv_w = 238, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7429, .adv_w = 238, .box_w = 11, .box_h = 17, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 7523, .adv_w = 238, .box_w = 17, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 7659, .adv_w = 170, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7734, .adv_w = 170, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7809, .adv_w = 238, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 7929, .adv_w = 238, .box_w = 15, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 7959, .adv_w = 306, .box_w = 20, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8089, .adv_w = 340, .box_w = 22, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8287, .adv_w = 306, .box_w = 21, .box_h = 18, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 8476, .adv_w = 272, .box_w = 17, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 8612, .adv_w = 238, .box_w = 15, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8687, .adv_w = 238, .box_w = 15, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 8762, .adv_w = 340, .box_w = 23, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8912, .adv_w = 272, .box_w = 17, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9023, .adv_w = 272, .box_w = 17, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9168, .adv_w = 272, .box_w = 18, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 9339, .adv_w = 238, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9467, .adv_w = 238, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9602, .adv_w = 238, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 9722, .adv_w = 238, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9827, .adv_w = 272, .box_w = 17, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9938, .adv_w = 170, .box_w = 12, .box_h = 18, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 10046, .adv_w = 238, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10181, .adv_w = 238, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10316, .adv_w = 306, .box_w = 20, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10446, .adv_w = 272, .box_w = 19, .box_h = 19, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 10627, .adv_w = 204, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10744, .adv_w = 340, .box_w = 22, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 10931, .adv_w = 340, .box_w = 22, .box_h = 11, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11052, .adv_w = 340, .box_w = 22, .box_h = 11, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11173, .adv_w = 340, .box_w = 22, .box_h = 11, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11294, .adv_w = 340, .box_w = 22, .box_h = 11, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11415, .adv_w = 340, .box_w = 22, .box_h = 11, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 11536, .adv_w = 340, .box_w = 22, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11690, .adv_w = 238, .box_w = 13, .box_h = 18, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 11807, .adv_w = 238, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11942, .adv_w = 272, .box_w = 18, .box_h = 18, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 12104, .adv_w = 340, .box_w = 22, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12247, .adv_w = 204, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12364, .adv_w = 274, .box_w = 18, .box_h = 11, .ofs_x = 0, .ofs_y = 1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_1[] = {
    0x0, 0x7, 0xa, 0xb, 0xc, 0x10, 0x12, 0x14,
    0x18, 0x1b, 0x20, 0x25, 0x26, 0x27, 0x3d, 0x42,
    0x47, 0x4a, 0x4b, 0x4c, 0x50, 0x51, 0x52, 0x53,
    0x66, 0x67, 0x6d, 0x6f, 0x70, 0x73, 0x76, 0x77,
    0x78, 0x7a, 0x92, 0x94, 0xc3, 0xc4, 0xc6, 0xc8,
    0xdf, 0xe6, 0xe9, 0xf2, 0x11b, 0x123, 0x15a, 0x1ea,
    0x23f, 0x240, 0x241, 0x242, 0x243, 0x286, 0x292, 0x2ec,
    0x303, 0x559, 0x7c1, 0x8a1
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 61441, .range_length = 2210, .glyph_id_start = 96,
        .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 60, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 0, 1, 2, 0, 3, 4, 5,
    2, 6, 7, 8, 9, 10, 9, 10,
    11, 12, 0, 13, 14, 15, 16, 17,
    18, 19, 12, 20, 20, 0, 0, 0,
    21, 22, 23, 24, 25, 22, 26, 27,
    28, 29, 29, 30, 31, 32, 29, 29,
    22, 33, 34, 35, 3, 36, 30, 37,
    37, 38, 39, 40, 41, 42, 43, 0,
    44, 0, 45, 46, 47, 48, 49, 50,
    51, 45, 52, 52, 53, 48, 45, 45,
    46, 46, 54, 55, 56, 57, 51, 58,
    58, 59, 58, 60, 41, 0, 0, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 1, 2, 0, 3, 4, 5,
    2, 6, 7, 8, 9, 10, 9, 10,
    11, 12, 13, 14, 15, 16, 17, 12,
    18, 19, 20, 21, 21, 0, 0, 0,
    22, 23, 24, 25, 23, 25, 25, 25,
    23, 25, 25, 26, 25, 25, 25, 25,
    23, 25, 23, 25, 3, 27, 28, 29,
    29, 30, 31, 32, 33, 34, 35, 0,
    36, 0, 37, 38, 39, 39, 39, 0,
    39, 38, 40, 41, 38, 38, 42, 42,
    39, 42, 39, 42, 43, 44, 45, 46,
    46, 47, 46, 48, 0, 0, 35, 9,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 3, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 12, 0, 7, -6, 0, 0, 0,
    0, -15, -16, 2, 13, 6, 5, -11,
    2, 13, 1, 11, 3, 9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 16, 2, -2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, -5,
    5, 5, 0, 0, -3, 0, -2, 3,
    0, -3, 0, -3, -1, -5, 0, 0,
    0, 0, -3, 0, 0, -4, -4, 0,
    0, -3, 0, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, -7, 0, -33, 0, 0, -5, 0,
    5, 8, 0, 0, -5, 3, 3, 9,
    5, -5, 5, 0, 0, -16, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, -13, 0, -11, -2, 0, 0, 0,
    0, 1, 11, 0, -8, -2, -1, 1,
    0, -5, 0, 0, -2, -20, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -22, -2, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 9, 0, 3, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 2, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 5, 3, 8, -3, 0, 0, 5,
    -3, -9, -37, 2, 7, 5, 1, -4,
    0, 10, 0, 9, 0, 9, 0, -25,
    0, -3, 8, 0, 9, -3, 5, 3,
    0, 0, 1, -3, 0, 0, -5, 22,
    0, 22, 0, 8, 0, 11, 4, 5,
    0, 0, 0, -10, 0, 0, 0, 0,
    1, -2, 0, 2, -5, -4, -5, 2,
    0, -3, 0, 0, 0, -11, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -18, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, -15, 0, -17, 0, 0, 0, 0,
    -2, 0, 27, -3, -4, 3, 3, -2,
    0, -4, 3, 0, 0, -14, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -26, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 16, 0, 0, -10, 0, 9, 0,
    -18, -26, -18, -5, 8, 0, 0, -18,
    0, 3, -6, 0, -4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 7, 8, -33, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, 0, 0, 2,
    2, -3, -5, 0, -1, -1, -3, 0,
    0, -2, 0, 0, 0, -5, 0, -2,
    0, -6, -5, 0, -7, -9, -9, -5,
    0, -5, 0, -5, 0, 0, 0, 0,
    -2, 0, 0, 3, 0, 2, -3, 0,
    0, 0, 0, 3, -2, 0, 0, 0,
    -2, 3, 3, -1, 0, 0, 0, -5,
    0, -1, 0, 0, 0, 0, 0, 1,
    0, 4, -2, 0, -3, 0, -5, 0,
    0, -2, 0, 8, 0, 0, -3, 0,
    0, 0, 0, 0, -1, 1, -2, -2,
    0, -3, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -1, -1, 0,
    -3, -3, 0, 0, 0, 0, 0, 1,
    0, 0, -2, 0, -3, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, 0, -2, -4, 0,
    0, -8, -2, -8, 5, 0, 0, -5,
    3, 5, 7, 0, -7, -1, -3, 0,
    -1, -13, 3, -2, 2, -14, 3, 0,
    0, 1, -14, 0, -14, -2, -24, -2,
    0, -14, 0, 5, 8, 0, 4, 0,
    0, 0, 0, 1, 0, -5, -4, 0,
    0, 0, 0, -3, 0, 0, 0, -3,
    0, 0, 0, 0, 0, -1, -1, 0,
    -1, -4, 0, 0, 0, 0, 0, 0,
    0, -3, -3, 0, -2, -3, -2, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, -2, 0,
    0, -2, 0, -5, 3, 0, 0, -3,
    1, 3, 3, 0, 0, 0, 0, 0,
    0, -2, 0, 0, 0, 0, 0, 2,
    0, 0, -3, 0, -3, -2, -3, 0,
    0, 0, 0, 0, 0, 0, 2, 0,
    -2, 0, 0, 0, 0, -3, -4, 0,
    0, 8, -2, 1, -9, 0, 0, 7,
    -14, -14, -11, -5, 3, 0, -2, -18,
    -5, 0, -5, 0, -5, 4, -5, -17,
    0, -7, 0, 0, 1, -1, 2, -2,
    0, 3, 0, -8, -10, 0, -14, -7,
    -6, -7, -8, -3, -7, -1, -5, -7,
    0, 1, 0, -3, 0, 0, 0, 2,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -1,
    0, -1, -3, 0, -5, -6, -6, -1,
    0, -8, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, 0, 1, -2, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 13, 0, 0, 0, 0, 0,
    0, 2, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, -5, 0, 0, 0,
    0, -14, -8, 0, 0, 0, -4, -14,
    0, 0, -3, 3, 0, -7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 3, 0,
    2, -5, -5, 0, -3, -3, -3, 0,
    0, 0, 0, 0, 0, -8, 0, -3,
    0, -4, -3, 0, -6, -7, -8, -2,
    0, -5, 0, -8, 0, 0, 0, 0,
    22, 0, 0, 1, 0, 0, -4, 0,
    0, -12, 0, 0, 0, 0, 0, -25,
    -5, 9, 8, -2, -11, 0, 3, -4,
    0, -14, -1, -4, 3, -19, -3, 4,
    0, 4, -10, -4, -10, -9, -11, 0,
    0, -16, 0, 16, 0, 0, -1, 0,
    0, 0, -1, -1, -3, -7, -9, -1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, -1, -3, -4, 0,
    0, -5, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -1, 0, -5, 0, 0, 5,
    -1, 4, 0, -6, 3, -2, -1, -7,
    -3, 0, -4, -3, -2, 0, -4, -5,
    0, 0, -2, -1, -2, -5, -3, 0,
    0, -3, 0, 3, -2, 0, -6, 0,
    0, 0, -5, 0, -5, 0, -5, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 3, 0, -4, 0, -2, -3, -8,
    -2, -2, -2, -1, -2, -3, -1, 0,
    0, 0, 0, 0, -3, -2, -2, 0,
    0, 0, 0, 3, -2, 0, -2, 0,
    0, 0, -2, -3, -2, -2, -3, -2,
    2, 11, -1, 0, -7, 0, -2, 5,
    0, -3, -11, -4, 4, 0, 0, -13,
    -5, 3, -5, 2, 0, -2, -2, -9,
    0, -4, 1, 0, 0, -5, 0, 0,
    0, 3, 3, -5, -5, 0, -5, -3,
    -4, -3, -3, 0, -5, 1, -5, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, -4, 0, 0, -3, -3, 0,
    0, 0, 0, -3, 0, 0, 0, 0,
    -1, 0, 0, 0, 0, 0, -2, 0,
    0, 0, -4, 0, -5, 0, 0, 0,
    -9, 0, 2, -6, 5, 1, -2, -13,
    0, 0, -6, -3, 0, -11, -7, -8,
    0, 0, -12, -3, -11, -10, -13, 0,
    -7, 0, 2, 18, -4, 0, -6, -3,
    -1, -3, -5, -7, -5, -10, -11, -6,
    0, 0, -2, 0, 1, 0, 0, -19,
    -2, 8, 6, -6, -10, 0, 1, -8,
    0, -14, -2, -3, 5, -25, -4, 1,
    0, 0, -18, -3, -14, -3, -20, 0,
    0, -19, 0, 16, 1, 0, -2, 0,
    0, 0, 0, -1, -2, -10, -2, 0,
    0, 0, 0, 0, -9, 0, -2, 0,
    -1, -8, -13, 0, 0, -1, -4, -8,
    -3, 0, -2, 0, 0, 0, 0, -12,
    -3, -9, -9, -2, -5, -7, -3, -5,
    0, -5, -2, -9, -4, 0, -3, -5,
    -3, -5, 0, 1, 0, -2, -9, 0,
    0, -5, 0, 0, 0, 0, 3, 0,
    2, -5, 11, 0, -3, -3, -3, 0,
    0, 0, 0, 0, 0, -8, 0, -3,
    0, -4, -3, 0, -6, -7, -8, -2,
    0, -5, 2, 11, 0, 0, 0, 0,
    22, 0, 0, 1, 0, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, 0, 0, 0, 0, -2, -5,
    0, 0, 0, 0, 0, -1, 0, 0,
    0, -3, -3, 0, 0, -5, -3, 0,
    0, -5, 0, 5, -1, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0,
    5, 2, -2, 0, -9, -4, 0, 8,
    -9, -9, -5, -5, 11, 5, 3, -24,
    -2, 5, -3, 0, -3, 3, -3, -10,
    0, -3, 3, -4, -2, -8, -2, 0,
    0, 8, 5, 0, -8, 0, -15, -4,
    8, -4, -10, 1, -4, -9, -9, -3,
    3, 0, -4, 0, -7, 0, 2, 9,
    -6, -10, -11, -7, 8, 0, 1, -20,
    -2, 3, -5, -2, -6, 0, -6, -10,
    -4, -4, -2, 0, 0, -6, -6, -3,
    0, 8, 6, -3, -15, 0, -15, -4,
    0, -10, -16, -1, -9, -5, -9, -8,
    0, 0, -4, 0, -5, -2, 0, -3,
    -5, 0, 5, -9, 3, 0, 0, -14,
    0, -3, -6, -5, -2, -8, -7, -9,
    -6, 0, -8, -3, -6, -5, -8, -3,
    0, 0, 1, 13, -5, 0, -8, -3,
    0, -3, -5, -6, -7, -8, -10, -4,
    5, 0, -4, 0, -14, -3, 2, 5,
    -9, -10, -5, -9, 9, -3, 1, -25,
    -5, 5, -6, -5, -10, 0, -8, -11,
    -3, -3, -2, -3, -6, -8, -1, 0,
    0, 8, 8, -2, -18, 0, -16, -6,
    7, -10, -18, -5, -10, -11, -14, -9,
    0, 0, 0, 0, -3, 0, 0, 3,
    -3, 5, 2, -5, 5, 0, 0, -8,
    -1, 0, -1, 0, 1, 1, -2, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 2, 8, 1, 0, -3, 0,
    0, 0, 0, -2, -2, -3, 0, 0,
    1, 2, 0, 0, 0, 0, 2, 0,
    -2, 0, 10, 0, 5, 1, 1, -4,
    0, 5, 0, 0, 0, 2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8, 0, 8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -16, 0, -3, 5, 0, 8, 0,
    0, 27, 3, -5, -5, 3, 3, -2,
    1, -14, 0, 0, 13, -16, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -18, 10, 38, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, 0, -5, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 0, -7, 0, 0, 1, 0,
    0, 3, 35, -5, -2, 9, 7, -7,
    3, 0, 0, 3, 3, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -35, 8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, 0, 0, 0, -7,
    0, 0, 0, 0, -6, -1, 0, 0,
    0, -6, 0, -3, 0, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -18, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, -4, 0, -7, 0, 0, 0, -5,
    3, -3, 0, 0, -7, -3, -6, 0,
    0, -7, 0, -3, 0, -13, 0, -3,
    0, 0, -22, -5, -11, -3, -10, 0,
    0, -18, 0, -7, -1, 0, 0, 0,
    0, 0, 0, 0, 0, -4, -5, -2,
    0, 0, 0, 0, -6, 0, -6, 4,
    -3, 5, 0, -2, -6, -2, -5, -5,
    0, -3, -1, -2, 2, -7, -1, 0,
    0, 0, -24, -2, -4, 0, -6, 0,
    -2, -13, -2, 0, 0, -2, -2, 0,
    0, 0, 0, 2, 0, -2, -5, -2,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 0, 0, 0, 0,
    0, -6, 0, -2, 0, 0, 0, -5,
    3, 0, 0, 0, -7, -3, -5, 0,
    0, -8, 0, -3, 0, -13, 0, 0,
    0, 0, -26, 0, -5, -10, -14, 0,
    0, -18, 0, -2, -4, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -4, -1,
    1, 0, 0, 5, -4, 0, 8, 13,
    -3, -3, -8, 3, 13, 5, 6, -7,
    3, 11, 3, 8, 6, 7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 13, -5, -3, 0, -2, 22,
    12, 22, 0, 0, 0, 3, 0, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, -23, -3, -2, -11, -13, 0,
    0, -18, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, -23, -3, -2, -11, -13, 0,
    0, -11, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    -6, 3, 0, -3, 2, 5, 3, -8,
    0, -1, -2, 3, 0, 2, 0, 0,
    0, 0, -7, 0, -2, -2, -5, 0,
    -2, -11, 0, 17, -3, 0, -6, -2,
    0, -2, -5, 0, -3, -8, -5, -3,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, 0, 0, 0,
    0, 0, 0, 0, 0, 4, 0, 0,
    0, 0, -23, -3, -2, -11, -13, 0,
    0, -18, 0, 0, 0, 0, 0, 0,
    14, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, -9, -3, -2, 8,
    -2, -3, -11, 1, -2, 1, -2, -7,
    1, 6, 1, 2, 1, 2, -7, -11,
    -3, 0, -10, -5, -7, -11, -11, 0,
    -4, -5, -3, -4, -2, -2, -3, -2,
    0, -2, -1, 4, 0, 4, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -2, -3, -3, 0,
    0, -7, 0, -1, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -16, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, 0, 0, 0, -2, 0, 0, -5,
    -3, 3, 0, -5, -5, -2, 0, -8,
    -2, -6, -2, -3, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -18, 0, 9, 0, 0, -5, 0,
    0, 0, 0, -4, 0, -3, 0, 0,
    0, 0, -2, 0, -6, 0, 0, 11,
    -4, -9, -8, 2, 3, 3, -1, -8,
    2, 4, 2, 8, 2, 9, -2, -7,
    0, 0, -11, 0, 0, -8, -7, 0,
    0, -5, 0, -4, -5, 0, -4, 0,
    -4, 0, -2, 4, 0, -2, -8, -3,
    0, 0, -2, 0, -5, 0, 0, 4,
    -6, 0, 3, -3, 2, 0, 0, -9,
    0, -2, -1, 0, -3, 3, -2, 0,
    0, 0, -11, -3, -6, 0, -8, 0,
    0, -13, 0, 10, -3, 0, -5, 0,
    2, 0, -3, 0, -3, -8, 0, -3,
    0, 0, 0, 0, -2, 0, 0, 3,
    -4, 1, 0, 0, -3, -2, 0, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 6, 0, 0, -2, 0,
    0, 0, 0, 1, 0, -3, -3, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 60,
    .right_class_cnt     = 48,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t lv_font_montserratMedium_17 = {
#else
lv_font_t lv_font_montserratMedium_17 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 19,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if LV_FONT_MONTSERRATMEDIUM_17*/

