/*
 * start rewrite from:
 * https://github.com/adafruit/Adafruit-GFX-Library.git
 * https://github.com/ananevilya/Arduino-AXS15231B-Library.git
 */
#ifndef _ARDUINO_AXS15231B_H_
#define _ARDUINO_AXS15231B_H_

#include "../Arduino_GFX.h"
#include "../Arduino_TFT.h"

#define AXS15231B_TFTWIDTH 360
#define AXS15231B_TFTHEIGHT 640

#define AXS15231B_RST_DELAY 200    ///< delay ms wait for reset finish
#define AXS15231B_SLPIN_DELAY 120  ///< delay ms wait for sleep in finish
#define AXS15231B_SLPOUT_DELAY 120 ///< delay ms wait for sleep out finish

#define AXS15231B_SWRESET 0x01

#define AXS15231B_SLPIN 0x10
#define AXS15231B_SLPOUT 0x11

#define AXS15231B_INVOFF 0x20
#define AXS15231B_INVON 0x21
#define AXS15231B_DISPOFF 0x28
#define AXS15231B_DISPON 0x29

#define AXS15231B_CASET 0x2A
#define AXS15231B_RASET 0x2B
#define AXS15231B_RAMWR 0x2C

#define AXS15231B_PTLAR 0x30
#define AXS15231B_COLMOD 0x3A
#define AXS15231B_MADCTL 0x36

#define AXS15231B_MADCTL_MY 0x80
#define AXS15231B_MADCTL_MX 0x40
#define AXS15231B_MADCTL_MV 0x20
#define AXS15231B_MADCTL_ML 0x10
#define AXS15231B_MADCTL_RGB 0x00

static const uint8_t axs15231b_init_operations[] = {
    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xBB, 8,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x5A, 0xA5,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xA0, 17,
    0xC0, 0x10, 0x00, 0x02, 0x00,
    0x00, 0x04, 0x3F, 0x20, 0x05,
    0x3F, 0x3F, 0x00, 0x00, 0x00,
    0x00, 0x00,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xA2, 31,
    0x30, 0x3C, 0x24, 0x14, 0xD0,
    0x20, 0xFF, 0xE0, 0x40, 0x19,
    0x80, 0x80, 0x80, 0x20, 0xf9,
    0x10, 0x02, 0xff, 0xff, 0xF0,
    0x90, 0x01, 0x32, 0xA0, 0x91,
    0xE0, 0x20, 0x7F, 0xFF, 0x00,
    0x5A,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xD0, 30,
    0xE0, 0x40, 0x51, 0x24, 0x08,
    0x05, 0x10, 0x01, 0x20, 0x15,
    0xC2, 0x42, 0x22, 0x22, 0xAA,
    0x03, 0x10, 0x12, 0x60, 0x14,
    0x1E, 0x51, 0x15, 0x00, 0x8A,
    0x20, 0x00, 0x03, 0x3A, 0x12,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xA3, 22,
    0xA0, 0x06, 0xAa, 0x00, 0x08,
    0x02, 0x0A, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x00,
    0x55, 0x55,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xC1, 30,
    0x31, 0x04, 0x02, 0x02, 0x71,
    0x05, 0x24, 0x55, 0x02, 0x00,
    0x41, 0x00, 0x53, 0xFF, 0xFF,
    0xFF, 0x4F, 0x52, 0x00, 0x4F,
    0x52, 0x00, 0x45, 0x3B, 0x0B,
    0x02, 0x0d, 0x00, 0xFF, 0x40,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xC3, 11,
    0x00, 0x00, 0x00, 0x50, 0x03,
    0x00, 0x00, 0x00, 0x01, 0x80,
    0x01,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xC4, 29,
    0x00, 0x24, 0x33, 0x80, 0x00,
    0xea, 0x64, 0x32, 0xC8, 0x64,
    0xC8, 0x32, 0x90, 0x90, 0x11,
    0x06, 0xDC, 0xFA, 0x00, 0x00,
    0x80, 0xFE, 0x10, 0x10, 0x00,
    0x0A, 0x0A, 0x44, 0x50,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xC5, 23,
    0x18, 0x00, 0x00, 0x03, 0xFE,
    0x3A, 0x4A, 0x20, 0x30, 0x10,
    0x88, 0xDE, 0x0D, 0x08, 0x0F,
    0x0F, 0x01, 0x3A, 0x4A, 0x20,
    0x10, 0x10, 0x00,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xC6, 20,
    0x05, 0x0A, 0x05, 0x0A, 0x00,
    0xE0, 0x2E, 0x0B, 0x12, 0x22,
    0x12, 0x22, 0x01, 0x03, 0x00,
    0x3F, 0x6A, 0x18, 0xC8, 0x22,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xC7, 20,
    0x50, 0x32, 0x28, 0x00, 0xa2,
    0x80, 0x8f, 0x00, 0x80, 0xff,
    0x07, 0x11, 0x9c, 0x67, 0xff,
    0x24, 0x0c, 0x0d, 0x0e, 0x0f,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xC9, 4,
    0x33, 0x44, 0x44, 0x01,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xCF, 27,
    0x2C, 0x1E, 0x88, 0x58, 0x13,
    0x18, 0x56, 0x18, 0x1E, 0x68,
    0x88, 0x00, 0x65, 0x09, 0x22,
    0xC4, 0x0C, 0x77, 0x22, 0x44,
    0xAA, 0x55, 0x08, 0x08, 0x12,
    0xA0, 0x08,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xD5, 30,
    0x40, 0x8E, 0x8D, 0x01, 0x35,
    0x04, 0x92, 0x74, 0x04, 0x92,
    0x74, 0x04, 0x08, 0x6A, 0x04,
    0x46, 0x03, 0x03, 0x03, 0x03,
    0x82, 0x01, 0x03, 0x00, 0xE0,
    0x51, 0xA1, 0x00, 0x00, 0x00,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xD6, 30,
    0x10, 0x32, 0x54, 0x76, 0x98,
    0xBA, 0xDC, 0xFE, 0x93, 0x00,
    0x01, 0x83, 0x07, 0x07, 0x00,
    0x07, 0x07, 0x00, 0x03, 0x03,
    0x03, 0x03, 0x03, 0x03, 0x00,
    0x84, 0x00, 0x20, 0x01, 0x00,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xD7, 19,
    0x03, 0x01, 0x0b, 0x09, 0x0f,
    0x0d, 0x1E, 0x1F, 0x18, 0x1d,
    0x1f, 0x19, 0x40, 0x8E, 0x04,
    0x00, 0x20, 0xA0, 0x1F,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xD8, 12,
    0x02, 0x00, 0x0a, 0x08, 0x0e,
    0x0c, 0x1E, 0x1F, 0x18, 0x1d,
    0x1f, 0x19,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xD9, 12,
    0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
    0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
    0x1F, 0x1F,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xDD, 12,
    0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
    0x1F, 0x1F, 0x1F, 0x1F, 0x1F,
    0x1F, 0x1F,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xDF, 8,
    0x44, 0x73, 0x4B, 0x69, 0x00,
    0x0A, 0x02, 0x90,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xE0, 17,
    0x3B, 0x28, 0x10, 0x16, 0x0c,
    0x06, 0x11, 0x28, 0x5c, 0x21,
    0x0D, 0x35, 0x13, 0x2C, 0x33,
    0x28, 0x0D,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xE1, 17,
    0x37, 0x28, 0x10, 0x16, 0x0b,
    0x06, 0x11, 0x28, 0x5C, 0x21,
    0x0D, 0x35, 0x14, 0x2C, 0x33,
    0x28, 0x0F,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xE2, 17,
    0x3B, 0x07, 0x12, 0x18, 0x0E,
    0x0D, 0x17, 0x35, 0x44, 0x32,
    0x0C, 0x14, 0x14, 0x36, 0x3A,
    0x2F, 0x0D,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xE3, 17,
    0x37, 0x07, 0x12, 0x18, 0x0E,
    0x0D, 0x17, 0x35, 0x44, 0x32,
    0x0C, 0x14, 0x14, 0x36, 0x32,
    0x2F, 0x0F,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xE4, 17,
    0x3B, 0x07, 0x12, 0x18, 0x0E,
    0x0D, 0x17, 0x39, 0x44, 0x2E,
    0x0C, 0x14, 0x14, 0x36, 0x3A,
    0x2F, 0x0D,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xE5, 17,
    0x37, 0x07, 0x12, 0x18, 0x0E,
    0x0D, 0x17, 0x39, 0x44, 0x2E,
    0x0C, 0x14, 0x14, 0x36, 0x3A,
    0x2F, 0x0F,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xA4, 16,
    0x85, 0x85, 0x95, 0x82, 0xAF,
    0xAA, 0xAA, 0x80, 0x10, 0x30,
    0x40, 0x40, 0x20, 0xFF, 0x60,
    0x30,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xA4, 4,
    0x85, 0x85, 0x95, 0x85,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0xBB, 8,
    0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00,
    END_WRITE,

    BEGIN_WRITE,
    WRITE_C8_D8, 0x11, 0x00,
    END_WRITE,

    DELAY, AXS15231B_SLPOUT_DELAY,

    BEGIN_WRITE,
    WRITE_C8_D8, 0x29, 0x00,
    END_WRITE,

    DELAY, 100,

    BEGIN_WRITE,
    WRITE_C8_BYTES, 0x2C, 4,
    0x00, 0x00, 0x00, 0x00,
    END_WRITE};

class Arduino_AXS15231B : public Arduino_TFT
{
public:
  Arduino_AXS15231B(
      Arduino_DataBus *bus, int8_t rst = GFX_NOT_DEFINED, uint8_t r = 0,
      bool ips = false, int16_t w = AXS15231B_TFTWIDTH, int16_t h = AXS15231B_TFTHEIGHT,
      uint8_t col_offset1 = 0, uint8_t row_offset1 = 0, uint8_t col_offset2 = 0, uint8_t row_offset2 = 0);

  bool begin(int32_t speed = GFX_NOT_DEFINED) override;

  void setRotation(uint8_t r) override;

  void writeAddrWindow(int16_t x, int16_t y, uint16_t w, uint16_t h) override;

  void invertDisplay(bool) override;
  void displayOn() override;
  void displayOff() override;

protected:
  void tftInit() override;

private:
};

#endif
